/*
 * $Id: FailedToQueueEventException.java 10529 2008-01-25 05:58:36Z dfeist $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule;

import org.mule.api.MuleMessage;
import org.mule.api.service.Service;
import org.mule.api.service.ServiceException;
import org.mule.config.i18n.Message;

/**
 * <code>FailedToQueueEventException</code> is thrown when an event cannot be put
 * on an internal service queue.
 */

public class FailedToQueueEventException extends ServiceException
{
    /**
     * Serial version
     */
    private static final long serialVersionUID = -8368283988424746098L;

    public FailedToQueueEventException(Message message, MuleMessage umoMessage, Service service)
    {
        super(message, umoMessage, service);
    }

    public FailedToQueueEventException(Message message,
                                       MuleMessage umoMessage,
                                       Service service,
                                       Throwable cause)
    {
        super(message, umoMessage, service, cause);
    }

    public FailedToQueueEventException(MuleMessage umoMessage, Service service, Throwable cause)
    {
        super(umoMessage, service, cause);
    }
}
