
#ifndef EC_VBUF_H
#define EC_VBUF_H

/* 
 * Virtual Buffer
 *
 * The funcions in this file are provided to manipulate buffers
 * from dissectors.
 * They provide a virtua buffer structure on which you can operate
 * forgetting the buffer boundaries.
 * Very useful to prevent buffer overflow for the sniffed pachets
 *
 */

typedef struct vbuf {
   u_char *base;
   size_t offset;
   size_t size;
} *vbuf_p;


/* create the vbuf on a buffer */
void vbuf_create(vbuf_p vbuf, u_char *buf, size_t len);

/* returns a pointer in the buffer */
#define vbuf_ptr(vbuf)        ((vbuf)->base + (vbuf)->offset)

/* returns the size left */
#define vbuf_len(vbuf)        ((vbuf)->size - (vbuf)->offset)

/* returns size of buffer */
#define vbuf_size(vbuf)       ((vbuf)->size)

/* returns the offset in the buffer */
#define vbuf_offset(vbuf)     ((vbuf)->offset)

/* moving through buffer */
int vbuf_seek(vbuf_p vbuf, int offset, char whence);
#define vbuf_move(vbuf, off)     vbuf_seek(vbuf, off, SEEK_CUR)
#define vbuf_rewind(vbuf, off)   vbuf_seek(vbuf, 0, SEEK_SET)
#define vbuf_end(vbuf, off)      vbuf_seek(vbuf, vbuf_size(vbuf), SEEK_SET)

/* read from buffer */
int vbuf_memcpy(vbuf_p vbuf, void *dst, size_t nbyte);
int vbuf_strcpy(vbuf_p vbuf, char *dst);
char * vbuf_strdup(vbuf_p vbuf);

/* write to buffer */
int vbuf_put(vbuf_p vbuf, const void *src, size_t nbyte);
int vbuf_printf(vbuf_p vbuf, const char *fmt, ...);

/* search for patterns in the buffer */
int vbuf_search(vbuf_p vbuf, const u_char *str, size_t len);   /* straightforward */
int vbuf_rsearch(vbuf_p vbuf, const u_char *str, size_t len);  /* reverse */

/* compare data from buffer */
int vbuf_cmp(vbuf_p vbuf, const void *src, size_t len);



#endif	/* EC_VBUF_H */

/* EOF */

// vim:ts=3:expandtab

