#include <glib.h>
#include <gmodule.h>
#include <ethos/ethos.h>

#define SAMPLE_TYPE_PLUGIN				(sample_plugin_get_type ())
#define SAMPLE_PLUGIN(obj)				(G_TYPE_CHECK_INSTANCE_CAST ((obj), SAMPLE_TYPE_PLUGIN, SamplePlugin))
#define SAMPLE_PLUGIN_CONST(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), SAMPLE_TYPE_PLUGIN, SamplePlugin const))
#define SAMPLE_PLUGIN_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), SAMPLE_TYPE_PLUGIN, SamplePluginClass))
#define SAMPLE_IS_PLUGIN(obj)			(G_TYPE_CHECK_INSTANCE_TYPE ((obj), SAMPLE_TYPE_PLUGIN))
#define SAMPLE_IS_PLUGIN_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), SAMPLE_TYPE_PLUGIN))
#define SAMPLE_PLUGIN_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), SAMPLE_TYPE_PLUGIN, SamplePluginClass))

typedef struct _SamplePlugin		SamplePlugin;
typedef struct _SamplePluginClass	SamplePluginClass;
typedef struct _SamplePluginPrivate	SamplePluginPrivate;

struct _SamplePlugin
{
	EthosPlugin parent;

	SamplePluginPrivate *priv;
};

struct _SamplePluginClass
{
	EthosPluginClass parent_class;
};

GType        sample_plugin_get_type (void) G_GNUC_CONST;
EthosPlugin* sample_plugin_new      (void);

struct _SamplePluginPrivate
{
	gpointer dummy;
};

G_DEFINE_TYPE (SamplePlugin, sample_plugin, ETHOS_TYPE_PLUGIN)

static void
sample_plugin_finalize (GObject *object)
{
	G_OBJECT_CLASS (sample_plugin_parent_class)->finalize (object);
}

static void activated (EthosPlugin *plugin)
{
}

static void deactivated (EthosPlugin *plugin)
{
}

static void
sample_plugin_class_init (SamplePluginClass *klass)
{
	GObjectClass *object_class = G_OBJECT_CLASS (klass);
	EthosPluginClass *plugin_class = ETHOS_PLUGIN_CLASS (klass);
	
	object_class->finalize = sample_plugin_finalize;
	plugin_class->activated = activated;
	plugin_class->deactivated = deactivated;

	g_type_class_add_private (object_class, sizeof(SamplePluginPrivate));
}

static void
sample_plugin_init (SamplePlugin *self)
{
	self->priv = G_TYPE_INSTANCE_GET_PRIVATE (self, SAMPLE_TYPE_PLUGIN, SamplePluginPrivate);
}

EthosPlugin*
sample_plugin_new ()
{
	return g_object_new (SAMPLE_TYPE_PLUGIN, NULL);
}

G_MODULE_EXPORT EthosPlugin*
ethos_plugin_register (void)
{
	return sample_plugin_new ();
}
