/* entry-plugin.h */

#ifndef __ENTRY_PLUGIN_H__
#define __ENTRY_PLUGIN_H__

#include <glib-object.h>
#include <ethos/ethos.h>
#include <ethos/ethos-ui.h>

G_BEGIN_DECLS

#define ENTRY_TYPE_PLUGIN            (entry_plugin_get_type())          
#define ENTRY_PLUGIN(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENTRY_TYPE_PLUGIN, EntryPlugin))     
#define ENTRY_PLUGIN_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  ENTRY_TYPE_PLUGIN, EntryPluginClass))
#define ENTRY_IS_PLUGIN(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENTRY_TYPE_PLUGIN))                  
#define ENTRY_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  ENTRY_TYPE_PLUGIN))                  
#define ENTRY_PLUGIN_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  ENTRY_TYPE_PLUGIN, EntryPluginClass))

typedef struct _EntryPlugin        EntryPlugin;
typedef struct _EntryPluginClass   EntryPluginClass;
typedef struct _EntryPluginPrivate EntryPluginPrivate;

struct _EntryPlugin
{
	EthosPlugin parent;

	/*< private >*/
	EntryPluginPrivate *priv;
};

struct _EntryPluginClass
{
	EthosPluginClass parent_class;
};

GType        entry_plugin_get_type (void);
EthosPlugin* entry_plugin_new      (void);

G_END_DECLS

#endif /* __ENTRY_PLUGIN_H__ */


/* entry-plugin.c */
#include "sample.h"

G_DEFINE_TYPE (EntryPlugin, entry_plugin, ETHOS_TYPE_PLUGIN)

struct _EntryPluginPrivate
{
	GtkWidget *entry;
};

static void
activated (EthosPlugin *plugin)
{
	GtkWidget *entry;

	ENTRY_PLUGIN (plugin)->priv->entry = entry = gtk_entry_new ();
	sample_add_widget (entry);
	gtk_widget_show (entry);
}

static void
deactivated (EthosPlugin *plugin)
{
	sample_remove_widget (ENTRY_PLUGIN (plugin)->priv->entry);
}

static void
entry_plugin_class_init (EntryPluginClass *klass)
{
	EthosPluginClass *plugin_class;

	g_type_class_add_private (klass, sizeof (EntryPluginPrivate));

	plugin_class = ETHOS_PLUGIN_CLASS (klass);
	plugin_class->activated = activated;
	plugin_class->deactivated = deactivated;
}

static void
entry_plugin_init (EntryPlugin *plugin)
{
	plugin->priv = G_TYPE_INSTANCE_GET_PRIVATE (plugin,
	                                            ENTRY_TYPE_PLUGIN,
	                                            EntryPluginPrivate);
}

EthosPlugin*
entry_plugin_new (void)
{
	return g_object_new (ENTRY_TYPE_PLUGIN, NULL);
}

G_MODULE_EXPORT EthosPlugin*
ethos_plugin_register (void)
{
	return entry_plugin_new ();
}
