changecom(`/*', `*/')dnl
/*
 * $Id$
 */

include(`hipe/hipe_x86_asm.m4')
#`include' "hipe_literals.h"

/*
 * These m4 macros expand to assembly code which
 * is further processed using the C pre-processor:
 * - Expansion of symbolic names for registers and PCB fields.
 * - Conditional assembly. Some BIFs need specialised code.
 *   Instead of special-casing them in all generated BIF lists,
 *   we use #ifndef wrappers to allow hand-written code to
 *   override that generated by the standard m4 macros.
 *   This is used for:
 *   - demonitor/1, exit/2, group_leader/2, link/1, monitor/2,
 *     port_command/2, send/2, unlink/1: can fail with RESCHEDULE
 * - Appropriate BIF exception test for debug and non-debug mode.
 *
 * XXX: TODO:
 * - Can a BIF with arity 0 fail? beam_emu doesn't think so.
 */

`#if THE_NON_VALUE == 0
#define TEST_GOT_EXN	testl	%eax,%eax
#else
#define TEST_GOT_EXN	cmpl	$THE_NON_VALUE,%eax
#endif'

/*
 * standard_bif_interface_0(nbif_name, cbif_name)
 * standard_bif_interface_1(nbif_name, cbif_name)
 * standard_bif_interface_2(nbif_name, cbif_name)
 * standard_bif_interface_3(nbif_name, cbif_name)
 *
 * Generate native interface for a BIF with 0-3 parameters and
 * standard failure mode (may fail, but not with RESCHEDULE).
 */
define(standard_bif_interface_0,
`
#ifndef HAVE_$1
#`define' HAVE_$1
	.section ".text"
	.align	4
	.global	$1
$1:
	/* switch to C stack */
	SWITCH_ERLANG_TO_C

	/* make the call on the C stack */
	pushl	P
	call	$2
	addl	`$'4, %esp

	/* switch to native stack */
	SWITCH_C_TO_ERLANG

	/* throw exception if failure, otherwise return */
	TEST_GOT_EXN
	jz	nbif_0_simple_exception
	NBIF_RET(0)
	.size	$1,.-$1
	.type	$1,@function
#endif')

define(standard_bif_interface_1,
`
#ifndef HAVE_$1
#`define' HAVE_$1
	.section ".text"
	.align	4
	.global	$1
$1:
	/* copy native stack pointer */
	NBIF_COPY_NSP(1)

	/* switch to C stack */
	SWITCH_ERLANG_TO_C

	/* make the call on the C stack */
	pushl	NBIF_ARG(1,0)
	pushl	P
	call	$2
	addl	`$'8, %esp

	/* switch to native stack */
	SWITCH_C_TO_ERLANG

	/* throw exception if failure, otherwise return */
	TEST_GOT_EXN
	jz	nbif_1_simple_exception
	NBIF_RET(1)
	.size	$1,.-$1
	.type	$1,@function
#endif')

define(standard_bif_interface_2,
`
#ifndef HAVE_$1
#`define' HAVE_$1
	.section ".text"
	.align	4
	.global	$1
$1:
	/* copy native stack pointer */
	NBIF_COPY_NSP(2)

	/* switch to C stack */
	SWITCH_ERLANG_TO_C

	/* make the call on the C stack */
	pushl	NBIF_ARG(2,1)
	pushl	NBIF_ARG(2,0)
	pushl	P
	call	$2
	addl	`$'12, %esp

	/* switch to native stack */
	SWITCH_C_TO_ERLANG

	/* throw exception if failure, otherwise return */
	TEST_GOT_EXN
	jz	nbif_2_simple_exception
	NBIF_RET(2)
	.size	$1,.-$1
	.type	$1,@function
#endif')

define(standard_bif_interface_3,
`
#ifndef HAVE_$1
#`define' HAVE_$1
	.section ".text"
	.align	4
	.global	$1
$1:
	/* copy native stack pointer */
	NBIF_COPY_NSP(3)

	/* switch to C stack */
	SWITCH_ERLANG_TO_C

	/* make the call on the C stack */
	pushl	NBIF_ARG(3,2)
	pushl	NBIF_ARG(3,1)
	pushl	NBIF_ARG(3,0)
	pushl	P
	call	$2
	addl	`$'16, %esp

	/* switch to native stack */
	SWITCH_C_TO_ERLANG

	/* throw exception if failure, otherwise return */
	TEST_GOT_EXN
	jz	nbif_3_simple_exception
	NBIF_RET(3)
	.size	$1,.-$1
	.type	$1,@function
#endif')

/*
 * expensive_bif_interface_1(nbif_name, cbif_name)
 * expensive_bif_interface_2(nbif_name, cbif_name)
 *
 * Generate native interface for a BIF with 1-2 parameters and
 * an expensive failure mode (may fail with RESCHEDULE).
 */
define(expensive_bif_interface_1,
`
#ifndef HAVE_$1
#`define' HAVE_$1
	.section ".text"
	.align	4
	.global	$1
$1:
	/* copy native stack pointer */
	NBIF_COPY_NSP(1)

	/* save actual parameters in case we must reschedule */
	NBIF_SAVE_RESCHED_ARGS(1)

	/* switch to C stack */
	SWITCH_ERLANG_TO_C

	/* make the call on the C stack */
	pushl	NBIF_ARG(1,0)
	pushl	P
	call	$2
	addl	`$'8, %esp

	/* switch to native stack */
	SWITCH_C_TO_ERLANG

	/* throw exception if failure, otherwise return */
	TEST_GOT_EXN
	jz	$1_failed
	NBIF_RET(1)
$1_failed:
	movl	$1, %edx	/* resumption address */
	jmp	nbif_1_hairy_exception
	.size	$1,.-$1
	.type	$1,@function
#endif')

define(expensive_bif_interface_2,
`
#ifndef HAVE_$1
#`define' HAVE_$1
	.section ".text"
	.align	4
	.global	$1
$1:
	/* copy native stack pointer */
	NBIF_COPY_NSP(2)

	/* save actual parameters in case we must reschedule */
	NBIF_SAVE_RESCHED_ARGS(2)

	/* switch to C stack */
	SWITCH_ERLANG_TO_C

	/* make the call on the C stack */
	pushl	NBIF_ARG(2,1)
	pushl	NBIF_ARG(2,0)
	pushl	P
	call	$2
	addl	`$'12, %esp

	/* switch to native stack */
	SWITCH_C_TO_ERLANG

	/* throw exception if failure, otherwise return */
	TEST_GOT_EXN
	jz	$1_failed
	NBIF_RET(2)
$1_failed:
	movl	$1, %edx	/* resumption address */
	jmp	nbif_2_hairy_exception
	.size	$1,.-$1
	.type	$1,@function
#endif')

/*
 * nofail_primop_interface_0(nbif_name, cbif_name)
 * nofail_primop_interface_1(nbif_name, cbif_name)
 * nofail_primop_interface_2(nbif_name, cbif_name)
 *
 * Generate native interface for a primop with implicit P
 * parameter, 0-2 ordinary parameters and no failure mode.
 * Also used for guard BIFs.
 */
define(nofail_primop_interface_0,
`
#ifndef HAVE_$1
#`define' HAVE_$1
	.section ".text"
	.align	4
	.global	$1
$1:
	/* switch to C stack */
	SWITCH_ERLANG_TO_C

	/* make the call on the C stack */
	pushl	P
	call	$2
	addl	`$'4, %esp

	/* switch to native stack */
	SWITCH_C_TO_ERLANG

	/* return */
	NBIF_RET(0)
	.size	$1,.-$1
	.type	$1,@function
#endif')

define(nofail_primop_interface_1,
`
#ifndef HAVE_$1
#`define' HAVE_$1
	.section ".text"
	.align	4
	.global	$1
$1:
	/* copy native stack pointer */
	NBIF_COPY_NSP(1)

	/* switch to C stack */
	SWITCH_ERLANG_TO_C

	/* make the call on the C stack */
	pushl	NBIF_ARG(1,0)
	pushl	P
	call	$2
	addl	`$'8, %esp

	/* switch to native stack */
	SWITCH_C_TO_ERLANG

	/* return */
	NBIF_RET(1)
	.size	$1,.-$1
	.type	$1,@function
#endif')

define(nofail_primop_interface_2,
`
#ifndef HAVE_$1
#`define' HAVE_$1
	.section ".text"
	.align	4
	.global	$1
$1:
	/* copy native stack pointer */
	NBIF_COPY_NSP(2)

	/* switch to C stack */
	SWITCH_ERLANG_TO_C

	/* make the call on the C stack */
	pushl	NBIF_ARG(2,1)
	pushl	NBIF_ARG(2,0)
	pushl	P
	call	$2
	addl	`$'12, %esp

	/* switch to native stack */
	SWITCH_C_TO_ERLANG

	/* return */
	NBIF_RET(2)
	.size	$1,.-$1
	.type	$1,@function
#endif')

/*
 * nocons_nofail_primop_interface_0(nbif_name, cbif_name)
 *
 * Generate native interface for a primop with implicit P
 * parameter, 0 ordinary parameters, and no failure mode.
 * The primop cannot CONS or gc.
 */
define(nocons_nofail_primop_interface_0,
`
#ifndef HAVE_$1
#`define' HAVE_$1
	.section ".text"
	.align	4
	.global	$1
$1:
	/* switch to C stack */
	SWITCH_ERLANG_TO_C_QUICK

	/* make the call on the C stack */
	pushl	P
	call	$2
	addl	`$'4, %esp

	/* switch to native stack */
	SWITCH_C_TO_ERLANG_QUICK

	/* return */
	NBIF_RET(0)
	.size	$1,.-$1
	.type	$1,@function
#endif')

/* 
 * noproc_primop_interface_0(nbif_name, cbif_name)
 * noproc_primop_interface_1(nbif_name, cbif_name)
 * noproc_primop_interface_2(nbif_name, cbif_name)
 * noproc_primop_interface_3(nbif_name, cbif_name)
 *
 * Generate native interface for a primop with no implicit P
 * parameter, 0-3 ordinary parameters, and no failure mode.
 * The primop cannot CONS or gc.
 */
define(noproc_primop_interface_0,
`
#ifndef HAVE_$1
#`define' HAVE_$1
	.section ".text"
	.align	4
	.global	$1
$1:
	/* switch to C stack */
	SWITCH_ERLANG_TO_C_QUICK

	/* make the call on the C stack */
	call	$2

	/* switch to native stack */
	SWITCH_C_TO_ERLANG_QUICK

	/* return */
	NBIF_RET(0)
	.size	$1,.-$1
	.type	$1,@function
#endif')

define(noproc_primop_interface_1,
`
#ifndef HAVE_$1
#`define' HAVE_$1
	.section ".text"
	.align	4
	.global	$1
$1:
	/* copy native stack pointer */
	NBIF_COPY_NSP(1)

	/* switch to C stack */
	SWITCH_ERLANG_TO_C_QUICK

	/* make the call on the C stack */
	pushl	NBIF_ARG(1,0)
	call	$2
	addl	`$'4, %esp

	/* switch to native stack */
	SWITCH_C_TO_ERLANG_QUICK

	/* return */
	NBIF_RET(1)
	.size	$1,.-$1
	.type	$1,@function
#endif')

define(noproc_primop_interface_2,
`
#ifndef HAVE_$1
#`define' HAVE_$1
	.section ".text"
	.align	4
	.global	$1
$1:
	/* copy native stack pointer */
	NBIF_COPY_NSP(2)

	/* switch to C stack */
	SWITCH_ERLANG_TO_C_QUICK

	/* make the call on the C stack */
	pushl	NBIF_ARG(2,1)
	pushl	NBIF_ARG(2,0)
	call	$2
	addl	`$'8, %esp

	/* switch to native stack */
	SWITCH_C_TO_ERLANG_QUICK

	/* return */
	NBIF_RET(2)
	.size	$1,.-$1
	.type	$1,@function
#endif')

define(noproc_primop_interface_3,
`
#ifndef HAVE_$1
#`define' HAVE_$1
	.section ".text"
	.align	4
	.global	$1
$1:
	/* copy native stack pointer */
	NBIF_COPY_NSP(3)

	/* switch to C stack */
	SWITCH_ERLANG_TO_C_QUICK

	/* make the call on the C stack */
	pushl	NBIF_ARG(3,2)
	pushl	NBIF_ARG(3,1)
	pushl	NBIF_ARG(3,0)
	call	$2
	addl	`$'12, %esp

	/* switch to native stack */
	SWITCH_C_TO_ERLANG_QUICK

	/* return */
	NBIF_RET(3)
	.size	$1,.-$1
	.type	$1,@function
#endif')

define(noproc_primop_interface_5,
`
#ifndef HAVE_$1
#`define' HAVE_$1
	.section ".text"
	.align	4
	.global	$1
$1:
	/* copy native stack pointer */
	NBIF_COPY_NSP(5)

	/* switch to C stack */
	SWITCH_ERLANG_TO_C_QUICK

	/* make the call on the C stack */
	pushl	NBIF_ARG(5,4)
	pushl	NBIF_ARG(5,3)
	pushl	NBIF_ARG(5,2)
	pushl	NBIF_ARG(5,1)
	pushl	NBIF_ARG(5,0)
	call	$2
	addl	`$'20, %esp

	/* switch to native stack */
	SWITCH_C_TO_ERLANG_QUICK

	/* return */
	NBIF_RET(5)
	.size	$1,.-$1
	.type	$1,@function
#endif')

/*
 * callee_save_primop_interface_0(nbif_name, cbif_name)
 *
 * Generate native interface for a primop with implicit P
 * parameters, 0 ordinary parameters, and no failure mode.
 * The caller does not have to save and restore caller-save
 * registers, since the interface takes care of that.
 * This is currently only used for internal calls to inc_stack_0.
 */
define(callee_save_primop_interface_0,
`
#ifndef HAVE_$1
#`define' HAVE_$1
	.section ".text"
	.align	4
	.global	$1
$1:
	/* switch to C stack */
	SWITCH_ERLANG_TO_C

	/* make the call on the C stack */
	NBIF_SAVE_CALLER_SAVE
	pushl	P
	call	$2
	NBIF_RESTORE_CALLER_SAVE(1)

	/* switch to native stack */
	SWITCH_C_TO_ERLANG

	/* return */
	NBIF_RET(0)
	.size	$1,.-$1
	.type	$1,@function
#endif')

/*
 * BIFs with expensive failure modes.
 */
expensive_bif_interface_1(nbif_demonitor_1, demonitor_1)
expensive_bif_interface_2(nbif_exit_2, exit_2)
expensive_bif_interface_2(nbif_group_leader_2, group_leader_2)
expensive_bif_interface_1(nbif_link_1, link_1)
expensive_bif_interface_2(nbif_monitor_2, monitor_2)
expensive_bif_interface_2(nbif_port_command_2, port_command_2)
expensive_bif_interface_2(nbif_send_2, send_2)
expensive_bif_interface_1(nbif_unlink_1, unlink_1)

/*
 * Arithmetic operators called indirectly by the HiPE compiler.
 */
standard_bif_interface_2(nbif_add_2, erts_mixed_plus)
standard_bif_interface_2(nbif_sub_2, erts_mixed_minus)
standard_bif_interface_2(nbif_mul_2, erts_mixed_times)
standard_bif_interface_2(nbif_div_2, erts_mixed_div)
standard_bif_interface_2(nbif_intdiv_2, intdiv_2)
standard_bif_interface_2(nbif_rem_2, rem_2)
standard_bif_interface_2(nbif_bsl_2, bsl_2)
standard_bif_interface_2(nbif_bsr_2, bsr_2)
standard_bif_interface_2(nbif_band_2, band_2)
standard_bif_interface_2(nbif_bor_2, bor_2)
standard_bif_interface_2(nbif_bxor_2, bxor_2)
standard_bif_interface_1(nbif_bnot_1, bnot_1)

/*
 * Miscellaneous primops.
 */
nofail_primop_interface_1(nbif_gc_1, hipe_gc)
callee_save_primop_interface_0(nbif_inc_stack_0, hipe_inc_nstack)
nocons_nofail_primop_interface_0(nbif_clear_timeout, hipe_clear_timeout)
standard_bif_interface_1(nbif_set_timeout, hipe_set_timeout)
standard_bif_interface_1(nbif_conv_big_to_float, hipe_conv_big_to_float)

/*
 * Mbox primops with implicit P parameter.
 */
nocons_nofail_primop_interface_0(nbif_get_msg, hipe_get_msg)
nocons_nofail_primop_interface_0(nbif_select_msg, hipe_select_msg)
nocons_nofail_primop_interface_0(nbif_mbox_empty, hipe_mbox_empty)
nocons_nofail_primop_interface_0(nbif_next_msg, hipe_next_msg)

/*
 * Binary-syntax primops with implicit P parameter.
 * XXX: only get_integer conses on the ordinary heap
 */
nofail_primop_interface_2(nbif_bs_get_integer, erts_bs_get_integer)
nofail_primop_interface_2(nbif_bs_get_binary, erts_bs_get_binary)
nofail_primop_interface_2(nbif_bs_get_float, erts_bs_get_float)
nofail_primop_interface_0(nbif_bs_get_binary_all, erts_bs_get_binary_all)
nofail_primop_interface_0(nbif_bs_final, erts_bs_final)

/*
 * Primops without any P parameter.
 * These cannot CONS or gc.
 */
noproc_primop_interface_1(nbif_bs_allocate, hipe_bs_allocate)
noproc_primop_interface_1(nbif_bs_start_match, erts_bs_start_match)
noproc_primop_interface_1(nbif_bs_skip_bits, erts_bs_skip_bits)
noproc_primop_interface_0(nbif_bs_skip_bits_all, erts_bs_skip_bits_all)
noproc_primop_interface_1(nbif_bs_test_tail, erts_bs_test_tail)
noproc_primop_interface_1(nbif_bs_save, erts_bs_save)
noproc_primop_interface_1(nbif_bs_restore, erts_bs_restore)
noproc_primop_interface_0(nbif_bs_init, erts_bs_init)
noproc_primop_interface_3(nbif_bs_put_integer, erts_bs_put_integer)
noproc_primop_interface_2(nbif_bs_put_binary, erts_bs_put_binary)
noproc_primop_interface_1(nbif_bs_put_binary_all, erts_bs_put_binary_all)
noproc_primop_interface_3(nbif_bs_put_float, erts_bs_put_float)
noproc_primop_interface_2(nbif_bs_put_string, erts_bs_put_string)
noproc_primop_interface_0(nbif_bs_get_matchbuffer, hipe_bs_get_matchbuffer)
noproc_primop_interface_5(nbif_bs_put_big_integer, hipe_bs_put_big_integer)
noproc_primop_interface_5(nbif_bs_put_small_float, hipe_bs_put_small_float)
noproc_primop_interface_2(nbif_cmp_2, cmp)
noproc_primop_interface_2(nbif_eq_2, eq)
noproc_primop_interface_0(nbif_handle_fp_exception, erts_restore_x87)

/*
 * BIFs that may trigger a native stack walk with p->narity != 0.
 */
standard_bif_interface_2(nbif_check_process_code_2, hipe_x86_check_process_code_2)
standard_bif_interface_1(nbif_garbage_collect_1, hipe_x86_garbage_collect_1)

/*
 * Standard BIFs.
 * BIF_LIST(ModuleAtom,FunctionAtom,Arity,CFun,Index)
 */
define(BIF_LIST,`standard_bif_interface_$3(nbif_$4, $4)')
include(TARGET/`erl_bif_list.h')

/*
 * Guard BIFs.
 * GBIF_LIST(FunctionAtom,Arity,CFun)
 */
define(GBIF_LIST,`nofail_primop_interface_$2(gbif_$3, $3)')
include(`hipe/hipe_gbif_list.h')
