# -*- coding: utf-8 -*-

# Copyright (c) 2003 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the font dialog wizard dialog.
"""

import os

from qt import *

from FontDialogWizardForm import FontDialogWizardForm

class FontDialogWizardDialog(FontDialogWizardForm):
    """
    Module implementing the font dialog wizard dialog.
    
    It displays a dialog for entering the parameters
    for the QFontDialog code generator.
    """
    def __init__(self, parent=None):
        """
        Constructor
        
        @param parent parent widget (QWidget)
        """
        FontDialogWizardForm.__init__(self, parent, None, 1)
        
        self.font = None
        
        # to get around a quirk in PyQt if the subclass has no translatable strings
        dummy = self.trUtf8('Dummy')
        
    def testDlg(self):
        """
        Private method to test the selected options.
        """
        if self.font is None:
            QFontDialog.getFont()
        else:
            QFontDialog.getFont(self.font)
        
    def getCode(self, indLevel, indString):
        """
        Public method to get the source code.
        
        @param indLevel indentation level (int)
        @param indString string used for indentation (space or tab) (string)
        @return generated code (string)
        """
        # calculate our indentation level and the indentation string
        il = indLevel + 1
        istring = il * indString
        
        # now generate the code
        code = 'QFontDialog.getFont('
        if self.eVariable.text().isEmpty():
            if self.font is not None:
                code += 'QFont("%s", %d, %d, %d)' % \
                    (self.font.family(), self.font.pointSize(),
                    self.font.weight(), self.font.italic())
        else:
            code += str(self.eVariable.text())
        code += ')%s' % os.linesep
            
        return code
        
    def handleVar(self, text):
        """
        Private slot to handle the textChanged signal of eVariable.
        
        @param text the new text (QString)
        """
        if text.isEmpty():
            self.bTest.setEnabled(1)
        else:
            self.bTest.setEnabled(0)
            
    def handleSelectFont(self):
        """
        Private slot to handle the button press to select a font via a font selection dialog.
        """
        if self.font is None:
            font, ok = QFontDialog.getFont()
        else:
            font, ok = QFontDialog.getFont(self.font)
        if ok:
            self.font = font
        else:
            self.font = None
