# -*- coding: utf-8 -*-

# Copyright (c) 2003 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a dialog to enter the data for a switch operation.
"""

from qt import *

from SwitchForm import SwitchForm

class SvnSwitchDialog(SwitchForm):
    """
    Class implementing a dialog to enter the data for a switch operation.
    """
    def __init__(self, taglist, parent = None):
        """
        Constructor
        
        @param taglist list of previously entered tags (QStringList)
        @param parent parent widget (QWidget)
        """
        SwitchForm.__init__(self, parent, None, 1)
       
        dummy = self.trUtf8('dummy')
        
        self.tagCombo.clear()
        self.tagCombo.insertStringList(taglist)
        
    def getParameters(self):
        """
        Public method to retrieve the tag data.
        
        @return tuple of QString and int (tag, tag type)
        """
        tag = self.tagCombo.currentText()
        tagType = 0
        if self.regularButton.isChecked():
            tagType = 1
        elif self.branchButton.isChecked():
            tagType = 2
        if tag.isEmpty():
            tagType = 4
        return (tag, tagType)

