# -*- coding: utf-8 -*-

# Copyright (c) 2002, 2003 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the VCS Options Dialog for a new project from the repository.
"""

import os

from qt import *

from NewProjectForm import vcsNewProjectOptionsForm
from Config import ConfigVcsSystems

class vcsNewProjectOptionsDialog(vcsNewProjectOptionsForm):
    """
    Class implementing the VCS Options Dialog for a new project from the repository.
    """
    def __init__(self, parent=None):
        """
        Constructor
        
        @param parent parent widget (QWidget)
        """
        vcsNewProjectOptionsForm.__init__(self, parent, None, 1)
        
        vcsSystems = QStringList()
        for vcssys in ConfigVcsSystems:
            vcsSystems.append(vcssys)
        self.vcsComboBox.insertStringList(vcsSystems)
        
        hd = QDir.convertSeparators(QDir.homeDirPath())
        hd = os.path.join(str(hd), ConfigVcsSystems[0].lower() + 'root')
        self.vcsDirectoryEdit.setText(hd)
        
        self.cvsTagValidator = QRegExpValidator(QRegExp(r"[a-zA-Z][a-zA-Z0-9_-]*"), self)
        
    def handleDirectory(self):
        """
        Private slot to display a directory selection dialog.
        """
        directory = QFileDialog.getExistingDirectory(self.vcsDirectoryEdit.text(),
            self, None, self.trUtf8("Select VCS-Directory"), 1)
            
        if not directory.isNull():
            self.vcsDirectoryEdit.setText(QDir.convertSeparators(directory))
            
    def handleProjectDir(self):
        """
        Private slot to display a directory selection dialog.
        """
        directory = QFileDialog.getExistingDirectory(self.vcsProjectDirEdit.text(),
            self, None, self.trUtf8("Select Project Directory"), 1)
            
        if not directory.isNull():
            self.vcsProjectDirEdit.setText(QDir.convertSeparators(directory))
            
    def handleComboBox(self, vcsSystem):
        """
        Private slot to set the vcs root directory entry.
        
        @param vcsSystem name of the VCS system (string)
        """
        hd = QDir.homeDirPath()
        hd.append('/').append(vcsSystem.lower()).append('root')
        self.vcsDirectoryEdit.setText(hd)
        
        if str(vcsSystem.lower()) == "cvs":
            self.vcsTagEdit.setValidator(self.cvsTagValidator)
        else:
            self.vcsTagEdit.clearValidator()
        
    def getData(self):
        """
        Public slot to retrieve the data entered into the dialog.
        
        @return a tuple of 5 strings and one boolean (vcs system, vcs directory,
            archive name, tag name, project directory, command options).
        """
        return (str(self.vcsComboBox.currentText()),
            str(self.vcsDirectoryEdit.text()),
            str(self.vcsArchiveEdit.text()),
            str(self.vcsTagEdit.text()),
            str(self.vcsProjectDirEdit.text()),
            self.optionsCheckBox.isChecked()
        )
