# -*- coding: utf-8 -*-

# Copyright (c) 2003 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a Qt free version of the debug client.
"""

from AsyncIOBase import *
from DebugBase import *
import DebugClientBase


class DebugClientNoQt(DebugClientBase.DebugClientBase, AsyncIOBase, DebugBase):
    """
    Class implementing the client side of the debugger.
    
    This variant of the debugger implements a Qt free debugger client
    by subclassing all relevant base classes.
    """
    def __init__(self):
        """
        Constructor
        """
        AsyncIOBase.__init__(self)
        
        DebugClientBase.DebugClientBase.__init__(self)
        
        DebugBase.__init__(self, self)
        
        self.variant = 'No Qt-Version'

# We are normally called by the debugger to execute directly.

if __name__ == '__main__':
    debugClient = DebugClientNoQt()
    debugClient.main()
