# -*- coding: utf-8 -*-

# Copyright (c) 2006 - 2008 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the Debugger General (2) configuration page.
"""

from E4Gui.E4Completers import E4FileCompleter, E4DirCompleter

from ConfigurationPageBase import ConfigurationPageBase
from Ui_DebuggerGeneral2Page import Ui_DebuggerGeneral2Page

import Preferences
import Utilities

class DebuggerGeneral2Page(ConfigurationPageBase, Ui_DebuggerGeneral2Page):
    """
    Class implementing the Debugger General (2) configuration page.
    """
    def __init__(self):
        """
        Constructor
        """
        ConfigurationPageBase.__init__(self)
        self.setupUi(self)
        self.setObjectName("DebuggerGeneral2Page")
        
        t = self.consoleDbgEdit.whatsThis()
        if not t.isEmpty():
            t.append(Utilities.getPercentReplacementHelp())
            self.consoleDbgEdit.setWhatsThis(t)
        
        self.consoleDbgCompleter = E4FileCompleter(self.consoleDbgEdit)
        self.dbgTranslationLocalCompleter = E4DirCompleter(self.dbgTranslationLocalEdit)
        
        # set initial values
        self.debugEnvironReplaceCheckBox.setChecked(\
            Preferences.getDebugger("DebugEnvironmentReplace"))
        self.debugEnvironEdit.setText(\
            Preferences.getDebugger("DebugEnvironment"))
        self.automaticResetCheckBox.setChecked(\
            Preferences.getDebugger("AutomaticReset"))
        self.debugAutoSaveScriptsCheckBox.setChecked(\
            Preferences.getDebugger("Autosave"))
        self.consoleDbgCheckBox.setChecked(\
            Preferences.getDebugger("ConsoleDbgEnabled"))
        self.consoleDbgEdit.setText(\
            Preferences.getDebugger("ConsoleDbgCommand"))
        self.dbgPathTranslationCheckBox.setChecked(\
            Preferences.getDebugger("PathTranslation"))
        self.dbgTranslationRemoteEdit.setText(\
            Preferences.getDebugger("PathTranslationRemote"))
        self.dbgTranslationLocalEdit.setText(\
            Preferences.getDebugger("PathTranslationLocal"))
        
    def save(self):
        """
        Public slot to save the Debugger General (2) configuration.
        """
        Preferences.setDebugger("DebugEnvironmentReplace", 
            int(self.debugEnvironReplaceCheckBox.isChecked()))
        Preferences.setDebugger("DebugEnvironment", 
            self.debugEnvironEdit.text())
        Preferences.setDebugger("AutomaticReset", 
            int(self.automaticResetCheckBox.isChecked()))
        Preferences.setDebugger("Autosave", 
            int(self.debugAutoSaveScriptsCheckBox.isChecked()))
        Preferences.setDebugger("ConsoleDbgEnabled", 
            int(self.consoleDbgCheckBox.isChecked()))
        Preferences.setDebugger("ConsoleDbgCommand", 
            self.consoleDbgEdit.text())
        Preferences.setDebugger("PathTranslation", 
            int(self.dbgPathTranslationCheckBox.isChecked()))
        Preferences.setDebugger("PathTranslationRemote",
            unicode(self.dbgTranslationRemoteEdit.text()))
        Preferences.setDebugger("PathTranslationLocal",
            unicode(self.dbgTranslationLocalEdit.text()))
    
def create(dlg):
    """
    Module function to create the configuration page.
    
    @param dlg reference to the configuration dialog
    """
    page = DebuggerGeneral2Page()
    return page
