# -*- coding: utf-8 -*-

# Copyright (c) 2005 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a dialog to show a list of tags.
"""

import os

from qt import *

import mercurial.hg as hg

from TagListForm import TagListForm
from HgDialog import HgDummyDialog

class HgTagListDialog(TagListForm):
    """
    Module implementing a dialog to show a list of tags.
    """
    def __init__(self, vcs, parent = None):
        """
        Constructor
        
        @param vcs reference to the vcs object
        @param parent parent widget (QWidget)
        """
        TagListForm.__init__(self, parent)
        
        self.setWFlags(self.getWFlags() | Qt.WDestructiveClose)
        self.vcs = vcs
        
        self.tagList.setSorting(1, 0)
        
    def start(self, path):
        """
        Public slot to start the hg status command.
        
        @param path name of directory to be listed (string)
        """
        dname, fname = self.vcs.splitPath(path)
        
        # find the root of the repo
        repodir = str(dname)
        while not os.path.isdir(os.path.join(repodir, '.hg')):
            repodir = os.path.dirname(repodir)
            if repodir == os.sep:
                return 0
        
        ui = HgDummyDialog()
        repo = hg.repository(ui, repodir)
        try:
            l = repo.tagslist()
            for tag, n in l:
                try:
                    rev = str(repo.changelog.rev(n))
                    changesetId = hg.hex(n)
                except KeyError:
                    rev = self.trUtf8("?")
                    changesetId = self.trUtf8("unknown")
                itm = QListViewItem(self.tagList,
                    tag, rev, changesetId)
        except Exception, e:
            self.errors.append(self.trUtf8("Error listing tags (%1).").arg(str(e)))
