# -*- coding: utf-8 -*-

# Copyright (c) 2005 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the Mercurial Options Dialog for a pull operation.
"""

import os

from qt import *

from KdeQt import KQFileDialog

from PullForm import HgPullForm
from Config import ConfigHgProtocols

class HgPullDialog(HgPullForm):
    """
    Class implementing the Options Dialog for a pull operation.
    """
    def __init__(self, forIncoming=0, parent=None):
        """
        Constructor
        
        @param forIncoming flag indicating a dialog for the hg incoming command
            (boolean)
        @param parent parent widget (QWidget)
        """
        HgPullForm.__init__(self, parent, None, 1)
        
        self.protocolCombo.insertStringList(ConfigHgProtocols)
        
        if forIncoming:
            self.setCaption(self.trUtf8("Mercurial Incoming"))
            self.updateCheckBox.hide()
        
        self.resize(self.width(), 1)
        
    def handleDirectory(self):
        """
        Private slot to display a directory selection dialog.
        """
        directory = KQFileDialog.getExistingDirectory(self.vcsDirectoryEdit.text(),
            self, None, self.trUtf8("Select Repository-Directory"), 1)
            
        if not directory.isNull():
            self.vcsDirectoryEdit.setText(QDir.convertSeparators(directory))
        
    def handleProtocol(self, protocol):
        """
        Private slot to switch the status of the directory selection button.
        """
        if str(protocol) == "file://":
            self.vcsDirButton.setEnabled(1)
        else:
            self.vcsDirButton.setEnabled(0)
        
    def getData(self):
        """
        Public slot to retrieve the data entered into the dialog.
        
        @return a tuple of a string (project directory) and a dictionary
            containing the data entered.
        """
        protocol = str(self.protocolCombo.currentText())
        if protocol == "file://":
            source = unicode(self.vcsDirectoryEdit.text())
        else:
            source = '%s%s' % (protocol, unicode(self.vcsDirectoryEdit.text())),
        return (str(source), self.updateCheckBox.isChecked())
