# -*- coding: utf-8 -*-

# Copyright (c) 2005 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the Mercurial command dialog.
"""

from qt import *

from CommandForm import CommandForm
import Utilities

class HgCommandDialog(CommandForm):
    """
    Class implementing the Mercurial command dialog.
    
    It implements a dialog that is used to enter an
    arbitrary Mercurial command. It asks the user to enter
    the commandline parameters.
    """
    def __init__(self, argvList, ppath, parent=None):
        """
        Constructor
        
        @param argvList history list of commandline arguments (QStringList)
        @param ppath pathname of the project directory (string)
        @param parent parent widget of this dialog (QWidget)
        """
        CommandForm.__init__(self, parent, None, 1)
        
        self.commandCombo.clear()
        self.commandCombo.insertStringList(argvList)
        if argvList.count() > 0:
            self.commandCombo.setCurrentItem(0)
        self.projectDirLabel.setText(ppath)
        
        # modify some what's this help texts
        t = QWhatsThis.textFor(self.commandCombo)
        if not t.isEmpty():
            t = t.append(Utilities.getPercentReplacementHelp())
            QWhatsThis.add(self.commandCombo, t)
        
    def enableOkButton(self, text):
        """
        Private method used to enable/disable the OK-button.
        
        @param text ignored
        """
        self.okButton.setDisabled(self.commandCombo.currentText().isEmpty())
    
    def getData(self):
        """
        Public method to retrieve the data entered into this dialog.
        
        @return a tuple of argv, workdir
        """
        return self.commandCombo.currentText()
