# -*- coding: utf-8 -*-

# Copyright (c) 2003 - 2005 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the CVS command dialog.
"""

from qt import *

from KdeQt import KQFileDialog

from CommandForm import CommandForm
import Utilities

class CvsCommandDialog(CommandForm):
    """
    Class implementing the CVS command dialog.
    
    It implements a dialog that is used to enter an
    arbitrary cvs command. It asks the user to enter
    the commandline parameters and the working directory.
    """
    def __init__(self, argvList, wdList, ppath, parent=None):
        """
        Constructor
        
        @param argvList history list of commandline arguments (QStringList)
        @param wdList history list of working directories (QStringList)
        @param ppath pathname of the project directory (string)
        @param parent parent widget of this dialog (QWidget)
        """
        CommandForm.__init__(self, parent, None, 1)
        
        self.commandCombo.clear()
        self.commandCombo.insertStringList(argvList)
        if argvList.count() > 0:
            self.commandCombo.setCurrentItem(0)
        self.workdirCombo.clear()
        self.workdirCombo.insertStringList(wdList)
        if wdList.count() > 0:
            self.workdirCombo.setCurrentItem(0)
        self.projectDirLabel.setText(ppath)
        
        # modify some what's this help texts
        t = QWhatsThis.textFor(self.commandCombo)
        if not t.isEmpty():
            t = t.append(Utilities.getPercentReplacementHelp())
            QWhatsThis.add(self.commandCombo, t)
        
    def handleDir(self):
        """
        Private method used to open a directory selection dialog.
        """
        cwd = self.workdirCombo.currentText()
        if cwd.isEmpty():
            cwd = self.projectDirLabel.text()
        d = KQFileDialog.getExistingDirectory(cwd,
            self, None, self.trUtf8('Working directory'))
            
        if not d.isEmpty():
            self.workdirCombo.setCurrentText(QDir.convertSeparators(d))
        
    def enableOkButton(self, text):
        """
        Private method used to enable/disable the OK-button.
        
        @param text ignored
        """
        self.okButton.setDisabled(
            self.commandCombo.currentText().isEmpty() or \
            self.workdirCombo.currentText().isEmpty())
    
    def getData(self):
        """
        Public method to retrieve the data entered into this dialog.
        
        @return a tuple of argv, workdir
        """
        return (self.commandCombo.currentText(),
                self.workdirCombo.currentText())
