# -*- coding: utf-8 -*-

# Copyright (c) 2002 - 2005 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a debugger stub for remote debugging.
"""

import os
import sys
import string
import distutils.sysconfig

from eric3config import getConfig

debugger = None
__scriptname = None

modDir = distutils.sysconfig.get_python_lib()
ericpath = os.getenv('ERICDIR', getConfig('ericDir'))

if not ericpath in sys.path:
    sys.path.insert(-1, ericpath)
    
def initDebugger(kind="standard"):
    """
    Module function to initialize a debugger for remote debugging.
    
    @param kind type of debugger ("standard", "noqt" or "threads")
    @return flag indicating success (boolean)
    """
    global debugger
    res = 1
    try:
        if kind == "standard":
            import DebugClient
            debugger = DebugClient.DebugClient()
        elif kind == "noqt":
            import DebugClientNoQt
            debugger = DebugClientNoQt.DebugClientNoQt()
        elif kind == "threads":
            import DebugClientThreads
            debugger = DebugClientThreads.DebugClientThreads()
        else:
            raise ValueError
    except:
        debugger = None
        res = 0
        
    return res

def runcall(func, *args):
    """
    Module function mimicing the Pdb interface.
    
    @param func function to be called (function object)
    @param *args arguments being passed to func
    @return the function result
    """
    global debugger, __scriptname
    return debugger.run_call(__scriptname, func, *args)
    
def setScriptname(name):
    """
    Module function to set the scriptname to be reported back to the IDE.
    
    @param name absolute pathname of the script (string)
    """
    global __scriptname
    __scriptname = name

def startDebugger(enableTrace=1, redirect=1):
    """
    Module function used to start the remote debugger.
    
    @param enableTrace flag to enable the tracing function (boolean)
    @param redirect flag indicating redirection of stdin, stdout and stderr (boolean)
    """
    global debugger
    if debugger:
        debugger.startDebugger(enableTrace=enableTrace, redirect=redirect)
