# -*- coding: utf-8 -*-

# Copyright (c) 2002 - 2005 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a dialog to add a file to the project.
"""

import os

from qt import *

from KdeQt import KQFileDialog

from AddFileForm import AddFileForm

class AddFileDialog(AddFileForm):
    """
    Class implementing a dialog to add a file to the project.
    """
    def __init__(self,pro,parent = None,filter = None, name = None,modal = 0,fl = 0):
        """
        Constructor
        
        @param pro reference to the project object
        @param parent parent widget of this dialog (QWidget)
        @param filter filter specification for the file to add (string or QString)
        @param name name of this dialog (string or QString)
        @param modal flag for a modal dialog (boolean)
        @param fl window flags
        """
        AddFileForm.__init__(self,parent,name,1,fl)
        
        self.targetDirEdit.setText(pro.ppath)
        self.filter = filter
        self.ppath = pro.ppath
        if pro.pdata["MIXEDLANGUAGE"][0]:
            self.sourceFilter = pro.sourceFilters["Mixed"]
        else:
            self.sourceFilter = pro.sourceFilters[pro.pdata["PROGLANGUAGE"][0]]
        
    def handleDirDialog(self):
        """
        Private slot to display a directory selection dialog.
        """
        directory = KQFileDialog.getExistingDirectory(self.targetDirEdit.text(),
            self, None, self.trUtf8("Select target directory"), 1)
            
        if not directory.isNull():
            self.targetDirEdit.setText(QDir.convertSeparators(directory))
            
    def handleFileDialog(self):
        """
        Private slot to display a file selection dialog.
        
        A filter of 'py' is synonym for source files.
        """
        dir = self.sourceFileEdit.text()
        if dir.isEmpty():
            dir = self.targetDirEdit.text()
        if self.filter is None:
            dfilter = QString(self.sourceFilter)
            dfilter.append(self.trUtf8(\
                "Qt User-Interface Files (*.ui);;"
                "Interface Files (*.idl);;"
                "All Files (*)"
            ))
        elif self.filter == 'ui':
            dfilter = self.trUtf8("Qt User-Interface Files (*.ui)")
        elif self.filter == 'py':
            dfilter = QString(self.sourceFilter)
            dfilter.append(self.trUtf8(\
                "All Files (*)"
            ))
        elif self.filter == 'idl':
            dfilter = self.trUtf8("Interface Files (*.idl)")
        elif self.filter == 'others':
            dfilter = self.trUtf8("All Files (*)")
        else:
            return
            
        fn = KQFileDialog.getOpenFileName(dir,
            dfilter,
            self, None, self.trUtf8("Select source file"))
            
        if not fn.isNull():
            self.sourceFileEdit.setText(QDir.convertSeparators(fn))
            
    def handleSTextChanged(self, sfile):
        """
        Private slot to handle the source dir text changed.
        
        If the entered source directory is a subdirectory of the current
        projects main directory, the target directory path is synchronized.
        It is assumed, that the user wants to add a bunch of files to
        the project in place.
        
        @param sfile the text of the source file line edit
        """
        if sfile.startsWith(self.ppath):
            dir = os.path.dirname(unicode(sfile))
            self.targetDirEdit.setText(dir)
        
    def getData(self):
        """
        Public slot to retrieve the dialogs data.
        
        @return tuple of three values (string, string, boolean) giving the 
            source file, the target directory and a flag telling, whether
            the file shall be added as source code
        """
        return (unicode(self.sourceFileEdit.text()), 
            unicode(self.targetDirEdit.text()), self.sourcecodeCheckBox.isChecked())
