// ePDFView - A lightweight PDF Viewer.
// Copyright (C) 2006 Emma's Software.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#if !defined (__MAIN_VIEW_H__)
#define __MAIN_VIEW_H__


namespace ePDFView
{
    // Forward declarations
    class FindView;
    class MainPter;
    class DocumentPage;
    class PageView;

    class MainView: public IMainView
    {
        public:
            MainView (MainPter *pter);
            ~MainView ();
           
            void activeZoomFit (gboolean active);
            void activeZoomWidth (gboolean active);
            gchar *openFileDialog (const gchar *lastFolder);
            gchar *promptPasswordDialog (void);
            void sensitiveFind (gboolean sensitive);
            void sensitiveGoToFirstPage (gboolean sensitive);
            void sensitiveGoToLastPage (gboolean sensitive);
            void sensitiveGoToNextPage (gboolean sensitive);
            void sensitiveGoToPage (gboolean sensitive);
            void sensitiveGoToPreviousPage (gboolean sensitive);
            void sensitiveReload (gboolean sensitive);
            void sensitiveOpen (gboolean sensitive);
            void sensitiveRotateLeft (gboolean sensitive);
            void sensitiveRotateRight (gboolean sensitive);
            void sensitiveZoomIn (gboolean sensitive);
            void sensitiveZoomOut (gboolean sensitive);
            void sensitiveZoomFit (gboolean sensitive);
            void sensitiveZoomWidth (gboolean sensitive);
            void show (void);
            void showErrorMessage (const gchar *title, const gchar *body);
            void showIndex (gboolean show);
            void setCursor (ViewCursor cursorType);
            void setTotalPages (gint pages);
            void setGoToPageText (const gchar *text);
            void setStatusBarText (const gchar *text);
            const gchar *getGoToPageText (void);
            IFindView *getFindView (void);
            IPageView *getPageView (void);
            void setTitle (const gchar *title);
            void setOutline (DocumentOutline *outline);
            void showToolbar (gboolean show);
            void showStatusbar (gboolean show);

        protected:
            GtkWidget *m_CurrentPage;
            GtkToolItem *m_CurrentPageToolItem;
            FindView *m_FindView;
            GtkWidget *m_MainWindow; 
            GtkWidget *m_MainBox;
            GtkTreeStore *m_Outline;
            PageView *m_PageView;
            GtkWidget *m_Sidebar;
            GtkWidget *m_StatusBar;
            GtkWidget *m_TreeIndex;
            gint m_TotalPages;
            GtkUIManager *m_UIManager;

            void createCurrentPage (void);
            GtkWidget *createPageView (void);
            void createUIManager (void);
            void setMainWindowIcon (void);
            void setOutlineChildren (DocumentOutline *outline, 
                                     GtkTreeIter *rootIter);
    };
}

#endif // !__MAIN_VIEW_H__
