// ePDFView - A lightweight PDF Viewer.
// Copyright (C) 2006 Emma's Software.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#if !defined (__DOCUMENT_LINK_H__)
#define __DOCUMENT_LINK_H__

namespace ePDFView
{
    ///
    /// @class DocumentLink
    /// @brief A single link on a page.
    ///
    /// This class is used by ePDFView::DocumentPage to maintain a list
    /// of all links that a single page have. A link, in this version of
    /// ePDFView, is just a rectangle on a page that points to another page.
    ///
    class DocumentLink
    {
        public:
            DocumentLink (gdouble x1, gdouble y1, gdouble x2, gdouble y1,
                          gint destinationPage);
            ~DocumentLink (void);

            gint getDestinationPage (void);
            gboolean positionIsOver (gint x, gint y);

        protected:
            /// The number of the link's destination page.
            gint m_DestinationPage;
            /// The link rectangle.
            DocumentRectangle *m_Rect;
    };
}

#endif // !__DOCUMENT_LINK_H__
