#-------------------------------------------------------------------------------
#  
#  Defines the OMMenuController class which creates and manages pop-up menus  
#  for use with various graph-related 'om' controller classes.
#  
#  Written by: David C. Morrill
#  
#  Date: 03/15/2005
#  
#  (c) Copyright 2005 by Enthought, Inc.
#  
#-------------------------------------------------------------------------------
                      
#-------------------------------------------------------------------------------
#  Imports:  
#-------------------------------------------------------------------------------

from enthought.traits.api import HasPrivateTraits, Any

#-------------------------------------------------------------------------------
#  'OMMenuController' class:
#-------------------------------------------------------------------------------

class OMMenuController ( HasPrivateTraits ):
    
    #---------------------------------------------------------------------------
    #  Trait definitions:  
    #---------------------------------------------------------------------------
        
    # The controller which implements the menu actions:
    controller = Any
    
    # Data to be passed to every action handler:
    data       = Any( () )
            
    #---------------------------------------------------------------------------
    #  Adds a menu item to the menu bar being constructed:    
    #---------------------------------------------------------------------------
                            
    def add_to_menu ( self, menu_item ):
        """ Adds a menu item to the menu bar being constructed.
        """
        pass
        
    #---------------------------------------------------------------------------
    #  Adds a tool bar item to the tool bar being constructed:    
    #---------------------------------------------------------------------------
                
    def add_to_toolbar ( self, toolbar_item ):
        """ Adds a tool bar item to the tool bar being constructed.
        """
        pass
        
    #---------------------------------------------------------------------------
    #  Returns whether the menu action should be defined in the user interface:
    #---------------------------------------------------------------------------
        
    def can_add_to_menu ( self, action ):
        """ Returns whether the action should be defined in the user interface.
        """
        return True
        
    #---------------------------------------------------------------------------
    #  Returns whether the toolbar action should be defined in the user 
    #  interface:
    #---------------------------------------------------------------------------
        
    def can_add_to_toolbar ( self, action ):
        """ Returns whether the toolbar action should be defined in the user 
            interface.
        """
        return True
        
    #---------------------------------------------------------------------------
    #  Performs the action described by a specified Action object:    
    #---------------------------------------------------------------------------
                
    def perform ( self, action ):
        """ Performs the action described by a specified Action object.
        """

        method = None
        if hasattr( action, 'action' ):
            method = getattr( self.controller, action.action, None )

        if method is not None:
            method( *self.data )
        else:
            action.perform()
            
#-------------------------------------------------------------------------------
#  Creates a singleton instance of a menu controller:  
#-------------------------------------------------------------------------------
                        
menu_controller = OMMenuController()
        
