#-------------------------------------------------------------------------------
#  
#  Defines the OMContactManager class of the Enable 'om' (Object Model) package. 
#
#  An OMContactManager is an object associated with an OMComponent object that
#  is used for managing (i.e. adding, deleting, retrieving) contacts for the
#  component object. In addition, the contact manager also performs layout
#  operations on its set of managed Contacts, thus simplifying the work that
#  must be done by the component itself.
#  
#  Note that it is not necessary for a OMComponent subclass to use a separate
#  contact manager object. The Contacts can be directly managed by the component
#  itself if desired. The contact manager is normally used by the component's
#  controller object.
#  
#  Written by: David C. Morrill
#  
#  Date: 02/01/2005
#  
#  (c) Copyright 2005 by Enthought, Inc.
#  
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
#  'OMContactManager' interface:  
#-------------------------------------------------------------------------------

class OMContactManager ( object ):
    
#-- Mandatory Interface: -------------------------------------------------------

    #---------------------------------------------------------------------------
    #  Adds one or more Contact objects to the associated Component:
    #---------------------------------------------------------------------------

    def add_contacts ( self, *contacts ):
        """ Adds one or more Contact objects to the associated Component.
        """
        raise NotImplementedError
        
    #---------------------------------------------------------------------------
    #  Removes one or more Contact objects from the associated Component:  
    #---------------------------------------------------------------------------
                
    def remove_contacts ( self, *contacts ):
        """ Removes one or more Contact objects from the associated Component.
        """
        raise NotImplementedError
        
    #---------------------------------------------------------------------------
    #  Gets the list of Contacts associated with a Component that match an 
    #  optionally specified name, category and/or group. If no arguments are 
    #  specified, it returns all Contacts associated with the Component;
    #  otherwise it returns all Contacts whose name, category or group match
    #  the specified value.
    #---------------------------------------------------------------------------
                
    def get_contacts ( self, name = None, category = None, group = None ):
        """ Gets the list of Contacts associated with a Component that match an 
            optionally specified name, category and/or group. If no arguments 
            are specified, it returns all Contacts associated with the 
            Component; otherwise it returns all Contacts whose name, category
            or group match the specified value.
        """
        raise NotImplementedError
        
    #---------------------------------------------------------------------------
    #  Lays out all of the Contacts being managed within the specified region:  
    #---------------------------------------------------------------------------
            
    def layout_contacts ( self, width = None, height = None ):        
        """ Lays out all of the Contacts being managed.
        """
        raise NotImplementedError
                       
    #---------------------------------------------------------------------------
    #  Return the components that contain a specified (x,y) point:
    #---------------------------------------------------------------------------
       
    def components_at ( self, x, y ):
        raise NotImplementedError
        
#-- Optional Interface: --------------------------------------------------------    

    #---------------------------------------------------------------------------
    #  Adds one or more Tracks to the associated Component:  
    #---------------------------------------------------------------------------

    def add_tracks ( self, *tracks ):
        """ Adds one or more Tracks to the associated Component.
        """
        raise NotImplementedError
        
    #---------------------------------------------------------------------------
    #  Removes one or more Tracks from the associated Component:  
    #---------------------------------------------------------------------------
                
    def remove_tracks ( self, *tracks ):
        """ Removes one or more Tracks from the associated Component.
        """
        raise NotImplementedError
        
    #---------------------------------------------------------------------------
    #  Gets the list of Tracks associated with a Component that match an 
    #  optionally specified name and/or category. If no arguments are
    #  specified, it returns all Tracks associated with the Component; 
    #  otherwise it returns all Tracks whose name or category match the
    #  specified value.
    #---------------------------------------------------------------------------
                
    def get_tracks ( self, name = None, category = None, group = None ):
        """ Gets the list of Tracks associated with a Component that match an 
            optionally specified name and/or category. If no arguments are 
            specified, it returns all Tracks associated with the Component; 
            otherwise it returns all Tracks whose name or category match the
            specified value.
        """
        raise NotImplementedError
        
