#-------------------------------------------------------------------------------
#  
#  Defines the OMCanvasController class of the Enable 'om' (Object Model) 
#  package. 
#
#  The OMCanvasController class defines the base class for creating controllers
#  used to connect and control the relationship between a canvas (i.e. OMCanvas
#  object) and the underlying object model. The controller mediates all
#  interaction between events that occur on the canvas and the object model.
#  
#  Written by: David C. Morrill
#  
#  Date: 01/27/2005
#  
#  (c) Copyright 2005 by Enthought, Inc.
#  
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
#  Imports:  
#-------------------------------------------------------------------------------

from enthought.traits.api \
    import HasPrivateTraits

from om_menu_controller \
    import menu_controller

#-------------------------------------------------------------------------------
#  'OMCanvasController' class:
#-------------------------------------------------------------------------------

class OMCanvasController ( HasPrivateTraits ):
    
    #---------------------------------------------------------------------------
    #  Trait definitions:  
    #---------------------------------------------------------------------------

    #---------------------------------------------------------------------------
    #  Returns whether or not the selection for a specified canvas can be 
    #  cleared:  
    #---------------------------------------------------------------------------
    
    def can_clear_selection ( self, canvas ):
        return True
        
    #---------------------------------------------------------------------------
    #  Returns whether or not a specified canvas should allow drag selection:  
    #---------------------------------------------------------------------------
                
    def can_drag_select ( self, canvas ):
        return True
        
    #---------------------------------------------------------------------------
    #  Called whenever a canvas's selection is changed:  
    #---------------------------------------------------------------------------
        
    def selection_changed ( self, canvas ):
        pass
        
    #---------------------------------------------------------------------------
    #  Edit the properties of the specified canvas:  
    #---------------------------------------------------------------------------
    
    def edit_canvas ( self, canvas ):
        canvas.edit()
        
    #---------------------------------------------------------------------------
    #  Returns whether or not a specified object can be dropped on the canvas:
    #---------------------------------------------------------------------------
    
    def can_drop ( self, canvas, object, event ):
        return False
                
    #---------------------------------------------------------------------------
    #  Handles a specified object being dropped on a canvas:
    #---------------------------------------------------------------------------
    
    def dropped ( self, canvas, object, event ):
        pass
        
    #---------------------------------------------------------------------------
    #  Handles a keyboard event for a canvas:  
    #---------------------------------------------------------------------------
                
    def key_pressed ( self, canvas, event ):
        pass
        
    #---------------------------------------------------------------------------
    #  Components were dragged from one location to another:  
    #---------------------------------------------------------------------------
    
    def components_dragged ( self, canvas, components, original_bounds ):
        pass
        
    #---------------------------------------------------------------------------
    #  Components were selected on the canvas:  
    #---------------------------------------------------------------------------
                
    def components_selected ( self, canvas, components, toggle = False ):
        if toggle:
            return canvas.toggle_select_components( components )
        return canvas.select_components( components )
                
    #---------------------------------------------------------------------------
    #  Display the canvas's context menu:
    #
    #  Note: The 'GetSizeTuple/PopupMenuXY' calls make this code wxPython
    #        specific
    #---------------------------------------------------------------------------
    
    def popup_menu ( self, canvas, event ):
        menu = canvas.menu
        if menu is not None:
            self._canvas               = canvas
            self._event                = event
            menu_controller.controller = self
            window                     = canvas.window.control
            dx, dy                     = window.GetSizeTuple()
            window.PopupMenuXY( menu.create_menu( window, menu_controller ),
                                event.x - 10, dy - event.y - 10 )
            self._canvas = self._event = None

