#-------------------------------------------------------------------------------
#
#  Define the base and default containers which are used with Enable components
#  to define the base set of traits defined by a component.
#
#  Written by: David C. Morrill
#
#  Date: 09/22/2003
#
#  (c) Copyright 2003 by Enthought, Inc.
#
#  Classes defined: BaseContainer
#                   DefaultContainer
#
#  Global values defined: default_container
#
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
#  Imports:
#-------------------------------------------------------------------------------
 
from enthought.traits.api          import Trait, HasTraits, ReadOnly, Any, Bool, \
                                      Tuple, Float
from enthought.traits.ui.api       import Group, View
from enthought.traits.standard import flexible_true_trait
from enable_traits             import Pointer
#from radio_group               import ARadioGroup
from radio_group               import radio_group_trait

#-------------------------------------------------------------------------------
#  Constants:
#-------------------------------------------------------------------------------

infinite_bounds = ( -1.0E99, -1.0E99, 2.0E99, 2.0E99 )

#-------------------------------------------------------------------------------
#  'BaseContainer' class:
#-------------------------------------------------------------------------------

class BaseContainer ( HasTraits ):
    """ The base class for enable containers.

    This is a marker base class for subclasses which agree to contain
    Components.  It functions to restrict the container trait of Components to
    be instances of classes marked as a container.  The exact containment
    protocol is up to the individual container.
    
    """
    #---------------------------------------------------------------------------
    #  Trait definitions:
    #---------------------------------------------------------------------------
    
#    radio_group = ARadioGroup
    radio_group = radio_group_trait
    
    #---------------------------------------------------------------------------
    #  Trait editor definition:
    #---------------------------------------------------------------------------
    
    traits_view = View( Group( 'radio_group', id = 'clinks' ) )

#-------------------------------------------------------------------------------
#  'DefaultContainer' class:
#-------------------------------------------------------------------------------

class DefaultContainer ( BaseContainer ):

    #---------------------------------------------------------------------------
    #  Trait definitions:
    #---------------------------------------------------------------------------
    
    visible = Bool( True, 
                    desc  = 'whether the component is visible or not' )
    pointer = Pointer( desc = 'the pointer shape to use' )

    # Set up generic, default trait definitions:
    __ = Any
    
    #---------------------------------------------------------------------------
    #  Returns the visible bounds of the component:
    #---------------------------------------------------------------------------
        
    def _visible_bounds ( self ):
        return infinite_bounds        
    
#-------------------------------------------------------------------------------
#  'SingletonDefaultContainer' class:
#-------------------------------------------------------------------------------
    
class SingletonDefaultContainer ( DefaultContainer ):
    
    #---------------------------------------------------------------------------
    #  Trait definitions:
    #---------------------------------------------------------------------------
    
    window = ReadOnly
    
    bounds = Tuple( Float, Float, Float, Float )

    #---------------------------------------------------------------------------
    #  Dummy method implementations:
    #---------------------------------------------------------------------------
    
    def redraw ( self, bounds = None, coordinates = None ):
        pass
        
    def _needs_redraw ( self, bounds ):
        return False
    
    def remove ( self, *components ):
        pass
        
    def _set_pointer ( self, pointer ):
        pass
    
default_container        = SingletonDefaultContainer()    
default_container.window = default_container

