
/*
    Enki - a fast 2D robot simulator
    Copyright (C) 1999-2016 Stephane Magnenat <stephane at magnenat dot net>
    Copyright (C) 2004-2005 Markus Waibel <markus dot waibel at epfl dot ch>
    Copyright (c) 2004-2005 Antoine Beyeler <abeyeler at ab-ware dot com>
    Copyright (C) 2005-2006 Laboratory of Intelligent Systems, EPFL, Lausanne
    Copyright (C) 2006 Laboratory of Robotics Systems, EPFL, Lausanne
    See AUTHORS for details

    This program is free software; the authors of any publication 
    arising from research using this software are asked to add the 
    following reference:
    Enki - a fast 2D robot simulator
    http://home.gna.org/enki
    Stephane Magnenat <stephane at magnenat dot net>,
    Markus Waibel <markus dot waibel at epfl dot ch>
    Laboratory of Intelligent Systems, EPFL, Lausanne.

    You can redistribute this program and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// Thymio2 body

#include <QtOpenGL>
#include <iostream>

namespace Enki
{
	static short face_indicies[817][9] = { {1,1,1,2,2,1,3,3,1},
{4,4,2,3,5,3,2,6,4},{5,7,1,1,1,1,3,3,1},{6,8,1,5,7,1,3,3,1},{7,9,5,6,10,5,3,5,5},{4,4,5,7,9,5,3,5,5},
{1,1,1,8,11,1,2,2,1},{9,12,6,2,13,7,8,14,8},{9,15,9,4,4,2,2,6,4},{8,14,10,1,16,11,10,17,12},
{9,12,6,8,14,8,10,17,13},{11,18,14,1,19,14,5,20,14},{10,17,12,1,16,11,11,21,15},{6,8,1,12,22,1,5,7,1},{13,23,16,5,20,17,12,24,18},
{11,18,14,5,20,14,13,23,14},{6,8,1,14,25,1,12,22,1},{15,26,19,12,27,20,14,28,21},{15,29,22,13,23,16,12,24,18},{16,30,23,14,28,24,6,31,25},
{16,30,26,15,26,19,14,28,21},{7,32,27,16,30,23,6,31,25},{51,33,14,23,34,14,48,35,14},{52,36,18,22,37,22,23,34,16},{51,33,17,52,36,18,23,34,16},
{53,38,11,48,39,15,49,40,12},{53,41,14,51,33,14,48,35,14},{56,42,8,49,40,13,55,43,6},{56,42,10,53,38,11,49,40,12},{60,44,4,55,45,9,59,46,2},
{60,47,7,56,42,8,55,43,6},{63,48,5,59,46,5,62,49,5},{60,44,4,59,46,2,63,48,3},{64,50,25,62,51,27,20,52,23},{64,53,5,63,48,5,62,49,5},
{65,54,21,20,52,26,22,55,19},{65,54,24,64,50,25,20,52,23},{52,56,20,65,54,21,22,55,19},{66,57,14,28,58,14,27,59,14},{67,60,18,26,61,22,28,58,16},
{66,57,17,67,60,18,28,58,16},{68,62,11,27,63,15,29,64,12},{68,65,14,66,57,14,27,59,14},{71,66,8,29,64,13,70,67,6},{71,66,10,68,62,11,29,64,12},{74,68,4,70,69,28,73,70,2},
{74,71,7,71,66,8,70,67,6},{77,72,5,73,70,5,76,73,5},{74,68,4,73,70,2,77,72,3},{79,74,25,76,75,27,50,76,23},{79,77,5,77,72,5,76,73,5},
{80,78,21,50,76,26,26,79,19},{80,78,24,79,74,25,50,76,23},{67,80,20,80,78,21,26,79,19},{82,81,14,72,82,14,69,83,14},{83,84,18,75,85,22,72,82,16},
{82,81,17,83,84,18,72,82,16},{84,86,11,69,87,15,30,88,12},{84,89,14,82,81,14,69,83,14},{87,90,8,30,88,13,86,91,6},{87,90,10,84,86,11,30,88,12},
{90,92,4,86,93,9,89,94,2},{90,95,7,87,90,8,86,91,6},{93,96,5,89,94,5,92,97,5},{90,92,4,89,94,2,93,96,3},{95,98,25,92,99,27,78,100,23},
{95,101,5,93,96,5,92,97,5},{96,102,21,78,100,26,75,103,19},{96,102,24,95,98,25,78,100,23},{83,104,20,96,102,21,75,103,19},{98,105,14,25,106,14,97,107,14},
{99,108,18,35,109,29,25,106,16},{98,105,17,99,108,18,25,106,16},{102,110,11,97,111,15,101,112,12},{102,113,14,98,105,14,97,107,14},{105,114,8,101,112,13,104,115,6},
{105,114,10,102,110,11,101,112,12},{110,116,4,104,117,28,109,118,2},{110,119,7,105,114,8,104,115,6},{113,120,5,109,118,5,112,121,5},{110,116,4,109,118,2,113,120,3},
{114,122,25,112,123,27,34,124,23},{114,125,5,113,120,5,112,121,5},{115,126,21,34,124,26,35,127,19},{115,126,24,114,122,25,34,124,23},
{99,128,20,115,126,21,35,127,19},{116,129,14,108,130,14,103,131,14},{117,132,18,111,133,22,108,130,16},{116,129,17,117,132,18,108,130,16},{118,134,11,103,135,15,106,136,12},
{118,137,14,116,129,14,103,131,14},{121,138,8,106,136,13,120,139,6},{121,138,10,118,134,11,106,136,12},{125,140,4,120,141,9,124,142,2},{125,143,7,121,138,8,120,139,6},
{128,144,5,124,142,5,127,145,5},{125,140,4,124,142,2,128,144,3},{129,146,25,127,147,27,36,148,23},{129,149,5,128,144,5,127,145,5},{130,150,21,36,148,26,111,151,19},
{130,150,24,129,146,25,36,148,23},{117,152,20,130,150,21,111,151,19},{131,153,14,32,154,14,33,155,14},{132,156,18,100,157,22,32,154,16},{131,153,17,132,156,18,32,154,16},
{133,158,11,33,159,15,18,160,12},{133,161,14,131,153,14,33,155,14},{136,162,8,18,160,13,135,163,6},{136,162,10,133,158,11,18,160,12},{139,164,4,135,165,9,138,166,2},
{139,167,7,136,162,8,135,163,6},{142,168,5,138,166,5,141,169,5},{139,164,4,138,166,2,142,168,3},{144,170,25,141,171,27,107,172,23},{144,173,5,142,168,5,141,169,5},
{145,174,21,107,172,26,100,175,19},{145,174,24,144,170,25,107,172,23},{132,176,20,145,174,21,100,175,19},{147,177,14,137,178,14,134,179,14},{148,180,18,140,181,29,137,178,16},
{147,177,17,148,180,18,137,178,16},{149,182,11,134,183,15,17,184,12},{149,185,14,147,177,14,134,179,14},{152,186,8,17,184,13,151,187,6},{152,186,10,149,182,11,17,184,12},
{155,188,4,151,189,9,154,190,2},{155,191,7,152,186,8,151,187,6},{158,192,5,154,190,5,157,193,5},{155,188,4,154,190,2,158,192,3},{160,194,25,157,195,27,143,196,23},
{160,197,5,158,192,5,157,193,5},{161,198,21,143,196,26,140,199,19},{161,198,24,160,194,25,143,196,23},{148,200,20,161,198,21,140,199,19},{162,201,14,58,202,14,54,203,14},
{163,204,18,61,205,22,58,202,16},{162,201,17,163,204,18,58,202,16},{164,206,11,54,207,15,57,208,12},{164,209,14,162,201,14,54,203,14},{167,210,8,57,208,13,166,211,6},
{167,210,10,164,206,11,57,208,12},{170,212,4,166,213,9,169,214,2},{170,215,7,167,210,8,166,211,6},{173,216,5,169,214,5,172,217,5},{170,212,4,169,214,2,173,216,3},
{174,218,25,172,219,27,46,220,23},{174,221,5,173,216,5,172,217,5},{175,222,21,46,220,26,61,223,19},{175,222,24,174,218,25,46,220,23},{163,224,20,175,222,21,61,223,19},
{176,225,14,168,226,14,165,227,14},{177,228,18,171,229,22,168,226,16},{176,225,17,177,228,18,168,226,16},{178,230,11,165,231,15,81,232,12},{178,233,14,176,225,14,165,227,14},
{181,234,8,81,232,13,180,235,6},{181,234,10,178,230,11,81,232,12},{183,236,4,180,237,9,39,238,2},{183,239,7,181,234,8,180,235,6},{184,240,5,39,238,5,38,241,5},
{183,236,4,39,238,2,184,240,3},{185,242,25,38,243,27,40,244,23},{185,245,5,184,240,5,38,241,5},{186,246,21,40,244,26,171,247,19},{186,246,24,185,242,25,40,244,23},
{177,248,20,186,246,21,171,247,19},{187,249,14,88,250,14,85,251,14},{188,252,18,91,253,22,88,250,16},{187,249,17,188,252,18,88,250,16},{189,254,11,85,255,15,31,256,12},
{189,257,14,187,249,14,85,251,14},{192,258,8,31,256,13,191,259,6},{192,258,10,189,254,11,31,256,12},{195,260,4,191,261,28,194,262,2},{195,263,7,192,258,8,191,259,6},
{198,264,5,194,262,5,197,265,5},{195,260,4,194,262,2,198,264,3},{199,266,25,197,267,27,94,268,23},{199,269,5,198,264,5,197,265,5},{200,270,21,94,268,26,91,271,19},{200,270,24,199,266,25,94,268,23},
{188,272,20,200,270,21,91,271,19},{201,273,14,193,274,14,190,275,14},{202,276,18,196,277,22,193,274,16},{201,273,17,202,276,18,193,274,16},{203,278,14,201,273,14,190,275,14},
{206,279,5,24,280,5,182,281,5},{205,282,4,24,280,2,206,279,3},{207,283,25,182,284,27,179,285,30},{207,286,5,206,279,5,182,281,5},{208,287,21,179,285,26,196,288,19},
{208,287,24,207,283,25,179,285,30},{202,289,20,208,287,21,196,288,19},{209,290,14,123,291,14,119,292,14},{210,293,18,126,294,29,123,291,16},{209,290,17,210,293,18,123,291,16},
{211,295,11,119,296,15,122,297,12},{211,298,14,209,290,14,119,292,14},{214,299,8,122,297,13,213,300,6},{214,299,10,211,295,11,122,297,12},{217,301,4,213,302,28,216,303,2},
{217,304,7,214,299,8,213,300,6},{220,305,5,216,303,5,219,306,5},{217,301,4,216,303,2,220,305,3},{221,307,25,219,308,27,37,309,23},{221,310,5,220,305,5,219,306,5},
{222,311,21,37,309,26,126,312,19},{222,311,24,221,307,25,37,309,23},{210,313,20,222,311,21,126,312,19},{223,314,14,215,315,14,212,316,14},{224,317,18,218,318,22,215,315,16},
{223,314,17,224,317,18,215,315,16},{225,319,11,212,320,15,146,321,12},{225,322,14,223,314,14,212,316,14},{228,323,8,146,321,13,227,324,6},{228,323,10,225,319,11,146,321,12},
{229,325,4,227,326,9,44,327,2},{229,328,7,228,323,8,227,324,6},{230,329,5,44,327,5,43,330,5},{229,325,4,44,327,2,230,329,3},{231,331,25,43,332,27,42,333,23},
{231,334,5,230,329,5,43,330,5},{232,335,21,42,333,26,218,336,19},{232,335,24,231,331,25,42,333,23},{224,337,20,232,335,21,218,336,19},{233,338,14,153,339,14,150,340,14},
{234,341,18,156,342,22,153,339,16},{233,338,17,234,341,18,153,339,16},{235,343,11,150,344,15,19,345,12},{235,346,14,233,338,14,150,340,14},{238,347,8,19,345,13,237,348,6},
{238,347,10,235,343,11,19,345,12},{241,349,4,237,350,9,240,351,2},{241,352,7,238,347,8,237,348,6},{244,353,5,240,351,5,243,354,5},{241,349,4,240,351,2,244,353,3},
{245,355,25,243,356,27,159,357,23},{245,358,5,244,353,5,243,354,5},{246,359,21,159,357,26,156,360,19},{246,359,24,245,355,25,159,357,23},{234,361,20,246,359,21,156,360,19},
{247,362,14,239,363,14,236,364,14},{248,365,18,242,366,29,239,363,16},{247,362,17,248,365,18,239,363,16},{249,367,11,236,368,15,21,369,12},{249,370,14,247,362,14,236,364,14},
{250,371,8,21,369,13,47,372,6},{250,371,10,249,367,11,21,369,12},{251,373,4,47,374,9,41,375,2},{251,376,7,250,371,8,47,372,6},{252,377,5,41,375,5,45,378,5},
{251,373,4,41,375,2,252,377,3},{253,379,25,45,380,27,226,381,23},{253,382,5,252,377,5,45,378,5},{254,383,21,226,381,26,242,384,19},{254,383,24,253,379,25,226,381,23},
{248,385,20,254,383,21,242,384,19},{267,386,31,258,387,32,259,388,33},{268,389,34,265,390,35,258,387,32},{268,389,34,258,387,32,267,386,31},{269,391,36,259,388,33,260,392,37},
{270,393,38,267,386,31,259,388,33},{269,391,36,270,393,38,259,388,33},{271,394,39,260,395,37,261,396,40},{271,394,39,269,397,36,260,395,37},{272,398,41,261,396,40,255,399,42},
{272,398,41,271,394,39,261,396,40},{273,400,43,255,399,42,257,401,44},{273,400,43,272,398,41,255,399,42},{274,402,45,257,403,44,256,404,46},{274,402,45,273,405,43,257,403,44},
{275,406,47,256,404,46,263,407,48},{275,406,47,274,402,45,256,404,46},{276,408,49,263,409,48,264,410,50},{277,411,51,275,406,47,263,407,48},{276,408,49,277,412,51,263,409,48},
{278,413,52,264,410,50,262,414,53},{278,413,52,276,408,49,264,410,50},{279,415,54,262,414,53,266,416,55},{279,415,54,278,413,52,262,414,53},{280,417,56,266,418,55,265,390,35},
{280,419,56,279,415,54,266,416,55},{268,389,34,280,417,56,265,390,35},{281,420,57,267,386,31,270,393,38},{282,421,58,267,386,31,281,420,57},{282,421,58,268,389,34,267,386,31},
{283,422,59,270,423,38,269,424,36},{281,420,57,270,393,38,283,425,59},{284,426,60,269,424,36,271,427,39},{283,422,59,269,424,36,284,426,60},{285,428,61,271,394,39,272,398,41},
{284,426,60,271,427,39,285,429,61},{286,430,62,272,431,41,273,432,43},{285,428,61,272,398,41,286,433,62},{287,434,63,273,432,43,274,435,45},{286,430,62,273,432,43,287,434,63},
{288,436,64,274,402,45,275,406,47},{287,434,63,274,435,45,288,437,64},{288,436,64,275,406,47,289,438,65},{277,411,51,289,438,65,275,406,47},{288,437,64,289,439,65,290,440,66},
{291,441,67,290,440,66,289,439,65},{287,434,63,288,437,64,290,440,66},{286,430,62,287,434,63,290,440,66},{285,429,61,286,430,62,290,440,66},{284,426,60,285,429,61,290,440,66},
{283,422,59,284,426,60,290,440,66},{281,442,57,283,422,59,290,440,66},{282,443,58,281,442,57,290,440,66},{292,444,68,290,440,66,291,441,67},{293,445,69,290,440,66,292,444,68},
{294,446,70,290,440,66,293,445,69},{295,447,71,290,440,66,294,446,70},{282,443,58,290,440,66,295,447,71},{291,448,67,289,438,65,277,411,51},{291,441,67,277,449,51,276,450,49},{292,451,68,276,408,49,278,413,52},
{292,444,68,291,441,67,276,450,49},{293,452,69,278,413,52,279,415,54},{293,452,69,292,451,68,278,413,52},{294,446,70,279,453,54,280,454,56},{294,455,70,293,452,69,279,415,54},
{295,447,71,280,454,56,268,456,34},{295,447,71,294,446,70,280,454,56},{282,443,58,295,447,71,268,456,34},{53,457,1,63,458,1,51,459,1},{60,460,1,63,458,1,53,457,1},
{52,461,1,64,462,1,65,463,1},{51,464,1,64,462,1,52,461,1},{60,460,1,53,457,1,56,465,1},{66,466,1,77,467,1,79,468,1},{68,469,1,77,467,1,66,466,1},
{74,470,1,77,467,1,68,469,1},{67,471,1,79,468,1,80,472,1},{66,466,1,79,468,1,67,471,1},{74,470,1,68,469,1,71,473,1},{82,474,1,93,475,1,95,476,1},
{84,477,1,93,475,1,82,474,1},{90,478,1,93,475,1,84,477,1},{83,479,1,95,476,1,96,480,1},{82,474,1,95,476,1,83,479,1},{90,478,1,84,477,1,87,481,1},
{98,482,1,113,483,1,114,484,1},{102,485,1,113,483,1,98,482,1},{110,486,1,113,483,1,102,485,1},{99,487,1,114,484,1,115,488,1},{98,482,1,114,484,1,99,487,1},
{110,486,1,102,485,1,105,489,1},{116,490,1,128,491,1,129,492,1},{118,493,1,128,491,1,116,490,1},{125,494,1,128,491,1,118,493,1},{117,495,1,129,492,1,130,496,1},
{116,490,1,129,492,1,117,495,1},{125,494,1,118,493,1,121,497,1},{131,498,1,142,499,1,144,500,1},{133,501,1,142,499,1,131,498,1},{139,502,1,142,499,1,133,501,1},
{132,503,1,144,500,1,145,504,1},{131,498,1,144,500,1,132,503,1},{139,502,1,133,501,1,136,505,1},{147,506,1,158,507,1,160,508,1},{149,509,1,158,507,1,147,506,1},
{155,510,1,158,507,1,149,509,1},{148,511,1,160,508,1,161,512,1},{147,506,1,160,508,1,148,511,1},{155,510,1,149,509,1,152,513,1},{162,514,1,173,515,1,174,516,1},
{164,517,1,173,515,1,162,514,1},{170,518,1,173,515,1,164,517,1},{163,519,1,174,516,1,175,520,1},{162,514,1,174,516,1,163,519,1},{170,518,1,164,517,1,167,521,1},
{176,522,1,184,523,1,185,524,1},{178,525,1,184,523,1,176,522,1},{183,526,1,184,523,1,178,525,1},{177,527,1,185,524,1,186,528,1},{176,522,1,185,524,1,177,527,1},
{183,526,1,178,525,1,181,529,1},{187,530,1,198,531,1,199,532,1},{189,533,1,198,531,1,187,530,1},{195,534,1,198,531,1,189,533,1},{188,535,1,199,532,1,200,536,1},
{187,530,1,199,532,1,188,535,1},{195,534,1,189,533,1,192,537,1},{201,538,1,206,539,1,207,540,1},{203,541,1,206,539,1,201,538,1},{205,542,1,206,539,1,203,541,1},
{202,543,1,207,540,1,208,544,1},{201,538,1,207,540,1,202,543,1},{205,542,1,203,541,1,204,545,1},{209,546,1,220,547,1,221,548,1},{211,549,1,220,547,1,209,546,1},
{217,550,1,220,547,1,211,549,1},{210,551,1,221,548,1,222,552,1},{209,546,1,221,548,1,210,551,1},{217,550,1,211,549,1,214,553,1},{223,554,1,230,555,1,231,556,1},
{225,557,1,230,555,1,223,554,1},{229,558,1,230,555,1,225,557,1},{224,559,1,231,556,1,232,560,1},{223,554,1,231,556,1,224,559,1},{229,558,1,225,557,1,228,561,1},
{233,562,1,244,563,1,245,564,1},{235,565,1,244,563,1,233,562,1},{241,566,1,244,563,1,235,565,1},{234,567,1,245,564,1,246,568,1},{233,562,1,245,564,1,234,567,1},
{241,566,1,235,565,1,238,569,1},{247,570,1,252,571,1,253,572,1},{249,573,1,252,571,1,247,570,1},{251,574,1,252,571,1,249,573,1},{248,575,1,253,572,1,254,576,1},
{247,570,1,253,572,1,248,575,1},{251,574,1,249,573,1,250,577,1},{296,578,72,303,579,73,298,580,1},{308,581,74,296,578,72,307,582,75},{308,581,74,309,583,76,296,578,72},
{312,584,77,307,585,78,311,586,79},{312,584,77,313,587,80,307,585,78},{308,588,81,307,585,78,360,589,82},{315,590,83,311,586,79,314,591,84},{312,584,77,311,586,79,315,590,83},
{318,592,85,314,591,84,317,593,86},{315,590,83,314,591,84,318,592,85},{318,592,85,317,593,86,319,594,87},{320,595,88,319,594,87,316,596,89},{318,592,85,319,594,87,320,595,88},
{321,597,90,316,596,89,310,598,91},{320,595,88,316,596,89,321,597,90},{322,599,92,310,598,91,304,600,93},{321,597,90,310,598,91,322,599,92},{322,599,92,304,600,93,323,601,94},
{325,602,95,298,603,96,324,604,97},{326,605,98,297,606,99,325,602,95},{328,607,100,324,608,97,331,609,101},{328,610,100,325,602,95,324,604,97},{330,611,102,327,612,103,329,613,104},
{331,609,101,327,612,103,330,611,102},{297,606,99,298,603,96,325,602,95},{333,614,105,332,615,106,335,616,107},{324,608,97,327,612,103,331,609,101},{336,617,108,300,618,109,299,619,110},
{337,620,111,299,619,110,301,621,112},{336,617,108,299,619,110,337,620,111},{326,622,98,301,621,112,297,623,99},{338,624,113,301,621,112,326,622,98},{337,620,111,301,621,112,338,624,113},
{327,625,1,303,579,73,329,626,1},{317,627,1,334,628,1,319,629,1},{314,630,1,334,628,1,317,627,1},{319,629,1,334,628,1,316,631,1},{334,628,1,332,632,1,316,631,1},
{303,579,73,324,633,1,298,580,1},{304,634,114,310,635,1,332,632,1},{304,634,114,332,632,1,329,626,1},{323,636,115,304,634,114,305,637,116},{304,634,114,303,579,73,305,637,116},
{324,633,1,303,579,73,327,625,1},{329,626,1,303,579,73,304,634,114},{316,631,1,332,632,1,310,635,1},{303,638,117,296,639,118,354,640,119},{340,641,120,305,637,116,339,642,121},
{340,641,120,323,636,115,305,637,116},{353,643,122,355,644,123,357,645,123},{342,646,124,339,647,121,341,648,125},{342,646,124,340,649,120,339,647,121},{355,644,123,356,650,123,357,645,123},
{342,646,124,341,648,125,344,651,126},{359,652,127,353,643,122,357,645,123},{452,653,123,377,654,123,400,655,123},{339,656,128,305,657,128,303,638,117},{377,654,123,343,658,129,400,655,123},
{358,659,123,359,652,127,357,645,123},{343,658,129,354,640,119,400,655,123},{359,652,127,351,660,130,353,643,122},{351,660,130,359,652,127,296,639,118},{352,661,128,351,660,130,296,639,118},
{343,658,129,341,662,131,354,640,119},{309,663,128,352,661,128,296,639,118},{354,640,119,341,662,131,303,638,117},{360,664,132,351,665,133,352,666,134},{361,667,135,351,665,133,360,664,132},
{362,668,135,353,669,136,351,665,133},{363,670,135,362,668,135,351,665,133},{364,671,135,363,670,135,351,665,133},{361,667,135,364,671,135,351,665,133},{365,672,137,352,673,134,309,583,76},
{366,674,138,360,664,132,352,666,134},{366,674,138,352,666,134,365,675,137},{365,672,137,309,583,76,308,581,74},{342,646,139,344,651,140,340,649,141},{322,599,92,323,601,94,340,676,141},
{370,677,142,340,649,141,367,678,143},{322,599,92,340,676,141,370,679,142},{344,651,140,367,678,143,340,649,141},{371,680,144,347,681,145,346,682,144},{372,683,146,348,684,147,347,681,145},
{372,683,146,347,681,145,373,685,148},{374,686,144,373,685,148,347,681,145},{375,687,144,374,686,144,347,681,145},{376,688,144,347,681,145,371,680,144},{375,687,144,347,681,145,376,688,144},
{377,689,149,346,690,150,343,691,151},{371,692,152,346,690,150,377,689,149},{354,640,119,453,693,123,400,655,123},{368,694,153,381,695,154,370,679,142},{378,696,155,379,697,156,380,698,157},
{380,698,157,381,695,154,378,696,155},{322,599,92,370,679,142,381,695,154},{384,699,158,368,700,159,383,701,160},{378,702,161,368,700,159,384,699,158},{387,703,162,383,704,163,382,705,164},
{384,706,163,383,704,163,387,703,162},{387,703,162,382,705,164,385,707,165},{388,708,166,385,707,165,386,709,167},{389,710,168,387,703,162,385,707,165},{388,708,166,389,710,168,385,707,165},
{390,711,169,386,712,167,369,713,170},{390,711,169,388,714,166,386,712,167},{391,715,171,369,713,170,345,716,171},{391,715,171,390,711,169,369,713,170},{391,715,171,345,716,171,349,717,172},
{392,718,173,349,717,172,350,719,174},{392,718,173,391,715,171,349,717,172},{393,720,174,350,721,174,348,684,147},{393,722,174,392,718,173,350,719,174},{372,683,146,393,720,174,348,684,147},
{394,723,175,372,724,175,373,725,175},{374,726,175,394,723,175,373,725,175},{394,723,175,387,727,175,389,728,175},{395,729,163,387,703,162,394,730,163},{396,731,163,384,706,163,387,703,162},
{395,729,163,396,731,163,387,703,162},{394,723,175,389,728,175,388,732,175},{394,723,175,388,732,175,390,733,175},{394,723,175,390,733,175,391,734,175},{394,723,175,391,734,175,392,735,175},
{394,723,175,392,735,175,393,736,175},{394,723,175,393,736,175,372,724,175},{375,737,176,400,738,177,374,739,66},{466,740,66,444,741,66,404,742,66},{406,743,66,408,744,66,403,745,66},
{379,746,178,384,699,158,396,747,179},{379,746,178,378,702,161,384,699,158},{380,748,180,396,749,179,395,750,181},{380,748,180,379,751,178,396,749,179},{381,752,182,380,748,180,395,750,181},
{322,599,92,381,695,154,410,753,183},{445,754,66,444,741,66,447,755,66},{422,756,66,423,757,66,451,758,66},{420,759,66,422,756,66,399,760,66},{360,589,82,366,761,184,365,762,185},
{204,763,8,302,764,13,306,765,6},{312,584,77,413,766,186,313,587,80},{307,585,78,313,587,80,412,767,187},{365,762,185,308,588,81,360,589,82},{414,768,188,313,587,80,413,766,186},
{415,769,189,414,770,190,411,771,191},{414,770,190,415,769,189,313,772,135},{416,773,192,411,771,191,413,774,193},{416,773,192,415,769,189,411,771,191},{417,775,194,413,766,186,409,776,195},
{418,777,196,413,778,193,417,779,197},{418,777,196,416,780,192,413,778,193},{313,772,135,415,769,189,412,781,135},{418,777,196,417,779,197,409,782,198},{312,584,77,419,783,199,409,776,195},
{451,758,66,399,760,66,422,756,66},{418,777,196,409,782,198,398,784,200},{419,785,66,420,759,66,399,760,66},{409,782,198,419,785,66,399,760,66},{410,786,66,394,787,66,421,788,66},
{398,784,200,409,782,198,399,760,66},{315,590,83,420,789,201,419,783,199},{381,752,182,394,787,66,410,786,66},{312,584,77,315,590,83,419,783,199},{446,790,66,440,791,66,448,792,66},
{395,750,181,394,787,66,381,752,182},{421,788,66,394,787,66,423,757,66},{451,758,66,450,793,66,399,760,66},{318,592,85,422,794,202,420,789,201},{394,787,66,397,795,66,451,758,66},
{315,590,83,318,592,85,420,789,201},{450,793,66,449,796,66,399,760,66},{320,595,88,423,797,203,422,794,202},{318,592,85,320,595,88,422,794,202},{320,595,88,421,798,204,423,797,203},
{321,597,90,410,753,183,421,798,204},{320,595,88,321,597,90,421,798,204},{321,597,90,322,599,92,410,753,183},{360,664,132,415,769,189,424,799,135},{416,800,205,424,801,206,415,802,205},
{425,803,135,360,664,132,424,799,135},{426,804,207,425,805,208,424,801,206},{427,806,209,426,804,207,424,801,206},{399,807,205,427,806,209,424,801,206},{398,808,205,399,807,205,424,801,206},
{418,809,205,398,808,205,424,801,206},{418,809,205,424,801,206,416,800,205},{307,585,78,412,767,187,360,589,82},{428,810,135,361,667,135,360,664,132},{429,811,135,428,810,135,360,664,132},
{425,803,135,429,811,135,360,664,132},{430,812,135,431,813,210,353,669,136},{432,814,211,353,669,136,431,813,210},{362,668,135,430,812,135,353,669,136},{355,815,212,353,669,136,432,814,211},
{433,816,213,431,817,214,430,818,215},{432,819,214,431,817,214,433,816,213},{433,816,213,430,818,215,362,820,216},{434,821,216,362,820,216,363,822,217},{434,821,216,433,816,213,362,820,216},
{435,823,218,363,824,217,364,825,219},{435,826,218,434,821,216,363,822,217},{436,827,220,364,825,219,361,828,221},{436,827,220,435,823,218,364,825,219},{437,829,222,361,828,221,428,830,223},
{437,829,222,436,827,220,361,828,221},{438,831,224,428,830,223,429,832,225},{438,831,224,437,829,222,428,830,223},{439,833,226,429,834,225,425,805,208},{439,835,226,438,831,224,429,832,225},
{426,804,207,439,833,226,425,805,208},{440,836,135,433,837,135,434,838,135},{441,839,214,433,816,213,440,840,214},{442,841,214,432,819,214,433,816,213},{441,839,214,442,841,214,433,816,213},
{440,836,135,434,838,135,435,842,135},{440,836,135,435,842,135,436,843,135},{440,836,135,436,843,135,437,844,135},{440,836,135,437,844,135,438,845,135},{440,836,135,438,845,135,439,846,135},
{440,836,135,439,846,135,426,847,135},{440,836,135,426,847,135,427,848,135},{399,849,135,440,836,135,427,848,135},{394,787,66,407,850,66,397,795,66},{441,851,227,440,791,66,357,852,228},
{443,853,66,358,854,66,440,791,66},{449,796,66,448,792,66,399,760,66},{403,745,66,404,742,66,406,743,66},{440,791,66,399,760,66,448,792,66},{448,792,66,445,754,66,447,755,66},
{404,742,66,444,741,66,445,754,66},{374,739,66,408,744,66,407,850,66},{447,755,66,446,790,66,448,792,66},{394,787,66,451,758,66,423,757,66},{443,853,66,440,791,66,446,790,66},
{355,855,212,432,856,211,442,857,229},{356,858,230,442,857,229,441,851,227},{356,858,230,355,855,212,442,857,229},{357,852,228,356,858,230,441,851,227},{371,692,152,377,689,149,452,859,231},
{359,652,127,354,640,119,296,639,118},{376,860,232,452,861,231,400,738,177},{376,862,232,371,692,152,452,859,231},{341,662,131,339,656,128,303,638,117},{378,696,155,381,695,154,368,694,153},
{375,737,176,376,860,232,400,738,177},{401,863,135,453,864,135,354,865,135},{454,866,66,354,867,66,456,868,66},{454,869,135,401,863,135,354,865,135},{455,870,175,359,871,175,358,872,175},
{457,873,66,456,868,66,359,874,66},{440,791,66,358,854,66,357,852,228},{354,867,66,359,874,66,456,868,66},{457,873,66,359,874,66,455,875,66},{455,870,175,358,872,175,443,876,175},
{458,877,66,459,878,66,460,879,66},{461,880,233,460,881,233,459,882,234},{462,883,66,458,877,66,460,879,66},{463,884,66,462,883,66,460,879,66},{464,885,235,463,886,235,460,881,233},
{464,885,235,460,881,233,461,880,233},{465,887,66,466,740,66,459,878,66},{467,888,234,459,882,234,466,889,236},{458,877,66,465,887,66,459,878,66},{461,880,233,459,882,234,467,888,234},
{403,745,66,466,740,66,404,742,66},{468,890,237,466,891,238,403,892,239},{465,887,66,444,741,66,466,740,66},{468,893,236,467,888,234,466,889,236},{394,787,66,374,739,66,407,850,66},
{468,890,237,403,892,239,469,894,240},{401,863,241,469,895,240,405,896,242},{405,896,242,469,895,240,402,897,243},{403,892,239,402,898,243,469,894,240},{469,895,244,401,863,244,454,869,244},
{470,899,245,447,900,246,444,901,247},{447,902,246,470,903,245,446,904,248},{446,904,248,470,903,245,443,876,249},{470,899,245,444,901,247,465,905,250},{443,876,251,470,903,251,455,870,251},
{471,906,252,465,907,252,458,908,253},{471,909,250,470,899,245,465,905,250},{472,910,253,458,908,253,462,911,254},{471,906,252,458,908,253,472,910,253},{463,884,66,473,912,66,462,883,66},
{474,913,254,462,911,254,473,914,255},{472,910,253,462,911,254,474,913,254},{475,915,66,476,916,66,463,884,66},{477,917,255,473,918,255,476,919,256},{469,895,244,454,869,244,456,920,244},
{474,913,254,473,914,255,477,921,255},{478,922,256,476,919,256,475,923,257},{477,917,255,476,919,256,478,922,256},{479,924,257,475,923,257,463,925,235},{478,922,256,475,923,257,479,924,257},
{479,924,257,463,925,235,464,926,235},{325,602,95,404,927,258,445,928,259},{328,610,100,406,929,260,325,602,95},{448,930,261,449,931,262,337,620,111},{326,622,98,445,932,259,448,930,261},
{326,605,98,325,602,95,445,928,259},{338,624,113,448,930,261,337,620,111},{338,624,113,326,622,98,448,930,261},{336,617,108,449,931,262,450,933,263},{332,615,106,334,934,264,335,616,107},
{336,617,108,337,620,111,449,931,262},{335,616,107,451,935,265,397,936,266},{406,929,260,404,927,258,325,602,95},{333,614,105,335,616,107,397,936,266},{331,609,101,408,937,267,406,938,260},
{328,607,100,331,609,101,406,938,260},{480,939,1,461,940,1,467,941,1},{472,942,1,467,941,1,468,943,1},{481,944,1,467,941,1,472,942,1},{482,945,1,480,939,1,467,941,1},
{483,946,1,482,945,1,467,941,1},{481,944,1,483,946,1,467,941,1},{484,947,1,464,948,1,461,940,1},{480,939,1,484,947,1,461,940,1},{471,949,1,468,943,1,469,950,1},
{470,951,268,469,952,268,456,953,268},{471,949,1,469,950,1,470,954,1},{471,949,1,472,942,1,468,943,1},{457,955,268,470,951,268,456,953,268},{455,870,251,470,903,251,457,956,251},
{485,957,1,479,958,1,464,948,1},{484,947,1,485,957,1,464,948,1},{485,957,1,478,959,1,479,958,1},{485,957,1,477,960,1,478,959,1},{486,961,1,474,962,1,477,960,1},
{487,963,1,486,961,1,477,960,1},{485,957,1,487,963,1,477,960,1},{481,944,1,472,942,1,474,962,1},{481,944,1,474,962,1,486,961,1},{488,964,269,486,965,269,487,966,269},
{489,967,270,481,968,271,486,965,272},{488,964,273,489,967,270,486,965,272},{490,969,274,487,970,275,485,971,276},{490,972,269,488,964,269,487,966,269},{491,973,277,485,971,278,484,974,279},
{491,973,280,490,969,274,485,971,276},{492,975,281,484,976,282,480,977,283},{492,978,284,491,973,277,484,974,279},{493,979,285,480,977,285,482,980,285},{492,975,281,480,977,283,493,979,286},
{494,981,287,482,982,288,483,983,289},{494,984,285,493,979,285,482,980,285},{495,985,290,483,983,291,481,986,292},{495,985,293,494,981,287,483,983,289},{489,987,294,495,985,290,481,986,292},
{488,988,1,493,989,1,494,990,1},{490,991,1,493,989,1,488,988,1},{492,992,1,493,989,1,490,991,1},{489,993,1,494,990,1,495,994,1},{488,988,1,494,990,1,489,993,1},
{492,992,1,490,991,1,491,995,1},{334,628,1,314,630,1,300,996,1},{314,630,1,311,997,1,300,996,1},{300,996,1,307,582,75,299,998,1},{311,997,1,307,582,75,300,996,1},
{301,999,1,299,998,1,296,578,72},{297,1000,1,301,999,1,296,578,72},{298,580,1,297,1000,1,296,578,72},{307,582,75,296,578,72,299,998,1},{341,648,125,343,691,151,347,1001,175},
{369,1002,175,344,651,126,345,1003,175},{345,1003,175,344,651,126,341,648,125},{345,1003,175,341,648,125,349,1004,175},{349,1004,175,341,648,125,350,1005,175},{350,1005,175,341,648,125,348,1006,175},
{348,1006,175,341,648,125,347,1001,175},{412,781,135,415,769,189,360,664,132},{386,1007,175,385,1008,175,344,651,126},{368,700,159,385,1008,175,382,1009,175},{413,766,186,312,584,77,409,776,195},
{368,700,159,382,1009,175,383,701,160},{346,690,150,347,1001,175,343,691,151},{344,651,126,369,1002,175,386,1007,175},{203,1010,11,190,1011,15,302,764,12},{476,916,66,473,912,66,463,884,66},
{374,739,66,400,738,177,453,1012,66},{374,739,66,453,1012,66,401,1013,66},{408,744,66,374,739,66,405,1014,66},{408,744,66,405,1014,66,402,1015,66},{408,744,66,402,1015,66,403,745,66},
{374,739,66,401,1013,66,405,1014,66},{336,1016,108,335,616,107,300,1017,109},{450,1018,263,335,616,107,336,1016,108},{450,1018,263,451,935,265,335,616,107},{300,1017,109,335,616,107,334,934,264},
{332,1019,106,333,1020,105,329,613,104},{411,1021,295,414,768,188,413,766,186},{330,611,102,408,937,267,331,609,101},{333,1020,105,407,1022,296,330,611,102},{397,1023,266,407,1022,296,333,1020,105},
{329,613,104,333,1020,105,330,611,102},{330,611,102,407,1022,296,408,937,267},{367,678,175,344,651,126,385,1008,175},{370,677,175,367,678,175,385,1008,175},{368,700,159,370,677,175,385,1008,175},
{63,458,1,64,53,1,51,464,1},{204,763,10,203,1010,11,302,764,12},{205,282,4,306,1024,9,24,280,2},{205,1025,7,204,763,8,306,765,6},{306,1026,1,24,1027,1,302,1028,1}
	};
	static GLfloat vertices [497][3] = {
{-3.872785,4.573677,5.460000}, {-3.872635,4.226219,5.460000},{-3.699999,4.155021,5.460000},
{-3.699999,4.155021,5.300000}, {-3.699999,4.645021,5.460000},{-3.527214,4.226365,5.460000}, {-3.527201,4.226371,5.300000},{-3.944955,4.399917,5.460000},
{-3.872907,4.226478,5.300000}, {-3.944962,4.400096,5.300000},{-3.872798,4.573670,5.300000}, {-3.527364,4.573823,5.460000},{-3.699999,4.645021,5.300000},
{-3.455043,4.400124,5.460000}, {-3.527092,4.573564,5.300000},{-3.455037,4.399945,5.300000}, {0.055038,3.600055,5.300000}, {0.055038,4.400096,5.300000},
{0.055038,-3.599904,5.300000}, {-3.455037,3.599904,5.300000},{0.055038,-4.399945,5.300000}, {-3.527092,3.773522,5.300000},{-3.699999,3.844980,5.300000},
{-4.499999,-4.645021,5.300001},{1.100001,4.645021,5.300000}, {-4.327092,4.573564,5.300001}, {-4.672798,4.573670,5.300001},{-4.499999,4.645021,5.300001},
{-4.744962,4.400096,5.300001}, {-4.744962,3.600055,5.300001},{-4.744962,-3.599904,5.300001},{0.300001,4.645021,5.300000}, {0.127202,4.573670,5.300000},
{1.344963,4.399945,5.300000},  {1.272908,4.573564,5.300000}, {1.344963,3.599904,5.300000},  {1.344963,-3.600055,5.300000},{-3.527201,-4.573670,5.300000},
{-3.699999,-4.645021,5.300000},{-3.455037,-4.400096,5.300000},{0.300001,-4.645021,5.300000},{1.344963,-4.400096,5.300000},{1.272799,-4.573670,5.300000},
{1.100001,-4.645021,5.300000}, {0.472800,-4.573670,5.300000},{-3.455037,-3.600055,5.300000},{0.127093,-4.573564,5.300000},{-3.872798,3.773629,5.300000},
{-3.944962,3.600055,5.300000}, {-4.255037,4.399945,5.300001},{-3.699999,3.844980,5.460000}, {-3.527364,3.773782,5.460000},{-3.872785,3.773635,5.460000},
{-3.872798,-3.426330,5.300000},{-3.872907,3.426437,5.300000},{-3.944955,3.599876,5.460000}, {-3.944962,-3.599904,5.300000},{-3.699999,-3.354979,5.300000},
{-3.699999,3.354979,5.300000}, {-3.872635,3.426177,5.460000},{-3.527092,-3.426437,5.300000},{-3.527201,3.426330,5.300000},{-3.699999,3.354979,5.460000},
{-3.527214,3.426324,5.460000}, {-3.455043,3.600083,5.460000},{-4.499999,4.645021,5.460001}, {-4.327363,4.573823,5.460001},{-4.672785,4.573677,5.460001},
{-4.672798,3.773629,5.300001}, {-4.672907,4.226478,5.300001},{-4.744955,4.399917,5.460001}, {-4.499999,3.844980,5.300001},{-4.499999,4.155021,5.300001},
{-4.672635,4.226219,5.460001}, {-4.327092,3.773522,5.300001},{-4.327200,4.226371,5.300001}, {-4.499999,4.155021,5.460001},{-4.255037,3.599904,5.300001},
{-4.327214,4.226365,5.460001}, {-4.255043,4.400124,5.460001},{-3.944962,-4.399945,5.300000},{-4.499999,3.844980,5.460001},{-4.327363,3.773782,5.460001},
{-4.672785,3.773635,5.460001}, {-4.672798,-3.426330,5.300001},{-4.672907,3.426437,5.300001},{-4.744955,3.599876,5.460001},{-4.499999,-3.354979,5.300001},
{-4.499999,3.354979,5.300001}, {-4.672635,3.426177,5.460001},{-4.327092,-3.426437,5.300001},{-4.327200,3.426330,5.300001},{-4.499999,3.354979,5.460001},
{-4.255037,-3.600055,5.300001},{-4.327214,3.426324,5.460001},{-4.255043,3.600083,5.460001}, {0.927202,4.573670,5.300000}, {1.100001,4.645021,5.460000},
{1.272636,4.573823,5.460000},  {0.472908,4.573564,5.300000}, {0.855038,4.400096,5.300000},  {0.927216,4.573677,5.460000}, {0.927202,3.773629,5.300000},
{0.927094,4.226478,5.300000},  {0.855045,4.399917,5.460000}, {0.855038,3.600055,5.300000},  {0.544963,4.399945,5.300000}, {1.100001,3.844980,5.300000},
{1.100001,4.155021,5.300000},  {0.927365,4.226219,5.460000}, {1.272908,3.773522,5.300000},  {1.272799,4.226371,5.300000}, {1.100001,4.155021,5.460000},
{1.272786,4.226365,5.460000},  {1.344957,4.400124,5.460000}, {1.100001,3.844980,5.460000},  {1.272636,3.773782,5.460000}, {0.927216,3.773635,5.460000},
{0.927202,-3.426330,5.300000}, {0.927094,3.426437,5.300000}, {0.855045,3.599876,5.460000},  {0.855038,-3.599904,5.300000},{1.100001,-3.354979,5.300000},
{1.100001,3.354979,5.300000},  {0.927365,3.426177,5.460000}, {1.272908,-3.426437,5.300000}, {1.272799,3.426330,5.300000}, {1.100001,3.354979,5.460000},
{1.272786,3.426324,5.460000},  {1.344957,3.600083,5.460000}, {0.300001,4.645021,5.460000},  {0.472636,4.573823,5.460000}, {0.127215,4.573677,5.460000},
{0.127202,3.773629,5.300000},  {0.127093,4.226478,5.300000}, {0.055045,4.399917,5.460000},  {0.300001,3.844980,5.300000}, {0.300001,4.155021,5.300000},
{0.127365,4.226219,5.460000},  {0.472908,3.773522,5.300000}, {0.472800,4.226371,5.300000},  {0.300001,4.155021,5.460000}, {0.544963,3.599904,5.300000},
{0.472786,4.226365,5.460000},  {0.544957,4.400124,5.460000}, {0.855038,-4.399945,5.300000}, {0.300001,3.844980,5.460000}, {0.472636,3.773782,5.460000},
{0.127215,3.773635,5.460000},  {0.127202,-3.426330,5.300000},{0.127093,3.426437,5.300000},  {0.055045,3.599876,5.460000}, {0.300001,-3.354979,5.300000},
{0.300001,3.354979,5.300000},  {0.127365,3.426177,5.460000}, {0.472908,-3.426437,5.300000}, {0.472800,3.426330,5.300000}, {0.300001,3.354979,5.460000},
{0.544963,-3.600055,5.300000}, {0.472786,3.426324,5.460000}, {0.544957,3.600083,5.460000},  {-3.699999,-3.354979,5.460000}, {-3.527364,-3.426177,5.460000},
{-3.872785,-3.426324,5.460000},{-3.872798,-4.226371,5.300000},{-3.872907,-3.773522,5.300000},{-3.944955,-3.600083,5.460000},{-3.699999,-4.155021,5.300000},
{-3.699999,-3.844980,5.300000},{-3.872635,-3.773782,5.460000},{-3.527092,-4.226478,5.300000},{-3.527201,-3.773629,5.300000},{-3.699999,-3.844980,5.460000},
{-3.527214,-3.773635,5.460000},{-3.455043,-3.599876,5.460000},{-3.699999,-4.155021,5.460000},{-3.527364,-4.226219,5.460000},{-3.872785,-4.226365,5.460000},
{-4.255037,-4.400096,5.300001},{-3.872907,-4.573564,5.300000},{-3.944955,-4.400124,5.460000},{-4.327200,-4.573670,5.300001},{-3.872635,-4.573823,5.460000},
{-3.699999,-4.645021,5.460000},{-3.527214,-4.573677,5.460000},{-3.455043,-4.399917,5.460000},{-4.499999,-3.354979,5.460001},{-4.327363,-3.426177,5.460001},
{-4.672785,-3.426324,5.460001},{-4.672798,-4.226371,5.300001},{-4.672907,-3.773522,5.300001},{-4.744955,-3.600083,5.460001},{-4.499999,-4.155021,5.300001},
{-4.499999,-3.844980,5.300001},{-4.672635,-3.773782,5.460001},{-4.327092,-4.226478,5.300001},{-4.327200,-3.773629,5.300001},{-4.499999,-3.844980,5.460001},
{-4.327214,-3.773635,5.460001},{-4.255043,-3.599876,5.460001},{-4.499999,-4.155021,5.460001},{-4.327363,-4.226219,5.460001},{-4.672785,-4.226365,5.460001},
{-4.744955,-4.400124,5.460001},{-4.672635,-4.573823,5.460001},{-4.499999,-4.645021,5.460001},{-4.327214,-4.573677,5.460001},{-4.255043,-4.399917,5.460001},
{1.100001,-3.354979,5.460000}, {1.272636,-3.426177,5.460000},{0.927216,-3.426324,5.460000}, {0.927202,-4.226371,5.300000}, {0.927094,-3.773522,5.300000},
{0.855045,-3.600083,5.460000}, {1.100001,-4.155021,5.300000},{1.100001,-3.844980,5.300000}, {0.927365,-3.773782,5.460000}, {1.272908,-4.226478,5.300000},
{1.272799,-3.773629,5.300000}, {1.100001,-3.844980,5.460000},{1.272786,-3.773635,5.460000}, {1.344957,-3.599876,5.460000}, {1.100001,-4.155021,5.460000},
{1.272636,-4.226219,5.460000}, {0.927216,-4.226365,5.460000},{0.544963,-4.400096,5.300000}, {0.927094,-4.573564,5.300000}, {0.855045,-4.400124,5.460000},
{0.927365,-4.573823,5.460000}, {1.100001,-4.645021,5.460000},{1.272786,-4.573677,5.460000}, {1.344957,-4.399917,5.460000}, {0.300001,-3.354979,5.460000},
{0.472636,-3.426177,5.460000}, {0.127215,-3.426324,5.460000},{0.127202,-4.226371,5.300000}, {0.127093,-3.773522,5.300000}, {0.055045,-3.600083,5.460000},
{0.300001,-4.155021,5.300000}, {0.300001,-3.844980,5.300000},{0.127365,-3.773782,5.460000}, {0.472908,-4.226478,5.300000}, {0.472800,-3.773629,5.300000},
{0.300001,-3.844980,5.460000}, {0.472786,-3.773635,5.460000},{0.544957,-3.599876,5.460000}, {0.300001,-4.155021,5.460000}, {0.472636,-4.226219,5.460000},
{0.127215,-4.226365,5.460000}, {0.055045,-4.400124,5.460000},{0.127365,-4.573823,5.460000}, {0.300001,-4.645021,5.460000}, {0.472786,-4.573677,5.460000},
{0.544957,-4.399917,5.460000}, {3.064525,-0.753116,0.899999},{2.630000,0.000000,0.899999},  {2.745887,-0.433757,0.899999}, {4.370000,0.000000,0.899999},
{4.254010,-0.433940,0.899999}, {3.935302,-0.753216,0.899999},{3.499900,-0.869996,0.899999}, {3.500101,0.869996,0.899999},  {2.745990,0.433940,0.899999},
{3.064699,0.753216,0.899999},  {4.254113,0.433757,0.899999}, {3.935475,0.753116,0.899999},  {4.253670,0.000000,0.465393},  {4.179033,0.327005,0.465393},
{3.969905,-0.589243,0.465393}, {4.179033,-0.327005,0.465393},{3.667707,-0.734774,0.465393}, {3.332293,-0.734774,0.465394},
{3.030095,-0.589243,0.465394}, {2.820967,-0.327005,0.465394},{2.746330,0.000000,0.465394},  {3.030095,0.589243,0.465394},  {2.820967,0.327005,0.465394},
{3.332293,0.734774,0.465394},  {3.667707,0.734774,0.465393}, {3.969905,0.589243,0.465393},  {3.935000,0.000000,0.146557},  {3.891922,0.188739,0.146557},
{3.891922,-0.188739,0.146557}, {3.771218,-0.340097,0.146557},{3.596797,-0.424094,0.146557}, {3.403203,-0.424094,0.146557}, {3.228782,-0.340097,0.146557},
{3.108078,-0.188739,0.146557}, {3.065000,0.000000,0.146557}, {3.500000,0.000000,0.029999},  {3.108078,0.188739,0.146557},  {3.228782,0.340097,0.146557},
{3.403203,0.424094,0.146557},  {3.596797,0.424094,0.146557}, {3.771218,0.340097,0.146557},  {-5.457709,5.090000,5.300001}, {-3.008256,0.368309,5.300000},
{-3.127720,0.000000,5.300000}, {-2.305509,0.596805,5.300000},{-1.991636,0.368159,5.300000}, {-2.694319,0.596861,5.300000}, {-4.744962,-4.399945,5.300001},
{-5.457709,-5.090000,5.300001},{3.479406,-5.090000,5.299999},{-5.459455,-5.339454,5.233299},{-4.672907,-4.573564,5.300001},{3.479406,5.090000,5.299999},
{3.264428,5.318091,5.244943},  {-5.459457,5.339587,5.233224},{4.421760,-3.808380,5.299999}, {4.421590,3.808673,5.299999},  {4.213839,4.230302,3.479999},
{3.048971,5.590000,3.479999},  {5.075618,2.355382,5.299999}, {5.029165,2.633443,3.479999},  {5.075722,-2.355064,5.299999}, {5.410134,0.797254,5.299999},
{5.446821,0.897493,3.479999},  {5.410170,-0.796918,5.299999}, {5.447552,-0.891324,3.479999},{5.028928,-2.634082,3.479999}, {4.214629,-4.229121,3.479999},
{3.265149,-5.317344,5.245325}, {-3.008363,-0.368159,5.300000},{-3.029000,0.000000,1.530000},{-2.927970,0.310938,1.530000}, {-2.694490,-0.596805,5.300000},
{-2.928220,-0.310593,1.530000},{-2.305679,-0.596861,5.300000},{-2.338460,-0.503732,1.530000},{-2.665240,-0.502530,1.530000},{-1.991742,-0.368309,5.300000},
{-2.073155,-0.312481,1.530000},{-1.872278,0.000000,5.300000}, {-1.971000,0.000000,1.530000},{-2.072030,0.310938,1.530000},  {-2.336530,0.503109,1.530000},
{-2.663470,0.503109,1.530000}, {-5.464264,-5.523178,5.049668},{3.109352,-5.474706,5.119376},{-5.470802,-5.590000,4.800001}, {3.020519,-5.563480,4.960673},
{-5.440166,-5.590000,1.400000},{2.997814,-5.590000,4.799999}, {-2.499870,-5.590000,4.577130},{-4.847135,-5.590000,1.400000},{-4.847135,-5.590000,2.230000},
{-4.669152,-5.590000,3.126494},{-3.398448,-5.590000,4.398335},{-4.160392,-5.590000,3.888881},{-5.470802,5.590000,4.800001}, {-5.464268,5.523252,5.049535},
{-5.440166,5.590000,1.400000}, {-5.463732,-0.800000,2.300000},{-5.433627,5.523178,1.150333},{-5.428819,5.339454,0.966702},  {-5.427073,5.090000,0.900000},
{-5.427073,0.800000,0.900000}, {-5.463732,0.800000,2.300000}, {2.997814,5.590000,4.799999}, {-2.500129,5.590000,4.577130},  {-4.669255,5.590000,3.126240},
{-4.160575,5.590000,3.888697}, {-3.398688,5.590000,4.398236}, {3.108761,5.475298,5.118661}, {3.020438,5.563570,4.960412},   {3.023385,-5.590000,4.141102},
{2.968232,-5.590000,1.399999}, {-1.601311,-5.590000,4.398235},{3.048971,-5.590000,3.479999},{-4.845387,-5.523223,1.150414}, {-4.625703,-3.790000,3.108214},
{-4.800000,-3.790000,2.230000},{-4.800000,-3.790000,0.900000},{-4.834042,-5.090000,0.900000},{-4.840576,-5.339534,0.966748},{-5.433631,-5.523252,1.150466},
{2.991150,-5.563409,1.239115}, {3.080205,-5.474941,1.080905}, {3.236817,-5.317630,0.954820},{3.452437,-5.090000,0.899999},  {-0.152865,-5.590000,2.230000},
{-0.152865,-5.590000,1.400000},{-0.154612,-5.523298,1.150546},{-0.330744,-5.590000,3.126240},{-0.839424,-5.590000,3.888697},{-0.200000,-3.790000,2.230000},
{-0.872607,-3.790000,3.855225},{-0.374176,-3.790000,3.107917},{-1.619241,-3.790000,4.354649},{-2.499849,-3.790000,4.530000},{-3.380480,-3.790000,4.354765},
{-4.127180,-3.790000,3.855438},{-0.200000,-3.790000,0.900000},{-0.165958,-5.090000,0.900000},{-0.159420,-5.339667,0.966822},{-2.058215,-0.319920,0.900000},
{-0.165958,5.090000,0.900000}, {-0.200000,3.790000,0.900000}, {-5.427073,-5.090000,0.900000},{-4.650000,-0.800000,0.900000},{-4.346697,-0.624663,0.900000},
{-4.300000,-0.450000,0.900000},{-3.045497,0.000000,0.900000}, {-4.475488,-0.753390,0.900000},{-2.941902,-0.319755,0.900000},{-2.331091,-0.518669,0.900000},
{-2.669096,-0.518608,0.900000},{3.452437,5.090000,0.899999},  {4.398006,-3.809567,0.899999}, {2.990717,5.563866,1.240464},  {3.023385,5.590000,4.141102},
{3.079821,5.475319,1.081362},  {2.968232,5.590000,1.399999},  {-0.152865,5.590000,1.400000}, {-0.154612,5.523298,1.150546}, {3.236273,5.318183,0.955103},
{-0.159420,5.339667,0.966822}, {4.397835,3.809861,0.899999},  {5.054270,2.356590,0.899999},  {5.054376,-2.356270,0.899999}, {5.390068,0.797743,0.899999},
{5.390104,-0.797405,0.899999}, {-0.152865,5.590000,2.230000}, {-0.330847,5.590000,3.126493}, {-0.374176,3.790000,3.107917}, {-0.200000,3.790000,2.230000},
{-1.601551,5.590000,4.398335}, {-0.839607,5.590000,3.888881}, {-4.847135,5.590000,2.230000}, {-4.847135,5.590000,1.400000}, {-4.845387,5.523223,1.150414},
{-4.800000,3.790000,2.230000}, {-4.625703,3.790000,3.108214}, {-4.127180,3.790000,3.855438}, {-3.380480,3.790000,4.354765}, {-2.499849,3.790000,4.530000},
{-1.619241,3.790000,4.354649}, {-0.872607,3.790000,3.855225}, {-4.800000,3.790000,0.900000}, {-4.834042,5.090000,0.900000}, {-4.840576,5.339534,0.966748},
{-4.650000,0.800000,0.900000}, {-4.300000,0.450000,0.900000}, {-2.941785,0.319920,0.900000}, {-4.475337,0.753303,0.900000}, {-4.346610,0.624512,0.900000},
{-2.668909,0.518669,0.900000}, {-2.330904,0.518608,0.900000}, {-2.058098,0.319755,0.900000}, {-1.954503,0.000000,0.900000}, {-5.428821,-5.339587,0.966777},
{-5.427073,-0.800000,0.900000},{-4.650000,-0.800000,2.300000},{-4.650000,0.800000,2.300000}, {-4.300000,-0.450000,2.300000},{-4.300000,0.450000,2.300000},
{-4.400000,0.350000,0.900000}, {-4.400000,-0.350000,0.900000},{-4.900000,-0.350000,0.900000},{-4.900000,-0.350000,1.200000},{-4.900000,0.350000,0.900000},
{-5.104676,-0.283855,0.900000},{-5.104676,-0.283855,1.200000},{-4.329340,0.379274,0.900000}, {-4.329274,-0.379340,0.900000},{-4.400000,-0.350000,1.200000},
{-4.329274,-0.379340,1.200000},{-4.300000,-0.450000,1.200000},{-4.300000,0.450000,1.200000}, {-4.329340,0.379274,1.200000}, {-4.400000,0.350000,1.200000},
{-5.104865,0.283723,0.900000}, {-4.900000,0.350000,1.200000}, {-5.232736,-0.108495,0.900000},{-5.232803,0.108290,0.900000}, {-5.104865,0.283723,1.200000},
{-5.232803,0.108290,1.200000}, {-5.232736,-0.108495,1.200000},{-4.900000,-0.225000,1.200000},{-4.741289,0.159416,1.200000}, {-4.741392,-0.159516,1.200000},
{-4.675004,-0.000069,1.200000},{-5.058711,-0.159416,1.200000},{-5.124996,0.000069,1.200000}, {-4.900000,0.225000,1.200000}, {-5.058608,0.159516,1.200000},
{-4.900000,0.225000,1.750000}, {-4.741547,0.159665,1.750000}, {-5.058595,0.159528,1.750000}, {-5.125000,-0.000095,1.750000},{-5.058453,-0.159665,1.750000},
{-4.900000,-0.225000,1.750000},{-4.741405,-0.159528,1.750000},{-4.675000,0.000095,1.750000}, {-6.202734,-2.509375,-3.109375},{-3.475391,2.406787,-1.006250}
	};
	static GLfloat normals [296][3] = {
{0.0000,0.0000,1.0000},   {0.3816,0.9243,-0.0004},  {0.3813,0.9245,0.0000},   {0.3816,0.9243,-0.0005},  {-0.3817,0.9243,0.0000},
{0.9234,0.3839,0.0003},   {0.9232,0.3844,0.0009},   {0.9234,0.3838,0.0002},   {0.3819,0.9242,-0.0008},  {0.9235,-0.3836,0.0005},  {0.9234,-0.3838,0.0002},
{0.9234,-0.3837,0.0003},  {0.9236,0.3833,-0.0004},  {0.3817,-0.9243,-0.0000}, {0.9234,-0.3839,0.0001},  {-0.3816,-0.9243,-0.0004},{-0.3813,-0.9245,0.0000},
{-0.3816,-0.9243,-0.0005},{-0.9234,-0.3839,0.0003}, {-0.9232,-0.3844,0.0009}, {-0.9234,-0.3838,0.0002}, {-0.3819,-0.9242,-0.0008},{-0.9234,0.3837,0.0003},
{-0.9235,0.3836,0.0005},  {-0.9234,0.3838,0.0002},  {-0.9236,-0.3833,-0.0004},{-0.9234,0.3839,0.0001},  {0.3819,0.9242,-0.0009},  {-0.3819,-0.9242,-0.0009},
{-0.9235,0.3837,0.0003},  {-0.8770,0.0052,-0.4805}, {-0.9680,0.0069,-0.2507}, {-0.8453,0.4758,-0.2430}, {-0.7898,-0.3741,-0.4859},{-0.8436,-0.4820,-0.2367},
{-0.5473,0.6793,-0.4888}, {-0.4883,0.8422,-0.2285}, {-0.7948,0.3702,-0.4808}, {-0.1955,0.8495,-0.4901}, {0.0001,0.9741,-0.2260},  {0.1955,0.8494,-0.4901},
{0.4885,0.8421,-0.2285},  {0.5473,0.6793,-0.4888},  {0.8436,0.4820,-0.2367},  {0.7898,0.3741,-0.4859},  {0.9680,-0.0069,-0.2507}, {0.8770,-0.0052,-0.4805},
{0.8453,-0.4758,-0.2430}, {0.5473,-0.6793,-0.4888}, {0.4883,-0.8422,-0.2285}, {0.7948,-0.3702,-0.4808}, {0.1955,-0.8495,-0.4901}, {-0.0001,-0.9741,-0.2260},
{-0.1955,-0.8494,-0.4901},{-0.4885,-0.8421,-0.2285},{-0.5473,-0.6793,-0.4888},{-0.5268,0.0000,-0.8500}, {-0.4746,-0.2286,-0.8500},{-0.4746,0.2286,-0.8500},
{-0.3284,0.4118,-0.8500}, {-0.1172,0.5136,-0.8500}, {0.1172,0.5136,-0.8500},  {0.3284,0.4118,-0.8500},  {0.4746,0.2286,-0.8500},  {0.5268,0.0000,-0.8500},
{0.0000,0.0000,-1.0000},  {0.4746,-0.2286,-0.8500}, {0.3284,-0.4118,-0.8500}, {0.1172,-0.5136,-0.8500}, {-0.1172,-0.5136,-0.8500},{-0.3284,-0.4118,-0.8500},
{0.0003,-0.1304,0.9915},  {-0.0000,0.1305,0.9914},  {-0.0001,-0.3524,0.9359}, {-0.0000,-0.0645,0.9979}, {0.0012,-0.5014,0.8652},  {-0.8301,-0.5576,-0.0024},
{-0.7613,-0.6482,0.0178}, {-0.8647,-0.5012,0.0320}, {-0.7518,-0.6594,-0.0079},{-0.7272,-0.6862,-0.0164},{-0.7065,-0.7073,0.0215}, {-0.9383,-0.3458,-0.0009},
{-0.9508,-0.3083,0.0296}, {-0.9932,-0.1162,-0.0005},{-0.9945,-0.1020,0.0257}, {-0.9944,0.1021,0.0256},  {-0.9933,0.1155,-0.0005}, {-0.9509,0.3082,0.0295},
{-0.9383,0.3457,-0.0009}, {-0.8647,0.5012,0.0320},  {-0.8301,0.5576,0.0002},  {-0.7577,0.6526,-0.0026}, {-0.7266,0.6863,-0.0322}, {-1.0000,0.0002,-0.0001},
{-0.9997,0.0001,0.0262},  {-0.8093,-0.5868,0.0261}, {-0.8090,0.5878,-0.0001}, {-0.8092,0.5870,0.0261},  {-0.8097,-0.5868,0.0000}, {-0.3120,-0.9501,0.0000},
{0.3054,-0.9522,-0.0002}, {-0.3096,-0.9505,0.0260}, {0.3093,-0.9506,0.0260},  {0.8073,-0.5900,-0.0003}, {0.8092,-0.5869,0.0261},
{1.0000,-0.0007,-0.0002}, {0.8090,0.5878,-0.0001},  {0.8093,0.5868,0.0261},   {0.3096,0.9505,0.0261},   {0.3089,0.9511,0.0000},   {-0.3093,0.9506,0.0261},
{-0.3089,0.9510,0.0000},  {0.0002,0.0643,0.9979},   {0.0004,0.3506,0.9365},   {0.0009,0.5010,0.8654},   {0.9999,-0.0060,0.0150},  {0.9999,0.0060,0.0150},
{1.0000,0.0002,-0.0074},  {-0.0007,0.7196,0.6943},  {0.0019,0.8679,0.4968},   {0.9998,-0.0016,-0.0179}, {0.9997,-0.0000,-0.0262}, {-0.0006,0.9337,0.3581},
{0.0009,0.9916,0.1291},   {-0.0000,0.9965,0.0842},  {1.0000,-0.0002,-0.0074}, {0.9997,0.0000,0.0262},   {0.9998,0.0016,-0.0179},  {1.0000,0.0032,0.0085},
{1.0000,-0.0032,0.0085},  {0.0015,-0.9964,0.0851},  {-0.0000,-0.9916,0.1296}, {0.0009,-0.8683,0.4961},  {0.0000,-1.0000,-0.0000}, {0.0000,-0.9917,-0.1289},
{-0.0006,-0.7208,0.6931}, {0.0007,-0.9342,0.3567},  {-0.6856,0.7276,0.0232},  {-0.6813,0.7315,0.0261},  {-0.7271,0.6865,-0.0054}, {-0.7526,0.6584,0.0038},
{-0.6812,0.7316,0.0264},  {-0.9997,0.0262,-0.0000}, {-0.9949,0.0260,-0.0976}, {-0.9238,0.0262,-0.3820}, {-0.9237,0.0262,-0.3821}, {-0.9949,0.0261,-0.0979},
{0.0000,0.8680,-0.4965},  {-0.0000,0.9914,-0.1306}, {0.0000,0.9917,-0.1289},  {-0.0000,0.8650,-0.5017}, {-0.7059,0.7079,-0.0242}, {-0.7599,0.6497,-0.0200},
{-0.7125,0.7016,-0.0087}, {-0.7118,0.7023,0.0080},  {-0.7293,0.6831,0.0397},  {0.0025,0.8659,-0.5002},  {0.0039,0.9962,-0.0872},  {0.0000,0.9914,-0.1305},
{0.0019,0.9346,-0.3557},  {0.9949,0.0260,-0.0979},  {0.9997,0.0262,-0.0000},  {0.9949,0.0261,-0.0976},  {0.9238,0.0262,-0.3820},  {0.7073,0.0262,-0.7064},
{0.7073,0.0262,-0.7065},  {0.9238,0.0262,-0.3819},  {0.3829,0.0262,-0.9234},  {0.3828,0.0262,-0.9235},  {0.0001,0.0262,-0.9997},  {-0.3827,0.0262,-0.9235},
{-0.3828,0.0262,-0.9235}, {-0.7072,0.0262,-0.7065}, {0.0000,1.0000,-0.0000},  {0.0000,0.1282,-0.9918},  {0.0000,0.1306,-0.9914},  {-0.0016,0.7201,-0.6938},
{0.0032,0.4960,-0.8683},  {-0.0003,0.3513,-0.9363}, {0.0008,0.1277,-0.9918},  {0.0000,0.0642,-0.9979},  {-0.8632,0.5038,-0.0322}, {-0.6856,-0.7276,0.0232},
{-0.7057,-0.7085,0.0093}, {-0.7233,-0.6906,0.0014}, {-0.7062,-0.7075,0.0273}, {-0.6793,-0.7334,-0.0261},{0.0025,-0.9916,-0.1289}, {0.0000,-0.9965,-0.0835},
{-0.0014,-0.9346,-0.3556},{0.0049,-0.8651,-0.5016}, {-0.0016,-0.7212,-0.6927},{-0.7321,-0.6783,0.0630}, {-0.7565,-0.6540,-0.0026},{0.0023,-0.4955,-0.8686},
{0.0010,-0.3503,-0.9366}, {0.0005,-0.0645,-0.9979}, {-0.8632,-0.5038,-0.0321},{0.0000,-0.1283,-0.9917}, {-0.9501,-0.3106,-0.0296},{-0.9943,-0.1035,-0.0260},
{-0.9943,0.1035,-0.0259}, {-0.9501,0.3105,-0.0295}, {0.9997,-0.0262,-0.0000}, {0.9949,-0.0260,-0.0976}, {0.9238,-0.0262,-0.3819}, {0.9237,-0.0261,-0.3821},
{0.9949,-0.0261,-0.0979}, {0.0000,-0.9914,-0.1306}, {-0.0000,-0.8650,-0.5017},{0.0000,-0.8679,-0.4968}, {-0.9949,-0.0261,-0.0979},{-0.9997,-0.0262,-0.0000},
{-0.9949,-0.0261,-0.0976},{-0.9238,-0.0262,-0.3820},{-0.7073,-0.0262,-0.7065},{-0.7072,-0.0262,-0.7065},{-0.3828,-0.0262,-0.9234},{-0.3828,-0.0262,-0.9235},
{-0.0001,-0.0262,-0.9997},{0.0001,-0.0262,-0.9997}, {0.3827,-0.0261,-0.9235}, {0.3829,-0.0262,-0.9234}, {0.7072,-0.0261,-0.7066}, {0.7073,-0.0262,-0.7064},
{-0.0000,-0.1282,-0.9918},{0.0000,-0.1305,-0.9914}, {-0.0000,-0.4966,-0.8680},{0.0000,-0.5015,-0.8651}, {0.0000,0.5017,-0.8650},  {-0.0000,0.4965,-0.8680},
{0.1557,0.9878,0.0000},   {0.1954,0.9807,0.0000},   {0.5862,0.8102,0.0000},   {0.3832,0.9237,0.0000},   {0.9239,0.3827,0.0000},   {0.9239,0.3828,0.0000},   {0.9978,0.0657,0.0000},
{0.9928,0.0080,-0.1197},  {0.1989,-0.7448,-0.6369}, {0.3342,-0.7534,-0.5664}, {0.8053,-0.5582,-0.1996}, {0.7071,-0.7071,0.0000},  {0.9928,-0.0083,-0.1197},
{0.8056,0.5579,-0.1994},  {0.9978,-0.0661,0.0000},  {0.3345,0.7534,-0.5662},  {0.1992,0.7449,-0.6367},  {0.9237,-0.3832,0.0000},  {0.7071,0.7071,0.0000},
{0.3827,-0.9239,0.0000},  {0.1951,-0.9808,0.0000},  {0.1558,-0.9878,0.0000},  {0.5866,-0.8099,0.0000},  {0.9508,-0.3097,0.0000},  {0.9506,0.3103,0.0000},
{-0.9997,0.0001,-0.0262}, {-0.8094,0.5867,-0.0260}, {-0.8096,-0.5864,-0.0259},{-0.3094,0.9506,-0.0259}, {0.3097,0.9505,-0.0259},
{0.8096,0.5865,-0.0259},  {0.9997,-0.0001,0.0262},  {0.9997,-0.0001,-0.0262}, {0.8096,-0.5865,-0.0257}, {-0.3099,-0.9504,-0.0255},{1.0000,0.0000,0.0000},
{0.3816,-0.9243,-0.0000}, {-0.3813,-0.9244,-0.0000},{-0.3819,-0.9242,-0.0002},{-0.3818,-0.9243,-0.0002},{-0.3812,-0.9245,-0.0000},{0.9233,-0.3842,0.0001},
{0.9232,-0.3844,0.0000},  {0.9232,-0.3843,0.0000},  {0.9230,0.3847,0.0002},   {0.9234,0.3838,-0.0001},  {0.9233,0.3840,-0.0000},  {0.9233,-0.3841,0.0001},
{0.3813,0.9244,-0.0000},  {0.3819,0.9242,-0.0002},  {0.3818,0.9243,-0.0002},  {0.9230,0.3849,0.0003},   {-0.3816,0.9243,-0.0000}, {0.3812,0.9245,0.0000},
{-0.9233,0.3842,0.0001},  {-0.9232,0.3844,0.0000},  {-0.9232,0.3843,0.0000},  {-0.9230,-0.3847,0.0002}, {-0.9234,-0.3838,-0.0001},
{-0.9233,-0.3840,-0.0000},{-0.9233,0.3841,0.0001},  {-0.9230,-0.3849,0.0003}, {-0.6836,-0.7295,-0.0232},{0.3094,-0.9506,-0.0252}
	};
	static GLfloat textures [1028][2] = { {0.5723,0.0687},{0.5666,0.0549},
{0.5723,0.0492},{0.3322,0.9507},{0.3253,0.9507},{0.3254,0.9433},{0.5804,0.0687},{0.5803,0.0492},{0.3323,0.9582},{0.3254,0.9581},{0.5666,0.0630},
{0.7589,0.9514},{0.7520,0.9514},{0.7520,0.9439},{0.3323,0.9432},{0.7520,0.9364},{0.7589,0.9439},{0.2487,0.9576},{0.2418,0.9577},{0.2417,0.9497},
{0.7589,0.9364},{0.5861,0.0630},{0.2486,0.9496},{0.2418,0.9433},{0.5861,0.0549},{0.7500,0.8960},{0.7431,0.8960},{0.7431,0.8885},{0.2487,0.9432},
{0.7500,0.8885},{0.7431,0.8810},{0.7500,0.8810},{0.1775,0.9497},{0.1844,0.9496},{0.1845,0.9576},{0.1776,0.9433},{0.1845,0.9432},{0.3671,0.9432},
{0.3740,0.9432},{0.3739,0.9507},{0.1776,0.9577},{0.3670,0.9507},{0.3740,0.9582},{0.3393,0.9433},{0.3462,0.9432},{0.3461,0.9507},{0.3671,0.9582},
{0.3392,0.9507},{0.3462,0.9582},{0.7590,0.9214},{0.7659,0.9214},{0.7658,0.9289},{0.3393,0.9581},{0.7589,0.9289},{0.7659,0.9364},{0.7590,0.9364},
{0.2556,0.9497},{0.2625,0.9496},{0.2626,0.9576},{0.2557,0.9433},{0.2626,0.9432},{0.7590,0.9364},{0.7659,0.9364},{0.7658,0.9439},{0.2557,0.9577},
{0.7589,0.9439},{0.7659,0.9514},{0.1427,0.9433},{0.1496,0.9432},{0.1495,0.9507},{0.7590,0.9514},{0.1426,0.9507},{0.1496,0.9582},{0.9142,0.0089},
{0.9211,0.0089},{0.9211,0.0164},{0.1427,0.9581},{0.9142,0.0164},{0.9211,0.0239},{0.9142,0.0239},{0.1705,0.9497},{0.1774,0.9496},{0.1775,0.9576},
{0.1706,0.9433},{0.1775,0.9432},{0.0731,0.9432},{0.0800,0.9432},{0.0800,0.9507},{0.1706,0.9577},{0.0731,0.9507},{0.0800,0.9582},{0.1149,0.9433},
{0.1218,0.9432},{0.1217,0.9507},{0.0731,0.9582},{0.1148,0.9507},{0.1218,0.9582},{0.7520,0.9064},{0.7589,0.9064},{0.7589,0.9139},{0.1149,0.9581},
{0.7520,0.9139},{0.7589,0.9214},{0.7520,0.9214},{0.2626,0.9497},{0.2695,0.9496},{0.2696,0.9576},{0.2627,0.9433},{0.2696,0.9432},{0.9490,0.0089},
{0.9559,0.0089},{0.9558,0.0164},{0.2627,0.9577},{0.9489,0.0164},{0.9559,0.0239},{0.3045,0.9433},{0.3114,0.9432},{0.3113,0.9507},{0.9490,0.0239},
{0.3044,0.9507},{0.3114,0.9582},{0.7590,0.8914},{0.7659,0.8914},{0.7658,0.8989},{0.3045,0.9581},{0.7589,0.8989},{0.7659,0.9064},{0.7590,0.9064},
{0.2835,0.9497},{0.2904,0.9496},{0.2905,0.9576},{0.2836,0.9433},{0.2905,0.9432},{0.0801,0.9432},{0.0870,0.9432},{0.0869,0.9507},{0.2836,0.9577},
{0.0800,0.9507},{0.0870,0.9582},{0.3184,0.9433},{0.3253,0.9432},{0.3253,0.9507},{0.0801,0.9582},{0.3184,0.9507},{0.3253,0.9582},{0.7431,0.8660},
{0.7500,0.8660},{0.7500,0.8735},{0.3184,0.9581},{0.7431,0.8735},{0.7500,0.8810},{0.7431,0.8810},{0.2766,0.9497},{0.2835,0.9496},{0.2835,0.9576},
{0.2766,0.9433},{0.2835,0.9432},{0.9512,0.4047},{0.9581,0.4047},{0.9581,0.4122},{0.2766,0.9577},{0.9512,0.4122},{0.9581,0.4197},{0.3115,0.9433},
{0.3184,0.9432},{0.3183,0.9507},{0.9512,0.4197},{0.3114,0.9507},{0.3184,0.9582},{0.8158,0.0971},{0.8227,0.0971},{0.8227,0.1046},{0.3115,0.9581},
{0.8158,0.1046},{0.8227,0.1121},{0.8158,0.1121},{0.1496,0.9497},{0.1565,0.9496},{0.1566,0.9576},{0.1497,0.9433},{0.1566,0.9432},{0.0870,0.9432},
{0.0939,0.9432},{0.0939,0.9507},{0.1497,0.9577},{0.0870,0.9507},{0.0939,0.9582},{0.3462,0.9433},{0.3531,0.9432},{0.3531,0.9507},{0.0870,0.9582},
{0.3462,0.9507},{0.3531,0.9582},{0.8019,0.0971},{0.8088,0.0971},{0.8088,0.1046},{0.3462,0.9581},{0.8019,0.1046},{0.8088,0.1121},{0.8019,0.1121},
{0.1914,0.9497},{0.1983,0.9496},{0.1984,0.9576},{0.1915,0.9433},{0.1984,0.9432},{0.9351,0.0089},{0.9420,0.0089},{0.9419,0.0164},{0.1915,0.9577},
{0.9350,0.0164},{0.9420,0.0239},{0.1010,0.9433},{0.1079,0.9432},{0.1078,0.9507},{0.9351,0.0239},{0.1009,0.9507},{0.1079,0.9582},{0.8089,0.0971},
{0.8158,0.0971},{0.8157,0.1046},{0.1010,0.9581},{0.8088,0.1046},{0.8158,0.1121},{0.8089,0.1121},{0.1984,0.9497},{0.2053,0.9496},{0.2054,0.9576},
{0.1985,0.9433},{0.2054,0.9432},{0.3532,0.9432},{0.3601,0.9432},{0.3600,0.9507},{0.1985,0.9577},{0.3531,0.9507},{0.3601,0.9582},{0.0940,0.9433},
{0.1009,0.9432},{0.1008,0.9507},{0.3532,0.9582},{0.0939,0.9507},{0.1009,0.9582},{0.9073,0.0089},{0.9142,0.0089},{0.9141,0.0164},{0.0940,0.9581},
{0.9072,0.0164},{0.9142,0.0239},{0.9073,0.0239},{0.1635,0.9497},{0.1704,0.9496},{0.1705,0.9576},{0.1636,0.9433},{0.1705,0.9432},{0.9420,0.0089},
{0.9489,0.0089},{0.9489,0.0164},{0.1636,0.9577},{0.9420,0.0164},{0.9489,0.0239},{0.1288,0.9433},{0.1357,0.9432},{0.1356,0.9507},{0.9420,0.0239},
{0.1287,0.9507},{0.1357,0.9582},{0.7520,0.8914},{0.7589,0.8914},{0.7589,0.8989},{0.1288,0.9581},{0.7520,0.8989},{0.7589,0.9064},{0.7520,0.9064},
{0.1566,0.9497},{0.1635,0.9496},{0.1635,0.9576},{0.1566,0.9433},{0.1635,0.9432},{0.1566,0.9577},{0.1357,0.9507},{0.1426,0.9507},{0.1426,0.9582},
{0.1357,0.9433},{0.7431,0.8960},{0.7500,0.8960},{0.7500,0.9035},{0.1357,0.9581},{0.7431,0.9035},{0.7500,0.9110},{0.7431,0.9110},{0.2487,0.9497},
{0.2556,0.9496},{0.2556,0.9576},{0.2487,0.9433},{0.2556,0.9432},{0.7520,0.9214},{0.7589,0.9214},{0.7589,0.9289},{0.2487,0.9577},{0.7520,0.9289},
{0.7589,0.9364},{0.2975,0.9433},{0.3044,0.9432},{0.3044,0.9507},{0.7520,0.9364},{0.2975,0.9507},{0.3044,0.9582},{0.7590,0.9064},{0.7659,0.9064},
{0.7658,0.9139},{0.2975,0.9581},{0.7589,0.9139},{0.7659,0.9214},{0.7590,0.9214},{0.2905,0.9497},{0.2974,0.9496},{0.2975,0.9576},{0.2906,0.9433},
{0.2975,0.9432},{0.3740,0.9432},{0.3809,0.9432},{0.3809,0.9507},{0.2906,0.9577},{0.3740,0.9507},{0.3809,0.9582},{0.1079,0.9433},{0.1148,0.9432},
{0.1148,0.9507},{0.3740,0.9582},{0.1079,0.9507},{0.1148,0.9582},{0.9281,0.0089},{0.9350,0.0089},{0.9350,0.0164},{0.1079,0.9581},{0.9281,0.0164},
{0.9350,0.0239},{0.9281,0.0239},{0.2696,0.9497},{0.2765,0.9496},{0.2766,0.9576},{0.2697,0.9433},{0.2766,0.9432},{0.7431,0.9260},{0.7500,0.9260},
{0.7500,0.9334},{0.2697,0.9577},{0.7431,0.9335},{0.7500,0.9409},{0.3323,0.9433},{0.3392,0.9432},{0.3392,0.9507},{0.7431,0.9409},{0.3323,0.9507},
{0.3392,0.9582},{0.7431,0.9110},{0.7500,0.9110},{0.7500,0.9185},{0.3323,0.9581},{0.7431,0.9185},{0.7500,0.9260},{0.7431,0.9260},{0.1845,0.9497},
{0.1914,0.9496},{0.1914,0.9576},{0.1845,0.9433},{0.1914,0.9432},{0.7431,0.9409},{0.7500,0.9409},{0.7500,0.9484},{0.1845,0.9577},{0.7431,0.9484},
{0.7500,0.9559},{0.1218,0.9433},{0.1287,0.9432},{0.1287,0.9507},{0.7431,0.9559},{0.1218,0.9507},{0.1287,0.9582},{0.9212,0.0089},{0.9281,0.0089},
{0.9280,0.0164},{0.1218,0.9581},{0.9211,0.0164},{0.9281,0.0239},{0.9212,0.0239},{0.9700,0.3191},{0.9512,0.3191},{0.9513,0.3004},{0.9701,0.3332},
{0.9513,0.3379},{0.9702,0.2937},{0.9515,0.2867},{0.9701,0.3050},{0.0140,0.9562},{0.0327,0.9446},{0.0329,0.9633},{0.0138,0.9432},{0.0141,0.9707},
{0.0329,0.9821},{0.0140,0.9838},{0.0327,0.9960},{0.3949,0.9546},{0.4136,0.9499},{0.4138,0.9686},{0.3947,0.9432},{0.3950,0.9687},{0.4138,0.9873},
{0.9653,0.3652},{0.9839,0.3516},{0.9842,0.3685},{0.3950,0.9828},{0.9651,0.3535},{0.9653,0.3794},{0.9842,0.3879},{0.9652,0.3934},{0.9839,0.4047},
{0.9702,0.3446},{0.9515,0.3516},{0.9650,0.4043},{0.9840,0.3191},{0.9840,0.3273},{0.8610,0.0343},{0.8487,0.0283},{0.8577,0.0170},{0.9840,0.3110},
{0.8662,0.0277},{0.8707,0.0107},{0.0000,0.9595},{0.8738,0.0241},{0.8821,0.0241},{0.8852,0.0107},{0.8982,0.0170},{0.0000,0.9678},{0.8896,0.0277},
{0.9072,0.0283},{0.3809,0.9606},{0.8948,0.0343},{0.3810,0.9687},{0.8967,0.0424},{0.8779,0.0424},{0.8948,0.0505},{0.8592,0.0424},{0.8610,0.0505},
{0.8896,0.0571},{0.8821,0.0607},{0.8738,0.0607},{0.8662,0.0571},{0.3810,0.9769},{0.9072,0.0565},{0.8982,0.0678},{0.9512,0.3707},{0.9512,0.3789},
{0.8707,0.0741},{0.8577,0.0678},{0.9512,0.3869},{0.8487,0.0565},{0.7584,0.8884},{0.7659,0.8703},{0.7659,0.8914},{0.7584,0.8734},{0.7431,0.8522},
{0.7488,0.8660},{0.7431,0.8603},{0.7488,0.8465},{0.7553,0.8809},{0.7181,0.0792},{0.7100,0.0987},{0.7043,0.0930},{0.7238,0.0849},{0.7181,0.0987},
{0.7101,0.0792},{0.7043,0.0849},{0.7238,0.0930},{0.7572,0.0792},{0.7491,0.0987},{0.7434,0.0930},{0.7629,0.0849},{0.7571,0.0987},{0.7491,0.0792},
{0.7434,0.0849},{0.7629,0.0930},{0.6389,0.0687},{0.6308,0.0492},{0.6388,0.0492},{0.6308,0.0687},{0.6251,0.0549},{0.6446,0.0630},{0.6446,0.0549},
{0.6251,0.0630},{0.5527,0.0687},{0.5609,0.0492},{0.5666,0.0549},{0.5470,0.0630},{0.5528,0.0492},{0.5608,0.0687},{0.5666,0.0630},{0.5470,0.0549},
{0.6986,0.0792},{0.6905,0.0987},{0.6848,0.0930},{0.7043,0.0849},{0.6986,0.0987},{0.6906,0.0792},{0.6848,0.0849},{0.7043,0.0930},{0.5413,0.0492},
{0.5332,0.0687},{0.5275,0.0630},{0.5470,0.0549},{0.5413,0.0687},{0.5333,0.0492},{0.5275,0.0549},{0.5470,0.0630},{0.4828,0.0492},{0.4747,0.0687},
{0.4690,0.0630},{0.4885,0.0549},{0.4828,0.0687},{0.4748,0.0492},{0.4690,0.0549},{0.4885,0.0630},{0.7767,0.0792},{0.7686,0.0987},{0.7629,0.0930},
{0.7824,0.0849},{0.7766,0.0987},{0.7686,0.0792},{0.7629,0.0849},{0.7824,0.0930},{0.7295,0.0987},{0.7377,0.0792},{0.7434,0.0849},{0.7238,0.0930},
{0.7296,0.0792},{0.7376,0.0987},{0.7434,0.0930},{0.7238,0.0849},{0.6194,0.0492},{0.6113,0.0687},{0.6056,0.0630},{0.6251,0.0549},{0.6193,0.0687},
{0.6113,0.0492},{0.6056,0.0549},{0.6251,0.0630},{0.5023,0.0492},{0.4942,0.0687},{0.4885,0.0630},{0.5080,0.0549},{0.5023,0.0687},{0.4943,0.0492},
{0.4885,0.0549},{0.5080,0.0630},{0.5218,0.0492},{0.5137,0.0687},{0.5080,0.0630},{0.5275,0.0549},{0.5218,0.0687},{0.5138,0.0492},{0.5080,0.0549},
{0.5275,0.0630},{0.5999,0.0492},{0.5918,0.0687},{0.5861,0.0630},{0.6056,0.0549},{0.5998,0.0687},{0.5918,0.0492},{0.5861,0.0549},{0.6056,0.0630},
{0.7962,0.0792},{0.7881,0.0987},{0.7824,0.0930},{0.8019,0.0849},{0.7961,0.0987},{0.7881,0.0792},{0.7824,0.0849},{0.8019,0.0930},{0.4687,0.0187},
{0.4687,0.4577},{0.3682,0.2382},{0.0925,0.0088},{0.0833,0.0187},{0.4688,0.0079},{0.5537,0.9000},{0.4757,0.9370},{0.4750,0.8818},{0.5545,0.9586},
{0.4782,0.9469},{0.4976,0.9586},{0.5531,0.8311},{0.4746,0.8191},{0.5528,0.7562},{0.4743,0.7519},{0.4743,0.6831},{0.5528,0.6791},{0.4746,0.6159},
{0.5531,0.6039},{0.4750,0.5533},{0.5537,0.5351},{0.4757,0.4980},{0.4782,0.4882},{0.6861,0.0265},{0.8486,0.0265},{0.8487,0.0423},{0.6861,0.0130},
{0.8487,0.0106},{0.4964,0.0050},{0.6589,0.0000},{0.4962,0.0138},{0.6861,0.0399},{0.4962,0.0274},{0.6586,0.0105},{0.6586,0.0267},{0.6861,0.0447},
{0.8487,0.0423},{0.6861,0.0582},{0.6315,0.1092},{0.4690,0.1126},{0.4692,0.0989},{0.6317,0.0977},{0.4692,0.0822},{0.6315,0.0723},{0.4690,0.0687},
{0.6317,0.0836},{0.3495,0.2640},{0.3328,0.2640},{0.0000,0.2038},{0.3141,0.2382},{0.0000,0.2726},{0.0144,0.1366},{0.0144,0.3398},{0.3192,0.2541},
{0.3631,0.2541},{0.0833,0.4577},{0.0426,0.4025},{0.0925,0.4675},{0.4688,0.4685},{0.4906,0.2867},{0.9296,0.2867},{0.6756,0.4160},{0.0992,0.4743},
{0.4690,0.4764},{0.9512,0.4549},{0.9483,0.4656},{0.9296,0.4764},{0.8367,0.4803},{0.8435,0.8462},{0.8328,0.8465},{0.8435,0.4764},{0.9404,0.4735},
{0.8298,0.4813},{0.7446,0.4160},{0.4798,0.4735},{0.4719,0.4656},{0.4906,0.4764},{0.4719,0.2974},{0.4798,0.2895},{0.4690,0.4549},{0.7446,0.4764},
{0.9512,0.3082},{0.9483,0.2975},{0.4690,0.3082},{0.9404,0.2895},{0.8222,0.1262},{0.4696,0.1264},{0.4690,0.1157},{0.5933,0.1359},{0.5034,0.1985},
{0.4718,0.2730},{0.5244,0.1656},{0.5560,0.1437},{0.0993,0.0021},{0.4690,0.0000},{0.8228,0.1193},{0.8255,0.1126},{0.4837,0.4814},{0.7729,0.4795},
{0.8014,0.4804},{0.5545,0.4764},{0.7402,0.9651},{0.7431,0.9185},{0.7431,0.9543},{0.6655,0.8805},{0.7431,0.8797},{0.6655,0.9185},{0.6655,0.9758},
{0.7215,0.9758},{0.7323,0.9730},{0.6753,0.8461},{0.6860,0.8207},{0.6862,0.8463},{0.6751,0.8208},{0.6756,0.4764},{0.6442,0.4764},{0.6655,0.4980},
{0.6511,0.4776},{0.6579,0.4814},{0.6632,0.4882},{0.6735,0.6185},{0.6832,0.4837},{0.6843,0.6183},{0.6763,0.4828},{0.9211,0.7257},{0.9988,0.6899},
{0.9988,0.7257},{0.9959,0.6792},{0.9988,0.7645},{0.9211,0.7963},{0.9988,0.7977},{0.9211,0.7637},{0.9211,0.7780},{0.8435,0.8116},{0.8435,0.7787},
{0.9211,0.8102},{0.9211,0.7400},{0.8435,0.7400},{0.8435,0.7012},{0.9211,0.7020},{0.8435,0.6684},{0.6655,0.8479},{0.7431,0.8465},{0.9211,0.6698},
{0.9820,0.2867},{0.8868,0.0958},{0.9246,0.0883},{0.9820,0.0883},{0.9246,0.2866},{0.8868,0.2791},{0.9772,0.6684},{0.9211,0.6684},{0.9880,0.6712},
{0.8546,0.2576},{0.8330,0.2254},{0.8255,0.1874},{0.8330,0.1495},{0.8546,0.1173},{0.0166,0.5023},{0.0166,0.4767},{0.0727,0.5037},{0.2198,0.5241},
{0.2555,0.5253},{0.2361,0.5794},{0.2223,0.5839},{0.2138,0.5957},{0.2167,0.5253},{0.6694,0.4790},{0.6655,0.6189},{0.0068,0.8504},{0.0058,0.7039},
{0.0166,0.7036},{0.0000,0.8436},{0.0166,0.8597},{0.6648,0.5532},{0.2499,0.5839},{0.2631,0.5233},{0.2705,0.9432},{0.2017,0.9432},{0.2361,0.6265},
{0.3378,0.9288},{0.3996,0.7021},{0.4907,0.9575},{0.4838,0.9537},{0.3601,0.9507},{0.3670,0.9507},{0.3670,0.9582},{0.6579,0.9537},{0.5260,0.9586},
{0.6442,0.9586},{0.6920,0.2729},{0.8220,0.2728},{0.8227,0.2797},{0.8248,0.1831},{0.6913,0.2837},{0.8255,0.2867},{0.6632,0.9469},{0.6655,0.9370},
{0.4664,0.7039},{0.4723,0.8436},{0.4655,0.8504},{0.4743,0.7041},{0.8235,0.1546},{0.4557,0.8597},{0.6648,0.8818},{0.4557,0.7036},{0.4004,0.9004},
{0.0718,0.9005},{0.0727,0.7021},{0.1345,0.9288},{0.6643,0.8192},{0.2686,0.5178},{0.3996,0.5038},{0.2585,0.5957},{0.2499,0.6220},{0.6641,0.7519},
{0.2223,0.6220},{0.2585,0.6102},{0.6641,0.6831},{0.6643,0.6159},{0.6918,0.2371},{0.9959,0.9301},{0.9988,0.8836},{0.9988,0.9194},{0.6841,0.1984},
{0.9211,0.8456},{0.9988,0.8448},{0.9211,0.8836},{0.9211,0.9409},{0.9772,0.9409},{0.9880,0.9381},{0.6308,0.1436},{0.6627,0.1656},{0.4963,0.2372},
{0.4965,0.2730},{0.4959,0.2838},{0.4714,0.2838},{0.8435,0.9185},{0.7659,0.9543},{0.7659,0.9185},{0.7687,0.9650},{0.7659,0.8797},{0.8435,0.8805},
{0.7659,0.8465},{0.8435,0.8130},{0.9211,0.8116},{0.9211,0.8445},{0.8435,0.8479},{0.8435,0.8452},{0.9211,0.8832},{0.8435,0.8832},{0.9211,0.9220},
{0.8435,0.9212},{0.9211,0.9548},{0.9211,0.8130},{0.9988,0.8116},{0.8435,0.9534},{1.0000,0.6680},{0.9427,0.6684},{0.9048,0.6613},{0.7874,0.9758},
{0.8435,0.9758},{0.7767,0.9730},{0.8726,0.6408},{0.8510,0.6098},{0.8435,0.5732},{0.8510,0.5365},{0.8726,0.5053},{0.9048,0.4843},{0.9427,0.4768},
{1.0000,0.4764},{0.2138,0.6102},{0.4557,0.5023},{0.4557,0.4767},{0.2706,0.5102},{0.2706,0.4767},{0.4743,0.4764},{0.4743,0.5018},{0.4664,0.5020},
{0.4664,0.4766},{0.6673,0.8461},{0.0058,0.5020},{0.0058,0.4766},{0.6671,0.8207},{0.9211,0.9748},{0.9214,0.9424},{0.9817,0.9409},{0.9072,0.0590},
{0.9072,0.0239},{0.9223,0.0741},{0.9815,0.9748},{0.4742,0.9585},{0.4743,0.9936},{0.4140,0.9924},{0.9611,0.0741},{0.9762,0.0239},{0.9762,0.0590},
{0.4138,0.9588},{0.2512,0.5210},{0.2210,0.5210},{0.2210,0.4994},{0.6589,0.0880},{0.6718,0.0879},{0.6718,0.1095},{0.2512,0.4994},{0.2239,0.4906},
{0.6589,0.0791},{0.6718,0.0791},{0.2525,0.5240},{0.6589,0.1095},{0.6718,0.1126},{0.7667,0.0996},{0.7667,0.1126},{0.7637,0.1126},{0.6589,0.1126},
{0.7637,0.0996},{0.9343,0.9933},{0.9211,0.9826},{0.9212,0.9894},{0.7561,0.1126},{0.7742,0.1126},{0.7667,0.0997},{0.7742,0.0996},{0.4139,0.9457},
{0.4269,0.9435},{0.4138,0.9513},{0.7773,0.0996},{0.6719,0.0792},{0.6848,0.0792},{0.6848,0.0824},{0.7773,0.1126},{0.6719,0.0825},{0.6848,0.1033},
{0.2484,0.4906},{0.6718,0.1033},{0.6848,0.1125},{0.2315,0.4851},{0.2408,0.4851},{0.6447,0.0443},{0.6576,0.0443},{0.6575,0.0518},{0.9817,0.9933},
{0.6719,0.1126},{0.6446,0.0518},{0.6575,0.0612},{0.6446,0.0612},{0.6576,0.0687},{0.6447,0.0687},{0.6589,0.0265},{0.6590,0.0127},{0.6590,0.0402},
{0.6589,0.0833},{0.6589,0.0979},{0.6587,0.0717},{0.6587,0.1098},{0.8486,0.0582},{0.6589,0.0582},{0.6589,0.0444},{0.4690,0.0137},{0.4692,0.0045},
{0.0472,0.9529},{0.0472,0.9476},{0.0688,0.9476},{0.0688,0.9777},{0.0718,0.9463},{0.0541,0.9695},{0.0541,0.9558},{0.0569,0.9626},{0.0404,0.9558},
{0.0384,0.9504},{0.0718,0.9790},{0.0731,0.9432},{0.9900,0.4764},{0.9512,0.4764},{0.9512,0.4290},{0.0731,0.9821},{0.9900,0.4290},{0.4743,0.9432},
{0.0375,0.9627},{0.0329,0.9580},{0.0329,0.9673},{0.0384,0.9749},{0.0472,0.9724},{0.0472,0.9777},{0.0404,0.9695},{0.7585,0.8703},{0.7585,0.8466},
{0.7659,0.8466},{0.7527,0.8702},{0.7526,0.8465},{0.7086,0.0988},{0.7323,0.0988},{0.7323,0.1057},{0.7659,0.8703},{0.7086,0.1057},{0.7323,0.1126},
{0.7324,0.0989},{0.7561,0.0989},{0.7561,0.1058},{0.7086,0.1126},{0.7323,0.1058},{0.7561,0.1126},{0.6849,0.0988},{0.7086,0.0988},{0.7085,0.1057},
{0.7324,0.1126},{0.6848,0.1057},{0.7086,0.1126},{0.6849,0.1126},{0.8146,0.0971},{0.8071,0.0792},{0.8145,0.0792},{0.8072,0.0971},{0.8019,0.0844},
{0.8198,0.0919},{0.8198,0.0844},{0.8019,0.0919},{0.3192,0.2223},{0.0426,0.0739},{0.3328,0.2125},{0.3495,0.2125},{0.3631,0.2223},{0.7217,0.8205},
{0.8141,0.6798},{0.8221,0.7184},{0.8147,0.7573},{0.7930,0.7903},{0.7603,0.8125},{0.7919,0.6471},{0.7588,0.6254},{0.7201,0.6180},{0.3601,0.9432},
{0.3670,0.9432},{0.2016,0.4767},{0.2016,0.5102},{0.2036,0.5177},{0.2092,0.5233},{0.6861,0.0716},{0.8487,0.0741},{0.6589,0.0720},{0.6589,0.0423},
{0.4964,0.0406},{0.6511,0.9575},{0.4690,0.0277},{0.4692,0.0413},{0.1426,0.9432},{0.3601,0.9582},{0.8198,0.0896},{0.8229,0.0822},{0.8229,0.0971},
	};

	GLint GenThymio2Body()
	{
		GLint lid=glGenLists(1);
		glNewList(lid, GL_COMPILE);

			glBegin (GL_TRIANGLES);
			for(unsigned int i=0;i<sizeof(face_indicies)/sizeof(face_indicies[0]);i++)
			{
				for(unsigned int j=0;j<3;j++)
				{
					unsigned int vi = face_indicies[i][3*j]   - 1;
					unsigned int ti = face_indicies[i][3*j+1] - 1;
					unsigned int ni = face_indicies[i][3*j+2] - 1;

					glNormal3f (normals[ni][0],normals[ni][1],normals[ni][2]);
					glTexCoord2f(textures[ti][0],textures[ti][1]);
					glVertex3f(vertices[vi][0],vertices[vi][1],vertices[vi][2]);
				}
			}
			glEnd ();

		glEndList();
		return lid;
	};
}
