/*
			       Text View
 */

#ifndef TVIEW_H
#define TVIEW_H

#include <gtk/gtk.h>


typedef struct _tview_struct		tview_struct;
#define TVIEW(p)			((tview_struct *)(p))


/*
 *	Widget Name:
 */
#define TVIEW_WIDGET_NAME		"text-view"


/*
 *	Flags:
 */
typedef enum {
	TVIEW_FLAG_HAS_CHANGES		= (1 << 0),
	TVIEW_FLAG_READ_ONLY		= (1 << 1)
} tview_flags;


/*
 *	Text View:
 */
struct _tview_struct {

	GtkWidget	*toplevel;
	gboolean	map_state;
	gint		freeze_count,
			busy_count;
	tview_flags	flags;

	GdkCursor	*busy_cur,
			*text_cur,
			*translate_cur;

	GdkFont		*text_font;

	GtkWidget	*text,
			*hscrollbar,
			*vscrollbar;

	GtkAdjustment	*hadj,
			*vadj;

	/* Right click menu */
	GtkWidget	*menu,
			*cut_mi,
			*copy_mi,
			*paste_mi,
			*delete_mi,
			*select_all_mi,
			*unselect_all_mi;

	/* Changed callback */   
	void		(*changed_cb)(
		tview_struct *tv,		/* Text View */
		gpointer			/* Data */
	);
	gpointer	changed_data;

};

#define TVIEW_HAS_CHANGES(_tv_)		\
 ((_tv_)->flags & TVIEW_FLAG_HAS_CHANGES)
#define TVIEW_READ_ONLY(_tv_)		\
 ((_tv_)->flags & TVIEW_FLAG_READ_ONLY)


extern void TViewScrollToLine(
	tview_struct *tv, const gint n,
	const gfloat ycoeff, const gboolean move_cursor 
);
extern GtkVisibility TViewIsLineVisible(tview_struct *tv, const gint n);

extern gint TViewOpenFile(tview_struct *tv, const gchar *path);
extern gint TViewSaveFile(tview_struct *tv, const gchar *path);
extern gint TViewOpenData(tview_struct *tv, const gchar *data, gint data_len);
extern void TViewClear(tview_struct *tv);

extern void TViewCut(tview_struct *tv);
extern void TViewCopy(tview_struct *tv);
extern void TViewPaste(tview_struct *tv);
extern void TViewDeleteText(tview_struct *tv);
extern void TViewSelectAll(tview_struct *tv);
extern void TViewUnselectAll(tview_struct *tv);

extern gboolean TViewToplevelIsWindow(tview_struct *tv);
extern GtkWidget *TViewGetToplevelWidget(tview_struct *tv);
extern GtkText *TViewGetTextWidget(tview_struct *tv);
extern GtkMenu *TViewGetMenuWidget(tview_struct *tv);

extern tview_struct *TViewNew(GtkWidget *parent);
extern tview_struct *TViewNewWithToplevel(
	const gint width, const gint height
);
extern void TViewSetReadOnly(tview_struct *tv, const gboolean read_only);
extern void TViewSetChangedCB(
	tview_struct *tv,
	void (*changed_cb)(tview_struct *, gpointer),
	gpointer data
);
extern void TViewUpdate(tview_struct *tv);
extern void TViewDraw(tview_struct *tv);
extern void TViewSetBusy(tview_struct *tv, const gboolean busy);
extern void TViewMap(tview_struct *tv);
extern void TViewUnmap(tview_struct *tv);
extern void TViewDelete(tview_struct *tv);


#endif	/* TVIEW_H */
