/*
			  Object Operation Dialog

	Used for the querying of copying, moving, linking, chowning,
	and changing permissions of objects.
 */

#ifndef OBJ_OP_DLG_H
#define OBJ_OP_DLG_H

#include <gtk/gtk.h>
#include "pulist.h"
#include "edv_types.h"
#include "edv_obj.h"


typedef struct _edv_obj_op_dlg_struct	edv_obj_op_dlg_struct;
#define EDV_OBJ_OP_DLG(p)		((edv_obj_op_dlg_struct *)(p))


/*
 *	Operations:
 */
typedef enum {
	EDV_OBJ_OP_DLG_OP_MOVE		= 0,
	EDV_OBJ_OP_DLG_OP_COPY		= 1,
	EDV_OBJ_OP_DLG_OP_LINK		= 2,
	EDV_OBJ_OP_DLG_OP_CHMOD		= 3,	/* Change permissions */
	EDV_OBJ_OP_DLG_OP_CHOWN		= 4,	/* Change ownership */
	EDV_OBJ_OP_DLG_OP_CHTIME	= 5
} edv_obj_op_dlg_op;


/*
 *	Object Operation Dialog:
 */
struct _edv_obj_op_dlg_struct {

	GtkWidget	*toplevel;
	GtkAccelGroup	*accelgrp;
	gboolean	processing;
	gint		freeze_count,
			busy_count;
	edv_core_struct *core;

	GtkWidget	*main_vbox,
			*icon_fixed,
			*icon_pm,
			*label,			/* For describing the source
						 * objects */

			/* Widgets for move, copy and link */
			*target_entry,
			*target_browse_btn,

			/* Widgets for change permissions */
			*target_chmod_parent,
			*target_ur_check,
			*target_uw_check,
			*target_ux_check,
			*target_gr_check,
			*target_gw_check,
			*target_gx_check,
			*target_or_check,
			*target_ow_check,
			*target_ox_check,
			*target_suid_check,
			*target_sgid_check,
			*target_sticky_check,

			/* Widgets for change ownership */
			*target_chown_parent,
			*target_owner_entry,
			*target_owner_btn,
			*target_group_entry,
			*target_group_btn,

			/* Widgets for set time */
			*target_time_parent,
			*target_atime_year_spin,
			*target_atime_day_spin,
			*target_atime_hours_spin,
			*target_atime_minutes_spin,
			*target_atime_seconds_spin,
			*target_atime_current_btn,
			*target_mtime_year_spin,
			*target_mtime_day_spin,
			*target_mtime_hours_spin,
			*target_mtime_minutes_spin,
			*target_mtime_seconds_spin,
			*target_mtime_current_btn,

			*opt_parent,
			*opt_recursive_check,
			*opt_dereference_links_check,

			*move_btn,
			*copy_btn,
			*link_btn,
			*chmod_btn,
			*chown_btn,
			*chtime_btn,

			*cancel_btn;

	pulistbox_struct	*target_atime_month_pulistbox,
				*target_mtime_month_pulistbox;

	/* Reference toplevel for transiency, shared */
	GtkWidget	*ref_toplevel;

	/* Operation that we are querying values for */
	edv_obj_op_dlg_op	op;

	/* Source list of objects */
	GList		*objs_list;

	/* Source directory (relative/current location) */
	gchar		*src_dir;

};


extern edv_obj_op_dlg_struct *EDVObjOpDlgNew(edv_core_struct *core);
extern void EDVObjOpDlgReset(edv_obj_op_dlg_struct *d);
extern void EDVObjOpDlgSetBusy(edv_obj_op_dlg_struct *d, const gboolean is_busy);
extern gboolean EDVObjOpDlgIsMapped(edv_obj_op_dlg_struct *d);
extern void EDVObjOpDlgMapValues(
	edv_obj_op_dlg_struct *d,
	const edv_obj_op_dlg_op op,
	GList *objs_list,		/* List of edv_object_struct * */
	const gchar *src_dir,
	GtkWidget *toplevel
);
extern void EDVObjOpDlgUnmap(edv_obj_op_dlg_struct *d);
extern void EDVObjOpDlgDelete(edv_obj_op_dlg_struct *d);


#endif	/* OBJ_OP_DLG_H */
