/*
		           Menu Configuration List
 */

#ifndef MENUCFG_LIST_H
#define MENUCFG_LIST_H

#include <gtk/gtk.h>


typedef struct _menucfg_item_struct	menucfg_item_struct;
#define MENUCFG_ITEM(p)			((menucfg_item_struct *)(p))
typedef struct _menucfg_list_struct	menucfg_list_struct;
#define MENUCFG_LIST(p)			((menucfg_list_struct *)(p))


/*
 *	Selection IDs:
 */
#define MENUCFG_LIST_ITEM_TARGET_NAME	"MenuCfgList/Item"
#define MENUCFG_LIST_ITEM_INFO		0


/*
 *	Flags:
 */
typedef enum {

	MENUCFG_LIST_EDITABLE			= (1 << 0),

} menucfg_list_flags;


/*
 *	List Style:
 */
typedef enum {

	MENUCFG_LIST_STYLE_SINGLE,		/* Item name only */
	MENUCFG_LIST_STYLE_DETAILS		/* Name & command */

} menucfg_list_style;


/*
 *	MenuCfg Item:
 */
struct _menucfg_item_struct {

	gchar		*label,
			*command,
			*icon_file,
			*description;

	GList		*custom_datas_list;	/* List of gchar * custom
						 * string values */
};


/*
 *	MenuCfg List:
 */
struct _menucfg_list_struct {

	GtkWidget	*toplevel;		/* GtkBox */
	gint		freeze_count;
	menucfg_list_flags	flags;
	GtkOrientation	orientation;
	menucfg_list_style	list_style;

	GtkWidget	*clist,
			*buttons_box,
			*add_btn,
			*edit_btn,
			*remove_btn,
			*shift_up_btn,
			*shift_down_btn;

	GdkCursor	*translate_cur;

	/* Right click menu */
	GtkWidget	*menu,
			*menu_add_mi,
			*menu_edit_mi,
			*menu_remove_mi,
			*menu_shift_up_mi,
			*menu_shift_down_mi;

	/* Last button that was pressed and pointer drag position */
	gint		button,
			drag_last_x,
			drag_last_y;

	gchar		*browse_path_rtn;

	/* Callbacks */
	void		(*changed_cb)(
		menucfg_list_struct *,	/* MenuCfg List */
		gpointer		/* Data */
	);
	gpointer	changed_data;

	void		(*item_added_cb)(
		menucfg_list_struct *,	/* MenuCfg List */
		gint,			/* Item index */
		menucfg_item_struct *,	/* Item */
		gpointer		/* Data */
	);
	gpointer	item_added_data;

	void		(*item_changed_cb)(
		menucfg_list_struct *,	/* MenuCfg List */
		gint,			/* Item index */
		menucfg_item_struct *,	/* Item */
		gpointer		/* Data */
	);
	gpointer	item_changed_data;

	void		(*item_removed_cb)(
		menucfg_list_struct *,	/* MenuCfg List */
		gint,			/* Item index */
		gpointer		/* Data */
	);
	gpointer	item_removed_data;

	/* Custom data names
	 *
	 * Each item in the GList is a gchar * string and each item
	 * represents the existance of each corresponding custom data
	 */
	GList		*custom_data_names;

};


/* Item */
extern menucfg_item_struct *MenuCfgItemNew(
	const gchar *label,
	const gchar *command,
	const gchar *icon_file,
	const gchar *description
);
extern void MenuCfgItemSetCustomData(
	menucfg_item_struct *item, GList *custom_datas_list
);
extern const gchar *MenuCfgItemGetCustomDataValue(
	menucfg_item_struct *item, const gint i
);
extern menucfg_item_struct *MenuCfgItemCopy(menucfg_item_struct *item);
extern void MenuCfgItemDelete(menucfg_item_struct *item);


/* MenuCfg List */
extern void MenuCfgListAdd(menucfg_list_struct *list);
extern gboolean MenuCfgListEdit(menucfg_list_struct *list);
extern void MenuCfgListRemove(menucfg_list_struct *list, const gboolean confirm);
extern void MenuCfgListShiftUp(menucfg_list_struct *list);
extern void MenuCfgListShiftDown(menucfg_list_struct *list);

extern menucfg_list_struct *MenuCfgListNew(
	GtkWidget *parent,
	const GtkOrientation orientation
);
extern void MenuCfgListSetCustomData(
        menucfg_list_struct *list,
        GList *custom_names_list
);
extern gint MeuCfgListGetTotalCustomDatas(menucfg_list_struct *list);
extern void MenuCfgListSetListStyle(
	menucfg_list_struct *list, const menucfg_list_style list_style
);
extern void MenuCfgListSetEditable(
	menucfg_list_struct *list, const gboolean editable
);
extern void MenuCfgListSetChangedCB(
	menucfg_list_struct *list,
	void (*cb)(menucfg_list_struct *, gpointer),
	gpointer data
);
extern void MenuCfgListSetItemAddedCB(
	menucfg_list_struct *list,
	void (*cb)(
		menucfg_list_struct *,
		gint,
		menucfg_item_struct *,
		gpointer
	),
	gpointer data
);
extern void MenuCfgListSetItemChangedCB(
	menucfg_list_struct *list,
	void (*cb)(
		menucfg_list_struct *,
		gint,
		menucfg_item_struct *,
		gpointer
	),
	gpointer data
);
extern void MenuCfgListSetItemRemovedCB(
	menucfg_list_struct *list,
	void (*cb)(
		menucfg_list_struct *,
		gint,
		gpointer
	),
	gpointer data
);
extern gint MenuCfgListInsert( 
	menucfg_list_struct *list, const gint row,
	menucfg_item_struct *item		/* Transfered */
);
extern gint MenuCfgListAppend(
	menucfg_list_struct *list,
	menucfg_item_struct *item		/* Transfered */
);
extern void MenuCfgListSet(
	menucfg_list_struct *list, const gint row,
	menucfg_item_struct *item		/* Transfered */
);
extern void MenuCfgListClear(menucfg_list_struct *list);
extern menucfg_item_struct *MenuCfgListGet(
	menucfg_list_struct *list, const gint row
);
extern void MenuCfgListUpdateWidgets(menucfg_list_struct *list);
extern void MenuCfgListMap(menucfg_list_struct *list);
extern void MenuCfgListUnmap(menucfg_list_struct *list);
extern void MenuCfgListDelete(menucfg_list_struct *list);


#endif	/* MENUCFG_LIST_H */
