/*
                        Endeavour Archive Object

	For objects within archives.
 */

#ifndef EDV_ARCHIVE_OBJ_H
#define EDV_ARCHIVE_OBJ_H

#include <sys/stat.h>
#include <glib.h>
#include "edv_types.h"


typedef struct _edv_archive_object_struct	edv_archive_object_struct;
#define EDV_ARCHIVE_OBJECT(p)		((edv_archive_object_struct *)(p))


/*
 *	Archive Object:
 */
struct _edv_archive_object_struct {

	/* Type */
	edv_object_type	type;

	/* Name */
	gchar		*name,
			*full_path;	/* This may or may not be an
					 * absolute path, it may also be
					 * a relative path (with parent
					 * directories) within the archive */

	/* Size */
	gulong		size,			/* In bytes */
			compressed_size;	/* In bytes */

	/* Link */
	gchar		*link_target;	/* Only for EDV_OBJECT_TYPE_LINK */

	/* Permissions */
	edv_permission_flags	permissions;

	/* Time Stamps */
	gulong		access_time,	/* In systime seconds */
			modify_time,
			change_time;

	/* Ownership */
	gchar		*owner_name,
			*group_name;

	/* Misc */
	gint		device_type;	/* Device major and minor numbers
					 * (used only if object type is one
					 * of EDV_OBJECT_TYPE_DEVICE_*
					 *
					 * Use EDVGetDeviceNumbers() to parse
					 * this value casted as a dev_t */

	gchar		*encryption;	/* If not NULL, then specifies that
					 * this object is encrypted and the
					 * name of the encryption, otherwise
					 * this object is not encrypted */

	gfloat		compression_ratio;	/* 0.0 = not compressed
						 * 1.0 = total compression */

	gchar		*method;	/* Method of storage */
	gchar		*crc;		/* CRC checksum */

};


extern edv_archive_object_struct *EDVArchObjectNew(void);
extern edv_archive_object_struct *EDVArchObjectCopy(
	edv_archive_object_struct *obj
);
extern void EDVArchObjectDelete(edv_archive_object_struct *obj);


#endif	/* EDV_ARCHIVE_OBJ_H */
