/*
	          Endeavour Devices List & Edit Window
 */

#ifndef DEVICESWIN_H
#define DEVICESWIN_H

#include <gtk/gtk.h>

#include "pie_chart.h"
#include "pulist.h"

#include "edv_types.h"
#include "edv_device.h"
#include "editclist.h"


typedef struct _edv_devices_list_win_struct	edv_devices_list_win_struct;
#define EDV_DEVICE_ICON_PICKER(p)		((edv_device_icon_picker_struct *)(p)) 
typedef struct _edv_device_edit_dlg_struct	edv_device_edit_dlg_struct;
#define EDV_DEVICE_EDIT_DLG(p)			((edv_device_edit_dlg_struct *)(p))
typedef struct _edv_device_icon_picker_struct	edv_device_icon_picker_struct;
#define EDV_DEVICE_LISTWIN(p)			((edv_devices_list_win_struct *)(p))


/*
 *	Device Edit Window Icon Picker:
 */
struct _edv_device_icon_picker_struct {

	GtkWidget	*toplevel,	/* GtkBox */
			*button,	/* Icon GtkButton */
			*gtk_pixmap,
			*left_btn, *right_btn, *state_label;

	edv_device_edit_dlg_struct	*d;

	GtkAdjustment	*adj;		/* State GtkAdjustment */

	gint		icon_width,
			icon_height;

	GdkPixmap	*pixmap[EDV_DEVICE_TOTAL_ICON_STATES];
	GdkBitmap	*mask[EDV_DEVICE_TOTAL_ICON_STATES];

	gchar		*path[EDV_DEVICE_TOTAL_ICON_STATES];

};

/*
 *	Device Edit Dialog:
 */
struct _edv_device_edit_dlg_struct {

	GtkWidget       *toplevel;
	GtkAccelGroup   *accelgrp;
	gint            busy_count,
			freeze_count;
	gboolean	has_changes;
	gchar		*title;
	edv_core_struct *core;

	edv_devices_list_win_struct	*list_win;

	GtkWidget       *main_vbox,
			*name_entry,
			*device_path_entry,
			*mount_path_entry,
			*command_mount_entry,
			*command_unmount_entry,
			*command_eject_entry,
			*command_check_entry,
			*command_tools_entry,
			*command_format_entry,
			*no_unmount_check,
			*read_only_check,
			*unlisted_check,
			*no_scan_check,
			*ok_btn,
			*apply_btn,
			*cancel_btn,
			*close_btn;

	pulistbox_struct	*fs_type_pulistbox;

	/* Icon Pickers */
	edv_device_icon_picker_struct	*icon_small,
					*icon_medium,
					*icon_large;

	/* Device being edited */
	gint		dev_num;

};

/*
 *	Device List Window:
 */
struct _edv_devices_list_win_struct {

	GtkWidget       *toplevel;
	GtkAccelGroup   *accelgrp;
	gint            busy_count,
			freeze_count;
	edv_core_struct	*core;

	GtkWidget	*main_vbox,
			*find_entry,
			*devices_clist,
			*add_btn,
			*edit_btn,
			*remove_btn,
			*up_btn,
			*down_btn,
			*display_parent,	/* GtkVBox */
			*display_client,	/* Parented to display_parent */
			*close_btn;

	/* Right click menu */
	GtkWidget	*menu,
			*add_mi,
			*edit_mi,
			*remove_mi,
			*up_mi,
			*down_mi;

	/* Important widgets on display_client */
	GtkWidget	*dev_icon_pm,
			*dev_name_label,
			*dev_device_path_label,
			*dev_mount_path_label,
			*dev_mount_btn, *dev_eject_btn,	*dev_properties_btn,
			*dev_fsck_btn, *dev_tools_btn, *dev_format_btn;
	pie_chart_struct	*dev_pc;

	edv_device_edit_dlg_struct	*edit_dlg;

#if 0
	/* Pixmaps and mask pairs for the mount and not mounted icons */
	GdkPixmap	*mounted_pm;
	GdkBitmap	*mounted_mask;
	GdkPixmap	*not_mounted_pm;
	GdkBitmap	*not_mounted_mask;
#endif
};


/* In devicesedit.c */
extern void EDVDevicesEditWinFetchValues(
	edv_device_edit_dlg_struct *d, const gint dev_num
);
extern void EDVDevicesEditWinDeviceRemovedCB(
	edv_device_edit_dlg_struct *d, gint dev_num
);

extern edv_device_edit_dlg_struct *EDVDevicesEditWinNew(
	edv_core_struct *core, edv_devices_list_win_struct *lw
);
extern void EDVDevicesEditWinResetHasChanges(
	edv_device_edit_dlg_struct *d, const gboolean has_changes
);
extern void EDVDevicesEditWinUpdateMenus(edv_device_edit_dlg_struct *d);
extern gboolean EDVDevicesEditWinIsMapped(edv_device_edit_dlg_struct *d);
extern void EDVDevicesEditWinMap(edv_device_edit_dlg_struct *d);
extern void EDVDevicesEditWinUnmap(edv_device_edit_dlg_struct *d);
extern void EDVDevicesEditWinDelete(edv_device_edit_dlg_struct *d);


/* In deviceswin.c */
extern void EDVDevicesListWinSetRow(
	edv_devices_list_win_struct *lw,
	const gint row, edv_device_struct *dev
);
extern void EDVDevicesListWinFetchValues(
	edv_devices_list_win_struct *lw,
	const gboolean verbose
);

extern void EDVDevicesListWinUsageChangedCB(
	edv_devices_list_win_struct *lw
);
extern void EDVDevicesListWinReconfiguredNotifyCB(
	edv_devices_list_win_struct *lw
);
extern void EDVDevicesListWinMountNotifyCB(
	edv_devices_list_win_struct *lw,
	gint dev_num, edv_device_struct *dev_ptr,
	gboolean is_mounted
);
extern void EDVDevicesListWinDeviceAddedCB(
	edv_devices_list_win_struct *lw,
	gint dev_num, edv_device_struct *dev_ptr
);
extern void EDVDevicesListWinDeviceModifiedCB(
	edv_devices_list_win_struct *lw,
	gint dev_num, edv_device_struct *dev_ptr
);
extern void EDVDevicesListWinDeviceRemovedCB(
	edv_devices_list_win_struct *lw, gint dev_num
);

extern edv_devices_list_win_struct *EDVDevicesListWinNew(
	edv_core_struct *core
);
extern void EDVDevicesListWinUpdateMenus(edv_devices_list_win_struct *lw);
extern void EDVDevicesListSetBusy(
	edv_devices_list_win_struct *lw, const gboolean busy
);
extern gboolean EDVDevicesListWinIsMapped(edv_devices_list_win_struct *lw);
extern void EDVDevicesListWinMap(edv_devices_list_win_struct *lw);
extern void EDVDevicesListWinUnmap(edv_devices_list_win_struct *lw);
extern void EDVDevicesListWinDelete(edv_devices_list_win_struct *lw);


#endif	/* DEVICESWIN_H */
