/*
                               Event Notification
 */

#ifndef EDV_NOTIFY_H
#define EDV_NOTIFY_H

#include "edv_context.h"


/*
 *	Queues an "object_added_notify" command.
 */
extern void EDVNotifyQueueObjectAdded(
	edv_context_struct *ctx, const gchar *path
);

/*
 *	Queues an "object_modified_notify" command.
 *
 *	If new_path is NULL then only path will be sent (hinting that
 *	the name of the object was not modified).
 */
extern void EDVNotifyQueueObjectModified(
	edv_context_struct *ctx, const gchar *path, const gchar *new_path
);

/*
 *	Queues an "object_removed_notify" command.
 */
extern void EDVNotifyQueueObjectRemoved(
	edv_context_struct *ctx, const gchar *path
);


/*
 *	Queues an "object_mounted_notify" command.
 */
extern void EDVNotifyQueueObjectMounted(
	edv_context_struct *ctx, const gchar *path
);

/*
 *	Queues an "object_unmounted_notify" command.
 */
extern void EDVNotifyQueueObjectUnmounted(
	edv_context_struct *ctx, const gchar *path
);


/*
 *	Queues a "recycled_object_added_notify" command.
 */
extern void EDVNotifyQueueRecycledObjectAdded(
	edv_context_struct *ctx, guint index
);

/*
 *	Queues a "recycled_object_removed_notify" command.
 */
extern void EDVNotifyQueueRecycledObjectRemoved(
	edv_context_struct *ctx, guint index
);


/*
 *	Queues a "reconfigured_notify" command.
 */
extern void EDVNotifyQeueReconfiguredNotify(
        edv_context_struct *ctx, guint index
);


#endif	/* EDV_NOTIFY_H */
