/*
                              MIME Type Fetching
 */

#ifndef EDV_MIME_TYPE_GET_H
#define EDV_MIME_TYPE_GET_H

#include <sys/stat.h>
#include <glib.h>
#include "edv_mime_type.h"
#include "edv_context.h"


/*
 *	Returns a list of MIME Types.
 *
 *	The returned list must not be modified or deleted.
 */
extern edv_mime_type_struct **EDVMimeTypeList(
	edv_context_struct *ctx, gint *total
);

/*
 *	Matches the object specified by path and lstat_buf with a
 *	MIME Type.
 *
 *	Returns the matched MIME Type or NULL on error, the returned
 *	MIME Type must not be modified or deleted.
 */
extern edv_mime_type_struct *EDVMimeTypeMatch(
	edv_context_struct *ctx,
	const gchar *path, const struct stat *lstat_buf
);

/*
 *	Matches the MIME Type by the specified type string.
 *
 *	Returns the matched MIME Type or NULL on error, the returned
 *	MIME Type must not be modified or deleted.
 */
extern edv_mime_type_struct *EDVMimeTypeMatchType(
	edv_context_struct *ctx,
	const gchar *type
);


#endif	/* EDV_MIME_TYPE_GET_H */
