/*
                            Configuration Fetching
 */

#ifndef EDV_GET_H
#define EDV_GET_H

#include <glib.h>
#include "edv_context.h"


/*
 *	Returns a dynamically allocated list of configuration
 *	parameters.
 *
 *	The calling function must delete the returned pointer array
 *	and each string.
 */
extern gchar **EDVGetConfigurationParameters(
	edv_context_struct *ctx, gint *total
);

/*
 *	Gets the boolean value of the specified parameter.
 */
extern gboolean EDVGetB(edv_context_struct *ctx, const gchar *parm);

/*
 *	Gets the integer value of the specified parameter.
 */
extern gint EDVGetI(edv_context_struct *ctx, const gchar *parm);

/*
 *	Gets the long integer value of the specified parameter.
 */
extern glong EDVGetL(edv_context_struct *ctx, const gchar *parm);

/*
 *	Gets the unsigned long integer value of the specified parameter.
 */
extern gulong EDVGetUL(edv_context_struct *ctx, const gchar *parm);

/*
 *	Gets the float value of the specified parameter.
 */
extern gfloat EDVGetF(edv_context_struct *ctx, const gchar *parm);

/*
 *	Gets the double value of the specified parameter.
 */
extern gdouble EDVGetD(edv_context_struct *ctx, const gchar *parm);

/*
 *	Gets the string value of the specified parameter.
 *
 *	The returned pointer must not be modified or deleted.
 *
 *	Can return NULL if the parameter does not exist.
 */
extern gchar *EDVGetS(edv_context_struct *ctx, const gchar *parm);

/*
 *	Convience function to return the version of Endeavour found
 *	in the configuration.
 *
 *	Note that this gives the version of Endeavour last recorded
 *	on the configuration file, not always the currently installed
 *	version.
 *
 *	Returns TRUE on success or FALSE on error.
 */
extern gboolean EDVGetVersion(
	edv_context_struct *ctx,
	gint *major, gint *minor, gint *release
);


#endif	/* EDV_GET_H */
