#ifndef EDV_DATE_H
#define EDV_DATE_H


/*
 *      Date Relativity:
 */
typedef enum {
        EDV_DATE_RELATIVITY_ABSOLUTE,	/* Relative to christian time */
        EDV_DATE_RELATIVITY_CURRENT	/* Relative to current time */
} edv_date_relativity;


/*
 *	Returns a statically allocated string describing the date &
 *	time specified by t in systime seconds.
 *
 *	The format and relativity of the date & time is specified by    
 *	the configuration on the context.
 */
extern const gchar *EDVDateString(edv_context_struct *ctx, gulong t);

/*
 *	Returns a statically allocated string describing the time that
 *	has been lapsed specified by dt in seconds.
 *
 *	The format and relativity of the date & time is specified by
 *	the configuration on the context.
 */
extern const gchar *EDVDateStringDuration(edv_context_struct *ctx, gulong dt);


#endif	/* EDV_DATE_H */
