/*
                              Endeavour Find Bar
 */

#ifndef EDV_FIND_BAR_H
#define EDV_FIND_BAR_H

#include <sys/stat.h>
#include <gtk/gtk.h>
#include "edv_types.h"


typedef struct _edv_findbar_struct	edv_findbar_struct;
#define EDV_FINDBAR(p)	((edv_findbar_struct *)(p))


/*
 *	Find Bar Operations:
 */
typedef enum {
	EDV_FINDBAR_FIND_OBJECT_NAME,
	EDV_FINDBAR_FIND_OBJECT_CONTENT
} edv_findbar_operation;

/*
 *	Find Bar Roles:
 */
typedef enum {
	EDV_FINDBAR_ROLE_DISK_OBJECT,
	EDV_FINDBAR_ROLE_RECYCLED_OBJECT,
	EDV_FINDBAR_ROLE_ARCHIVE_OBJECT
} edv_findbar_role;


/*
 *	Find Bar:
 */
struct _edv_findbar_struct {

	GtkWidget	*toplevel;
	gint		freeze_count,
			stop_count;
	gpointer	core;

	edv_findbar_role	role;

	GtkWidget	*find_op_combo,
			*search_combo,
			*case_sensitive_check,
			*stop_btn;

	/* Get current location callback */
	const gchar	*(*get_location_cb)(
		edv_findbar_struct *,	/* Find Bar */
		gpointer		/* Data */
	);

	/* Find start callback */
	void	(*start_cb)(
		edv_findbar_struct *,	/* Find Bar */
		gpointer		/* Data */
	);
	/* Find end callback */
	void	(*end_cb)(
		edv_findbar_struct *,	/* Find Bar */
		gint,			/* Total Matches */
		gpointer		/* Data */
	);

	/* Matched path callback
	 *
	 * Note, if the role is set to EDV_FINDBAR_ROLE_RECYCLED_OBJECT
	 * then the path is a string describing the index of the
	 * recycled object
	 */
	void	(*match_cb)(
		const gchar *,		/* Path */
		const struct stat *,	/* Local Stats */
		const gchar *,		/* Excerpt */
		gint,			/* Line Index */
		gpointer		/* Data */
	);

        /* Status message callback */
        void    (*status_message_cb)(
                const gchar *,		/* Message */
                gpointer		/* Data */
        );
        /* Status progress callback */
        void    (*status_progress_cb)(
                gfloat,			/* Progress */
                gpointer		/* Data */
        );

	gpointer	data;

};


extern void EDVFindBarSetSearch(
	edv_findbar_struct *fb, const gchar *s,
	gboolean record_history
);
extern edv_findbar_operation EDVFindBarCurrentFindOP(
	edv_findbar_struct *fb
);

extern edv_findbar_struct *EDVFindBarNew(
	gpointer core, GtkWidget *parent,
	edv_findbar_role role,
	const gchar *(*get_location_cb)(
		edv_findbar_struct *, gpointer
	),
	void (*start_cb)(
		edv_findbar_struct *, gpointer
	),
	void (*end_cb)(
		edv_findbar_struct *, gint, gpointer
	),
	void (*match_cb)(
	    const gchar *, const struct stat *,
	    const gchar *, gint,
	    gpointer
	),
        void (*status_message_cb)(const gchar *, gpointer),
        void (*status_progress_cb)(gfloat, gpointer),
	gpointer data
);
extern void EDVFindBarUpdateMenus(edv_findbar_struct *fb);
extern void EDVFindBarMap(edv_findbar_struct *fb);
extern void EDVFindBarUnmap(edv_findbar_struct *fb);
extern void EDVFindBarDelete(edv_findbar_struct *fb);


#endif	/* EDV_FIND_BAR_H */
