#include <string.h>
#include <gtk/gtk.h>

#include "guiutils.h"
#include "stacklist.h"
#include "keymap_list.h"

#include "cfg.h"
#include "edv_types.h"
#include "browser.h"
#include "edv_generic_options_win.h"
#include "customize_win.h"
#include "endeavour2.h"
#include "edv_utils.h"
#include "edv_utils_gtk.h"

#include "edv_cfg_list.h"
#include "config.h"


/* File Browser */
static void EDVCustomizeBrowserKeymapsDefaultsCB(
	keymap_list_struct *kmlist, keymap_key_struct *km,
	gpointer data
);
void EDVCustomizeBrowserCreateKeymapsPage(
	edv_core_struct *core, edv_gen_opt_win_struct *optwin,
	GtkWidget *parent
);
void EDVCustomizeBrowserCreateContentsListPage(
	edv_core_struct *core, edv_gen_opt_win_struct *optwin,
	GtkWidget *parent
);
void EDVCustomizeBrowserCreateToolBarPage(
	edv_core_struct *core, edv_gen_opt_win_struct *optwin,
	GtkWidget *parent
);
void EDVCustomizeBrowserCreateAppearancePage(
	edv_core_struct *core, edv_gen_opt_win_struct *optwin,
	GtkWidget *parent
);


#define ATOI(s)         (((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)         (((s) != NULL) ? atol(s) : 0)
#define ATOF(s)         (((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)       (((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)        (((a) > (b)) ? (a) : (b))
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)     (MIN(MAX((a),(l)),(h)))
#define STRLEN(s)       (((s) != NULL) ? strlen(s) : 0)
#define STRISEMPTY(s)   (((s) != NULL) ? (*(s) == '\0') : TRUE)


/*
 *	Keymaps List defaults callback.
 */
static void EDVCustomizeBrowserKeymapsDefaultsCB(
	keymap_list_struct *kmlist, keymap_key_struct *km,
	gpointer data
)
{
	gint op;
	GList *glist;
	cfg_accelkey_struct *ak;
	cfg_accelkey_list_struct *ak_list;
	edv_core_struct *core = EDV_CORE(data);
	if((kmlist == NULL) || (km == NULL) || (core == NULL))
	    return;

	op = (gint)km->data;
	ak_list = EDVBrowserAccelkeysListNewDefault();
	if(ak_list == NULL)
	    return;

	for(glist = ak_list->list; glist != NULL; glist = g_list_next(glist))
	{
	    ak = CFG_ACCELKEY(glist->data);
	    if(ak == NULL)
		continue;

	    if(ak->opid == op)
	    {
		km->keyval = ak->key;
		km->state = ak->modifiers;
		break;
	    }
	}

	CFGAccelkeyListDelete(ak_list);
}

/*
 *	Creates the File Browser Keymaps page.
 */
void EDVCustomizeBrowserCreateKeymapsPage(
	edv_core_struct *core, edv_gen_opt_win_struct *optwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5,
			border_minor = 2;
	GList *opid_list;
	GtkWidget *w, *parent2;
	const cfg_item_struct *cfg_list = core->cfg_list;
	cfg_accelkey_list_struct *ak_list;
	edv_gen_opt_wref_struct *wref;
	keymap_list_struct *kmlist;
	edv_browser_opid_struct *opid;


	/* Accelerator Keys frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Acelerador Adapta"
#elif defined(PROG_LANGUAGE_FRENCH)
"L'Accelerateur Saisit"
#elif defined(PROG_LANGUAGE_GERMAN)
"Beschleuniger Gibt Ein"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Chiavi Di Acceleratore"
#elif defined(PROG_LANGUAGE_DUTCH)
"De Versneller Stemt"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Teclas De Acelerador"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Akselerator Fester"
#else
"Accelerator Keys"
#endif
);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_hbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* Create the Keymap List */
	kmlist = KeymapListNew(
	    parent2,
	    GTK_ORIENTATION_HORIZONTAL
	);
	KeymapListSetEditable(kmlist, TRUE);
	KeymapListSetAutoCheckConflicts(kmlist, TRUE);
	KeymapListSetKeyDefaultRequestCB(
	    kmlist,
	    EDVCustomizeBrowserKeymapsDefaultsCB,
	    core
	);
	KeymapListMap(kmlist);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_KEYMAP_LIST, kmlist,
	    NULL,
	    EDV_CFG_PARM_BROWSER_ACCELERATOR_KEYS
	);

	/* Add the Accelkeys to the Keymap List */
	KeymapListClear(kmlist);
	opid_list = EDVBrowserOPIDListNew(NULL);
	ak_list = EDV_GET_ACCELKEY_LIST(
	    EDV_CFG_PARM_BROWSER_ACCELERATOR_KEYS
	);
	if(ak_list != NULL)
	{
	    gint op;
	    GList *glist, *glist2, *ak_glist = ak_list->list;
	    cfg_accelkey_struct *ak;

	    /* Iterate through Operation IDs */
	    for(glist = opid_list;
		glist != NULL;
		glist = g_list_next(glist)
	    )
	    {
		opid = EDV_BROWSER_OPID(glist->data);
		if(opid == NULL)
		    continue;

		if(opid->flags & EDV_OPID_NO_OP)
		    continue;

		/* Get the Operation Code */
		op = opid->op;

		/* Find an Accelkey for this Operation ID */
		for(glist2 = ak_glist;
		    glist2 != NULL;
		    glist2 = g_list_next(glist2)
		)
		{
		    ak = CFG_ACCELKEY(glist2->data);
		    if(ak == NULL)
			continue;

		    if(ak->opid == op)
		    {
			/* Add this Accelkey to the Keymap List */
			gchar *name = EDVCustomizeSimplifyOPIDName(
			    opid->menu_name
			);
			keymap_key_struct *km = KeymapKeyNew(
			    ak->key, ak->modifiers, (gpointer)op
			);
			KeymapListAppend(
			    kmlist,
			    opid->button_icon_data,
			    name,
			    km			/* Shared */
			);
			KeymapKeyDelete(km);
			g_free(name);
			break;
		    }
		}
	    }
	}
	EDVBrowserOPIDListDelete(opid_list);



}


/*
 *      Creates the File Browser Contents List page.
 */
void EDVCustomizeBrowserCreateContentsListPage(
	edv_core_struct *core, edv_gen_opt_win_struct *optwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5,
			border_minor = 2;
	GtkWidget *w, *parent2;
	edv_gen_opt_wref_struct *wref;
	stack_list_struct *slist;


	/* Display options frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Las Opciones Del Despliegue De La Clula"
#elif defined(PROG_LANGUAGE_FRENCH)
"Les Options D'Exposition De Cellule"
#elif defined(PROG_LANGUAGE_GERMAN)
"Zelle Ausstellung Optionen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Le Opzioni Di Mostra Di Cellula"
#elif defined(PROG_LANGUAGE_DUTCH)
"Cel Tentoonstelling Opties"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"As Opes De Exposio De Clula"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Celleut Stillings Alternativer"
#else
"Cell Display Options"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_hbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* Hide dir size check */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Esconda Tamao Gua"
#elif defined(PROG_LANGUAGE_FRENCH)
"Cacher Taille D'Annuaire"
#elif defined(PROG_LANGUAGE_GERMAN)
"Verstecken Sie Verzeichnis Gre"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Misura Di Elenco Di Nascondiglio"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verberg Gids Maat"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Esconda Tamanho De Guia"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Gjemm Katalog Strrelse"
#else
"Hide Directory Size"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_TOGGLE_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_BROWSER_CONTENTS_HIDE_DIR_SIZE
	);

	/* Hide link size check */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Esconda tamao del enlace"
#elif defined(PROG_LANGUAGE_FRENCH)
"Cacher Taille Lien"
#elif defined(PROG_LANGUAGE_GERMAN)
"Verstecken Sie Verbindung Gre"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Misura Di Maglia Di Nascondiglio"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verberg Schakel Maat"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Tamanho De Elo De Couro"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Gjemm LeddStrrelse"
#else
"Hide Link Size"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_TOGGLE_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_BROWSER_CONTENTS_HIDE_LINK_SIZE
	);

	/* Hide link permission check */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Esconda permisos del enlace"
#elif defined(PROG_LANGUAGE_FRENCH)
"Cacher Permissions Lien"
#elif defined(PROG_LANGUAGE_GERMAN)
"Verstecken Sie Verbindung Erlaubnis"
#elif defined(PROG_LANGUAGE_ITALIAN)
"I Permessi Di Maglia Di Nascondiglio"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verberg Schakel Toestemmingen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"As Permisses De Elo De Couro"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Gjemm Ledd Tillatelse"
#else
"Hide Link Permissions"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_TOGGLE_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_BROWSER_CONTENTS_HIDE_LINK_PERMISSIONS
	);


	/* Arrangement frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Arreglo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Arrangement"
#elif defined(PROG_LANGUAGE_GERMAN)
"Anordnung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Disposizione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Schikking"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Arranjo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Arrangement"
#else
"Arrangement"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* Create contents list stack list */
	slist = StackListNew(
	    parent2,
#if defined(PROG_LANGUAGE_SPANISH)
"Disponible", "La Corriente"
#elif defined(PROG_LANGUAGE_FRENCH)
"Disponible", "Courant"
#elif defined(PROG_LANGUAGE_GERMAN)
"Verfgbar", "Strmung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Disponibile", "La Corrente"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verkrijgbaar", "Stroom"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Disponvel", "A Corrente"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Tilgjengelig", "Strm"
#else
"Available", "Current"
#endif
	);
	StackListShowDescription(slist, TRUE, TRUE);
	StackListSetMaintainSourceOrder(slist, TRUE);
	StackListMap(slist);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_STACK_LIST, slist,
	    NULL,
	    EDV_CFG_PARM_BROWSER_CONTENTS_COLUMN
	);

	/* Create Contents List Headings Stack List */
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"El Nombre",
"El nombre del objeto",
#elif defined(PROG_LANGUAGE_FRENCH)
"Nom",
"Le nom de l'objet",
#elif defined(PROG_LANGUAGE_GERMAN)
"Name",
"Name des objekts",
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Nome",
"Il nome dell'oggetto",
#elif defined(PROG_LANGUAGE_DUTCH)
"Naam",
"Naam van het voorwerp",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Nome",
"O nome do objeto",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Navn",
"Navn av objektet",
#else
"Name",
"Name of the object",
#endif
	    NULL,		/* No icon data */
	    NULL,		/* No client data */
	    EDV_BROWSER_COLUMN_TYPE_NAME,
	    FALSE, TRUE		/* No multiple, stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"El Tamao",
"El tamao del objeto",
#elif defined(PROG_LANGUAGE_FRENCH)
"Taille",
"La taille de l'objet",
#elif defined(PROG_LANGUAGE_GERMAN)
"Gre.",
"Gre des objekts",
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Misura",
"La misura dell'oggetto",
#elif defined(PROG_LANGUAGE_DUTCH)
"Maat",
"Maat van het voorwerp",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Tamanho",
"O tamanho do objeto",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Strrelse",
"Strrelse av objektet",
#else
"Size",
"Size of the object",
#endif
	    NULL,               /* No icon data */
	    NULL,		/* No client data */
	    EDV_BROWSER_COLUMN_TYPE_SIZE,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"El Tipo",
"De tipo MIME se asoci con el objeto",
#elif defined(PROG_LANGUAGE_FRENCH)
"Type",
"Le Type de MIME a associ avec l'objet",
#elif defined(PROG_LANGUAGE_GERMAN)
"Typ",
"MIME Typ hat verbunden mit dem objekt",
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Tipo",
"Il tipo di MIME  frequentato l'oggetto",
#elif defined(PROG_LANGUAGE_DUTCH)
"Type",
"MIME type associeerde met het voorwerp",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Tipo",
"O tipo de MIME associou-se com o objeto",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Type",
"MIME maskinskriver tilknyttet med objektet",
#else
"Type",
"MIME Type associated with the object",
#endif
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_BROWSER_COLUMN_TYPE_TYPE,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"Los Permisos",
"Los permisos para el objeto",
#elif defined(PROG_LANGUAGE_FRENCH)
"Permissions",
"Les permissions pour l'objet",
#elif defined(PROG_LANGUAGE_GERMAN)
"Erlaubnis",
"Erlaubnis fr das objekt",
#elif defined(PROG_LANGUAGE_ITALIAN)
"I Permessi",
"I permessi per l'oggetto",
#elif defined(PROG_LANGUAGE_DUTCH)
"Toestemmingen",
"Toestemmingen voor het voorwerp",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"As Permisses",
"As permisses para o objeto",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Tillatelse",
"Tillatelse for objektet",
#else
"Permissions",
"Access rights to the object",
#endif
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_BROWSER_COLUMN_TYPE_PERMISSIONS,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"El Dueo",
"El dueo del objeto",
#elif defined(PROG_LANGUAGE_FRENCH)
"Propritaire",
"Le propritaire de l'objet",
#elif defined(PROG_LANGUAGE_GERMAN)
"Eigentmer",
"Eigentmer des objekts",
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Proprietario",
"Il proprietario dell'oggetto",
#elif defined(PROG_LANGUAGE_DUTCH)
"Eigenaar",
"Eigenaar van het voorwerp",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Proprietrio",
"O proprietrio do objeto",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Eier",
"Eier av objektet",
#else
"Owner",
"User that the object belongs to",
#endif
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_BROWSER_COLUMN_TYPE_OWNER,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"El Grupo",
"La propiedad agrupada del objeto",
#elif defined(PROG_LANGUAGE_FRENCH)
"Groupe",
"La possession groupe de l'objet",
#elif defined(PROG_LANGUAGE_GERMAN)
"Gruppe",
"Klassifiziertes eigentumsrecht des objekts",
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Gruppo",
"La propriet raggruppata dell'oggetto",
#elif defined(PROG_LANGUAGE_DUTCH)
"Groep",
"Gegroepeerd eigendomsrecht van het voorwerp",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Grupo",
"Posse agrupada do objeto",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Gruppe",
"Gruppert eiendomsrett av objektet",
#else
"Group",
"Group that the object belongs to",
#endif
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_BROWSER_COLUMN_TYPE_GROUP,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"El Acceso De La Fecha",
"Feche que el objeto era ltimo conseguir acceso a",
#elif defined(PROG_LANGUAGE_FRENCH)
"Accs De Date",
"Dater que l'objet tait dernier a accd ",
#elif defined(PROG_LANGUAGE_GERMAN)
"Datieren Sie Zugriff",
"Datum, da das objekt zuletzt auf zugegriffen wurde",
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Accesso Di Data",
"Data che l'oggetto era ultimo accesso a",
#elif defined(PROG_LANGUAGE_DUTCH)
"Dateer Toegang",
"Datum dat het voorwerp was vorig toegang tot had",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Acesso De Data",
"Date que o objeto era ltimo acedido",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Dater Tilgang",
"Dato at objektet var siste kommet til",
#else
"Date Access",
"Date and time that the object was last read from or written to",
#endif
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_BROWSER_COLUMN_TYPE_DATE_ACCESS,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"Feche Modificado",
"La fecha que el objeto era ltimo modificado",
#elif defined(PROG_LANGUAGE_FRENCH)
"Dater Modifi",
"La date que l'objet tait dernier",
#elif defined(PROG_LANGUAGE_GERMAN)
"Datum Hat Modifiziert",
"Datum, da das objekt zuletzt modifiziert wurde",
#elif defined(PROG_LANGUAGE_ITALIAN)
"Datare Modificato",
"Data che l'oggetto era ultimo modificato",
#elif defined(PROG_LANGUAGE_DUTCH)
"Datum Wijzigde",
"Datum dat het voorwerp vorig gewijzigde was",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Date Modificado",
"Data que o objeto era ltimos modificados",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Dato Modifisert",
"Dato at objektet var siste modifisert",
#else
"Date Modified",
"Date and time that the object was last written to",
#endif
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_BROWSER_COLUMN_TYPE_DATE_MODIFIED,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"Feche Cambiado",
"Feche que el objeto era ltimo cambiado",
#elif defined(PROG_LANGUAGE_FRENCH)
"Dater Chang",
"Dater que l'objet tait dernier",
#elif defined(PROG_LANGUAGE_GERMAN)
"Datum Hat Gendert",
"Datum, da das objekt zuletzt gendert wurde",
#elif defined(PROG_LANGUAGE_ITALIAN)
"Datare Cambiato",
"Data che l'oggetto era ultimo cambiato",
#elif defined(PROG_LANGUAGE_DUTCH)
"Datum Veranderde",
"Datum dat het voorwerp vorig veranderde was",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Date Mudado",
"Date que o objeto era ltimo mudado",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Dato Forandret Seg",
"Dato at objektet var siste forandret",
#else
"Date Changed",
"Date and time that the object was last written to or its properties were modified",
#endif
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_BROWSER_COLUMN_TYPE_DATE_CHANGED,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
"Hard Links",
"Number of hard links to the object",
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_BROWSER_COLUMN_TYPE_HARD_LINKS,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"Ligado A",
"Ligue el destino",
#elif defined(PROG_LANGUAGE_FRENCH)
"Reli A",
"Relier la destination",
#elif defined(PROG_LANGUAGE_GERMAN)
"Verknpft Zu",
"Verknpfen sie reiseziel",
#elif defined(PROG_LANGUAGE_ITALIAN)
"Concatenato A",
"Concatenare la destinazione",
#elif defined(PROG_LANGUAGE_DUTCH)
"Verbindenene Te",
"Verbind bestemming",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Ligado A",
"Ligue destino",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Forbundet Til",
"Forbind destinasjon",
#else
"Linked To",
"Link destination",
#endif
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_BROWSER_COLUMN_TYPE_LINKED_TO,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
"Device",
"Device that the object exists on",
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_BROWSER_COLUMN_TYPE_DEVICE,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
"INode",
"Index location on the media that the object exists on",
 	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_BROWSER_COLUMN_TYPE_INODE,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
#if defined(PROG_LANGUAGE_SPANISH)
"De Tipo Dispositivo",
"El dispositivo el par mayor y secundario del nmero",
#elif defined(PROG_LANGUAGE_FRENCH)
"Type D'Appareil",
"Le commandant d'appareil et la paire de numro mineure",
#elif defined(PROG_LANGUAGE_GERMAN)
"Gertetyp",
"Gertemajor und minderjhriger zhlen paar",
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Tipo Di Congegno",
"Congegno maggiore e minore numero",
#elif defined(PROG_LANGUAGE_DUTCH)
"Apparaat Type",
"Apparaat majoor en minderjarige nummeren paar",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Tipo De Artifcio",
"O artifcio par menor importante de nmero",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Innretnings Type",
"Innretnings major og mindr erigantall par",
#else
"Device Type",
"Device major and minor number pair",
#endif
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_BROWSER_COLUMN_TYPE_DEVICE_TYPE,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
"Block Size",
"Optimul size for reading or writing a block of the object's data",
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_BROWSER_COLUMN_TYPE_BLOCK_SIZE,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);
	StackListAppend(
	    slist,
"Blocks",
"Number of blocks allocated to the object",
	    NULL,               /* No icon data */
	    NULL,               /* No client data */
	    EDV_BROWSER_COLUMN_TYPE_BLOCKS,
	    FALSE, FALSE        /* No multiple, no stay on target */
	);

	StackListUpdateMenus(slist);

}

/*
 *	Creates the File Browser Tool Bar page.
 */
void EDVCustomizeBrowserCreateToolBarPage(
	edv_core_struct *core, edv_gen_opt_win_struct *optwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5,
			border_minor = 2;
	gchar *name;
	GList *glist, *opid_list;
	GSList *gslist;
	GtkWidget *w, *parent2, *parent3;
	edv_gen_opt_wref_struct *wref;
	stack_list_struct *slist;
	edv_browser_opid_struct *opid;


	/* Hbox for Tool Bar Display and Relief frames */
	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent2 = w;


	/* Display Buttons As Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Despliegue Abrocha Como"
#elif defined(PROG_LANGUAGE_FRENCH)
"L'exposition Boutonne Comme"
#elif defined(PROG_LANGUAGE_GERMAN)
"Ausstellung Knpft Als Zu"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Mostra Abbottona Come"
#elif defined(PROG_LANGUAGE_DUTCH)
"Tentoonstelling Knoopt Als Dicht"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Exiba Botes Como"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Utstilling Knapper Som"
#else
"Display Buttons As"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_hbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	/* Text */
	gslist = NULL;
	w = gtk_radio_button_new_with_label(gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"El Texto"
#elif defined(PROG_LANGUAGE_FRENCH)
"Texte"
#elif defined(PROG_LANGUAGE_GERMAN)
"Text"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Testo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Tekst"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Texto"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Tekst"
#else
"Text"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_RADIO_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_BROWSER_TOOL_BAR_DISPLAY
	);
	wref->radio_value = TOOLBAR_DISPLAY_TEXT;
	gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

	/* Pictures */
	w = gtk_radio_button_new_with_label(gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"Los Retratos"
#elif defined(PROG_LANGUAGE_FRENCH)
"Images"
#elif defined(PROG_LANGUAGE_GERMAN)
"Bilder"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Le Immagini"
#elif defined(PROG_LANGUAGE_DUTCH)
"Afbeelding"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Os Quadros"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Bilder"
#else
"Pictures"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_RADIO_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_BROWSER_TOOL_BAR_DISPLAY
	);
	wref->radio_value = TOOLBAR_DISPLAY_PICTURES;
	gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

	/* Pictures & Text */
	w = gtk_radio_button_new_with_label(gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"Los Retratos & Texto"
#elif defined(PROG_LANGUAGE_FRENCH)
"Les Images & Le Texte"
#elif defined(PROG_LANGUAGE_GERMAN)
"Bilder & Text"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Le Immagini & Il Testo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Afbeelding & Tekst"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Os Quadros & Texto"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Bilder & Tekst"
#else
"Pictures & Text"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_RADIO_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_BROWSER_TOOL_BAR_DISPLAY
	);
	wref->radio_value = TOOLBAR_DISPLAY_PICTURES_AND_TEXT;


	/* Buttons Relief Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Alivio De Botones"
#elif defined(PROG_LANGUAGE_FRENCH)
"Soulagement De Boutons"
#elif defined(PROG_LANGUAGE_GERMAN)
"Knpfe Erleichterung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Sollievo Di Bottoni"
#elif defined(PROG_LANGUAGE_DUTCH)
"Knopen Steun"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Alvio De Botes"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Knapp Lettelse"
#else
"Buttons Relief"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_hbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	/* Flush */
	gslist = NULL;
	w = gtk_radio_button_new_with_label(gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"El Rubor"
#elif defined(PROG_LANGUAGE_FRENCH)
"Eclat"
#elif defined(PROG_LANGUAGE_GERMAN)
"Splen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Flusso"
#elif defined(PROG_LANGUAGE_DUTCH)
"Vloed"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Nivele"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Spyl"
#else
"Flush"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_RADIO_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_BROWSER_TOOL_BAR_RELIEF
	);
	wref->radio_value = TOOLBAR_RELIEF_NONE;
	gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

	/* Half */
	w = gtk_radio_button_new_with_label(gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"La Mitad"
#elif defined(PROG_LANGUAGE_FRENCH)
"Moiti"
#elif defined(PROG_LANGUAGE_GERMAN)
"Hlfte"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Met"
#elif defined(PROG_LANGUAGE_DUTCH)
"Helft"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Metade"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Halvdel"
#else
"Half"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_RADIO_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_BROWSER_TOOL_BAR_RELIEF
	);
	wref->radio_value = TOOLBAR_RELIEF_HALF;
	gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

	/* Raised */
	w = gtk_radio_button_new_with_label(gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"Levantado"
#elif defined(PROG_LANGUAGE_FRENCH)
"Hauss"
#elif defined(PROG_LANGUAGE_GERMAN)
"Erhoben"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Aumentato"
#elif defined(PROG_LANGUAGE_DUTCH)
"Opgetilde"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Levantado"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Hevet"
#else
"Raised"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_RADIO_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_BROWSER_TOOL_BAR_RELIEF
	);
	wref->radio_value = TOOLBAR_RELIEF_NORMAL;



	/* Arrangement Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Arreglo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Arrangement"
#elif defined(PROG_LANGUAGE_GERMAN)
"Anordnung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Disposizione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Schikking"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Arranjo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Arrangement"
#else
"Arrangement"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* Create Tool Bar Stack List */
	slist = StackListNew(
	    parent2,
#if defined(PROG_LANGUAGE_SPANISH)
"Disponible", "La Corriente"
#elif defined(PROG_LANGUAGE_FRENCH)
"Disponible", "Courant"
#elif defined(PROG_LANGUAGE_GERMAN)
"Verfgbar", "Strmung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Disponibile", "La Corrente"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verkrijgbaar", "Stroom"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Disponvel", "A Corrente"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Tilgjengelig", "Strm"
#else
"Available", "Current"
#endif
	);
	StackListShowDescription(slist, TRUE, TRUE);
	StackListSetMaintainSourceOrder(slist, TRUE);
	StackListMap(slist);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_STACK_LIST, slist,
	    NULL,
	    EDV_CFG_PARM_BROWSER_TOOL_BAR
	);

	/* Create tool bar items from browser operation ids */
	opid_list = EDVBrowserOPIDListNew(NULL);
	for(glist = opid_list;
	    glist != NULL;
	    glist = g_list_next(glist)
	)
	{
	    opid = EDV_BROWSER_OPID(glist->data);
	    if(opid == NULL)
		continue;

	    name = EDVCustomizeSimplifyOPIDName(opid->menu_name);
	    StackListAppend(
		slist, name, opid->tooltip,
		opid->button_icon_data,
		NULL,				/* Client Data */
		(gint)opid->op,			/* ID */
		opid->flags & EDV_OPID_ALLOW_MULTIPLE,	/* Allow Multiples? */
		FALSE				/* Fixed On Target? */
	    );
	    g_free(name);
	}
	EDVBrowserOPIDListDelete(opid_list);

	StackListUpdateMenus(slist);

}

/*
 *	Creates the File Browser Appearance page.
 */
void EDVCustomizeBrowserCreateAppearancePage(
	edv_core_struct *core, edv_gen_opt_win_struct *optwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5,
			border_minor = 2;
	GtkWidget *w, *parent2, *parent3, *parent4;
	edv_gen_opt_wref_struct *wref;


	/* Hbox to separate two columns */
	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent = w;


	/* First column vbox */
	w = gtk_vbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	parent2 = w;

	/* Show In Title Bar Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Muestre En La Barra Del Ttulo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Montrer Dans La Barre De Titre"
#elif defined(PROG_LANGUAGE_GERMAN)
"Zeigen Sie In Titel Stab"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Mostrare Nella Sbarra Di Titolo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Toon In Titel Staaf"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Mostre Em Barra De Ttulo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Vis In Title Bar"
#else
"Show In Title Bar"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	/* Show User Name */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"El Nombre Del Usuario"
#elif defined(PROG_LANGUAGE_FRENCH)
"Nom D'Utilisateur"
#elif defined(PROG_LANGUAGE_GERMAN)
"Verbraucher Name"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Nome Di Operatore"
#elif defined(PROG_LANGUAGE_DUTCH)
"Gebruiker Naam"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Nome De Operador"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Bruker Name"
#else
"User Name"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_TOGGLE_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_BROWSER_TITLE_WITH_USER
	);

	/* Show Location */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"La Ubicacin"
#elif defined(PROG_LANGUAGE_FRENCH)
"Emplacement"
#elif defined(PROG_LANGUAGE_GERMAN)
"Ort"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Posizione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Plaats"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Localidade"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Plassering"
#else
"Location"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_TOGGLE_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_BROWSER_TITLE_WITH_LOCATION
	);


	/* Display Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Despliegue"
#elif defined(PROG_LANGUAGE_FRENCH)
"Exposition"
#elif defined(PROG_LANGUAGE_GERMAN)
"Ausstellung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Mostra"
#elif defined(PROG_LANGUAGE_DUTCH)
"Tentoonstelling"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Exposio"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Utstilling"
#else
"Display"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	/* Show Tool Bar */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Barra De Instrumento"
#elif defined(PROG_LANGUAGE_FRENCH)
"Barre D'Outil"
#elif defined(PROG_LANGUAGE_GERMAN)
"Werkzeug Stab"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Sbarra Di attrezzo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Werktuig Staaf"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Barra De Ferramenta"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Redskap Bar"
#else
"Tool Bar"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_TOGGLE_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_BROWSER_SHOW_TOOL_BAR
	);

	/* Show Location Bar */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Barra De Ubicacin"
#elif defined(PROG_LANGUAGE_FRENCH)
"Barre D'Emplacement"
#elif defined(PROG_LANGUAGE_GERMAN)
"Ort Stab"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Sbarra Di Posizione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Plaats Staaf"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Barra De Localidade"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Plassering Bar"
#else
"Location Bar"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_TOGGLE_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_BROWSER_SHOW_LOCATION_BAR
	);

	/* Show Mount Bar */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Barra El Monte"
#elif defined(PROG_LANGUAGE_FRENCH)
"Barre Mont"
#elif defined(PROG_LANGUAGE_GERMAN)
"Stab Untersatz"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Sbarra Il Monte"
#elif defined(PROG_LANGUAGE_DUTCH)
"Staaf Berg"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Barra O Monte"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Bar Fotstykke"
#else
"Mount Bar"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_TOGGLE_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_BROWSER_SHOW_MOUNT_BAR
	);

	/* Show Find Bar */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Barra La Encuentre"
#elif defined(PROG_LANGUAGE_FRENCH)
"Barre La Trouver"
#elif defined(PROG_LANGUAGE_GERMAN)
"Stab Sie Finden"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Sbarra Trova"
#elif defined(PROG_LANGUAGE_DUTCH)
"Sluit Vondst Uit"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Barra Acha"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sperr Find"
#else
"Find Bar"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_TOGGLE_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_BROWSER_SHOW_FIND_BAR
	);

	/* Show Status Bar */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Barra La Posicin"
#elif defined(PROG_LANGUAGE_FRENCH)
"Barre La Statut"
#elif defined(PROG_LANGUAGE_GERMAN)
"Stab Sie Status"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Sbarra Lo Stato"
#elif defined(PROG_LANGUAGE_DUTCH)
"Sluit Status"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Barra Estado"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sperr Status"
#else
"Status Bar"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_TOGGLE_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_BROWSER_SHOW_STATUS_BAR
	);


	/* Second column vbox */
	w = gtk_vbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	parent2 = w;


	/* Filter Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Filtro"
#elif defined(PROG_LANGUAGE_FRENCH)
"Filtre"
#elif defined(PROG_LANGUAGE_GERMAN)
"Filter"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Filtro"
#elif defined(PROG_LANGUAGE_DUTCH)
"Filter"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Filtro"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Filter"
#else
"Show"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	/* Show Hidden Objects */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Los Objetos Escondidos"
#elif defined(PROG_LANGUAGE_FRENCH)
"Objets Cachs"
#elif defined(PROG_LANGUAGE_GERMAN)
"Versteckte Objekte"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Gli Oggetti Nascosti"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verbergenene Voorwerpen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Objetos Escondidos"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Gjemte Objekt"
#else
"Hidden Objects"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_TOGGLE_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_BROWSER_SHOW_OBJECT_HIDDEN
	);

	/* Show No Access Objects */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Ningn Acceso Se Opone"
#elif defined(PROG_LANGUAGE_FRENCH)
"Aucuns Objets D'accs"
#elif defined(PROG_LANGUAGE_GERMAN)
"Keine Zugriffsobjekte"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Nessuno Accesso Obbietta"
#elif defined(PROG_LANGUAGE_DUTCH)
"Geen Toegang Heeft Bezwaar"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Nenhum Acesso Ope-se"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Ingen Tilgang Protesterer"
#else
"No Access Objects"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_TOGGLE_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_BROWSER_SHOW_OBJECT_NOACCESS
	);

}
