/*
			      Properties Dialog
 */

#ifndef PROPDLG_H
#define PROPDLG_H

#include <gtk/gtk.h>
#include "piechart.h"
#include "edvtypes.h"
#include "edvobj.h"


typedef struct _edv_propdlg_struct      edv_propdlg_struct;


/*
 *	Properties Dialog:
 */
struct _edv_propdlg_struct {

	GtkWidget       *toplevel;
	GtkAccelGroup   *accelgrp;
	gboolean        processing;
	gint            busy_count,
			freeze_count;
	gpointer        core_ptr;

	GtkWidget	*main_vbox,
			*notebook;

	GtkWidget	*ok_btn,
			*apply_btn,
			*cancel_btn,
			*close_btn;

	/* Widgets on General Page */
	GtkWidget	*gen_icon_pm,
			*gen_name_label,
			*gen_location_label,
			*gen_size_label,
			*gen_timestamps_frame,
			*gen_date_access_label,
			*gen_date_modify_label,
			*gen_date_change_label,
			*gen_date_touch_btn,
			*gen_ownership_frame,
			*gen_owner_entry,
			*gen_owner_btn,
			*gen_group_entry,
			*gen_group_btn,
			*gen_permissions_frame,
			*gen_uread_check,
			*gen_uwrite_check,
			*gen_uexecute_check,
			*gen_gread_check,
			*gen_gwrite_check,
			*gen_gexecute_check,
			*gen_aread_check,
			*gen_awrite_check,
			*gen_aexecute_check,
			*gen_setuid_check,
			*gen_setgid_check,
			*gen_sticky_check;

	/* Widgets on Details Page */
	GtkWidget 	*det_vbox,		/* Details main vbox */
			*det_verbose_radio,
			*det_raw_radio,
			*det_table,		/* Table for labels */
			*det_device_label,
			*det_inode_label,
			*det_type_label,
			*det_permissions_label,
			*det_hard_links_label,
			*det_uid_label,
			*det_gid_label,
			*det_device_type_label,
			*det_size_label,
			*det_io_block_size_label,
			*det_blocks_label,
			*det_date_access_label,
			*det_date_modify_label,
			*det_date_change_label;

	/* Widgets on Link Page */
	GtkWidget	*link_connected_icon,
			*link_broken_icon,
			*link_dest_entry,
			*link_dest_properties_btn;

	/* Widgets on Device Page (mount paths, not device nodes) */
	gint		dev_num;
	GtkWidget	*dev_icon_pm,
			*dev_device_path_label,
			*dev_mount_path_label,
			*dev_fs_type_label,
			*dev_usage_frame,
			*dev_usage_vbox;
	pie_chart_struct	*dev_usage_pc;
	GtkWidget       *dev_mount_btn,
			*dev_eject_btn,
			*dev_check_btn,
			*dev_tools_btn,
			*dev_format_btn;

	/* Widgets on Device Node Page */
	GtkWidget	*dev_node_major_entry,	/* Major number */
			*dev_node_minor_entry;	/* Minor number */


	gint		type;		/* Object type, one of
					 * EDV_OBJECT_TYPE_*
					 */
	gchar		*path;		/* Absolute path to object */
	gchar		*title;		/* Title */
	gboolean	has_changes;	/* Has changes */

};
#define EDV_PROPDLG(p)	((edv_propdlg_struct *)(p))


/* Callbacks */
extern void EDVPropDlgObjectAddedNotifyCB(
        edv_propdlg_struct *pd, const gchar *path,
        const struct stat *lstat_buf
);
extern void EDVPropDlgObjectModifiedNotifyCB(
	edv_propdlg_struct *pd,
	const gchar *path, const gchar *new_path,
	const struct stat *lstat_buf
);
extern void EDVPropDlgObjectRemovedNotifyCB(
	edv_propdlg_struct *pd, const gchar *path
);
extern void EDVPropDlgMountNotifyCB(
        edv_propdlg_struct *pd, 
        gint dev_num, edv_device_struct *dev,
        gboolean is_mounted
);
extern void EDVPropDlgWriteProtectChangedCB(
	edv_propdlg_struct *pd, gboolean state
);
extern void EDVPropDlgReconfiguredNotifyCB(edv_propdlg_struct *pd);

/* Front Ends */
extern edv_propdlg_struct *EDVPropDlgNew(
	gpointer core_ptr, edv_object_struct *obj
);
extern void EDVPropDlgResetHasChanges(
	edv_propdlg_struct *pd, gboolean has_changes
);
extern void EDVPropDlgUpdateMenus(edv_propdlg_struct *pd);
extern void EDVPropDlgSetBusy(edv_propdlg_struct *pd, gboolean is_busy);
extern gboolean EDVPropDlgIsMapped(edv_propdlg_struct *pd);
extern void EDVPropDlgMap(edv_propdlg_struct *pd);
extern void EDVPropDlgUnmap(edv_propdlg_struct *pd);
extern void EDVPropDlgDelete(edv_propdlg_struct *pd);


#endif	/* PROPDLG_H */
