/*
 *	Opens an object using the Endeavour program.  The object's type
 *	must be found in Endeavour's MIME Types list and the Endeavour
 *	program itself must be running or else nothing will happen.
 */

#include <glib.h>
#include <endeavour2.h>

int main(int argc, char *argv[])
{
	edv_context_struct *ctx = EDVContextNew();
	EDVContextLoadConfigurationFile(ctx, NULL);

	if(argc > 1)
	{
	    /* Instruct Endeavour to open the object by matching the
	     * object's type with Endeavour's MIME Types list
	     *
	     * The Endeavour program must be currently running or else
	     * this call will have no affect.
	     */
	    GList *glist = NULL;
	    glist = g_list_append(glist, g_strdup(argv[1]));
	    EDVOpen(ctx, glist, NULL);
	    g_list_foreach(glist, (GFunc)g_free, NULL);
	    g_list_free(glist);
	}
	else
	{
	    g_print(
"Usage: %s <path>\n",
		argv[0]
	    );
	}

	EDVContextSync(ctx);
	EDVContextDelete(ctx);

	return(0);
}
