/*
		    Endeavour Image Browser Callbacks
 */

#ifndef IMBRCB_H
#define IMBRCB_H

#include <sys/stat.h>
#include <gtk/gtk.h>
#include "edvdevices.h"
#include "edvmimetypes.h"
#include "imbr.h"


extern void EDVImbrTListItemDestroyCB(gpointer data);

extern gint EDVImbrDeleteEventCB(
	GtkWidget *widget, GdkEvent *event, gpointer data
);
extern gint EDVImbrKeyEventCB(
	 GtkWidget *widget, GdkEventKey *key, gpointer data
);
extern gint EDVImbrButtonPressEventCB(
	GtkWidget *widget, GdkEventButton *button, gpointer data
);

extern void EDVImbrHandleChildAttachedCB(
	GtkHandleBox *handle_box, GtkWidget *child, gpointer data
);
extern void EDVImbrHandleChildDetachedCB(
	GtkHandleBox *handle_box, GtkWidget *child, gpointer data
);

extern void EDVImbrTListSelectCB(
	tlist_struct *tlist, GdkEventButton *button, gint thumb_num,
	gpointer data
);
extern void EDVImbrTListUnselectCB(
	tlist_struct *tlist, GdkEventButton *button, gint thumb_num,
	gpointer data
);

extern void EDVImbrComboActivateCB(GtkWidget *widget, gpointer data);

extern gint EDVImbrLoadingTOCB(gpointer data);

extern void EDVImbrWriteProtectChangedCB(
	edv_imbr_struct *imbr, gboolean state
);
extern void EDVImbrObjectAddedNotifyCB(
	edv_imbr_struct *imbr, const gchar *path,
	const struct stat *lstat_buf
);
extern void EDVImbrObjectModifiedNotifyCB(
	edv_imbr_struct *imbr, const gchar *path,
	const gchar *new_path,
	const struct stat *lstat_buf
);
extern void EDVImbrObjectRemovedNotifyCB(
	edv_imbr_struct *imbr, const gchar *path
);

extern void EDVImbrMountNotifyCB(
	edv_imbr_struct *imbr,
	gint dev_num, edv_device_struct *dev,
	gboolean is_mounted
);

extern void EDVImbrRecycledObjectAddedNotifyCB(
	edv_imbr_struct *imbr, guint index
);
extern void EDVImbrRecycledObjectRemovedNotifyCB(
	edv_imbr_struct *imbr, guint index
);

extern void EDVImbrReconfiguredNotifyCB(edv_imbr_struct *imbr);

extern void EDVImbrMimeTypeAddedCB(
	edv_imbr_struct *imbr,
	gint mt_num, edv_mimetype_struct *mt
);
extern void EDVImbrMimeTypeModifiedCB(
	edv_imbr_struct *imbr,
	gint mt_num, edv_mimetype_struct *mt
);
extern void EDVImbrMimeTypeRemovedCB(
	edv_imbr_struct *imbr, gint mt_num
);

extern void EDVImbrDeviceAddedCB(
	edv_imbr_struct *imbr,
	gint dev_num, edv_device_struct *dev
);
extern void EDVImbrDeviceModifiedCB(
	edv_imbr_struct *imbr,
	gint dev_num, edv_device_struct *dev
);
extern void EDVImbrDeviceRemovedCB(
	edv_imbr_struct *imbr, gint dev_num
);


#endif	/* IMBRCB_H */
