/*
		   Endeavour User/Group ID Management
 */

#ifndef EDVID_H
#define EDVID_H

#include <glib.h>

/*
 *	User ID:
 */
typedef struct {

	gchar		*name;
	gchar		*password;	/* Crypted */

	gint		user_id,
			group_id;

	gchar		*government_name;	/* "Government/legal/provisional/real" name */
	gchar		*home_directory;
	gchar		*shell_program;

} edv_uid_struct;
#define EDV_UID(p)	((edv_uid_struct *)(p))

/*
 *	Group ID:
 */
typedef struct {

	gchar		*name;
	gchar		*password;        /* Crypted */

	gint		group_id;

	gchar		**group_member;
	gint		total_group_members;

} edv_gid_struct;
#define EDV_GID(p)	((edv_gid_struct *)(p))


/* User ID functions */
extern edv_uid_struct *EDVUIDNew(void);
extern void EDVUIDDelete(edv_uid_struct *uid);

extern edv_uid_struct **EDVUIDGetSystem(gint *total);

extern edv_uid_struct *EDVUIDMatchByUID(
	edv_uid_struct **list, gint total,
	gint user_id, gint *n
);
extern edv_uid_struct *EDVUIDMatchByGID(
	edv_uid_struct **list, gint total,
	gint group_id, gint *n
);
extern gint EDVUIDNameToUID(
	edv_uid_struct **list, gint total, const gchar *user_name
);
extern gchar *EDVUIDGetNameFromUID(
	edv_uid_struct **list, gint total,
	gint user_id, gint *n
);
extern gchar *EDVUIDGetNameFromGID(
	edv_uid_struct **list, gint total,
	gint group_id, gint *n
);


/* Group ID functions */
extern edv_gid_struct *EDVGIDNew(void);
extern void EDVGIDDelete(edv_gid_struct *gid);

extern edv_gid_struct **EDVGIDGetSystem(gint *total);

extern edv_gid_struct *EDVGIDMatchByGID(
	edv_gid_struct **list, gint total,
	gint group_id, gint *n
);
extern gint EDVGIDNameToGID(
	edv_gid_struct **list, gint total, const gchar *group_name
);
extern gchar *EDVGIDGetNameFromGID(
	edv_gid_struct **list, gint total,
	gint group_id, gint *n
);


#endif	/* EDVID_H */
