/*
		       Endeavour Recycle Bin
 */

#ifndef RECBIN_H
#define RECBIN_H

#include <gtk/gtk.h>
#include "edvtypes.h"
#include "edvstatusbar.h"
#include "toolbar.h"
#include "findbar.h"


/*
 *	Recycle Bin Contents List Column Types:
 */
typedef enum {

	EDV_RECBIN_COLUMN_TYPE_NAME			= 0,
	EDV_RECBIN_COLUMN_TYPE_SIZE			= 1,
	EDV_RECBIN_COLUMN_TYPE_TYPE			= 2,
	EDV_RECBIN_COLUMN_TYPE_PERMISSIONS		= 3,
	EDV_RECBIN_COLUMN_TYPE_OWNER			= 4,
	EDV_RECBIN_COLUMN_TYPE_GROUP			= 5,
	EDV_RECBIN_COLUMN_TYPE_DATE_ACCESS		= 6,
	EDV_RECBIN_COLUMN_TYPE_DATE_MODIFIED		= 7,
	EDV_RECBIN_COLUMN_TYPE_DATE_CHANGED		= 8,
	EDV_RECBIN_COLUMN_TYPE_DATE_DELETED		= 9,
	EDV_RECBIN_COLUMN_TYPE_LINKED_TO		= 10,
	EDV_RECBIN_COLUMN_TYPE_ORIGINAL_LOCATION	= 11,
	EDV_RECBIN_COLUMN_TYPE_INDEX			= 12

} edv_recbin_column_type;
/* Total number of column types */
#define EDV_RECBIN_CONTENTS_CLIST_COLUMNS_MAX		13


/*
 *	Recycle Bin Operations:
 */
typedef enum {

	EDV_RECBIN_OP_NONE			= 0,
	EDV_RECBIN_OP_SEPARATOR			= 10,

	EDV_RECBIN_OP_CLOSE			= 20,
	EDV_RECBIN_OP_EXIT			= 21,

	EDV_RECBIN_OP_SYNC_DISKS		= 30,
	EDV_RECBIN_OP_RUN			= 31,
	EDV_RECBIN_OP_RUN_TERMINAL		= 32,
	EDV_RECBIN_OP_WRITE_PROTECT		= 35,

	EDV_RECBIN_OP_SYNC_RECYCLE_BIN		= 40,

	EDV_RECBIN_OP_RECOVER			= 60,
	EDV_RECBIN_OP_PURGE			= 61,
	EDV_RECBIN_OP_PURGE_ALL			= 62,
	EDV_RECBIN_OP_SELECT_ALL		= 70,
	EDV_RECBIN_OP_UNSELECT_ALL		= 71,
	EDV_RECBIN_OP_INVERT_SELECTION		= 72,
	EDV_RECBIN_OP_FIND			= 73,

	EDV_RECBIN_OP_HISTORY			= 77,

	EDV_RECBIN_OP_REFRESH			= 80,
	EDV_RECBIN_OP_REFRESH_ALL		= 81,
	EDV_RECBIN_OP_SHOW_TOOL_BAR		= 90,
	EDV_RECBIN_OP_SHOW_FIND_BAR		= 91,
	EDV_RECBIN_OP_SHOW_STATUS_BAR		= 92,

	EDV_RECBIN_OP_MIME_TYPES		= 100,

	EDV_RECBIN_OP_NEW_BROWSER		= 110,
	EDV_RECBIN_OP_NEW_IMBR			= 111,
	EDV_RECBIN_OP_NEW_ARCHIVER		= 112,

	EDV_RECBIN_OP_OPTIONS			= 150,
	EDV_RECBIN_OP_CUSTOMIZE			= 151,

	EDV_RECBIN_OP_HELP_ABOUT		= 1000,
	EDV_RECBIN_OP_HELP_CONTENTS		= 1001,
	EDV_RECBIN_OP_HELP_FILE_BROWSER		= 1002,
	EDV_RECBIN_OP_HELP_IMAGE_BROWSER	= 1003,
	EDV_RECBIN_OP_HELP_ARCHIVER		= 1004,
	EDV_RECBIN_OP_HELP_RECYCLE_BIN		= 1005,
	EDV_RECBIN_OP_HELP_KEYS_LIST		= 1006,
	EDV_RECBIN_OP_HELP_COMMON_OPERATIONS	= 1007

} edv_recbin_op;


/*
 *	Recycle Bin Operation ID:
 */
typedef struct {

	gpointer	recbin;
	edv_recbin_op	op;
	gboolean	allow_multiple;		/* Allow multiple instances
						 * of this operation in
						 * lists */
	toolbar_item_type tb_item_type;		/* Type of item when placed
						 * on the tool bar */

	/* Operation callback */
	void	(*func_cb)(
		toolbar_item_struct *,	/* Tool Bar Item */
		gint,			/* ID */
		gpointer		/* OPID */
	);

	/* Enter and leave notify callbacks */
	void	(*enter_func_cb)(
		toolbar_item_struct *,	/* Tool Bar Item */
		gint,			/* ID */
		gpointer		/* OPID */
	);
	void	(*leave_func_cb)(
		toolbar_item_struct *,	/* Tool Bar Item */
		gint,			/* ID */
		gpointer		/* OPID */
	);

	gchar		*button_name;	/* Name as it would appear on a button */
	gchar		*menu_name;	/* Name as it would appear on a menu item */
	gchar		*tooltip;	/* Tool tip or description (one line) */

	guint		accel_key,	/* Accelerator key */
			accel_mods;	/* Accelerator key modifiers */

	guint8		**button_icon_data,	/* Shared */
			**menu_icon_data;	/* Shared */

} edv_recbin_opid_struct;
#define EDV_RECBIN_OPID(p)	((edv_recbin_opid_struct *)(p))

/*
 *	Recycle Bin:
 */
typedef struct {

	GtkWidget	*toplevel;
	GtkAccelGroup	*accelgrp;
	gboolean	processing;
	gint		busy_count,
			freeze_count;
	gpointer	core_ptr;

	edv_recbin_opid_struct	**opid;
	gint			total_opids;

	gboolean	tool_bar_map_state,
			find_bar_map_state,
			status_bar_map_state;

	GtkWidget	*main_vbox,
			*menu_bar,
			*bars_vbox,		/* Toolbars GtkVBox */

			*menu_bar_handle,
			*tool_bar_handle,
			*find_bar_handle,

			*contents_clist;	/* Contents GtkCList */

	/* General tool bar */
	toolbar_struct	*toolbar;

	/* Find bar */
	edv_findbar_struct	*findbar;

	/* Important menu items */
	GtkWidget	*recover_mi,
			*purge_mi,
			*purge_all_mi,
			*sync_recycle_bin_mi,
			*sync_disks_mi,
			*history_mi,
			*run_mi,
			*close_mi,

			*edit_recover_mi,
			*edit_purge_mi,
			*edit_purge_all_mi,
			*select_all_mi,
			*unselect_all_mi,
			*invert_selection_mi,
			*find_mi,

			*refresh_mi,
			*refresh_all_mi,
			*show_tool_bar_micheck,
			*show_find_bar_micheck,
			*show_status_bar_micheck,
			*mime_types_mi,

			*write_protect_mi,
			*options_mi,
			*customize_mi,

			*window_new_browser_mi,
			*window_new_imbr_mi,
			*window_new_archiver_mi,

			*help_contents_mi,
			*help_recycle_bin_mi,
			*help_keys_list_mi,
			*help_common_operations_mi,
			*help_about_mi;

	/* Contents clist right-click menu */
	GtkWidget       *contents_clist_menu,
			*contents_clist_recover_mi,
			*contents_clist_purge_mi,
			*contents_clist_purge_all_mi;

	/* Last selected row on the clist (can be -1 for none)
	 *
	 * Note that this does not reflect other selected rows since
	 * multiple selections are allowed
	 */
	gint		contents_clist_selected_row;


	/* Last known items in recycle bin, this is used as a quick access
	 * value to check if the recycle bin has contents or not
	 *
	 * Can be -1 to indicate undefined
	 */
	gint		last_recbin_items;

	/* Last known write protect state (can be -1 to indicate
	 * undefined)
	 */
	gint		last_write_protect_state;




	/* Status bar */
	edv_status_bar_struct	*status_bar;

} edv_recbin_struct;
#define EDV_RECBIN(p)	((edv_recbin_struct *)(p))


extern void EDVRecBinSetTitle(edv_recbin_struct *recbin);

extern void EDVRecBinToolbarRegenerate(edv_recbin_struct *recbin);
extern void EDVRecBinContentsMenuRegenerate(edv_recbin_struct *recbin);

extern void EDVRecBinSyncConfiguration(edv_recbin_struct *recbin);

extern edv_recbin_opid_struct **EDVRecBinOPIDListNew(
	edv_recbin_struct *recbin,	/* Can be NULL */
	gint *total
);
extern void EDVRecBinOPIDListDelete(
	edv_recbin_opid_struct **list, gint total
);

extern edv_recbin_struct *EDVRecBinNew(gpointer core_ptr);
extern void EDVRecBinSyncData(edv_recbin_struct *recbin);
extern void EDVRecBinUpdateMenus(edv_recbin_struct *recbin);
extern void EDVRecBinUpdateContentsHeadings(
	edv_recbin_struct *recbin,
	const gint *contents_heading, gint total_contents_headings
);
extern void EDVRecBinSetBusy(edv_recbin_struct *recbin, gboolean is_busy);
extern gboolean EDVRecBinIsMapped(edv_recbin_struct *recbin);
extern void EDVRecBinMap(edv_recbin_struct *recbin);
extern void EDVRecBinUnmap(edv_recbin_struct *recbin);
extern void EDVRecBinDelete(edv_recbin_struct *recbin);


#endif	/* RECBIN_H */
