/*
                           Endeavour Confirmation Querying

	Uses the confirmation dialog to query the user to get responses
	for preset types of confirmations.

 */

#ifndef EDVCONFIRM_H
#define EDVCONFIRM_H

#include <gtk/gtk.h>

#include "url.h"
#include "edvtypes.h"
#include "edvobj.h"
#include "endeavour.h"


extern gint EDVConfirmLink(
	edv_core_struct *core_ptr, GtkWidget *toplevel,
	const gchar *src_path, gint total_objects,
	const gchar *tar_path
);
extern gint EDVConfirmMove(
	edv_core_struct *core_ptr, GtkWidget *toplevel,
	const gchar *src_path, gint total_objects,
	const gchar *tar_path
);
extern gint EDVConfirmCopy(
	edv_core_struct *core_ptr, GtkWidget *toplevel,
	const gchar *src_path, gint total_objects,
	const gchar *tar_path
);
extern gint EDVConfirmDelete(
	edv_core_struct *core_ptr, GtkWidget *toplevel,
	const gchar *src_path, gint total_objects
);

extern gint EDVConfirmArchiveAdd(
	edv_core_struct *core_ptr, GtkWidget *toplevel,
	const gchar *src_path, gint total_objects,
	const gchar *arch_path
);
extern gint EDVConfirmArchiveExtract(
	edv_core_struct *core_ptr, GtkWidget *toplevel,
	const gchar *src_path, gint total_objects,
	const gchar *tar_path
);
extern gint EDVConfirmArchiveDelete(
	edv_core_struct *core_ptr, GtkWidget *toplevel,
	const gchar *src_path, gint total_objects
);

extern gint EDVConfirmRecover(
	edv_core_struct *core_ptr, GtkWidget *toplevel,
	const gchar *src_path,		/* String containing index number. */
	gint total_objects,
	const gchar *tar_path
);
extern gint EDVConfirmPurge(
	edv_core_struct *core_ptr, GtkWidget *toplevel,
	const gchar *src_path,		/* String containing index number. */
	gint total_objects
);

extern gint EDVConfirmDND(
	edv_core_struct *core_ptr,
	gint gdk_action, guint info,
	GtkWidget *toplevel,
	GList *url_list,
	const gchar *tar_path
);




#endif	/* EDVCONFIRM_H */
