#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <glib.h>

#include "../include/string.h"
#include "../include/disk.h"

#include "edvtypes.h"
#include "edvarchobj.h"
#include "edvutils.h"


edv_archive_object_struct *EDVArchObjectNew(void);
edv_archive_object_struct *EDVArchObjectCopy(
	const edv_archive_object_struct *obj
);
void EDVArchObjectSetPath(
	edv_archive_object_struct *obj, const gchar *path
);
void EDVArchObjectSetPath2(
	edv_archive_object_struct *obj,
	const gchar *parent, const gchar *name
);
void EDVArchObjectDelete(edv_archive_object_struct *obj);


#define ATOI(s)         (((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)         (((s) != NULL) ? atol(s) : 0)
#define ATOF(s)         (((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)       (((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)        (((a) > (b)) ? (a) : (b))
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)     (MIN(MAX((a),(l)),(h)))
#define STRLEN(s)       (((s) != NULL) ? strlen(s) : 0)
#define STRISEMPTY(s)   (((s) != NULL) ? (*(s) == '\0') : TRUE)


/*
 *	Create a new Archive Object.
 */
edv_archive_object_struct *EDVArchObjectNew(void)
{
	edv_archive_object_struct *obj = EDV_ARCHIVE_OBJECT(
	    g_malloc0(sizeof(edv_archive_object_struct))
	);
	obj->type = EDV_OBJECT_TYPE_FILE;
	obj->name = NULL;
	obj->full_path = NULL;
	obj->linked_to = NULL;
	obj->permissions = 0x00000000;
	obj->access_time = 0l;
	obj->modify_time = 0l;
	obj->change_time = 0l;
	obj->owner_name = NULL;
	obj->group_name = NULL;
	obj->size = 0l;
	obj->compressed_size = 0l;
	obj->device_type = 0;
	obj->encrypted = FALSE;
	obj->compression_ratio = 0.0f;
	obj->method = NULL;
	obj->crc = NULL;

	return(obj);
}


/*
 *	Coppies the Archive Object.
 */
edv_archive_object_struct *EDVArchObjectCopy(
	const edv_archive_object_struct *obj
)
{
	edv_archive_object_struct *tar;
	const edv_archive_object_struct *src = obj;

	if(src == NULL)
	    return(NULL);

	/* Create new object to be the copy */
	tar = EDVArchObjectNew();

	/* Begin copying values */
	tar->type = src->type;

	tar->name = STRDUP(src->name);
	tar->full_path = STRDUP(src->full_path);
	tar->linked_to = STRDUP(src->linked_to);

	tar->permissions = src->permissions;
	tar->access_time = src->access_time;
	tar->modify_time = src->modify_time;
	tar->change_time = src->change_time;

	tar->owner_name = STRDUP(src->owner_name);
	tar->group_name = STRDUP(src->group_name);

	tar->size = src->size;
	tar->compressed_size = src->compressed_size;

	tar->device_type = src->device_type;

	tar->encrypted = src->encrypted;
	tar->compression_ratio = src->compression_ratio;
	tar->method = STRDUP(src->method);
	tar->crc = STRDUP(src->crc);

	return(tar);
}

/*
 *	Deletes the Archive Object.
 */
void EDVArchObjectDelete(edv_archive_object_struct *obj)
{
	if(obj == NULL)
	    return;

	g_free(obj->name);
	g_free(obj->full_path);

	g_free(obj->linked_to);

	g_free(obj->owner_name);
	g_free(obj->group_name);

	g_free(obj->method);
	g_free(obj->crc);

	g_free(obj);
}
