/*
		 Endeavour Browser Directory CTree Handling
 */

#ifndef BROWSERDIRTREE_H
#define BROWSERDIRTREE_H

#include <sys/stat.h>
#include <gtk/gtk.h>

#include "edvtypes.h"
#include "edvobj.h"
#include "edvdevices.h"
#include "browser.h"


extern GtkCTreeNode *EDVBrowserDirTreeGetToplevel(edv_browser_struct *browser);

extern GtkCTreeNode *EDVBrowserDirTreeInsertNode(
	edv_browser_struct *browser,
	GtkCTreeNode *parent, GtkCTreeNode *sibling,
	edv_object_struct *obj
);

extern void EDVBrowserDirTreeCreateToplevels(edv_browser_struct *browser);

extern void EDVBrowserDirTreeSetOriginPath(
	edv_browser_struct *browser, const gchar *path
);

extern void EDVBrowserDirTreeDoRefresh(
	edv_browser_struct *browser, GtkCTreeNode *node,
	gboolean update_progress
);
extern void EDVBrowserDirTreeDoExpand(
	edv_browser_struct *browser, GtkCTreeNode *node,
	gboolean update_progress
);

extern void EDVBrowserDirTreeDoSync(
	edv_browser_struct *browser, GtkCTreeNode *node
);

extern void EDVBrowserDirTreeDoSelectPath(
	edv_browser_struct *browser, const gchar *path
);

extern GtkCTreeNode *EDVBrowserDirTreeFindNodeByPath(
	edv_browser_struct *browser, const gchar *path
);

extern void EDVBrowserDirTreeDoOpenWithObject(
	edv_browser_struct *browser, GtkCTreeNode *node
);

extern void EDVBrowserDirTreeDoFPromptRename(
	edv_browser_struct *browser, GtkCTreeNode *node
);

extern void EDVBrowserDirTreeObjectAddedNotify(
	edv_browser_struct *browser, const gchar *path,
	const struct stat *lstat_buf
);
extern void EDVBrowserDirTreeObjectModifiedNotify(
	edv_browser_struct *browser, const gchar *path,
	const gchar *new_path,
	const struct stat *lstat_buf
);
extern void EDVBrowserDirTreeObjectRemovedNotify(
	edv_browser_struct *browser, const gchar *path
);

extern void EDVBrowserDirTreeMountNotify(
	edv_browser_struct *browser, edv_device_struct *dev_ptr,
	gboolean is_mounted
);


#endif	/* BROWSERDIRTREE_H */
