/*
		  Endeavour Browser Contents List
 */

#ifndef BROWSERCONTENTS_H
#define BROWSERCONTENTS_H

#include <gtk/gtk.h>
#include "browser.h"
#include "endeavour.h"


extern gint EDVBrowserContentsFindRowByPath(
	edv_browser_struct *browser, const gchar *path
);

extern void EDVBrowserContentsResetRows(edv_browser_struct *browser);
extern void EDVBrowserContentsDoUpdate(
	edv_browser_struct *browser, const gchar *path,
	gboolean update_status_bar
);

extern void EDVBrowserContentsDoOpenObject(
	edv_browser_struct *browser, gint row, gint column, guint state
);
extern void EDVBrowserContentsDoOpenWithObject(
	edv_browser_struct *browser, gint row, gint column
);

extern void EDVBrowserContentsDoFPromptRename(
	edv_browser_struct *browser, gint row, gint column
);

extern void EDVBrowserContentsObjectAddedNotify(
	edv_browser_struct *browser, const gchar *path,
	const struct stat *lstat_buf
);
extern void EDVBrowserContentsObjectModifiedNotify(
	edv_browser_struct *browser, const gchar *path,
	const gchar *new_path,
	const struct stat *lstat_buf
);
extern void EDVBrowserContentsObjectRemovedNotify(
	edv_browser_struct *browser, const gchar *path
);

extern void EDVBrowserContentsMountNotify(
	edv_browser_struct *browser, edv_device_struct *dev_ptr,
	gboolean is_mounted
);


#endif	/* BROWSERCONTENTS_H */
