#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <gtk/gtk.h>

#include "../../include/fio.h"
#include "../../include/prochandle.h"

#include "../guiutils.h"
#include "../cdialog.h"
#include "../pdialog.h"

#include "../edvtypes.h"
#include "../lib/endeavour2.h"

#include "ziptoolio.h"
#include "ziptool.h"
#include "ziptoolcb.h"
#include "config.h"


gint ZipToolsExposeEventCB(
        GtkWidget *widget, GdkEventExpose *expose, gpointer data
);
gint ZipToolsButtonPressEventCB(
        GtkWidget *widget, GdkEventButton *button, gpointer data
);

gint ZipToolsCloseCB(
        GtkWidget *widget, GdkEvent *event, gpointer data
);
void ZipToolsDestroyCB(GtkObject *object, gpointer data);

gint ZipToolsMenuItemEnterCB(
        GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
gint ZipToolsMenuItemLeaveCB(
        GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);

void ZipToolsOPIDEnterCB(gpointer data);
void ZipToolsOPIDLeaveCB(gpointer data);
void ZipToolsOPIDCB(gpointer data);

void ZipToolsMountCB(GtkWidget *widget, gpointer data);
void ZipToolsUnmountCB(GtkWidget *widget, gpointer data);
void ZipToolsSpinDownCB(GtkWidget *widget, gpointer data);
void ZipToolsEjectCB(GtkWidget *widget, gpointer data);
void ZipToolsPasswordCB(GtkWidget *widget, gpointer data);
void ZipToolsBrowseCB(GtkWidget *widget, gpointer data);
void ZipToolsRefreshCB(GtkWidget *widget, gpointer data);
void ZipToolsFSCKCB(GtkWidget *widget, gpointer data);
void ZipToolsCloseBtnCB(GtkWidget *widget, gpointer data);
void ZipToolsExitCB(GtkWidget *widget, gpointer data);



/*
 *	"expose_event" signal callback.
 */
gint ZipToolsExposeEventCB(
        GtkWidget *widget, GdkEventExpose *expose, gpointer data
)
{
        gint etype;
        zip_tools_struct *zt = (zip_tools_struct *)data;
        if((widget == NULL) || (expose == NULL) || (zt == NULL))
            return(FALSE);

        /* Get event type. */
        etype = expose->type;

        /* Handle by widget. */
        if(widget == zt->display_event_box)
        {
	    GdkWindow *window = widget->window;
	    if(window != NULL)
	    {
#if 0
		gdk_window_clear(window);
#endif
	    }
	}

	return(TRUE);
}

/*
 *	"button_press_event" signal callback.
 */
gint ZipToolsButtonPressEventCB(
        GtkWidget *widget, GdkEventButton *button, gpointer data
)
{
	gint etype;
        zip_tools_struct *zt = (zip_tools_struct *)data;
        if((widget == NULL) || (button == NULL) || (zt == NULL))
            return(FALSE);

        /* Get event type. */
        etype = button->type;

	/* Handle by widget. */
        if(widget == zt->display_event_box)
        {
	    GtkWidget *w;

            /* Handle by event type. */
            switch(etype)
            {
#if 0
              case GDK_2BUTTON_PRESS:
                /* Handle by button number. */
                switch(button->button)
                {
                  case 1:
		    /* Do start. */
		    ZipToolsStartCB(widget, data);
                    break;
                }
		break;
#endif

              case GDK_BUTTON_PRESS:
                /* Handle by button number. */
                switch(button->button)
                {
                  case 3:
                    /* Get right click menu widget and map it. */
                    w = zt->menu;
                    if(w != NULL)
                        gtk_menu_popup(
                            GTK_MENU(w), NULL, NULL,
                            NULL, NULL,
                            button->button, button->time
                        );
                    break;
                }
                break;
            }
        }

        return(TRUE);
}


/*
 *      Close callback.
 */
gint ZipToolsCloseCB(
        GtkWidget *widget, GdkEvent *event, gpointer data
)
{
        ZipToolsCloseBtnCB(widget, data);

        return(TRUE);
}

/*
 *      Destroy callback.
 */
void ZipToolsDestroyCB(GtkObject *object, gpointer data)
{
	return;
}


/*
 *	Menu item enter callback.
 */
gint ZipToolsMenuItemEnterCB(
        GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
)
{
	zip_tools_struct *zt;
        zip_tools_opid_struct *opid_ptr = (zip_tools_opid_struct *)data;
        if(opid_ptr == NULL)
            return(FALSE);

        zt = (zip_tools_struct *)opid_ptr->zt;
        if(zt == NULL)
            return(FALSE);

	ZipToolsStatusMessage(zt, opid_ptr->tooltip, FALSE);

	return(TRUE);
}

/*
 *	Menu item leave callback.
 */
gint ZipToolsMenuItemLeaveCB(
        GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
)
{
	zip_tools_struct *zt;
        zip_tools_opid_struct *opid_ptr = (zip_tools_opid_struct *)data;
        if(opid_ptr == NULL)
            return(FALSE);

	zt = (zip_tools_struct *)opid_ptr->zt;
	if(zt == NULL)
	    return(FALSE);

        ZipToolsStatusMessage(zt, NULL, FALSE);

	return(TRUE);
}

/*
 *	Operation ID enter callback.
 */
void ZipToolsOPIDEnterCB(gpointer data)
{
        zip_tools_opid_struct *opid_ptr = (zip_tools_opid_struct *)data;
        if(opid_ptr == NULL)
            return;

        if(opid_ptr->func_enter_cb != NULL)
            opid_ptr->func_enter_cb(NULL, NULL, opid_ptr);
}

/*
 *      Operation ID leave callback.
 */
void ZipToolsOPIDLeaveCB(gpointer data)
{
        zip_tools_opid_struct *opid_ptr = (zip_tools_opid_struct *)data;
        if(opid_ptr == NULL)
            return;

        if(opid_ptr->func_leave_cb != NULL)
            opid_ptr->func_leave_cb(NULL, NULL, opid_ptr);
}

/*
 *	Operation id callback.
 */
void ZipToolsOPIDCB(gpointer data)
{
        zip_tools_opid_struct *opid_ptr = (zip_tools_opid_struct *)data;
        if(opid_ptr == NULL)
            return;

	if(opid_ptr->func_cb != NULL)
	    opid_ptr->func_cb(NULL, opid_ptr->zt);
}


/*
 *	Mount callback.
 */
void ZipToolsMountCB(GtkWidget *widget, gpointer data)
{
#ifdef ZIP_TOOL_USE_ENDEAVOUR_MOUNT
        gboolean got_error = FALSE;
        const gchar *cmd;
        gchar *stderr_path;
	edv_device_struct *dev_ptr;
        zip_tools_struct *zt = (zip_tools_struct *)data;
        if(zt == NULL)
            return;

	dev_ptr = zt->device;
        if(dev_ptr == NULL)
            return;

        cmd = dev_ptr->command_mount;
        if((cmd != NULL) ? (*cmd == '\0') : TRUE)
        {
            CDialogSetTransientFor(zt->toplevel);
            CDialogGetResponse(
                "Mount Failed",
"There is no mount command defined for this device",
"You should run Endeavour Mark II and configure the\n\
device references by going to Device->Devices...\n\
and then exit Endeavour Mark II to ensure that\n\
the changes have been saved. Afterwards run this\n\
program again.",
                CDIALOG_ICON_WARNING,
                CDIALOG_BTNFLAG_OK | CDIALOG_BTNFLAG_HELP,
                CDIALOG_BTNFLAG_OK
            );
            CDialogSetTransientFor(NULL);
            return;
        }

        ZipToolsSetBusy(zt, TRUE);

        stderr_path = tempnam(NULL, NULL);
        if(ExecBOE(cmd, NULL, stderr_path) != 0)
        {
            struct stat stat_buf;

            if(!stat(stderr_path, &stat_buf))
            {
                if(stat_buf.st_size > 0)
                {
                    CDialogSetTransientFor(zt->toplevel);
                    CDialogGetResponseFile(
                        "Mount Warning",
                        stderr_path,
                        NULL,
                        CDIALOG_ICON_WARNING,
                        CDIALOG_BTNFLAG_OK,
                        CDIALOG_BTNFLAG_OK
                    );
                    CDialogSetTransientFor(NULL);
                }
            }
        }
        else
        {
            gchar *buf = g_strdup_printf(
"Unable to execute unmount command:\n\
\n\
    %s",
                cmd
            );
            CDialogSetTransientFor(zt->toplevel);
            CDialogGetResponse(
                "Mount Failed",
                cmd,
                NULL,
                CDIALOG_ICON_ERROR,
                CDIALOG_BTNFLAG_OK,
                CDIALOG_BTNFLAG_OK
            );
            CDialogSetTransientFor(NULL);
            g_free(buf);
            got_error = TRUE;
        }
        unlink(stderr_path);
        g_free(stderr_path);

        ZipToolsRefreshDevice(zt, dev_ptr);
        ZipToolsUpdateMenus(zt);
        ZipToolsStatusMessage(
            zt,
            got_error ?
                "Error mounting device" : "Device mounted",
            FALSE
        );
        ZipToolsSetBusy(zt, FALSE);
#else   /* ZIP_TOOL_USE_ENDEAVOUR_MOUNT */
        gboolean got_error = FALSE;
        gint status;
        edv_device_struct *dev_ptr;
        zip_tools_struct *zt = (zip_tools_struct *)data;
        if(zt == NULL)
            return;

        dev_ptr = zt->device;
        if(dev_ptr == NULL)
            return;

        ZipToolsSetBusy(zt, TRUE);

        ZipToolsStatusMessage(
            zt, "Mounting device...", TRUE
        );
        status = ZipToolsMount(dev_ptr);
        if(status != 0)
        {
            const gchar *buf =
"General error encountered while mounting device";
            switch(status)
            {
              case -3:
                buf =
"Unable to execute mount command";
                break;

              case -2:
                buf =
"Invalid device reference value";
                break;
            }
            CDialogSetTransientFor(zt->toplevel);
            CDialogGetResponse(
                "Error Mounting Device",
                buf,
"Please check to make sure that you have\n\
sufficient permission to run ziptool and access\n\
the device.  Also make sure that the device is\n\
properly defined from Endeavour Mark II.\n\
\n\
You should run Endeavour Mark II and configure the\n\
device references by going to Device->Devices...\n\
and then exit Endeavour Mark II to ensure that\n\
the changes have been saved. Afterwards run this\n\
program again.",
                CDIALOG_ICON_ERROR,
                CDIALOG_BTNFLAG_OK | CDIALOG_BTNFLAG_HELP,
                CDIALOG_BTNFLAG_OK
            );
            CDialogSetTransientFor(NULL);
            got_error = TRUE;
        }

        ZipToolsRefreshDevice(zt, dev_ptr);
        ZipToolsUpdateMenus(zt);
        ZipToolsStatusMessage(
            zt,
            got_error ?
                "Error mounting device" : "Device mounted",
            FALSE
        );
	if(!got_error)
	    EDVNotifyQueueObjectMounted(zt->ctx, dev_ptr->mount_path);
        EDVContextSync(zt->ctx);
        ZipToolsSetBusy(zt, FALSE);
#endif  /* !ZIP_TOOL_USE_ENDEAVOUR_MOUNT */
}

/*
 *	Unmount callback.
 */
void ZipToolsUnmountCB(GtkWidget *widget, gpointer data)
{
#ifdef ZIP_TOOL_USE_ENDEAVOUR_MOUNT
	gboolean got_error = FALSE;
	const gchar *cmd;
	gchar *stderr_path;
        edv_device_struct *dev_ptr;
        zip_tools_struct *zt = (zip_tools_struct *)data;
        if(zt == NULL)
            return;

        dev_ptr = zt->device;
        if(dev_ptr == NULL)
            return;

	cmd = dev_ptr->command_unmount;
	if((cmd != NULL) ? (*cmd == '\0') : TRUE)
	{
            CDialogSetTransientFor(zt->toplevel);
            CDialogGetResponse(
                "Unmount Failed",
"There is no unmount command defined for this device",
"You should run Endeavour Mark II and configure the\n\
device references by going to Device->Devices...\n\
and then exit Endeavour Mark II to ensure that\n\
the changes have been saved. Afterwards run this\n\
program again.",
                CDIALOG_ICON_WARNING,
                CDIALOG_BTNFLAG_OK | CDIALOG_BTNFLAG_HELP,
                CDIALOG_BTNFLAG_OK
            );
            CDialogSetTransientFor(NULL);
	    return;
	}

        ZipToolsSetBusy(zt, TRUE);

        ZipToolsStatusMessage(
            zt, "Unmounting device...", TRUE
        );

        stderr_path = tempnam(NULL, NULL);
        if(ExecBOE(cmd, NULL, stderr_path) != 0)
        {
	    struct stat stat_buf;

            if(!stat(stderr_path, &stat_buf))
            {
		if(stat_buf.st_size > 0)
		{
		    CDialogSetTransientFor(zt->toplevel);
                    CDialogGetResponseFile(
                        "Unmount Warning",
                        stderr_path,
                        NULL,
                        CDIALOG_ICON_WARNING,
                        CDIALOG_BTNFLAG_OK,
                        CDIALOG_BTNFLAG_OK
                    );
                    CDialogSetTransientFor(NULL);
                }
	    }
        }
	else
	{
	    gchar *buf = g_strdup_printf(
"Unable to execute unmount command:\n\
\n\
    %s",
		cmd
	    );
            CDialogSetTransientFor(zt->toplevel);
            CDialogGetResponse(
		"Unmount Error",
		cmd,
		NULL,
		CDIALOG_ICON_ERROR,
                CDIALOG_BTNFLAG_OK,
                CDIALOG_BTNFLAG_OK
            );
            CDialogSetTransientFor(NULL);
	    g_free(buf);
	    got_error = TRUE;
	}
        unlink(stderr_path);
        g_free(stderr_path);

        ZipToolsRefreshDevice(zt, dev_ptr);
        ZipToolsUpdateMenus(zt);
        ZipToolsStatusMessage(
            zt,
	    got_error ?
		"Error unmounting device" : "Device unmounted",
	    FALSE
        );
	ZipToolsSetBusy(zt, FALSE);
#else	/* ZIP_TOOL_USE_ENDEAVOUR_MOUNT */
        gboolean got_error = FALSE;
        gint status;
        edv_device_struct *dev_ptr;
        zip_tools_struct *zt = (zip_tools_struct *)data;
        if(zt == NULL)
            return;

        dev_ptr = zt->device;
        if(dev_ptr == NULL)
            return;

        ZipToolsSetBusy(zt, TRUE);

        ZipToolsStatusMessage(
            zt, "Unmounting device...", TRUE
        );
        status = ZipToolsUnmount(dev_ptr);
        if(status != 0)
        {
            const gchar *buf =
"General error encountered while unmounting device";
            switch(status)
            {
              case -3:
                buf =
"Unable to execute unmount command";
                break;

              case -2:
                buf =
"Invalid device reference value";
                break;
            }
            CDialogSetTransientFor(zt->toplevel);
            CDialogGetResponse(
                "Error Unmounting Device",
                buf,
"Please check to make sure that you have\n\
sufficient permission to run ziptool and access\n\
the device.  Also make sure that the device is\n\
properly defined from Endeavour Mark II.\n\
\n\
You should run Endeavour Mark II and configure the\n\
device references by going to Device->Devices...\n\
and then exit Endeavour Mark II to ensure that\n\
the changes have been saved. Afterwards run this\n\
program again.",
                CDIALOG_ICON_ERROR,
                CDIALOG_BTNFLAG_OK | CDIALOG_BTNFLAG_HELP,
                CDIALOG_BTNFLAG_OK
            );
            CDialogSetTransientFor(NULL);
            got_error = TRUE;
        }

	ZipToolsRefreshDevice(zt, dev_ptr);
        ZipToolsUpdateMenus(zt);
        ZipToolsStatusMessage(
            zt,
            got_error ?
                "Error unmounting device" : "Device unmounted",
            FALSE
        );
	if(!got_error)
            EDVNotifyQueueObjectUnmounted(zt->ctx, dev_ptr->mount_path);
        EDVContextSync(zt->ctx);
        ZipToolsSetBusy(zt, FALSE);
#endif	/* !ZIP_TOOL_USE_ENDEAVOUR_MOUNT */
}

/*
 *	Spin down callback.
 */
void ZipToolsSpinDownCB(GtkWidget *widget, gpointer data)
{
        gboolean got_error = FALSE;
        gint status;
        edv_device_struct *dev_ptr;
        zip_tools_struct *zt = (zip_tools_struct *)data;
        if(zt == NULL)
            return;

        dev_ptr = zt->device;
        if(dev_ptr == NULL)
            return;

        ZipToolsSetBusy(zt, TRUE);

        ZipToolsStatusMessage(
            zt, "Spinning down device...", TRUE
        );
        status = ZipToolsSpinDown(dev_ptr);
        if(status != 0)
        {
            const gchar *buf =
"General error encountered while spinning down device";
            switch(status)
            {
              case -3:
                buf =
"Unable to execute spin down command";
                break;

              case -2:
                buf =
"Invalid device reference value";
                break;
            }
            CDialogSetTransientFor(zt->toplevel);
            CDialogGetResponse(
                "Error Spinning Down Device",
                buf,
"Please check to make sure that you have\n\
sufficient permission to run ziptool and access\n\
the device.  Also make sure that the device is\n\
properly defined from Endeavour Mark II.\n\
\n\
You should run Endeavour Mark II and configure the\n\
device references by going to Device->Devices...\n\
and then exit Endeavour Mark II to ensure that\n\
the changes have been saved. Afterwards run this\n\
program again.",
                CDIALOG_ICON_ERROR,
                CDIALOG_BTNFLAG_OK | CDIALOG_BTNFLAG_HELP,
                CDIALOG_BTNFLAG_OK
            );
            CDialogSetTransientFor(NULL);
            got_error = TRUE;
        }

/* Do not refresh after spinning down device, because otherwise it
 * would check the device and cause things to spin up again.
 */
/*	ZipToolsRefreshDevice(zt, dev_ptr); */
        ZipToolsUpdateMenus(zt);
        ZipToolsStatusMessage(
            zt,
            got_error ?
                "Error spinning down device" : "Device spinned down",
            FALSE
        );
        ZipToolsSetBusy(zt, FALSE);
}

/*
 *	Eject callback.
 */
void ZipToolsEjectCB(GtkWidget *widget, gpointer data)
{
	gboolean got_error = FALSE;
	gint status;
        edv_device_struct *dev_ptr;
        zip_tools_struct *zt = (zip_tools_struct *)data;
        if(zt == NULL)
            return;

        dev_ptr = zt->device;
        if(dev_ptr == NULL)
            return;

        ZipToolsSetBusy(zt, TRUE);

        ZipToolsStatusMessage(
            zt, "Ejecting media...", TRUE
        );
	status = ZipToolsEject(dev_ptr);
	if(status != 0)
	{
	    const gchar *buf =
"General error encountered while ejecting media";
            switch(status)
            {
              case -4:
                buf =
"Device is currently mounted";
                break;

              case -3:
                buf =
"Unable to execute eject command";
                break;

              case -2:
                buf =
"Invalid device reference value";
                break;
            }
            CDialogSetTransientFor(zt->toplevel);
            CDialogGetResponse(
                "Error Ejecting Media",
                buf,
"Please check to make sure that you have\n\
sufficient permission to run ziptool and access\n\
the device.  Also make sure that the device is\n\
properly defined from Endeavour Mark II.\n\
\n\
You should run Endeavour Mark II and configure the\n\
device references by going to Device->Devices...\n\
and then exit Endeavour Mark II to ensure that\n\
the changes have been saved. Afterwards run this\n\
program again.",
                CDIALOG_ICON_ERROR,
                CDIALOG_BTNFLAG_OK | CDIALOG_BTNFLAG_HELP,
                CDIALOG_BTNFLAG_OK
            );
            CDialogSetTransientFor(NULL);
	    got_error = TRUE;
	}

        ZipToolsRefreshDevice(zt, dev_ptr);
        ZipToolsUpdateMenus(zt);
        ZipToolsStatusMessage(
            zt,
            got_error ?
                "Error ejecting media" : "Media ejected",
            FALSE
        );
        if(!got_error)
            EDVNotifyQueueObjectUnmounted(zt->ctx, dev_ptr->mount_path);
	EDVContextSync(zt->ctx);
        ZipToolsSetBusy(zt, FALSE);
}

/*
 *	Lock/unlock with password callback.
 */
void ZipToolsPasswordCB(GtkWidget *widget, gpointer data)
{
	gint status, device_locked;
	gchar **strv;
	gint strc;
        zip_tools_struct *zt = (zip_tools_struct *)data;
        if(zt == NULL)
            return;

	if(CDialogIsQuery() || PDialogIsQuery())
	    return;

	if(zt->device == NULL)
	    return;

	if(zt->device->is_mounted)
	{
	    CDialogSetTransientFor(zt->toplevel);
	    CDialogGetResponse(
"Error Locking/Unlocking Media",
"The device must be unmounted first, before\n\
locking or unlocking the media.",
		NULL,
		CDIALOG_ICON_ERROR,
		CDIALOG_BTNFLAG_OK,
		CDIALOG_BTNFLAG_OK
	    );
	    CDialogSetTransientFor(NULL);
	    return;
	}

        ZipToolsSetBusy(zt, TRUE);

	/* Get current lock state. */
	device_locked = ZipToolsDeviceIsProtected(zt->device);
	switch(device_locked)
	{
	  case 2:
	    /* Already locked with password, prompt for unlock
	     * with password.
	     */
            ZipToolsStatusMessage(
                zt, "Unlocking media with password...", TRUE
            );
	    PDialogDeleteAllPrompts();
	    PDialogAddPromptPassword(
		NULL, "Password:", NULL
	    );
	    PDialogSetSize(300, -1);
            PDialogSetTransientFor(zt->toplevel);
	    strv = PDialogGetResponse(
		"Unlock Media",
"A password is required to unlock this media,\n\
please enter the password below.",
		NULL,
		PDIALOG_ICON_SECURITY,
		"Unlock", "Cancel",
		PDIALOG_BTNFLAG_SUBMIT | PDIALOG_BTNFLAG_CANCEL,
		PDIALOG_BTNFLAG_SUBMIT,
		&strc
	    );
            PDialogSetTransientFor(NULL);
	    if((strv != NULL) && (strc >= 1))
	    {
		const gchar *password = strv[0];
                status = ZipToolsUnlock(zt->device, password);
                if(status)
                {
                    const gchar *buf =
"General error encountered while unlocking media";
                    switch(status)
                    {
                      case -4:
                        buf =
"Bad password";
                        break;

                      case -3:
                        buf =
"Unable to execute unlock command";
                        break;

                      case -2:
                        buf =
"Invalid device reference value";
                        break;
                    }
                    CDialogSetTransientFor(zt->toplevel);
                    CDialogGetResponse(
                        "Error Unlocking Media",
                        buf,
"Please check to make sure that you have\n\
sufficient permission to run ziptool and access\n\
the device.  Also make sure that the device is\n\
properly defined from Endeavour Mark II.\n\
\n\
You should run Endeavour Mark II and configure the\n\
device references by going to Device->Devices...\n\
and then exit Endeavour Mark II to ensure that\n\
the changes have been saved. Afterwards run this\n\
program again.",
                        CDIALOG_ICON_ERROR,
                        CDIALOG_BTNFLAG_OK | CDIALOG_BTNFLAG_HELP,
                        CDIALOG_BTNFLAG_OK
                    );
                    CDialogSetTransientFor(NULL);
                    ZipToolsStatusMessage(
                        zt, "Failed to unlock media", FALSE
                    );
		}
		else
                {
                    ZipToolsStatusMessage(
                        zt, "Unlocked media", FALSE
                    );
                }
	    }
            else
            {
                ZipToolsStatusMessage(
                    zt, "Unlock media aborted", FALSE
                );
            }
	    break;

	  case 1:
	    /* Locked (without password), just unlock. */
            ZipToolsStatusMessage(
                zt, "Unlocking media...", TRUE
            );
	    status = ZipToolsUnlock(zt->device, NULL);
	    if(status)
	    {
		const gchar *buf =
"General error encountered while unlocking media";
		switch(status)
		{
                  case -4:
                    buf =
"Bad password";
                    break;

		  case -3:
		    buf =
"Unable to execute unlock command";
		    break;

		  case -2:
		    buf =
"Invalid device reference value";
		    break;
		}
		CDialogSetTransientFor(zt->toplevel);
		CDialogGetResponse(
		    "Error Unlocking Media",
		    buf,
"Please check to make sure that you have\n\
sufficient permission to run ziptool and access\n\
the device.  Also make sure that the device is\n\
properly defined from Endeavour Mark II.\n\
\n\
You should run Endeavour Mark II and configure the\n\
device references by going to Device->Devices...\n\
and then exit Endeavour Mark II to ensure that\n\
the changes have been saved. Afterwards run this\n\
program again.",
		    CDIALOG_ICON_ERROR,
		    CDIALOG_BTNFLAG_OK | CDIALOG_BTNFLAG_HELP,
		    CDIALOG_BTNFLAG_OK
		);
		CDialogSetTransientFor(NULL);
                ZipToolsStatusMessage(
                    zt, "Failed to unlock media", FALSE
                );
	    }
	    else
	    {
                ZipToolsStatusMessage(
                    zt, "Unlocked media", FALSE
                );
	    }
	    break;

	  default:
	    /* Assume unlocked, prompt for lock with optional
	     * password.
	     */
	    ZipToolsStatusMessage(
		zt, "Locking media...", TRUE
	    );
            PDialogDeleteAllPrompts();
            PDialogAddPromptPassword(
                NULL, "Password:", NULL
            );
            PDialogAddPromptPassword(
                NULL, "Confirm:", NULL
            );
            PDialogSetSize(300, -1);
            PDialogSetTransientFor(zt->toplevel);
            strv = PDialogGetResponse(
                "Lock Media",
"Enter a new password that will be used to\n\
lock this media. Or you may leave it blank\n\
to set this media as read only",
                NULL,
                PDIALOG_ICON_SECURITY,
                "Lock", "Cancel",
                PDIALOG_BTNFLAG_SUBMIT | PDIALOG_BTNFLAG_CANCEL,
                PDIALOG_BTNFLAG_SUBMIT,
                &strc
            );
            PDialogSetTransientFor(NULL);
            if((strv != NULL) && (strc >= 2))
            {
                const gchar *password = strv[0];
		const gchar *confirm = strv[1];
		if((password != NULL) ? (*password != '\0') : FALSE)
		{
		    /* Password given, now make sure password matches
		     * with confirm.
		     */
		    if((confirm != NULL) ?
			!strcmp(password, confirm) : FALSE
		    )
			status = ZipToolsLock(zt->device, password);
		    else
			status = -100;
		}
		else
		{
		    /* Just lock media. */
		    status = ZipToolsLock(zt->device, NULL);
		}
		if(status)
                {
                    const gchar *buf =
"General error encountered while locking media";
                    switch(status)
                    {
		      case -100:
			buf =
"Passwords do not match";
			break;

                      case -4:
                        buf =
"Unable to lock media";
                        break;

                      case -3:
                        buf =
"Unable to execute lock command";
                        break;

                      case -2:
                        buf =
"Invalid device reference value";
                        break;
                    }
                    CDialogSetTransientFor(zt->toplevel);
                    CDialogGetResponse(
                        "Error Locking Media",
                        buf,
"Please check to make sure that you have\n\
sufficient permission to run ziptool and access\n\
the device.  Also make sure that the device is\n\
properly defined from Endeavour Mark II.\n\
\n\
You should run Endeavour Mark II and configure the\n\
device references by going to Device->Devices...\n\
and then exit Endeavour Mark II to ensure that\n\
the changes have been saved. Afterwards run this\n\
program again.",
                        CDIALOG_ICON_ERROR,
                        CDIALOG_BTNFLAG_OK | CDIALOG_BTNFLAG_HELP,
                        CDIALOG_BTNFLAG_OK
                    );
                    CDialogSetTransientFor(NULL);
                    ZipToolsStatusMessage(
                        zt, "Failed to lock media", FALSE
                    );
		}
		else
		{
                    ZipToolsStatusMessage(
                        zt, "Locked media", FALSE
                    );
		}
            }
	    else
	    {
                ZipToolsStatusMessage(
                    zt, "Lock media aborted", FALSE
                );
	    }
	    break;
	}

        ZipToolsRefreshDevice(zt, zt->device);
        ZipToolsUpdateMenus(zt);
        ZipToolsSetBusy(zt, FALSE);
}

/*
 *	Run file browser to browse media callback.
 */
void ZipToolsBrowseCB(GtkWidget *widget, gpointer data)
{
	edv_device_struct *dev_ptr;
        zip_tools_struct *zt = (zip_tools_struct *)data;
        if(zt == NULL)
            return;

	dev_ptr = zt->device;
	if(dev_ptr == NULL)
	    return;

        ZipToolsSetBusy(zt, TRUE);
	EDVWindowBrowserNew(zt->ctx, dev_ptr->mount_path);
        ZipToolsSetBusy(zt, FALSE);
}

/*
 *	Refresh calback.
 */
void ZipToolsRefreshCB(GtkWidget *widget, gpointer data)
{
        zip_tools_struct *zt = (zip_tools_struct *)data;
        if(zt == NULL)
            return;

	ZipToolsSetBusy(zt, TRUE);
	ZipToolsStatusMessage(
	    zt, "Refreshing device information...", TRUE
	);
	ZipToolsRefreshDevice(zt, zt->device);
	ZipToolsUpdateMenus(zt);
	ZipToolsStatusMessage(
            zt, "Refreshed device information", FALSE
        );
	ZipToolsSetBusy(zt, FALSE);
}

/*
 *	FSCK callback.
 */
void ZipToolsFSCKCB(GtkWidget *widget, gpointer data)
{
	const gchar *cmd;
        zip_tools_struct *zt = (zip_tools_struct *)data;
        if(zt == NULL)
            return;

        ZipToolsSetBusy(zt, TRUE);

	cmd = (zt->device != NULL) ? zt->device->command_check : NULL;
	if((cmd != NULL) ? (*cmd != '\0') : FALSE)
	{
	    Exec(cmd);
	}
	else
	{
            CDialogSetTransientFor(zt->toplevel);
            CDialogGetResponse(
                "FSCK Program Undefined",
"There is no defined command to run the FSCK program\n\
for this device.",
"To define a command to run the FSCK program for this\n\
device, run Endeavour Mark II and configure the\n\
device references by going to Device->Devices...\n\
and define the Check Command to run the FSCK program.\n\
Then exit Endeavour Mark II to ensure that\n\
the changes have been saved. Afterwards run this\n\
program again.",
                CDIALOG_ICON_WARNING,
                CDIALOG_BTNFLAG_OK | CDIALOG_BTNFLAG_HELP,
                CDIALOG_BTNFLAG_OK
            );
            CDialogSetTransientFor(NULL);
	}

        ZipToolsSetBusy(zt, FALSE);
}

/*
 *	Close button callback.
 */
void ZipToolsCloseBtnCB(GtkWidget *widget, gpointer data)
{
	zip_tools_struct *zt = (zip_tools_struct *)data;
	if(zt == NULL)
	    return;

	ZipToolsUnmap(zt);
}

/*
 *	Exit callback.
 */
void ZipToolsExitCB(GtkWidget *widget, gpointer data)
{
        zip_tools_struct *zt = (zip_tools_struct *)data;
        if(zt == NULL)
            return;
/* Need to work on this. */
        ZipToolsUnmap(zt);
}

