/*
             Zip Tools Window Creation, Management, and Deletion
 */

#ifndef ZIPTOOLS_H
#define ZIPTOOLS_H

#include <sys/types.h>
#include <gtk/gtk.h>
#include "../piechart.h"
#include "../edvtypes.h"
#include "../edvdevices.h"
#include "../toolbar.h"
#include "../lib/endeavour2.h"

/*
 *	Operation IDs:
 */
#define ZIP_TOOLS_OPID_CLOSE		10
#define ZIP_TOOLS_OPID_EXIT		11

#define ZIP_TOOLS_OPID_MOUNT		30
#define ZIP_TOOLS_OPID_UNMOUNT		31

#define ZIP_TOOLS_OPID_SPIN_DOWN	35
#define ZIP_TOOLS_OPID_EJECT		36

#define ZIP_TOOLS_OPID_PASSWORD		40

#define ZIP_TOOLS_OPID_BROWSE		50
#define ZIP_TOOLS_OPID_REFRESH		51
#define ZIP_TOOLS_OPID_FSCK		52


/*
 *	Zip Tools Window Operation ID:
 */
typedef struct {

	gint opid;
	gpointer zt;

	void (*func_cb)(GtkWidget *, gpointer);
	gint (*func_enter_cb)(GtkWidget *, GdkEventCrossing *, gpointer);
	gint (*func_leave_cb)(GtkWidget *, GdkEventCrossing *, gpointer);

	guint8 **icon_data;
        gchar *name;
        gchar *button_name;
	gchar *tooltip;

} zip_tools_opid_struct;

/*
 *	Zip Tools Window:
 */
typedef struct {

	GtkWidget	*toplevel;
	gboolean	initialized;
	gboolean	map_state;
	gint		busy_count;
	GtkAccelGroup	*accelgrp;
	edv_context_struct	*ctx;

	GdkCursor	*busy_cur,
			*text_cur;

	zip_tools_opid_struct	**opid;
	gint			total_opids;

	toolbar_struct	*tool_bar;

	GtkWidget	*main_vbox,
			*tool_bar_handle,
			*display_event_box,
			*display_parent,	/* A vbox. */
			*display_child;		/* A hbox. */

	pie_chart_struct	*capacity_piechart;

	GtkWidget	*status_label;

	GtkWidget	*menu,			/* Right click menu. */
			*mount_mi,
			*unmount_mi,
			*spin_down_mi,
			*eject_mi,
			*password_mi,
			*fsck_mi,
			*refresh_mi;

	/* IOMega Jaz or Zip drive device reference. */
	edv_device_struct	*device;
	gint			device_locked;	/* 0 = unlocked
						 * 1 = locked
						 * 2 = locked with password
						 */

} zip_tools_struct;


extern zip_tools_opid_struct *ZipToolsOPIDMatchByID(
        zip_tools_opid_struct **opid, gint total,
        gint id
);
extern zip_tools_opid_struct **ZipToolsOPIDListNew(
	zip_tools_struct *zt, gint *total
);
extern void ZipToolsOPIDListDelete(
	zip_tools_opid_struct **opid, gint total
);

extern void ZipToolsSetDevice(
	zip_tools_struct *zt, edv_device_struct *dev_ptr
);
extern void ZipToolsRefreshDevice(
	zip_tools_struct *zt, edv_device_struct *dev_ptr
);

extern zip_tools_struct *ZipToolsNew(edv_context_struct *ctx);
extern void ZipToolsUpdateMenus(zip_tools_struct *zt);
extern void ZipToolsSetBusy(zip_tools_struct *zt, gboolean is_busy);
extern void ZipToolsStatusMessage(
        zip_tools_struct *zt, const gchar *mesg,
        gboolean allow_gtk_iteration

);
extern void ZipToolsMap(zip_tools_struct *zt);
extern void ZipToolsUnmap(zip_tools_struct *zt);
extern void ZipToolsDelete(zip_tools_struct *zt);




#endif	/* ZIPTOOLS_H */
