/*
                          Image Thumbs List
 */

#ifndef TLIST_H
#define TLIST_H

#include <gtk/gtk.h>

#ifndef gbool
# define gbool	gboolean
#endif


/*
 *	Image thumb structure:
 */
typedef struct {

#define TLIST_LOAD_STATE_NOT_LOADED	0
#define TLIST_LOAD_STATE_LOADED		1
#define TLIST_LOAD_STATE_FAILED		2
	gint load_state;

	gchar *text;
	GdkPixmap *pixmap;
	GdkBitmap *mask;

	gpointer client_data;
	void (*destroy_cb)(gpointer);

} tlist_thumb_struct;

#define TLIST_THUMB(p)		((tlist_thumb_struct *)(p))


/*
 *	Image thumbs list structure:
 */
typedef struct {

	gbool initialized;
	gbool map_state;
	GdkVisibilityState visibility;
	gbool double_buffer;
	gbool horizontal;
	gint freeze_count;

	GdkGC *gc, *selection_gc;

	GtkWidget	*toplevel,
			*list_da,
			*vsb, *hsb;

	GdkPixmap *list_pm;

	GtkAdjustment *vadj, *hadj;

	gint focus_thumb, pointer_over_thumb;
        gint selection_mode;		/* One of GTK_SELECTION_*. */
	GList *selection, *selection_end;

	tlist_thumb_struct **thumb;
	gint total_thumbs;

	/* Geometry. */
	gint	thumb_width,	/* Size of each thumb (incuding borders). */
		thumb_height;
	gint thumb_border;	/* Padding between thumbs. */
	gint thumbs_per_line;	/* Thumbs visible on one `line', min 1. */

	/* Callback info. */
	gpointer client_data;
	void (*select_cb)(gpointer, GdkEventButton *, gint, gpointer);
	void (*unselect_cb)(gpointer, GdkEventButton *, gint, gpointer);

} tlist_struct;

#define TLIST(p)	((tlist_struct *)(p))


extern void TListDraw(tlist_struct *tlist);
extern void TListResize(
        tlist_struct *tlist, gint width, gint height,
        gbool allow_gtk_main_iteration
);

extern void TListFreeze(tlist_struct *tlist);
extern void TListThaw(tlist_struct *tlist);

extern gint TListAppend(
	tlist_struct *tlist, const gchar *text,
	gpointer client_data,
        void (*destroy_cb)(gpointer)
);
extern void TListSetLoadState(
        tlist_struct *tlist, gint thumb_num,
        gint load_state         /* One of TLIST_LOAD_STATE_*. */
);
extern void TListSetText(
        tlist_struct *tlist, gint thumb_num,
	const gchar *text
);
extern void TListSetPixmap(
        tlist_struct *tlist, gint thumb_num,
        GdkPixmap *pixmap, GdkBitmap *mask
);
extern void TListSetRGBA(
        tlist_struct *tlist, gint thumb_num,
        gint width, gint height,        /* Of image data. */
        gint bpl,                       /* Bytes per line, can be -1. */
        GdkRgbDither dith,
        const guint8 *rgba_buf,
	gbool no_enlarge		/* Do not upscale if image smaller
					 * than thumb.
					 */
);
extern void TListSetDestroy(
        tlist_struct *tlist, gint thumb_num,
        gpointer client_data,
        void (*destroy_cb)(gpointer)
);
extern void TListRemove(tlist_struct *tlist, gint thumb_num);
extern void TListClear(tlist_struct *tlist);

extern gpointer TListGetThumbData(tlist_struct *tlist, gint thumb_num);

extern void TListSelectThumb(tlist_struct *tlist, gint thumb_num);
extern void TListUnselectThumb(tlist_struct *tlist, gint thumb_num);
extern void TListSelectAll(tlist_struct *tlist);
extern void TListUnselectAll(tlist_struct *tlist);

extern gbool TListGetSelection(
        tlist_struct *tlist, gint x, gint y,
	gint *thumb_num, gint *thumb_ix, gint *thumb_iy
);
extern gbool TListGetPosition(
        tlist_struct *tlist, gint thumb_num,
	gint *x, gint *y
);

extern gint TListIsThumbVisible(
	tlist_struct *tlist, gint thumb_num
);
extern void TListMoveTo(
        tlist_struct *tlist, gint thumb_num, gfloat coeff
);

extern tlist_struct *TListNew(
	gbool horizontal,
	gint thumb_width, gint thumb_height, gint thumb_border,
	gpointer client_data,
	void (*select_cb)(gpointer, GdkEventButton *, gint, gpointer),
        void (*unselect_cb)(gpointer, GdkEventButton *, gint, gpointer)
);
extern void TListSelectionMode(tlist_struct *tlist, gint selection_mode);
extern void TListDoubleBuffer(tlist_struct *tlist, gbool double_buffer);
extern void TListOrientation(tlist_struct *tlist, gbool horizontal);
extern void TListMap(tlist_struct *tlist);
extern void TListUnmap(tlist_struct *tlist);
extern void TListDelete(tlist_struct *tlist);



#endif	/* TLIST_H */
