#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>

#include "guiutils.h"
#include "deskicon.h"

#include "edvtypes.h"
#include "edvcfg.h"
#include "recbindnd.h"
#include "recbindeskicon.h"
#include "endeavour.h"
#include "edvcfglist.h"
#include "edvcb.h"
#include "edvop.h"
#include "config.h"

#include "images/icon_trash_empty_48x48.xpm"
#include "images/icon_trash_48x48.xpm"
#include "images/icon_purge_all_20x20.xpm"


static void EDVRecBinDeskIconMapCB(gpointer di, gpointer data);
static void EDVRecBinDeskIconMovedCB(
        gpointer di, gint x, gint y, gpointer data
);

edv_recbin_deskicon_struct *EDVRecBinDeskIconNew(
        gpointer core_ptr
);
void EDVRecBinDeskIconUpdate(edv_recbin_deskicon_struct *rbdi);
void EDVRecBinDeskIconMap(edv_recbin_deskicon_struct *rbdi);
void EDVRecBinDeskIconUnmap(edv_recbin_deskicon_struct *rbdi);
void EDVRecBinDeskIconDelete(edv_recbin_deskicon_struct *rbdi);



/*
 *	Desktop icon map reference window callback.
 */
static void EDVRecBinDeskIconMapCB(gpointer di, gpointer data)
{
	edv_core_struct *core_ptr;
	edv_recbin_deskicon_struct *rbdi = (edv_recbin_deskicon_struct *)data;
        if(rbdi == NULL)
            return;

        core_ptr = (edv_core_struct *)rbdi->core_ptr;
        if(core_ptr == NULL)
            return;

	EDVDoMapRecBin(core_ptr);
}

/*
 *	Desktop icon moved callback.
 */
static void EDVRecBinDeskIconMovedCB(
        gpointer di, gint x, gint y, gpointer data
)
{
        edv_core_struct *core_ptr;
        edv_recbin_deskicon_struct *rbdi = (edv_recbin_deskicon_struct *)data;
        if(rbdi == NULL)
            return;

        core_ptr = (edv_core_struct *)rbdi->core_ptr;
        if(core_ptr == NULL)
            return;

        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_RECBIN_DESKTOP_ICON_X,
            x, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_RECBIN_DESKTOP_ICON_Y,
            y, FALSE
        );
}


/*
 *	Creates a new recycle bin desktop icon.
 */
edv_recbin_deskicon_struct *EDVRecBinDeskIconNew(
        gpointer core_ptr
)
{
	gint x = 0, y = 0;
	GtkWidget *w;
	deskicon_struct *di;
        const GtkTargetEntry dnd_tar_types[] = {
{"text/plain",				0,	EDV_DND_TYPE_INFO_TEXT_PLAIN},
{"text/uri-list",			0,	EDV_DND_TYPE_INFO_TEXT_URI_LIST},
{"STRING",				0,	EDV_DND_TYPE_INFO_STRING}
        };
	edv_core_struct *c_ptr = (edv_core_struct *)core_ptr;
	edv_recbin_deskicon_struct *rbdi = (edv_recbin_deskicon_struct *)g_malloc0(
	    sizeof(edv_recbin_deskicon_struct)
	);
	if(rbdi == NULL)
	    return(rbdi);


	if(c_ptr != NULL)
	{
            x = EDVCFGItemListGetValueI(
                c_ptr->cfg_list, EDV_CFG_PARM_RECBIN_DESKTOP_ICON_X
            );
            y = EDVCFGItemListGetValueI(
                c_ptr->cfg_list, EDV_CFG_PARM_RECBIN_DESKTOP_ICON_Y
            );
	}


	/* Reset values. */
	rbdi->core_ptr = core_ptr;
	rbdi->last_recbin_items = -1;


        /* Create desktop icon. */
        rbdi->deskicon = di = DeskIconNew(
            x, y,
            (guchar **)icon_trash_empty_48x48_xpm, "Recycle Bin"
        );
        DeskIconSetMapRefCB(
            di,
            EDVRecBinDeskIconMapCB,
            rbdi
        );
        DeskIconSetMovedCB(
            di,
            EDVRecBinDeskIconMovedCB,
            rbdi
        );

	/* Set up the desktop icon's toplevel icon and label as
	 * as dnd target widgets.
	 */
	/* Icon toplevel. */
        w = (di != NULL) ? di->icon_toplevel : NULL;
        GUIDNDSetTar(
            w,
            dnd_tar_types,
            sizeof(dnd_tar_types) / sizeof(GtkTargetEntry),
            GDK_ACTION_MOVE,                    /* Actions. */
            GDK_ACTION_MOVE,                    /* Default action if same. */
            GDK_ACTION_MOVE,                    /* Default action. */
            EDVRecBinDeskIconDragDataReceivedCB,
            rbdi
        );
        gtk_signal_connect_after(
            GTK_OBJECT(w), "drag_motion",
            GTK_SIGNAL_FUNC(EDVRecBinDeskIconDragMotionCB), rbdi
        );
	/* Label toplevel. */
#if 0
/* Don't set the label as a dnd target widget, only allow user to
 * drop on the icon.
 */
        w = (di != NULL) ? di->label_toplevel : NULL;
        GUIDNDSetTar(
            w,
            dnd_tar_types,
            sizeof(dnd_tar_types) / sizeof(GtkTargetEntry),
            GDK_ACTION_MOVE,                    /* Actions. */
            GDK_ACTION_MOVE,                    /* Default action if same. */
            GDK_ACTION_MOVE,                    /* Default action. */
            EDVRecBinDeskIconDragDataReceivedCB,
            rbdi
        );
        gtk_signal_connect_after(
            GTK_OBJECT(w), "drag_motion",
            GTK_SIGNAL_FUNC(EDVRecBinDeskIconDragMotionCB), rbdi
        );
#endif

	/* Create menu. */
        if(1)
        {
            GtkAccelGroup *accelgrp = NULL;
            guint8 **icon_data;
	    const gchar *label;
	    gint accel_key;
	    guint accel_mods;
	    gpointer mclient_data;
	    void (*func_cb)(GtkWidget *, gpointer);
            GtkWidget *menu = GUIMenuCreate();
	    GtkWidget **fw_rtn;

#define DO_ADD_MENU_ITEM_LABEL	\
{ \
 w = GUIMenuItemCreate( \
  menu, GUI_MENU_ITEM_TYPE_LABEL, accelgrp, \
  icon_data, label, accel_key, accel_mods, \
  (gpointer *)fw_rtn, \
  mclient_data, func_cb \
 ); \
}
#define DO_ADD_MENU_SEP		\
{ \
 w = GUIMenuItemCreate( \
  menu, GUI_MENU_ITEM_TYPE_SEPARATOR, NULL, \
  NULL, NULL, 0, 0, NULL, \
  NULL, NULL \
 ); \
}
	    icon_data = NULL;
	    label = "Restore";
	    accel_key = 0;
	    accel_mods = 0;
	    fw_rtn = NULL;
	    mclient_data = core_ptr;
	    func_cb = EDVMapRecBinCB;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

            icon_data = (u_int8_t **)icon_purge_all_20x20_xpm;
            label = "Purge All";
            accel_key = 0;
            accel_mods = 0;
            fw_rtn = NULL;
            mclient_data = core_ptr;
            func_cb = EDVPurgeAllRecycledObjectsCB;
            DO_ADD_MENU_ITEM_LABEL

#undef DO_ADD_MENU_ITEM_LABEL
#undef DO_ADD_MENU_SEP

	    DeskIconSetMenu(di, menu);
        }

	return(rbdi);
}

/*
 *	Updates the icon on the recycle bin desktop icon to reflect the
 *	current unmber of contents in the recycle bin.
 */
void EDVRecBinDeskIconUpdate(edv_recbin_deskicon_struct *rbdi)
{
	deskicon_struct *di;
	edv_core_struct *core_ptr;
        guint8 **icon_data;


	if(rbdi == NULL)
	    return;

	core_ptr = (edv_core_struct *)rbdi->core_ptr;
	if(core_ptr == NULL)
	    return;

	di = rbdi->deskicon;
	if(di == NULL)
	    return;

        /* Update recycle bin icon data, setting it to not NULL if it
         * needs to be changed and update the recycle bin's last_recbin_items
         * to match the value on the core structure.
         */
        icon_data = NULL;
        if(rbdi->last_recbin_items < 0)
        {
	    /* Unknown if there were contents before, so definately
	     * set a new icon.
	     */
            if(core_ptr->last_recbin_items > 0)
                icon_data = (guint8 **)icon_trash_48x48_xpm;
            else
                icon_data = (guint8 **)icon_trash_empty_48x48_xpm;
        }
        else
        {
	    /* Had no contents before and there are contents now? */
            if(!rbdi->last_recbin_items &&
               core_ptr->last_recbin_items
            )
                icon_data = (guint8 **)icon_trash_48x48_xpm;
	    /* Had contents before but there are not contents now? */
            else if(rbdi->last_recbin_items &&
                    !core_ptr->last_recbin_items
            )
                icon_data = (guint8 **)icon_trash_empty_48x48_xpm;
        }

        /* Update desktop icon. */
        if(icon_data != NULL)
            DeskIconSet(di, icon_data, NULL);
}

/*
 *	Maps the recycle bin desktop icon.
 */
void EDVRecBinDeskIconMap(edv_recbin_deskicon_struct *rbdi)
{
	if(rbdi == NULL)
	    return;

	DeskIconMap(rbdi->deskicon);
}

/*
 *	Unmaps the recycle bin desktop icon.
 */
void EDVRecBinDeskIconUnmap(edv_recbin_deskicon_struct *rbdi)
{
        if(rbdi == NULL)
            return;

        DeskIconUnmap(rbdi->deskicon);
}

/*
 *	Deallocates all resources of the given recycle bin desktop icon
 *	and deallocates the structure itself.
 */
void EDVRecBinDeskIconDelete(edv_recbin_deskicon_struct *rbdi)
{
        if(rbdi == NULL)
            return;

	/* Delete the desktop icon. */
	DeskIconDelete(rbdi->deskicon);
	rbdi->deskicon = NULL;

	/* Deallocate the structure itself. */
	g_free(rbdi);
}
