/*
                       Endeavour Recycle Bin
 */

#ifndef RECBIN_H
#define RECBIN_H

#include <gtk/gtk.h>
#include "edvtypes.h"
#include "edvstatusbar.h"
#include "toolbar.h"
#include "findbar.h"


/*
 *	Contents clist column type id codes:
 */
#define EDV_RECBIN_COLUMN_TYPE_NAME		0
#define EDV_RECBIN_COLUMN_TYPE_SIZE		1
#define EDV_RECBIN_COLUMN_TYPE_TYPE		2
#define EDV_RECBIN_COLUMN_TYPE_PERMISSIONS	3
#define EDV_RECBIN_COLUMN_TYPE_OWNER		4
#define EDV_RECBIN_COLUMN_TYPE_GROUP		5
#define EDV_RECBIN_COLUMN_TYPE_DATE_ACCESS	6
#define EDV_RECBIN_COLUMN_TYPE_DATE_MODIFIED	7
#define EDV_RECBIN_COLUMN_TYPE_DATE_CHANGED	8
#define EDV_RECBIN_COLUMN_TYPE_DATE_DELETED	9
#define EDV_RECBIN_COLUMN_TYPE_LINKED_TO	10
#define EDV_RECBIN_COLUMN_TYPE_ORIGINAL_PATH	11
#define EDV_RECBIN_COLUMN_TYPE_INDEX		12


/* Total number of column types. */
#define EDV_RECBIN_CONTENTS_CLIST_COLUMNS_MAX	13


/*
 *	Recycle bin operation codes:
 */
#define EDV_RECBIN_OP_NONE		0
#define EDV_RECBIN_OP_SEPARATOR		10

#define EDV_RECBIN_OP_CLOSE		20
#define EDV_RECBIN_OP_EXIT		21

#define EDV_RECBIN_OP_SYNC_DISKS	30
#define EDV_RECBIN_OP_RUN		31
#define EDV_RECBIN_OP_RUN_TERMINAL	32
#define EDV_RECBIN_OP_WRITE_PROTECT	35

#define EDV_RECBIN_OP_RECOVER		60
#define EDV_RECBIN_OP_PURGE		61
#define EDV_RECBIN_OP_PURGE_ALL		62
#define EDV_RECBIN_OP_SELECT_ALL	70
#define EDV_RECBIN_OP_UNSELECT_ALL	71
#define EDV_RECBIN_OP_INVERT_SELECTION	72
#define EDV_RECBIN_OP_FIND		73

#define EDV_RECBIN_OP_HISTORY		77

#define EDV_RECBIN_OP_REFRESH		80
#define EDV_RECBIN_OP_REFRESH_ALL	81
#define EDV_RECBIN_OP_SHOW_TOOL_BAR	90
#define EDV_RECBIN_OP_SHOW_FIND_BAR	91
#define EDV_RECBIN_OP_SHOW_STATUS_BAR	92

#define EDV_RECBIN_OP_MIME_TYPES	100

#define EDV_RECBIN_OP_NEW_BROWSER	110
#define EDV_RECBIN_OP_NEW_IMBR		111
#define EDV_RECBIN_OP_NEW_ARCHIVER	112

#define EDV_RECBIN_OP_OPTIONS		150
#define EDV_RECBIN_OP_CUSTOMIZE		151

#define EDV_RECBIN_OP_HELP_ABOUT		1000
#define EDV_RECBIN_OP_HELP_CONTENTS		1001
#define EDV_RECBIN_OP_HELP_FILE_BROWSER		1002
#define EDV_RECBIN_OP_HELP_IMAGE_BROWSER	1003
#define EDV_RECBIN_OP_HELP_ARCHIVER		1004
#define EDV_RECBIN_OP_HELP_RECYCLE_BIN		1005
#define EDV_RECBIN_OP_HELP_KEYS_LIST		1006
#define EDV_RECBIN_OP_HELP_COMMON_OPERATIONS	1007


/*
 *	Recycle bin operation id structure:
 */
typedef struct {

	gpointer recbin;	/* Pointer back to recycle bin. */

	gint op;		/* One of EDV_RECBIN_OP_*. */

	gbool allow_multiple;	/* Allow multiple instances of this
				 * operation in a list if TRUE.
				 */

        gint toolbar_item_type; /* Type of item when placed on the
                                 * tool bar, one of TOOLBAR_ITEM_*.
                                 */

	/* Operation function callback, sole argument is the pointer
	 * to this structure.
	 */
	void (*func_cb)(gpointer);

	/* Enter and leave notify callback, sole argument is the pointer
	 * to this structure.
	 */
	void (*enter_func_cb)(gpointer);
	void (*leave_func_cb)(gpointer);

	gchar *button_name;	/* Name as it would appear on a button. */
	gchar *menu_name;	/* Name as it would appear on a menu item. */
	gchar *tooltip;		/* Tool tip or description (one line). */

	gint accel_key;		/* GTK accelerator key. */
	guint accel_mods;	/* GTK key modifiers for accelerator key. */

	guint8	**button_icon_data,	/* Shared. */
		**menu_icon_data;	/* Shared. */

} edv_recbin_opid_struct;


/*
 *	Recycle bin structure:
 */
typedef struct {

	gbool initialized;
	gbool map_state;
	gbool processing;
	gbool ignore_input;
	gint busy_count;
	gpointer core_ptr;

	edv_recbin_opid_struct **opid;
	gint total_opids;

	GtkAccelGroup *accelgrp;

	gbool	tool_bar_map_state,
                find_bar_map_state,
		status_bar_map_state;

	GtkWidget	*toplevel,
			*main_vbox,
			*menu_bar,
			*bars_vbox,		/* Toolbars GtkVBox. */

			*menu_bar_handle,
			*tool_bar_handle,
                        *find_bar_handle,

			*contents_clist;	/* Contents GtkCList. */

	/* General tool bar. */
	toolbar_struct *toolbar;

        /* Find bar. */
        edv_findbar_struct *findbar;

	/* Important menu items. */
	GtkWidget	*recover_mi,
                        *purge_mi,
                        *purge_all_mi,
			*sync_disks_mi,
			*history_mi,
			*run_mi,
			*close_mi,

			*edit_recover_mi,
                        *edit_purge_mi,
			*edit_purge_all_mi,
			*select_all_mi,
			*unselect_all_mi,
                        *invert_selection_mi,
			*find_mi,

			*refresh_mi,
			*refresh_all_mi,
                        *show_tool_bar_micheck,
                        *show_find_bar_micheck,
                        *show_status_bar_micheck,
			*mime_types_mi,

                        *write_protect_mi,
			*options_mi,
			*customize_mi,

			*window_new_browser_mi,
                        *window_new_imbr_mi,
                        *window_new_archiver_mi,

                        *help_contents_mi,
			*help_recycle_bin_mi,
			*help_keys_list_mi,
                        *help_common_operations_mi,
                        *help_about_mi;

        /* Contents clist right-click menu. */
        GtkWidget       *contents_clist_menu,
                        *contents_clist_recover_mi,
                        *contents_clist_purge_mi,
                        *contents_clist_purge_all_mi;

	/* Last selected row on the clist, can be -1. Note that
	 * this does not reflect other selected rows since multiple
	 * selections are allowed.
	 */
	gint contents_clist_selected_row;


        /* Last known items in recycle bin, this is used as a quick access
         * value to check if the recycle bin has contents or not. Can be
         * -1 to indicate undefined.
	 */
        gint last_recbin_items;

        /* Last known write protect state, can be -1 to indicate
         * undefined.
         */
        gint last_write_protect_state;




	/* Status bar. */
	edv_status_bar_struct *status_bar;

} edv_recbin_struct;



extern void EDVRecBinSetTitle(edv_recbin_struct *recbin);

extern void EDVRecBinToolbarRegenerate(edv_recbin_struct *recbin);
extern void EDVRecBinContentsMenuRegenerate(edv_recbin_struct *recbin);

extern void EDVRecBinSyncConfiguration(edv_recbin_struct *recbin);

extern edv_recbin_opid_struct **EDVRecBinOPIDListNew(
	edv_recbin_struct *recbin,	/* Can be NULL. */
        gint *total
);
extern void EDVRecBinOPIDListDelete(
        edv_recbin_opid_struct **list, gint total
);

extern edv_recbin_struct *EDVRecBinNew(gpointer core_ptr);
extern void EDVRecBinReset(edv_recbin_struct *recbin, gbool need_unmap);
extern void EDVRecBinSyncData(edv_recbin_struct *recbin);
extern void EDVRecBinUpdateMenus(edv_recbin_struct *recbin);
extern void EDVRecBinUpdateContentsHeadings(
	edv_recbin_struct *recbin,
        const gint *contents_heading, gint total_contents_headings
);
extern void EDVRecBinSetBusy(edv_recbin_struct *recbin, gbool is_busy);
extern void EDVRecBinMap(edv_recbin_struct *recbin);
extern void EDVRecBinUnmap(edv_recbin_struct *recbin);
extern void EDVRecBinDelete(edv_recbin_struct *recbin);


#endif	/* RECBIN_H */
