/*
                     Edneavour Properties window
 */

#ifndef PROPWIN_H
#define PROPWIN_H

#include <gtk/gtk.h>

#include "piechart.h"

#include "edvtypes.h"
#include "edvobj.h"


/*
 *	Properties window structure:
 */
typedef struct {

	gbool initialized;
	gbool map_state;

	gpointer core_ptr;

	GtkAccelGroup *accelgrp;

	GtkWidget	*toplevel,
			*main_vbox,
			*notebook;

	GtkWidget	*ok_btn,
			*apply_btn,
			*cancel_btn;

	/* Widgets on general page. */
	GtkWidget	*gen_icon_pm,
			*gen_name_label,
			*gen_location_label,
			*gen_timestamps_frame,
			*gen_date_access_label,
                        *gen_date_modified_label,
                        *gen_date_changed_label,
			*gen_date_touch_btn,
			*gen_ownership_frame,
                        *gen_owner_entry,
                        *gen_owner_btn,
                        *gen_group_entry,
                        *gen_group_btn,
			*gen_permissions_frame,
			*gen_uread_check,
                        *gen_uwrite_check,
                        *gen_uexecute_check,
                        *gen_gread_check,
                        *gen_gwrite_check,
                        *gen_gexecute_check,
                        *gen_aread_check,
                        *gen_awrite_check,
                        *gen_aexecute_check,
			*gen_setuid_check,
			*gen_setgid_check,
			*gen_sticky_check;

	/* Widgets on link page. */
	GtkWidget	*link_dest_entry,
			*link_check_btn,
			*link_dest_properties_btn;

	/* Widgets on device page (available when the object is a mount
	 * path, not a device node).
	 */
	gint		dev_num;
        GtkWidget	*dev_icon_pm,
			*dev_device_path_label,
			*dev_mount_path_label,
			*dev_fs_type_label;
	pie_chart_struct	*dev_usage_pc;
        GtkWidget       *dev_check_btn,
			*dev_tools_btn,
			*dev_format_btn;

	/* Widgets on device node page. */
	GtkWidget	*dev_node_major_entry,	/* Major number. */
			*dev_node_minor_entry;	/* Minor number. */

	/* Full path to object being edited. */
	gchar *path;

} edv_propwin_struct;


extern void EDVWriteProtectChangedCB(edv_propwin_struct *pw, gbool state);
extern void EDVPropWinReconfiguredNotifyCB(edv_propwin_struct *pw);

extern edv_propwin_struct *EDVPropWinNew(
	gpointer core_ptr, edv_object_struct *obj
);
extern void EDVPropWinMap(edv_propwin_struct *pw);
extern void EDVPropWinUnmap(edv_propwin_struct *pw);
extern void EDVPropWinDelete(edv_propwin_struct *pw);



#endif	/* PROPWIN_H */
