#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
/* #include <gdk/gdkprivate.h> */

#include "../include/string.h"

#include "guiutils.h"
#include "cdialog.h"
#include "fb.h"
#include "progressdialog.h"

#include "edvtypes.h"
#include "edvcfg.h"
#include "edvmimetypes.h"
#include "edvmimetypesfio.h"
#include "mimetypeswin.h"
#include "endeavour.h"
#include "edvcb.h"
#include "edvutils.h"
#include "edvutilsgtk.h"
#include "edvcfglist.h"
#include "config.h"

#include "images/icon_add_20x20.xpm"
#include "images/icon_edit_20x20.xpm"
#include "images/icon_remove_20x20.xpm"
#include "images/icon_save_20x20.xpm"
#include "images/icon_save_32x32.xpm"
#include "images/icon_import_20x20.xpm"
#include "images/icon_import_32x32.xpm"
#include "images/icon_export_20x20.xpm"
#include "images/icon_export_32x32.xpm"
#include "images/icon_close_20x20.xpm"

#include "images/icon_mimetypes_48x48.xpm"

#include "images/icon_system_object_20x20.xpm"
#include "images/icon_file_extension_20x20.xpm"
#include "images/icon_executable_20x20.xpm"
#include "images/icon_unique_object_20x20.xpm"


static gint EDVMimeTypesListProgressCB(
	gpointer data, gulong pos, gulong max
);

static gint EDVMimeTypesListWinDeleteEventCB(
        GtkWidget *widget, GdkEvent *event, gpointer data
);
static gint EDVMimeTypesListWinKeyEventCB(
        GtkWidget *widget, GdkEventKey *key, gpointer data
);
static gint EDVMimeTypesListWinButtonPressEventCB(
	GtkWidget *widget, GdkEventButton *button, gpointer data
);
static void EDVMimeTypesListWinSelectRowCB(
	GtkCList *clist, gint row, gint column, GdkEvent *event,
        gpointer data
);
static void EDVMimeTypesListWinUnselectRowCB(
        GtkCList *clist, gint row, gint column, GdkEvent *event,
        gpointer data
);
static void EDVMimeTypesListWinFindCB(
        GtkWidget *widget, gpointer data
);
static void EDVMimeTypesListWinAddCB(
        GtkWidget *widget, gpointer data
);
static void EDVMimeTypesListWinEditCB(
        GtkWidget *widget, gpointer data
);
static void EDVMimeTypesListWinRemoveCB(
        GtkWidget *widget, gpointer data
);
static void EDVMimeTypesListWinUpCB(
        GtkWidget *widget, gpointer data
);
static void EDVMimeTypesListWinDownCB(
        GtkWidget *widget, gpointer data
);
static void EDVMimeTypesListWinSaveCB(
        GtkWidget *widget, gpointer data
);
static void EDVMimeTypesListWinImportCB(
        GtkWidget *widget, gpointer data
);
static void EDVMimeTypesListWinExportCB(
        GtkWidget *widget, gpointer data
);
static void EDVMimeTypesListWinCloseCB(
        GtkWidget *widget, gpointer data
);

static void EDVMimeTypesListWinUpdateDisplay(
	edv_mimetype_listwin_struct *lw, edv_mimetype_struct *mt_ptr
);
void EDVMimeTypesListWinSetRow(
        edv_mimetype_listwin_struct *lw,
	gint row, edv_mimetype_struct *mt_ptr
);
void EDVMimeTypesListWinFetchValues(
	edv_mimetype_listwin_struct *lw
);

void EDVMimeTypesListWinMimeTypeAddedCB(
        edv_mimetype_listwin_struct *lw,
        gint mt_num, edv_mimetype_struct *mt_ptr
);
void EDVMimeTypesListWinMimeTypeModifiedCB(
        edv_mimetype_listwin_struct *lw,
        gint mt_num, edv_mimetype_struct *mt_ptr
);
void EDVMimeTypesListWinMimeTypeRemovedCB(
        edv_mimetype_listwin_struct *lw,
        gint mt_num
);

edv_mimetype_listwin_struct *EDVMimeTypesListWinNew(
	gpointer core_ptr
);
void EDVMimeTypesListWinUpdateMenus(
        edv_mimetype_listwin_struct *lw
);
void EDVMimeTypesListWinSetBusy(
        edv_mimetype_listwin_struct *lw, gbool is_busy
);
void EDVMimeTypesListWinMap(
        edv_mimetype_listwin_struct *lw
);
void EDVMimeTypesListWinUnmap(
        edv_mimetype_listwin_struct *lw
);
void EDVMimeTypesListWinDelete(
	edv_mimetype_listwin_struct *lw
);


#define LISTWIN_WIDTH	500
#define LISTWIN_HEIGHT	510

#define LISTWIN_BTN_WIDTH	(100 + (2 * 3))
#define LISTWIN_BTN_HEIGHT	(30 + (2 * 3))

#define LISTWIN_ARROW_WIDTH	20
#define LISTWIN_ARROW_HEIGHT	20

#define LISTWIN_TITLE	"MIME Types"


/*
 *	MIME Types list window save, import, and export progress 
 *	callbacks.
 */
static gint EDVMimeTypesListProgressCB(
        gpointer data, gulong pos, gulong max
)
{
	edv_mimetype_listwin_struct *lw = (edv_mimetype_listwin_struct *)data;
	if(lw == NULL)
	    return(-1);

        if(ProgressDialogIsQuery())
        {
	    if(ProgressDialogStopCount() > 0)
		return(-1);

	    if(max > 0)
	    {
		gfloat progress = (gfloat)pos / (gfloat)max;

		ProgressDialogUpdate(
		    NULL, NULL, NULL, NULL,
                    progress, EDV_DEF_PROGRESS_BAR_TICKS, TRUE
                );
            }
        }

	return(0);
}


/*
 *	MIME Types list window "delete_event" signal callback.
 */
static gint EDVMimeTypesListWinDeleteEventCB(
	GtkWidget *widget, GdkEvent *event, gpointer data
)
{
	edv_mimetype_listwin_struct *lw = (edv_mimetype_listwin_struct *)data;
	if(lw == NULL)
	    return(TRUE);

	EDVMimeTypesListWinCloseCB(NULL, lw);

	return(TRUE);
}

/*
 *	MIME Types list window "key_press_event" signal callback.
 */
static gint EDVMimeTypesListWinKeyEventCB(
        GtkWidget *widget, GdkEventKey *key, gpointer data
)
{
        static gbool reenterent = FALSE;
        gint status = FALSE;
        gint etype;
        guint keyval, state;
        gbool press;
        edv_core_struct *core_ptr;
        GtkCList *clist;
        edv_mimetype_listwin_struct *lw = (edv_mimetype_listwin_struct *)data;
        if(lw == NULL)
            return(status);

        clist = (GtkCList *)lw->mimetypes_clist;
        if(clist == NULL)
            return(status);

        core_ptr = (edv_core_struct *)lw->core_ptr;
        if(core_ptr == NULL)
            return(status);

        if(reenterent)
            return(status);
        else
            reenterent = TRUE;

        /* Get event type. */
        etype = key->type;

        /* Get other key event values. */
        press = (etype == GDK_KEY_PRESS) ? TRUE : FALSE;
        keyval = key->keyval;
        state = key->state;

/* Macro to emit a signal stop for a key press or release depending
 * on the current event's type.
 */
#define DO_STOP_KEY_SIGNAL_EMIT \
{ \
 gtk_signal_emit_stop_by_name( \
  GTK_OBJECT(widget), \
  press ? "key_press_event" : "key_release_event" \
 ); \
}

/* Macro to clamp the GtkAdjustment adj and emit a "value_changed"
 * signal.
 */
#define DO_ADJ_CLAMP_EMIT       \
{ \
 if(adj->value > (adj->upper - adj->page_size)) \
  adj->value = adj->upper - adj->page_size; \
\
 if(adj->value < adj->lower) \
  adj->value = adj->lower; \
\
 gtk_signal_emit_by_name( \
  GTK_OBJECT(adj), "value_changed" \
 ); \
}

/* Macro to clamp the GtkCList clist's focus_row. */
#define DO_CLIST_FOCUS_ROW_CLAMP        \
{ \
 if(clist->focus_row >= clist->rows) \
  clist->focus_row = clist->rows - 1; \
 if(clist->focus_row < 0) \
  clist->focus_row = 0; \
}

	if(1)
	{
            gint row;
	    GList *glist;
            GtkCList *clist = GTK_CLIST(widget);


            /* Get last selected row. */
	    row = EDVCListGetSelectedLast(clist, NULL);

            /* Handle by key value. */
            switch(keyval)
            {
              case GDK_Return:
              case GDK_KP_Enter:
              case GDK_ISO_Enter:
              case GDK_3270_Enter:
                if(press)
                {
		    EDVMimeTypesListWinEditCB(NULL, lw);
		}
		DO_STOP_KEY_SIGNAL_EMIT
		status = TRUE;
                break;

              case GDK_Delete:
                if(press)
                {
		    EDVMimeTypesListWinRemoveCB(NULL, lw);
                }
                DO_STOP_KEY_SIGNAL_EMIT
                status = TRUE;
                break;

              case GDK_space:
              case GDK_KP_Space:
                row = clist->focus_row;
                if((row >= 0) && (row < clist->rows) && press)
                {
                    gbool already_selected = FALSE;

                    /* Check if this row is already selected. */
                    glist = clist->selection;
                    while(glist != NULL)
                    {
                        if(row == (gint)glist->data)
                        {
                            already_selected = TRUE;
                            break;
                        }
                        glist = glist->next;
                    }

                    gtk_clist_freeze(clist);
                    if(already_selected)
                        gtk_clist_unselect_row(clist, row, 0);
                    else
                        gtk_clist_select_row(clist, row, 0);
                    gtk_clist_thaw(clist);
                }
                DO_STOP_KEY_SIGNAL_EMIT
                status = TRUE;
                break;

              case GDK_Up:
              case GDK_KP_Up:
                if(state & GDK_CONTROL_MASK)
                {
                    /* Get adjustment and scroll up. */
                    GtkAdjustment *adj = clist->vadjustment;
                    if((adj != NULL) && press)
                    {
                        gtk_clist_freeze(clist);
                        adj->value -= adj->step_increment;
                        DO_ADJ_CLAMP_EMIT
                        gtk_clist_thaw(clist);
                    }
                    DO_STOP_KEY_SIGNAL_EMIT
                    status = TRUE;
                }
                else
                {
                    if(press)
                    {
                        gint prev_focus_row = clist->focus_row;

                        gtk_clist_freeze(clist);
                        clist->focus_row--;
                        DO_CLIST_FOCUS_ROW_CLAMP

                        if(gtk_clist_row_is_visible(
                            clist, clist->focus_row) != GTK_VISIBILITY_FULL
                        )
                            gtk_clist_moveto(
                                clist,
                                clist->focus_row, -1,   /* Row, column. */
                                0.5, 0.0                /* Row, column. */
                            );

                        if(state & GDK_SHIFT_MASK)
                        {
                            gtk_clist_select_row(
                                clist, prev_focus_row, 0
                            );
                            gtk_clist_select_row(
                                clist, clist->focus_row, 0
                            );
                        }
                        gtk_clist_thaw(clist);
                    }
                    DO_STOP_KEY_SIGNAL_EMIT
                    status = TRUE;
                }
                break;

              case GDK_Down:
              case GDK_KP_Down:
                if(state & GDK_CONTROL_MASK)
                {
                    /* Get adjustment and scroll down. */
                    GtkAdjustment *adj = clist->vadjustment;
                    if((adj != NULL) && press)
                    {
                        gtk_clist_freeze(clist);
                        adj->value += adj->step_increment;
                        DO_ADJ_CLAMP_EMIT
                        gtk_clist_thaw(clist);
                    }
                    DO_STOP_KEY_SIGNAL_EMIT
                    status = TRUE;
                }
                else
                {
                    if(press)
                    {
                        gint prev_focus_row = clist->focus_row;

                        gtk_clist_freeze(clist);
                        clist->focus_row++;
                        DO_CLIST_FOCUS_ROW_CLAMP

                        if(gtk_clist_row_is_visible(
                            clist, clist->focus_row) != GTK_VISIBILITY_FULL
                        )
                            gtk_clist_moveto(
                                clist,
                                clist->focus_row, -1,   /* Row, column. */
                                0.5, 0.0                /* Row, column. */
			    );

                        if(state & GDK_SHIFT_MASK)
                        {
                            gtk_clist_select_row(
                                clist, prev_focus_row, 0
                            );
                            gtk_clist_select_row(
                                clist, clist->focus_row, 0
                            );
                        }
                        gtk_clist_thaw(clist);
                    }
                    DO_STOP_KEY_SIGNAL_EMIT
                    status = TRUE;
                }
		break;

              case GDK_Left:
              case GDK_KP_Left:
                if(1)
                {
                    /* Get adjustment and scroll left. */
                    GtkAdjustment *adj = clist->hadjustment;
                    if((adj != NULL) && press)
                    {
                        gtk_clist_freeze(clist);
                        if(state & GDK_CONTROL_MASK)
                            adj->value -= adj->step_increment * 4;
                        else if(state & GDK_SHIFT_MASK)
                            adj->value = adj->lower;
                        else
                            adj->value -= adj->step_increment;
                        DO_ADJ_CLAMP_EMIT
                        gtk_clist_thaw(clist);
                    }
                }
                DO_STOP_KEY_SIGNAL_EMIT
                status = TRUE;
                break;

              case GDK_Right:
              case GDK_KP_Right:
                if(1)
                {
                    /* Get adjustment and scroll right. */
                    GtkAdjustment *adj = clist->hadjustment;
                    if((adj != NULL) && press)
                    {
                        gtk_clist_freeze(clist);
                        if(state & GDK_CONTROL_MASK)
                            adj->value += adj->step_increment * 4;
                        else if(state & GDK_SHIFT_MASK)
                            adj->value = adj->upper - adj->page_size;
                        else
                            adj->value += adj->step_increment;
                        DO_ADJ_CLAMP_EMIT
                        gtk_clist_thaw(clist);
                    }
                }
                DO_STOP_KEY_SIGNAL_EMIT
                status = TRUE;
                break;

              case GDK_Page_Up:
              case GDK_KP_Page_Up:
                if(1)
                {
                    /* Get adjustment and scroll up one page. */
                    GtkAdjustment *adj = clist->vadjustment;
                    if((adj != NULL) && press)
                    {
                        gtk_clist_freeze(clist);
                        adj->value -= adj->page_increment;
                        DO_ADJ_CLAMP_EMIT
                        gtk_clist_thaw(clist);
                    }
                }
                DO_STOP_KEY_SIGNAL_EMIT
                status = TRUE;
                break;

              case GDK_Page_Down:
              case GDK_KP_Page_Down:
                if(1)
                {
                    /* Get adjustment and scroll down one page. */
                    GtkAdjustment *adj = clist->vadjustment;
                    if((adj != NULL) && press)
                    {
                        gtk_clist_freeze(clist);
                        adj->value += adj->page_increment;
                        DO_ADJ_CLAMP_EMIT
                        gtk_clist_thaw(clist);
                    }
                }
                DO_STOP_KEY_SIGNAL_EMIT
                status = TRUE;
                break;

              case GDK_Home:
              case GDK_KP_Home:
                if(1)
                {
                    /* Get adjustment and scroll all the way up. */
                    GtkAdjustment *adj = clist->vadjustment;
                    if((adj != NULL) && press)
                    {
                        gtk_clist_freeze(clist);
                        adj->value = adj->lower;
                        DO_ADJ_CLAMP_EMIT
                        gtk_clist_thaw(clist);
                    }
                }
                DO_STOP_KEY_SIGNAL_EMIT
                status = TRUE;
                break;

              case GDK_End:
              case GDK_KP_End:
                if(1)
                {
                    /* Get adjustment and scroll all the way down. */
                    GtkAdjustment *adj = clist->vadjustment;
                    if((adj != NULL) && press)
                    {
                        gtk_clist_freeze(clist);
                        adj->value = adj->upper - adj->page_size;
                        DO_ADJ_CLAMP_EMIT
                        gtk_clist_thaw(clist);
                    }
                }
                DO_STOP_KEY_SIGNAL_EMIT
                status = TRUE;
                break;

            }
	}

#undef DO_CLIST_FOCUS_ROW_CLAMP
#undef DO_ADJ_CLAMP_EMIT
#undef DO_STOP_KEY_SIGNAL_EMIT

	reenterent = FALSE;
	return(status);
}

/*
 *	MIME Types list window "button_press_event" signal callback.
 */
static gint EDVMimeTypesListWinButtonPressEventCB(
        GtkWidget *widget, GdkEventButton *button, gpointer data
)
{
        static gbool reenterent = FALSE;
        gint etype;
        edv_core_struct *core_ptr;
        GtkCList *clist;
        edv_mimetype_listwin_struct *lw = (edv_mimetype_listwin_struct *)data;
        if(lw == NULL)
            return(TRUE);

        clist = (GtkCList *)lw->mimetypes_clist;
        if(clist == NULL)
            return(TRUE);

        core_ptr = (edv_core_struct *)lw->core_ptr;
        if(core_ptr == NULL)
            return(TRUE);

        if(reenterent)
            return(TRUE);
        else
            reenterent = TRUE;

	if(clist->clist_window != ((GdkEventAny *)button)->window)
	{
	    reenterent = FALSE;
	    return(TRUE);
	}

        /* Get event type. */
        etype = button->type;

        if(1)
        {
            gint row, column;
            GtkWidget *w;


            /* Find row and column based on given coordinates. */
            if(!gtk_clist_get_selection_info(
                clist, button->x, button->y, &row, &column
            ))
            {
                row = -1;
                column = 0;
            }

            /* Handle by event type. */
            switch(etype)
            {
              case GDK_2BUTTON_PRESS:
                /* Handle by button number. */
                switch(button->button)
                {
                  case 1:
		    EDVMimeTypesListWinEditCB(NULL, lw);
		    break;
		}
		break;

              case GDK_BUTTON_PRESS:
                /* Handle by button number. */
                switch(button->button)
                {
                  case 3:
		    /* Select row before mapping menu? */
                    if(EDVCFGItemListGetValueI(
                        core_ptr->cfg_list, EDV_CFG_PARM_RIGHT_CLICK_MENU_SELECTS
                    ) && (row >= 0) && (row < clist->rows))
                    {
                        /* Select the row that the button was pressed over.
                         * if no key modifiers are held then this will also
                         * unselect all previously selected rows.
                         */
                        gtk_clist_freeze(clist);
                        if(!(button->state & GDK_CONTROL_MASK) &&
                           !(button->state & GDK_SHIFT_MASK)
                        )
                            gtk_clist_unselect_all(clist);
                        clist->focus_row = row;
                        gtk_clist_select_row(clist, row, 0);
                        gtk_clist_thaw(clist);
		    }

                    /* Get right click menu widget and map it. */
                    w = lw->menu;
                    if(w != NULL)
                        gtk_menu_popup(
                            GTK_MENU(w), NULL, NULL,
                            NULL, NULL,
                            button->button, button->time
                        );
                    break;
                }
                break;
            }
        }


        reenterent = FALSE;

	return(TRUE);
}

/*
 *	MIME Types list window "select_row" signal callback.
 */
static void EDVMimeTypesListWinSelectRowCB(
        GtkCList *clist, gint row, gint column, GdkEvent *event,
        gpointer data
)
{
        static gbool reenterent = FALSE;
	edv_core_struct *core_ptr;
        edv_mimetype_listwin_struct *lw = (edv_mimetype_listwin_struct *)data;
        if(lw == NULL)
            return;

	core_ptr = (edv_core_struct *)lw->core_ptr;
	if(core_ptr == NULL)
	    return;

        if(reenterent)
            return;
        else
            reenterent = TRUE;

	/* Check which clist this event is for. */
	if(GTK_WIDGET(clist) == lw->mimetypes_clist)
	{
	    /* Check if selected row is fully visible, if not then
	     * adjust scroll position to try and make it visible.
	     */
	    if(gtk_clist_row_is_visible(clist, row) !=
		GTK_VISIBILITY_FULL
	    )
		gtk_clist_moveto(
		    clist,
		    row, -1,	/* Row, column. */
		    0.5, 0.0	/* Row, column. */
		);

	    /* Update displayed MIME Types structure. */
            if((row >= 0) && (row < core_ptr->total_mimetypes))
                EDVMimeTypesListWinUpdateDisplay(
                    lw,  core_ptr->mimetype[row]
                );

	    EDVMimeTypesListWinUpdateMenus(lw);
	}

        reenterent = FALSE;
}

/*
 *	MIME Types list window "unselect_row" signal callback.
 */
static void EDVMimeTypesListWinUnselectRowCB(
        GtkCList *clist, gint row, gint column, GdkEvent *event,
        gpointer data
)
{
        static gbool reenterent = FALSE;
        edv_core_struct *core_ptr;
        edv_mimetype_listwin_struct *lw = (edv_mimetype_listwin_struct *)data;
        if(lw == NULL)
            return;

        core_ptr = (edv_core_struct *)lw->core_ptr;
        if(core_ptr == NULL)
            return;

        if(reenterent)
            return;
        else
            reenterent = TRUE;

        /* Check which clist this event is for. */
        if(GTK_WIDGET(clist) == lw->mimetypes_clist)
        {
	    EDVMimeTypesListWinUpdateDisplay(lw, NULL);
            EDVMimeTypesListWinUpdateMenus(lw);
        }

        reenterent = FALSE;
}

/*
 *	MIME Type find by type entry "activate" signal callback.
 */
static void EDVMimeTypesListWinFindCB(
        GtkWidget *widget, gpointer data
)
{
        static gbool reenterent = FALSE;
	gint find_itterations = 0;
	gint row, column, sel_row;
	const gchar *find_str;
	GtkEntry *entry;
        GtkCList *clist;

        gchar *cell_text;
        guint8 spacing;
        GdkPixmap *pixmap;
        GdkBitmap *mask;

        edv_mimetype_listwin_struct *lw = (edv_mimetype_listwin_struct *)data;
        if(lw == NULL)
            return;

	entry = (GtkEntry *)lw->find_entry;
	if(entry == NULL)
	    return;

        clist = (GtkCList *)lw->mimetypes_clist;
        if(clist == NULL)
            return;

        if(reenterent)
            return;
        else
            reenterent = TRUE;


	/* Get string to match for from entry. */
        find_str = gtk_entry_get_text(entry);
        if(find_str == NULL)
	{
	    reenterent = FALSE;
            return;
	}
	if(*find_str == '\0')
	{
            reenterent = FALSE;
            return;
        }

	/* Get selected row + 1 or 0 if none. */
	sel_row = EDVCListGetSelectedLast(clist, NULL);
	if(sel_row < 0)
            sel_row = 0;
	else
	    sel_row++;

	/* Iterate through rows, checking each Type column to see if
	 * therer is any partial patches.
	 */
	do
	{
	    /* Iterate from selected row to end. */
	    for(row = sel_row; row < clist->rows; row++)
	    {
		/* Iterate through all cells on this row. */
		for(column = 0; column < clist->columns; column++)
		{
		    /* Begin fetching current cell's text by its type. */
		    cell_text = NULL;
		    switch((gint)gtk_clist_get_cell_type(clist, row, column))
		    {
		      case GTK_CELL_TEXT:
			gtk_clist_get_text(clist, row, column, &cell_text);
			break;

		      case GTK_CELL_PIXTEXT:
			gtk_clist_get_pixtext(
			    clist, row, column, &cell_text,
			    &spacing, &pixmap, &mask
			);
			break;
		    }
		    /* Got cell text? */
		    if(cell_text != NULL)
		    {
			/* Find string found inside cell text string? */
			if(strcasestr(cell_text, find_str))
			    break;
		    }
		}
                /* If column itteration broke before all columns were
                 * iterated through then that implies a match was made.
                 */
                if(column < clist->columns)
                    break;
            }
	    /* Got match? */
            if(row < clist->rows)
		break;
	    else
		find_itterations++;

	    /* Reset sel_row to 0 so that find starts at beginning. */
	    sel_row = 0;

	} while(find_itterations < 2);

	/* Got match? */
	if(row < clist->rows)
	{
	    /* Select new matched row. */
	    gtk_clist_unselect_all(clist);
	    gtk_clist_select_row(clist, row, 0);
	}

        reenterent = FALSE;
}

/*
 *      MIME Types list window add button callback.
 */
static void EDVMimeTypesListWinAddCB(
        GtkWidget *widget, gpointer data
)
{
        static gbool reenterent = FALSE;
	gint row, mt_num;
	edv_mimetype_struct *mt_ptr;
	GtkCList *clist;
	edv_core_struct *core_ptr;
	edv_mimetype_editwin_struct *ew;
        edv_mimetype_listwin_struct *lw = (edv_mimetype_listwin_struct *)data;
        if(lw == NULL)
            return;

        core_ptr = (edv_core_struct *)lw->core_ptr;
        if(core_ptr == NULL)
            return;

        clist = (GtkCList *)lw->mimetypes_clist;
        if(clist == NULL)
            return;

        if(reenterent)
            return;
        else
            reenterent = TRUE;

	EDVMimeTypesListWinSetBusy(lw, TRUE);

        /* Get last selected row. */
        row = EDVCListGetSelectedLast(clist, NULL);

        /* Get MIME Type number index as the selected row's index. */
	mt_num = row;

	/* Create a new MIME Type at the selected position specified by
	 * mt_num relative to the core structure.
	 */
	if((mt_num < 0) || (mt_num >= core_ptr->total_mimetypes))
	{
	    /* Append. */
	    gint n;

	    /* Sanitize total. */
	    if(core_ptr->total_mimetypes < 0)
		core_ptr->total_mimetypes = 0;

	    /* Allocate more pointers. */
	    n = core_ptr->total_mimetypes;
	    core_ptr->total_mimetypes = n + 1;
	    core_ptr->mimetype = (edv_mimetype_struct **)g_realloc(
		core_ptr->mimetype,
		core_ptr->total_mimetypes * sizeof(edv_mimetype_struct *)
	    );
	    if(core_ptr->mimetype == NULL)
	    {
		core_ptr->total_mimetypes = 0;
		EDVMimeTypesListWinSetBusy(lw, FALSE);
		reenterent = FALSE;
		return;
	    }

	    /* Create new MIME Type structure. */
            mt_num = n;
	    core_ptr->mimetype[mt_num] = mt_ptr = EDVMimeTypeNew(
		EDV_MIMETYPE_CLASS_FORMAT,
		NULL,
		"misc/untitled", "New MIME Type"
	    );
	    if(mt_ptr == NULL)
	    {
                EDVMimeTypesListWinSetBusy(lw, FALSE);
                reenterent = FALSE;
                return;
	    }
	}
	else
	{
	    /* Insert. */
            gint i, n;

            /* Sanitize total. */
            if(core_ptr->total_mimetypes < 0)
                core_ptr->total_mimetypes = 0;

            /* Allocate more pointers. */
            n = core_ptr->total_mimetypes;
            core_ptr->total_mimetypes = n + 1;
            core_ptr->mimetype = (edv_mimetype_struct **)g_realloc(
                core_ptr->mimetype,
                core_ptr->total_mimetypes * sizeof(edv_mimetype_struct *)
            );
            if(core_ptr->mimetype == NULL)
            {
                core_ptr->total_mimetypes = 0;
                EDVMimeTypesListWinSetBusy(lw, FALSE);
                reenterent = FALSE;
                return;
            }

	    /* Shift pointers. */
	    for(i = n; i > mt_num; i--)
		core_ptr->mimetype[i] = core_ptr->mimetype[i - 1];

            /* Create new MIME Type structure. */
            core_ptr->mimetype[mt_num] = mt_ptr = EDVMimeTypeNew(
                EDV_MIMETYPE_CLASS_FORMAT, NULL,
                "misc/untitled", "New MIME Type"
            );
            if(mt_ptr == NULL)
            {
                EDVMimeTypesListWinSetBusy(lw, FALSE);
                reenterent = FALSE;
                return;
            }
	}


        /* Send MIME Type added signal to all of endeavour's resources. */
        EDVMimeTypeAddedEmit(core_ptr, mt_num, mt_ptr);

	/* The new MIME Type should be added to our MIME Types list, now
	 * select the new MIME Type.
	 */
	gtk_clist_unselect_all(clist);
	gtk_clist_select_row(clist, mt_num, 0);


        EDVMimeTypesListWinSetBusy(lw, FALSE);


	/* Map MIME Types edit window, creating it as needed. */
	ew = lw->editwin;
	if(ew == NULL)
	    lw->editwin = ew = EDVMimeTypesEditWinNew(
		core_ptr, lw
	    );
	if(ew != NULL)
	{
            EDVCenterWindowToWindow(lw->toplevel, ew->toplevel);
	    EDVMimeTypesEditWinMap(ew);
	    EDVMimeTypesEditWinFetchValues(ew, mt_num);
	}

	EDVMimeTypesListWinUpdateMenus(lw);

        reenterent = FALSE;
}

/*
 *      MIME Types list window edit button callback.
 */
static void EDVMimeTypesListWinEditCB(
        GtkWidget *widget, gpointer data
)
{
        static gbool reenterent = FALSE;
        gint row, mt_num;
	edv_mimetype_struct *mt_ptr;
        GtkCList *clist;
        edv_core_struct *core_ptr;
        edv_mimetype_editwin_struct *ew;
        edv_mimetype_listwin_struct *lw = (edv_mimetype_listwin_struct *)data;
        if(lw == NULL)
            return;

        core_ptr = (edv_core_struct *)lw->core_ptr;
        if(core_ptr == NULL)
            return;

        clist = (GtkCList *)lw->mimetypes_clist;
        if(clist == NULL)
            return;

        if(reenterent)
            return;
        else
            reenterent = TRUE;

        /* Get last selected row. */
        row = EDVCListGetSelectedLast(clist, NULL);

        /* Get MIME Type number index as the selected row's index. */
	mt_num = row;

        if((mt_num >= 0) && (mt_num < core_ptr->total_mimetypes))
            mt_ptr = core_ptr->mimetype[mt_num];
        else
            mt_ptr = NULL;
        if(mt_ptr == NULL)
        {
            reenterent = FALSE;
            return;
        }

#if 0
	/* Check if this MIME Type is internally created by this program
	 * or loaded from a global configuration.
	 */
/* Skip this check, the MIME Types edit window will make the buttons
 * insensitive if this is read only.
 */
        if(mt_ptr->read_only)
        {
	    gchar *buf = g_strdup_printf(
"MIME Type `%s' cannot be edited, because it\n\
was either created internally or loaded from a global\n\
configuration.",
		mt_ptr->type
	    );

            CDialogSetTransientFor(lw->toplevel);
            CDialogGetResponse(
		"Edit Failed",
		buf,
                NULL,
                CDIALOG_ICON_WARNING,
                CDIALOG_BTNFLAG_OK,
                CDIALOG_BTNFLAG_OK
            );
            CDialogSetTransientFor(NULL);

	    g_free(buf);

            reenterent = FALSE;
            return;
        }
#endif


        /* Map MIME Types edit window, creating it as needed. */
        ew = lw->editwin;
        if(ew == NULL)
            lw->editwin = ew = EDVMimeTypesEditWinNew(
                core_ptr, lw
            );
        if(ew != NULL)
        {
            EDVCenterWindowToWindow(lw->toplevel, ew->toplevel);
            EDVMimeTypesEditWinMap(ew);
            EDVMimeTypesEditWinFetchValues(ew, mt_num);
        }

	EDVMimeTypesListWinUpdateMenus(lw);

        reenterent = FALSE;
}

/*
 *      MIME Types list window remove button callback.
 */
static void EDVMimeTypesListWinRemoveCB(
        GtkWidget *widget, gpointer data
)
{
        static gbool reenterent = FALSE;
	gint i;
	edv_mimetype_struct **list;
	gint total;
	gint mt_num;
	edv_mimetype_struct *mt_ptr;
	GList *glist;
        GtkCList *clist;
        edv_core_struct *core_ptr;
        edv_mimetype_listwin_struct *lw = (edv_mimetype_listwin_struct *)data;
        if(lw == NULL)
            return;

        core_ptr = (edv_core_struct *)lw->core_ptr;
        if(core_ptr == NULL)
            return;

        clist = (GtkCList *)lw->mimetypes_clist;
        if(clist == NULL)
            return;

        if(reenterent)
            return;
        else
            reenterent = TRUE;

	/* Iterate through selected MIME Types, check if any are marked
	 * as internal which means they cannot be removed.
	 */
	glist = clist->selection;
	while(glist != NULL)
	{
	    mt_num = (gint)glist->data;
	    if((mt_num >= 0) && (mt_num < core_ptr->total_mimetypes))
		mt_ptr = core_ptr->mimetype[mt_num];
	    else
		mt_ptr = NULL;
	    if((mt_ptr != NULL) ? mt_ptr->read_only : FALSE)
	    {
		gchar *buf = g_strdup_printf(
"MIME Type `%s' cannot be removed, because it\n\
was either created internally or loaded from a global\n\
configuration.",
		    mt_ptr->type
		);

		CDialogSetTransientFor(lw->toplevel);
                CDialogGetResponse(
		    "Remove Failed",
		    buf,
                    NULL,
                    CDIALOG_ICON_WARNING,
                    CDIALOG_BTNFLAG_OK,
                   CDIALOG_BTNFLAG_OK
                );
                CDialogSetTransientFor(NULL);

		g_free(buf);

                reenterent = FALSE;
                return;
            }

	    glist = glist->next;
	}


	/* Generate a list of MIME Type pointers reffering to the
	 * selected MIME Types to be removed. Only the pointer array is
	 * allocated by this function, each pointer in the array is
	 * shared.
	 */
	list = NULL;
	total = 0;
	glist = clist->selection;
        while(glist != NULL)
        {
	    mt_num = (gint)glist->data;
            if((mt_num >= 0) && (mt_num < core_ptr->total_mimetypes))
                mt_ptr = core_ptr->mimetype[mt_num];
            else
                mt_ptr = NULL;

	    if(mt_ptr != NULL)
	    {
		i = total;
		total = i + 1;
		list = (edv_mimetype_struct **)g_realloc(
		    list,
		    total * sizeof(edv_mimetype_struct *)
		);
		if(list == NULL)
		    total = 0;
		else
		    list[i] = mt_ptr;
	    }

	    glist = glist->next;
	}

	/* Nothing to remove? */
	if(total <= 0)
	{
            g_free(list);
            list = NULL;
            total = 0;

	    reenterent = FALSE;

	    return;
	}

	/* Get pointer to first selected MIME Type if and only if
	 * exactly one MIME Type is selected.
	 */
	mt_num = -1;
	mt_ptr = (total == 1) ? list[0] : NULL;

	/* Confirm removal of MIME Type. */
	if(1)
	{
	    gint status;
	    gchar *buf;


	    if((mt_ptr != NULL) ? (mt_ptr->type != NULL) : FALSE)
		buf = g_strdup_printf(
"Are you sure you want to remove MIME Type\n\
\"%s\"?",
		    mt_ptr->type
		);
	    else
		buf = g_strdup_printf(
"Are you sure you want to remove %i MIME Types?",
		    total
		);

            CDialogSetTransientFor(lw->toplevel);
            status = CDialogGetResponse(
		"Confirm Remove",
		buf,
		NULL,
                CDIALOG_ICON_WARNING,
                CDIALOG_BTNFLAG_YES | CDIALOG_BTNFLAG_NO,
                CDIALOG_BTNFLAG_NO
            );
            CDialogSetTransientFor(NULL);

	    g_free(buf);

	    switch(status)
	    {
	      case CDIALOG_RESPONSE_YES_TO_ALL:
	      case CDIALOG_RESPONSE_YES:
	      case CDIALOG_RESPONSE_OK:
		break;

	      default:
		g_free(list);
		list = NULL;
		total = 0;

		reenterent = FALSE;

		return;
		break;
	    }
	}


	EDVMimeTypesListWinSetBusy(lw, TRUE);


	/* Begin removing selected MIME Types. */
	for(i = 0; i < total; i++)
	{
	    mt_ptr = list[i];
	    if(mt_ptr == NULL)
		continue;

	    /* Get MIME Type number index from the selected MIME Type
	     * pointer.
	     */
	    for(mt_num = 0; mt_num < core_ptr->total_mimetypes; mt_num++)
	    {
		if(core_ptr->mimetype[mt_num] == mt_ptr)
		    break;
	    }
	    /* MIME Type pointer is not in the core structure's list of
	     * MIME Types?
	     */
	    if(mt_num >= core_ptr->total_mimetypes)
		continue;


	    /* Delete MIME Type from the core structure's list of MIME
	     * Types.
	     */
	    EDVMimeTypeDelete(core_ptr->mimetype[mt_num]);
	    core_ptr->mimetype[mt_num] = NULL;

	    /* Value of MIME Type number index and pointer should now be
	     * considered invalid, however we will not reset them as they
	     * need to be used to emit the MIME Type removed signal
	     * further below.
	     */

	    /* Reduce total. */
	    core_ptr->total_mimetypes--;
	    if(core_ptr->total_mimetypes < 0)
		core_ptr->total_mimetypes = 0;

	    /* Shift pointers and reallocate if there are still other
	     * MIME Types?
	     */
	    if(core_ptr->total_mimetypes > 0)
	    {
		gint n;

		for(n = mt_num; n < core_ptr->total_mimetypes; n++)
		    core_ptr->mimetype[n] = core_ptr->mimetype[n + 1];

		core_ptr->mimetype = (edv_mimetype_struct **)g_realloc(
		    core_ptr->mimetype,
		    core_ptr->total_mimetypes * sizeof(edv_mimetype_struct *)
		);
		if(core_ptr->mimetype == NULL)
		{
		    core_ptr->total_mimetypes = 0;
		}
	    }
	    else
	    {
		g_free(core_ptr->mimetype);
		core_ptr->mimetype = NULL;
	    }

	    /* Send MIME Type removed signal to all of endeavour's
	     * resources.
	     */
	    EDVMimeTypeRemovedEmit(core_ptr, mt_num);
	}


	EDVMimeTypesListWinSetBusy(lw, FALSE);


	/* Deallocate pointer array to selected MIME Types but not each
	 * pointer since they are shared and probably invalid after the
	 * removal of each pointer.
	 */
	g_free(list);
	list = NULL;
	total = 0;

        reenterent = FALSE;
}

/*
 *      MIME Types list window move up button callback.
 */
static void EDVMimeTypesListWinUpCB(
        GtkWidget *widget, gpointer data
)
{
        static gbool reenterent = FALSE;
	gint row;
	GtkCList *clist;
        edv_core_struct *core_ptr;
        edv_mimetype_listwin_struct *lw = (edv_mimetype_listwin_struct *)data;
        if(lw == NULL)
            return;

        core_ptr = (edv_core_struct *)lw->core_ptr;
        if(core_ptr == NULL)
            return;

	clist = (GtkCList *)lw->mimetypes_clist;
	if(clist == NULL)
	    return;

        if(reenterent)
            return;
        else
            reenterent = TRUE;


        EDVMimeTypesListWinSetBusy(lw, TRUE);

        /* Get last selected row. */
        row = EDVCListGetSelectedLast(clist, NULL);

        /* Can shift selected row up? */
        if(row > 0)
        {
            edv_mimetype_struct *tmp_mt_ptr;

            /* Shift clist rows. */
            gtk_clist_freeze(clist);
            gtk_clist_swap_rows(clist, row, row - 1);
            gtk_clist_thaw(clist);

            /* Shift MIME Type structure pointers on the core structure's
             * MIME Types list.
             */
            tmp_mt_ptr = core_ptr->mimetype[row - 1];
            core_ptr->mimetype[row - 1] = core_ptr->mimetype[row];
            core_ptr->mimetype[row] = tmp_mt_ptr;

            /* Emit MIME Type modified signal for both MIME Types involved
	     * in the shift.
             */
            EDVMimeTypeModifiedEmit(
                core_ptr,
                row - 1,
                core_ptr->mimetype[row - 1]
            );
            EDVMimeTypeModifiedEmit(
                core_ptr,
                row,
                core_ptr->mimetype[row]
            );

            EDVMimeTypesListWinUpdateMenus(lw);
	}

        EDVMimeTypesListWinSetBusy(lw, FALSE);

        reenterent = FALSE;
}

/*
 *      MIME Types list window move down button callback.
 */
static void EDVMimeTypesListWinDownCB(
        GtkWidget *widget, gpointer data
)
{
	static gbool reenterent = FALSE;
	gint row;
        GtkCList *clist;
        edv_core_struct *core_ptr;
        edv_mimetype_listwin_struct *lw = (edv_mimetype_listwin_struct *)data;
        if(lw == NULL)
            return;

        core_ptr = (edv_core_struct *)lw->core_ptr;
        if(core_ptr == NULL)
            return;

        clist = (GtkCList *)lw->mimetypes_clist;
        if(clist == NULL)
            return;

	if(reenterent)
	    return;
	else
	    reenterent = TRUE;


        EDVMimeTypesListWinSetBusy(lw, TRUE);

	/* Get last selected row. */
        row = EDVCListGetSelectedLast(clist, NULL);

	/* Can shift selected row down? */
	if((row > -1) && (row < (clist->rows - 1)))
	{
            edv_mimetype_struct *tmp_mt_ptr;

            /* Shift clist rows. */
	    gtk_clist_freeze(clist);
	    gtk_clist_swap_rows(clist, row, row + 1);
	    gtk_clist_thaw(clist);

            /* Shift MIME Type structure pointers on the core structure's
             * MIME Types list.
             */
            tmp_mt_ptr = core_ptr->mimetype[row + 1];
            core_ptr->mimetype[row + 1] = core_ptr->mimetype[row];
            core_ptr->mimetype[row] = tmp_mt_ptr;

            /* Emit MIME Type modified signal for both MIME Types involved
             * in the shift.
             */
            EDVMimeTypeModifiedEmit(
                core_ptr,
                row + 1,
                core_ptr->mimetype[row + 1]
            );
            EDVMimeTypeModifiedEmit(
                core_ptr,
                row,
                core_ptr->mimetype[row]
            );

            EDVMimeTypesListWinUpdateMenus(lw);
	}

        EDVMimeTypesListWinSetBusy(lw, FALSE);

	reenterent = FALSE;
}


/*
 *	MIME Types list window save MIME Types callback.
 */
static void EDVMimeTypesListWinSaveCB(
        GtkWidget *widget, gpointer data
)
{
        static gbool reenterent = FALSE;
	const gchar *cstrptr;
	GtkWidget *toplevel;
	edv_core_struct *core_ptr;
        edv_mimetype_listwin_struct *lw = (edv_mimetype_listwin_struct *)data;
        if(lw == NULL)
            return;

        core_ptr = (edv_core_struct *)lw->core_ptr;
        if(core_ptr == NULL)
            return;

        if(reenterent)
            return;
        else
            reenterent = TRUE;


	toplevel = lw->toplevel;

        EDVMimeTypesListWinSetBusy(lw, TRUE);


	/* Get MIME Types file path. */
	cstrptr = EDVCFGItemListGetValueS(
            core_ptr->cfg_list, EDV_CFG_PARM_FILE_MIME_TYPES
        );
        if(cstrptr != NULL)
        {
	    struct stat lstat_buf;
	    gchar *path = g_strdup(cstrptr);
	    gboolean object_existed = access(path, F_OK) ? FALSE : TRUE;

	    /* Map progress dialog. */
            ProgressDialogSetTransientFor(toplevel);
	    ProgressDialogMap(
		"Saving MIME Types",
		"Saving MIME Types...",
		(const u_int8_t **)icon_save_32x32_xpm,
		"Stop"
	    );

	    /* Begin saving MIME Types. */
            EDVMimeTypeListSaveToFile(
                path,
                core_ptr->mimetype, core_ptr->total_mimetypes,
		FALSE,		/* Do not include read only MIME Types. */
                EDVMimeTypesListProgressCB, lw
            );
	    if(!lstat(path, &lstat_buf))
	    {
		if(object_existed)
		    EDVObjectModifiedEmit(core_ptr, path, NULL, &lstat_buf);
		else
		    EDVObjectAddedEmit(core_ptr, path, &lstat_buf);
	    }
            g_free(path);
        }


        EDVMimeTypesListWinSetBusy(lw, FALSE);

	EDVMimeTypesListWinUpdateMenus(lw);

	/* Unmap progress dialog, it may have been mapped in the above
	 * operation.
	 */
	ProgressDialogBreakQuery(TRUE);
	ProgressDialogSetTransientFor(NULL);

        reenterent = FALSE;
}

/*
 *      MIME Types list window import MIME Types callback.
 */
static void EDVMimeTypesListWinImportCB(
        GtkWidget *widget, gpointer data
)
{
        static gbool reenterent = FALSE;
	gbool status;
	gint mt_num;
        fb_type_struct **ftype = NULL, *ftype_rtn = NULL;
        gint total_ftypes = 0;
        gchar **path_rtn = NULL;
        gint total_path_rtns = 0;
        GtkWidget *toplevel;
        edv_core_struct *core_ptr;
        edv_mimetype_listwin_struct *lw = (edv_mimetype_listwin_struct *)data;
        if(lw == NULL)
            return;

        core_ptr = (edv_core_struct *)lw->core_ptr;
        if(core_ptr == NULL)
            return;

        /* Get selected MIME Type index number that corresponds to the
         * last selected row index number on the MIME Types clist.
         */
        mt_num = EDVCListGetSelectedLast(
            (GtkCList *)lw->mimetypes_clist, NULL
        );

        if(reenterent)
            return;
        else
            reenterent = TRUE;


        toplevel = lw->toplevel;

        EDVMimeTypesListWinSetBusy(lw, TRUE);


        /* Create file types list, the list of formats that we can import
	 * from.
         */
        FileBrowserTypeListNew(
            &ftype, &total_ftypes,
            ".mailcap", "MailCap MIME Type files"
        );
        FileBrowserTypeListNew(
            &ftype, &total_ftypes,
            ".media.types", "Media Types files"
        );
        FileBrowserTypeListNew(
            &ftype, &total_ftypes,
            ".ini", "Endeavour MIME Type files"
        );

        /* Query user for MIME Types file. */
        FileBrowserSetTransientFor(toplevel);
        status = FileBrowserGetResponse(
            "Import MIME Types",
            "Import", "Cancel",
            NULL,		/* Use last path. */
            ftype, total_ftypes,
            &path_rtn, &total_path_rtns,
            &ftype_rtn
        );
        FileBrowserSetTransientFor(NULL);

        /* Got user response? */
        if(status)
        {
            const gchar *new_path = (total_path_rtns > 0) ?
                path_rtn[0] : NULL;
	    const gchar *ftype_ext = (ftype_rtn != NULL) ?
		ftype_rtn->ext : NULL;

            if(((new_path != NULL) ? (*new_path != '\0') : FALSE) &&
               (ftype_ext != NULL)
	    )
            {
		gchar *buf = g_strdup_printf(
"Importing MIME Types from file:\n\
\n\
    %s\n",
		    new_path
		);

                /* Map progress dialog. */
                ProgressDialogSetTransientFor(toplevel);
                ProgressDialogMap(
                    "Importing MIME Types",
                    buf,
                    (const u_int8_t **)icon_import_32x32_xpm,
                    "Stop"
                );

		g_free(buf);

                /* Begin importing MIME Types based on selected
		 * extension.
		 */
 		if(!strcmp(ftype_ext, ".mailcap"))
		{
		    EDVMimeTypeListImportMailCap(
			new_path,
			&core_ptr->mimetype, &core_ptr->total_mimetypes,
			mt_num,		/* Insert index. */
			EDVMimeTypesListProgressCB, lw,
			EDVMimeTypeAddedEmit, core_ptr
		    );
		}
                else if(!strcmp(ftype_ext, ".media.types"))
                {
                    EDVMimeTypeListImportMediaTypes(
                        new_path,
                        &core_ptr->mimetype, &core_ptr->total_mimetypes,
                        mt_num,         /* Insert index. */
                        EDVMimeTypesListProgressCB, lw,
                        EDVMimeTypeAddedEmit, core_ptr
                    );
                }
		else if(!strcmp(ftype_ext, ".ini"))
		{
		    EDVMimeTypeListLoadFromFile(
			new_path,
			&core_ptr->mimetype, &core_ptr->total_mimetypes,
                        mt_num,         /* Insert index. */
			EDVMimeTypesListProgressCB, lw,
                        EDVMimeTypeAddedEmit, core_ptr,
			FALSE
		    );
		}
	    }
	}	/* Got user response? */

        /* Deallocate file types list. */
        FileBrowserDeleteTypeList(ftype, total_ftypes);
	ftype = NULL;
	total_ftypes = 0;


        EDVMimeTypesListWinSetBusy(lw, FALSE);

        EDVMimeTypesListWinUpdateMenus(lw);

        /* Unmap progress dialog, it may have been mapped in the above
         * operation.
         */
        ProgressDialogBreakQuery(TRUE);
        ProgressDialogSetTransientFor(NULL);

        reenterent = FALSE;
}

/*
 *      MIME Types list window export MIME Types callback.
 */
static void EDVMimeTypesListWinExportCB(
        GtkWidget *widget, gpointer data
)
{
        static gbool reenterent = FALSE;
        gbool status;
	edv_mimetype_struct **list, *mt_ptr;
	gint i, mt_num, total;
        fb_type_struct **ftype = NULL, *ftype_rtn = NULL;
        gint total_ftypes = 0;
        gchar **path_rtn = NULL;
        gint total_path_rtns = 0;
	GList *glist;
        GtkWidget *toplevel;
	GtkCList *clist;
        edv_core_struct *core_ptr;
        edv_mimetype_listwin_struct *lw = (edv_mimetype_listwin_struct *)data;
        if(lw == NULL)
            return;

        core_ptr = (edv_core_struct *)lw->core_ptr;
        if(core_ptr == NULL)
            return;

	clist = (GtkCList *)lw->mimetypes_clist;
	if(clist == NULL)
	    return;

        if(reenterent)
            return;
        else
            reenterent = TRUE;


	/* Generate a list of pointers to MIME Types that are selected,
	 * these are the MIME Types that are to be exported.
	 */
	glist = clist->selection;
	list = NULL;
	total = 0;
	while(glist != NULL)
	{
	    mt_num = (gint)glist->data;
	    if((mt_num >= 0) && (mt_num < core_ptr->total_mimetypes))
		mt_ptr = core_ptr->mimetype[mt_num];
	    else
		mt_ptr = NULL;
	    if(mt_ptr != NULL)
	    {
		i = total;
		total = i + 1;

		list = (edv_mimetype_struct **)g_realloc(
		    list, total * sizeof(edv_mimetype_struct *)
		);
		if(list == NULL)
		{
		    total = 0;
		    break;
		}

		list[i] = mt_ptr;
	    }

	    glist = glist->next;
	}
	/* No MIME Types selected? */
	if(total <= 0)
	{
	    g_free(list);
	    list = 0;
	    total = 0;

	    reenterent = FALSE;
	    return;
	}


        toplevel = lw->toplevel;

        EDVMimeTypesListWinSetBusy(lw, TRUE);


        /* Create file types list, the list of formats that we can export
	 * to.
	 */
        FileBrowserTypeListNew(
            &ftype, &total_ftypes,
            ".mailcap", "MailCap MIME Type files"
        );
        FileBrowserTypeListNew(
            &ftype, &total_ftypes,
            ".media.types", "Media Types files"
        );
        FileBrowserTypeListNew(
            &ftype, &total_ftypes,
            ".ini", "Endeavour MIME Type files"
        );


        /* Query user for MIME Types file. */
        FileBrowserSetTransientFor(toplevel);
        status = FileBrowserGetResponse(
            "Export MIME Types",
            "Export", "Cancel",
            NULL,		/* Use last path. */
            ftype, total_ftypes,
            &path_rtn, &total_path_rtns,
            &ftype_rtn
        );
        FileBrowserSetTransientFor(NULL);

        /* Got user response? */
        if(status)
        {
            const gchar *new_path = (total_path_rtns > 0) ?
                path_rtn[0] : NULL;
            const gchar *ftype_ext = (ftype_rtn != NULL) ?
                ftype_rtn->ext : NULL;

            while(((new_path != NULL) ? (*new_path != '\0') : FALSE) &&
                   (ftype_ext != NULL)
            )
            {
		gbool exported_object_existed = FALSE;
                gchar *buf;
		struct stat stat_buf, lstat_buf;


		/* File already exists? */
		if(!stat(new_path, &stat_buf))
		{
		    gbool need_break = FALSE;
		    gint status2;
		    gchar *buf2 = g_strdup_printf(
"Overwrite:\n\
\n\
    %s\n",
			new_path
		    );

		    CDialogSetTransientFor(toplevel);
		    status2 = CDialogGetResponse(
			"Confirm Overwrite",
			buf2,
			NULL,
			CDIALOG_ICON_WARNING,
			CDIALOG_BTNFLAG_YES | CDIALOG_BTNFLAG_NO,
			CDIALOG_BTNFLAG_NO
		    );
		    CDialogSetTransientFor(NULL);

		    g_free(buf2);

		    switch(status2)
		    {
		      case CDIALOG_RESPONSE_YES:
		      case CDIALOG_RESPONSE_YES_TO_ALL:
		      case CDIALOG_RESPONSE_OK:
			break;

		      default:
			need_break = TRUE;
			break;
		    }

		    /* Mark that the object we are exporting to previously
		     * existed.
		     */
		    exported_object_existed = TRUE;

		    if(need_break)
			break;
		}


		buf = g_strdup_printf(
"Exporting MIME Types to file:\n\
\n\
    %s\n",
                    new_path
                );

                /* Map progress dialog. */
                ProgressDialogSetTransientFor(toplevel);
                ProgressDialogMap(
                    "Exporting MIME Types",
                    buf,
                    (const u_int8_t **)icon_export_32x32_xpm,
                    "Stop"
                );

                g_free(buf);


                /* Begin exporting MIME Types based on selected
                 * extension.
                 */
                if(!strcmp(ftype_ext, ".mailcap"))
                {
                    EDVMimeTypeListExportMailCap(
                        new_path,
                        list, total,
                        TRUE,	/* Include read_only MIME Types. */
                        EDVMimeTypesListProgressCB, lw
                    );
                }
                else if(!strcmp(ftype_ext, ".media.types"))
                {
                    EDVMimeTypeListExportMediaTypes(
                        new_path,
                        list, total,
                        TRUE,   /* Include read_only MIME Types. */
                        EDVMimeTypesListProgressCB, lw
                    );
                }
                else if(!strcmp(ftype_ext, ".ini"))
                {
                    EDVMimeTypeListSaveToFile(
                        new_path,
                        list, total,
                        TRUE,   /* Include read_only MIME Types. */
                        EDVMimeTypesListProgressCB, lw
                    );
                }

		/* Notify Endeavour's resources about the export. */
		if(exported_object_existed)
		{
		    if(!lstat(new_path, &lstat_buf))
			EDVObjectModifiedEmit(
			    core_ptr, new_path, new_path, &lstat_buf
			);
		}
		else
		{
		    if(!lstat(new_path, &lstat_buf))
                        EDVObjectAddedEmit(
                            core_ptr, new_path, &lstat_buf
                        );
		}

		break;	/* Break since this level is one big while() loop. */
            }
        }       /* Got user response? */

        /* Deallocate file types list. */
        FileBrowserDeleteTypeList(ftype, total_ftypes);
        ftype = NULL;
        total_ftypes = 0;


        EDVMimeTypesListWinSetBusy(lw, FALSE);

        EDVMimeTypesListWinUpdateMenus(lw);

        /* Unmap progress dialog, it may have been mapped in the above
         * operation.
         */
        ProgressDialogBreakQuery(TRUE);
        ProgressDialogSetTransientFor(NULL);

	/* Deallocate list of MIME Types to be exported but not each pointer
	 * in the list since they are shared.
	 */
        g_free(list);
        list = 0;
        total = 0;

        reenterent = FALSE;
}


/*
 *	MIME Types list window close button callback.
 */
static void EDVMimeTypesListWinCloseCB(
	GtkWidget *widget, gpointer data
)
{
        edv_mimetype_listwin_struct *lw = (edv_mimetype_listwin_struct *)data;
        if(lw == NULL)
            return;

	EDVMimeTypesListWinUnmap(lw);
}



/*
 *	Updates the displayed MIME Type on the given list window.
 *
 *	This will destroy the display_client widget and create a
 *	new one if mt_ptr is not NULL.
 */
static void EDVMimeTypesListWinUpdateDisplay(
        edv_mimetype_listwin_struct *lw, edv_mimetype_struct *mt_ptr
)
{
	gint border_major = 5, border_minor = 2;
	GtkWidget *w, *parent, *parent2, *parent3;


	if(lw == NULL)
	    return;

	/* Get previous display client GtkVBox and destroy it. */
	w = lw->display_client;
	if(w != NULL)
	{
	    gtk_widget_destroy(w);
	    lw->display_client = w = NULL;
	}

	/* Get parent. */
	parent = lw->display_parent;
	if(parent == NULL)
	    return;

	/* Stop updating at this point if the given MIME Type structure
	 * is NULL.
	 */
	if(mt_ptr == NULL)
	    return;

	/* Realize MIME Type as needed. */
	EDVMimeTypeRealize(mt_ptr, FALSE);

	/* Create new client vbox. */
	lw->display_client = w = gtk_vbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent2 = w;


	if(1)
	{
	    const gchar *class_str = NULL;

	    /* Hbox for class heading. */
	    w = gtk_hbox_new(FALSE, border_minor);
	    gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	    gtk_widget_show(w);
	    parent3 = w;

	    switch(mt_ptr->mt_class)
	    {
	      case EDV_MIMETYPE_CLASS_SYSTEM:
		class_str =
#ifdef PROG_LANGUAGE_ENGLISH
			"System Object Type";
#endif
#ifdef PROG_LANGUAGE_SPANISH
			"El Tipo Del Objeto Del Sistema";
#endif
#ifdef PROG_LANGUAGE_FRENCH
                        "Le Type D'Objet De Systme";
#endif
		break;

	      case EDV_MIMETYPE_CLASS_FORMAT:
		class_str =
#ifdef PROG_LANGUAGE_ENGLISH
			"File Format";
#endif
#ifdef PROG_LANGUAGE_SPANISH
                        "Archive Formato";
#endif
#ifdef PROG_LANGUAGE_FRENCH
                        "Classer Le Format";
#endif
		break;

	      case EDV_MIMETYPE_CLASS_PROGRAM:
		class_str =
#ifdef PROG_LANGUAGE_ENGLISH
			"Application";
#endif
#ifdef PROG_LANGUAGE_SPANISH
                        "La Aplicacin";
#endif
#ifdef PROG_LANGUAGE_FRENCH
                        "Application";
#endif
		break;

              case EDV_MIMETYPE_CLASS_UNIQUE:
                class_str =
#ifdef PROG_LANGUAGE_ENGLISH
			"Unique Object";
#endif
#ifdef PROG_LANGUAGE_SPANISH
                        "El Objeto Extraordinario";
#endif
#ifdef PROG_LANGUAGE_FRENCH
                        "Objet Unique";
#endif
                break;
	    }
	    w = gtk_label_new(
		(class_str != NULL) ? class_str :
#ifdef PROG_LANGUAGE_ENGLISH
			"*Unsupported Class*"
#endif
#ifdef PROG_LANGUAGE_SPANISH
                        "*La Clase No Apoyada*"
#endif
#ifdef PROG_LANGUAGE_FRENCH
                        "*Classe Non Soutenue*"
#endif
            );
            gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
            gtk_widget_show(w);
	}


	/* HBox for icon and type line. */
	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent3 = w;

	/* Create icon? */
	if(1)
	{
	    GdkPixmap *pixmap;
	    GdkBitmap *mask;

	    /* First try to get large sized pixmap, use standard state
	     * always.
	     */
	    pixmap = mt_ptr->large_pixmap[EDV_MIMETYPE_ICON_STATE_STANDARD];
	    mask = mt_ptr->large_mask[EDV_MIMETYPE_ICON_STATE_STANDARD];
	    /* No large? Then try medium. */
	    if(pixmap == NULL)
	    {
                pixmap = mt_ptr->medium_pixmap[EDV_MIMETYPE_ICON_STATE_STANDARD];
                mask = mt_ptr->medium_mask[EDV_MIMETYPE_ICON_STATE_STANDARD];
	    }
            /* No medium? Then try small. */
            if(pixmap == NULL)
            {
                pixmap = mt_ptr->small_pixmap[EDV_MIMETYPE_ICON_STATE_STANDARD];
                mask = mt_ptr->small_mask[EDV_MIMETYPE_ICON_STATE_STANDARD];
            }

	    /* Got pixmap and mask pair? */
	    if(pixmap != NULL)
	    {
		w = gtk_pixmap_new(pixmap, mask);
		gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
		gtk_widget_show(w);
	    }
	}
	/* Type label. */
	w = gtk_label_new(
	    (mt_ptr->type != NULL) ? mt_ptr->type : "(null)"
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);


        /* HBox for value line. */
        w = gtk_hbox_new(FALSE, border_minor);
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent3 = w;

        /* Value label. */
        w = gtk_label_new(
#ifdef PROG_LANGUAGE_ENGLISH
		"Value:"
#endif
#ifdef PROG_LANGUAGE_SPANISH
		"El Valor:"
#endif
#ifdef PROG_LANGUAGE_FRENCH
		"Valeur:"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        /* Label. */
        w = gtk_label_new(
            (mt_ptr->value != NULL) ? mt_ptr->value : "*none*"
        );
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);


	/* Description available? */
	if(mt_ptr->description != NULL)
	{
            /* HBox for description line. */
            w = gtk_hbox_new(FALSE, border_minor);
            gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
            gtk_widget_show(w);
            parent3 = w;

            /* Description label. */
            w = gtk_label_new(mt_ptr->description);
	    gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	    gtk_widget_show(w);
	}



}


/*
 *	Sets the row on the MIME Types clist on the given list window to the
 *	values specified by the given MIME Type structure.
 */
void EDVMimeTypesListWinSetRow(
	edv_mimetype_listwin_struct *lw, gint row, edv_mimetype_struct *mt_ptr
)
{
	gint mt_class;
        GtkCList *clist;
        edv_core_struct *core_ptr;

	const gchar *type = NULL, *value = NULL;
	GdkPixmap *pixmap = NULL, *class_pixmap = NULL;
	GdkBitmap *mask = NULL, *class_mask = NULL;


	if((lw == NULL) || (mt_ptr == NULL))
	    return;

        core_ptr = (edv_core_struct *)lw->core_ptr;
        if(core_ptr == NULL)
            return;

        clist = (GtkCList *)lw->mimetypes_clist;
        if(clist == NULL)
            return;

	/* Realize MIME Type structure so we can have use of its
	 * icon pixmap and mask pairs.
	 */
	EDVMimeTypeRealize(mt_ptr, FALSE);

	/* Get MIME Type class. */
	mt_class = mt_ptr->mt_class;

	/* Get values based on MIME Type class. */
	switch(mt_class)
	{
	  case EDV_MIMETYPE_CLASS_SYSTEM:
	    type = mt_ptr->type;
	    value = "";
	    pixmap = mt_ptr->small_pixmap[
                EDV_MIMETYPE_ICON_STATE_STANDARD
            ];
	    mask = mt_ptr->small_mask[
		EDV_MIMETYPE_ICON_STATE_STANDARD
	    ];
	    class_pixmap = lw->system_object_pixmap;            
	    class_mask = lw->system_object_mask;
	    break;

          case EDV_MIMETYPE_CLASS_FORMAT:
            type = mt_ptr->type;
            value = mt_ptr->value;
            pixmap = mt_ptr->small_pixmap[
                EDV_MIMETYPE_ICON_STATE_STANDARD
            ];
            mask = mt_ptr->small_mask[
                EDV_MIMETYPE_ICON_STATE_STANDARD
            ];
            class_pixmap = lw->file_format_pixmap;
            class_mask = lw->file_format_mask;
            break;

          case EDV_MIMETYPE_CLASS_PROGRAM:
            type = mt_ptr->type;
            value = mt_ptr->value;
	    pixmap = mt_ptr->small_pixmap[
                EDV_MIMETYPE_ICON_STATE_STANDARD
            ];
            mask = mt_ptr->small_mask[
                EDV_MIMETYPE_ICON_STATE_STANDARD
            ];
            class_pixmap = lw->program_pixmap;
            class_mask = lw->program_mask;
            break;

          case EDV_MIMETYPE_CLASS_UNIQUE:
            type = mt_ptr->type;
            value = mt_ptr->value;
            pixmap = mt_ptr->small_pixmap[
                EDV_MIMETYPE_ICON_STATE_STANDARD
            ];
            mask = mt_ptr->small_mask[
                EDV_MIMETYPE_ICON_STATE_STANDARD
            ];
            class_pixmap = lw->unique_object_pixmap;
            class_mask = lw->unique_object_mask;
            break;
	}


	/* Given row index in bounds? */
	if((row >= 0) && (row < clist->rows))
	{
	    /* Set column 0 as MIME Type type. */
	    if((type != NULL) && (clist->columns > 0))
	    {
		if(pixmap != NULL)
		    gtk_clist_set_pixtext(
			clist, row, 0,
			type,
			EDV_LIST_PIXMAP_TEXT_SPACING,
			pixmap, mask
		    );
		else
		    gtk_clist_set_text(
                        clist, row, 0,
                        type
                    );
	    }
            /* Set column 1 as MIME Type value. */
            if((value != NULL) && (clist->columns > 1))
            {
		gtk_clist_set_text(
		    clist, row, 1,
		    value
		);
            }
            /* Set column 2 as MIME Type class icon. */
            if((class_pixmap != NULL) && (clist->columns > 2))
            {
                gtk_clist_set_pixmap(
                    clist, row, 2,
                    class_pixmap, class_mask
                );
            }

	}
}

/*
 *	Regets list of MIME Types from the core structure on the given list
 *	window.
 */
void EDVMimeTypesListWinFetchValues(
        edv_mimetype_listwin_struct *lw
)
{
	gint i, row;
	gchar **strv;
	GtkCList *clist;
	edv_core_struct *core_ptr;
	edv_mimetype_struct *mt_ptr;


	if(lw == NULL)
	    return;

	core_ptr = (edv_core_struct *)lw->core_ptr;
	if(core_ptr == NULL)
	    return;

	clist = (GtkCList *)lw->mimetypes_clist;
	if(clist == NULL)
	    return;


	/* Allocate values list for one row. */
	strv = (gchar **)g_malloc(clist->columns * sizeof(gchar *));
	if(strv != NULL)
	{
	    for(i = 0; i < clist->columns; i++)
		strv[i] = g_strdup("");
	}


	/* Begin updating MIME Types clist. */

	gtk_clist_freeze(clist);

	/* Remove existing rows on clist. */
	gtk_clist_clear(clist);

	/* Iterate through all MIME Types on the core structure. */
	for(i = 0; i < core_ptr->total_mimetypes; i++)
	{
	    mt_ptr = core_ptr->mimetype[i];
	    if(mt_ptr == NULL)
		continue;

	    /* Append a new clist row. */
	    row = gtk_clist_append(
		clist, strv
	    );

	    /* Set new clist row values with the current MIME Type
	     * structure's values.
	     */
	    EDVMimeTypesListWinSetRow(
		lw, row, mt_ptr
	    );
	}

	gtk_clist_thaw(clist);


        /* Deallocate valies array for clist row. */
	if(strv != NULL)
	{
            for(i = 0; i < clist->columns; i++)
                g_free(strv[i]);

	    g_free(strv);
	    strv = NULL;
        }


        EDVMimeTypesListWinUpdateMenus(lw);
}


/*
 *      Called whenever a MIME Type has been added to the core
 *      structure's list of MIME Types.
 */
void EDVMimeTypesListWinMimeTypeAddedCB(
        edv_mimetype_listwin_struct *lw,
        gint mt_num, edv_mimetype_struct *mt_ptr
)
{
        gint row, new_row;
        gchar **strv;
        GtkCList *clist;
        edv_core_struct *core_ptr;


        if((lw == NULL) || (mt_ptr == NULL))
            return;

        core_ptr = (edv_core_struct *)lw->core_ptr;
        if(core_ptr == NULL)
            return;

        clist = (GtkCList *)lw->mimetypes_clist;
        if(clist == NULL)
            return;

        /* The row to create a new MIME Type entry on should correspond to
         * the given MIME Type index number since the clist should be synced
         * with the MIME Types list.
         */
        row = mt_num;

        /* Insert a new row on the clist to indicate this new MIME Type
         * structure.
         */
        strv = (gchar **)g_malloc(clist->columns * sizeof(gchar *));
        if(strv != NULL)
        {
            gint i;
            for(i = 0; i < clist->columns; i++)
                strv[i] = g_strdup("");
        }
        if(row >= clist->rows)
            new_row = gtk_clist_append(clist, strv);
        else
            new_row = gtk_clist_insert(clist, row, strv);
        if(strv != NULL)
        {
            gint i;
            for(i = 0; i < clist->columns; i++)
                g_free(strv[i]);
            g_free(strv);
            strv = NULL;
        }
        /* Failed to insert new row on clist? */
        if(new_row < 0)
            return;

        /* Update clist row text with values from the new MIME Type. */
        EDVMimeTypesListWinSetRow(lw, new_row, mt_ptr);

        EDVMimeTypesListWinUpdateMenus(lw);

        /* Select new row on clist. */
/*	gtk_clist_select_row(clist, new_row, 0); */
}

/*
 *	Called whenever a MIME Type has been modified on the core
 *	structure's list of MIME Types.
 */
void EDVMimeTypesListWinMimeTypeModifiedCB(
        edv_mimetype_listwin_struct *lw,
        gint mt_num, edv_mimetype_struct *mt_ptr
)
{
	GtkCList *clist;
	edv_core_struct *core_ptr;


	if((lw == NULL) || (mt_ptr == NULL))
	    return;

        core_ptr = (edv_core_struct *)lw->core_ptr;
        if(core_ptr == NULL)
            return;

	clist = (GtkCList *)lw->mimetypes_clist;
	if(clist == NULL)
	    return;

        /* Check if given MIME Type index number is in bounds. */
        if((mt_num >= 0) && (mt_num < core_ptr->total_mimetypes) &&
           (mt_num < clist->rows)
	)
        {
            gint sel_row = EDVCListGetSelectedLast(clist, NULL);

	    /* Update this row with the values from the given MIME Type. */
	    EDVMimeTypesListWinSetRow(lw, mt_num, mt_ptr);

	    /* This row currently selected? */
	    if(mt_num == sel_row)
	    {
		/* Update displayed MIME Type info. */
		EDVMimeTypesListWinUpdateDisplay(lw, mt_ptr);
	    }

            EDVMimeTypesListWinUpdateMenus(lw);
	}
}

/*
 *      Notifies the given MIME Types list window that the given MIME Type
 *      has been removed.
 */
void EDVMimeTypesListWinMimeTypeRemovedCB(
        edv_mimetype_listwin_struct *lw, gint mt_num
)
{
        gint row;
        GtkCList *clist;
        edv_core_struct *core_ptr;


        if(lw == NULL)
            return;

        core_ptr = (edv_core_struct *)lw->core_ptr;
        if(core_ptr == NULL)
            return;

        clist = (GtkCList *)lw->mimetypes_clist;
        if(clist == NULL)
            return;

        /* The row to remove should correspond to the MIME Type entry index
         * since the clist should be synced with the MIME Types list.
         */
        row = mt_num;

        /* Delete row from clist. */
        if((row >= 0) && (row < clist->rows))
            gtk_clist_remove(clist, row);

        EDVMimeTypesListWinUpdateMenus(lw);


        /* Forward this signal to the MIME Type edit window. */
        EDVMimeTypesEditWinMimeTypeRemovedCB(lw->editwin, mt_num);
}



/*
 *	Creates a new MIME Types list window.
 */
edv_mimetype_listwin_struct *EDVMimeTypesListWinNew(
        gpointer core_ptr
)
{
        gint border_minor = 2, border_major = 5;
        const gchar     *font_name = NULL,
                        *fg_color_name = NULL,
                        *bg_color_name = NULL,
                        *sfg_color_name = NULL,
                        *sbg_color_name = NULL,
                        *bg_pixmap_path = NULL,
                        *sbg_pixmap_path = NULL,
                        *wm_name = NULL,
                        *wm_class = NULL;
        gint state;
	gchar *heading[3];
        gpointer mclient_data;
	gpointer entry_rtn;
        GdkWindow *window;
        GtkAccelGroup *accelgrp;
	GtkStyle *style;
        GtkRcStyle *rcstyle;
        GtkWidget *w, *fw, *menu;
	GtkWidget *parent, *parent2, *parent3, *parent4, *parent5;
	GtkEntry *entry;
	GtkCList *clist;
        edv_mimetype_listwin_struct *lw = (edv_mimetype_listwin_struct *)g_malloc0(
            sizeof(edv_mimetype_listwin_struct)
        );
        if(lw == NULL)
            return(lw);


        /* Get values from core structure. */
        if(core_ptr != NULL)
        {
            edv_core_struct *c_ptr = EDV_CORE(core_ptr);

            font_name = c_ptr->font_name;
            fg_color_name = c_ptr->fg_color_name;
            bg_color_name = c_ptr->bg_color_name;
            sfg_color_name = c_ptr->sfg_color_name;
            sbg_color_name = c_ptr->sbg_color_name;
            bg_pixmap_path = c_ptr->bg_pixmap_path;
            sbg_pixmap_path = c_ptr->sbg_pixmap_path;
            wm_name = c_ptr->wm_name;
            wm_class = c_ptr->wm_class;
        }


        /* Reset values. */
        lw->initialized = TRUE;
        lw->map_state = FALSE;
	lw->busy_count = 0;
        lw->core_ptr = core_ptr;


        /* Keyboard accelerator group. */
        lw->accelgrp = accelgrp = gtk_accel_group_new();


        /* Toplevel. */
        lw->toplevel = w = gtk_window_new(GTK_WINDOW_DIALOG);
        gtk_widget_set_usize(w, LISTWIN_WIDTH, LISTWIN_HEIGHT);
        gtk_window_set_wmclass(GTK_WINDOW(w), wm_name, wm_class);
        gtk_widget_realize(w);
        gtk_window_set_title(GTK_WINDOW(w), LISTWIN_TITLE);
	style = gtk_widget_get_style(w);
        window = w->window;
        if(window != NULL)
        {
            gdk_window_set_decorations(
                window,
                GDK_DECOR_TITLE | GDK_DECOR_MENU | GDK_DECOR_MINIMIZE
            );
            gdk_window_set_functions(
                window,
                GDK_FUNC_MOVE | GDK_FUNC_MINIMIZE | GDK_FUNC_CLOSE
            );
            GUISetWMIcon(window, (u_int8_t **)icon_mimetypes_48x48_xpm);
        }
        gtk_signal_connect(
            GTK_OBJECT(w), "delete_event",
            GTK_SIGNAL_FUNC(EDVMimeTypesListWinDeleteEventCB), lw
        );
        gtk_container_border_width(GTK_CONTAINER(w), 0);
        gtk_accel_group_attach(accelgrp, GTK_OBJECT(w));
        parent = w;


	/* Load pixmap and mask pairs for class icons. */
        if((window != NULL) && (style != NULL))
        {
	    GdkPixmap *pixmap;
	    GdkBitmap *mask;
	    u_int8_t **icon_data;

#define DO_LOAD_PIXMAP	\
{ \
 mask = NULL; \
 pixmap = gdk_pixmap_create_from_xpm_d( \
  window, &mask, \
  &style->bg[GTK_STATE_NORMAL], \
  (gchar **)icon_data \
 ); \
}

	    icon_data = (u_int8_t **)icon_system_object_20x20_xpm;
	    DO_LOAD_PIXMAP
	    lw->system_object_pixmap = pixmap;
            lw->system_object_mask = mask;

            icon_data = (u_int8_t **)icon_file_extension_20x20_xpm;
	    DO_LOAD_PIXMAP
            lw->file_format_pixmap = pixmap;
            lw->file_format_mask = mask;

            icon_data = (u_int8_t **)icon_executable_20x20_xpm;
	    DO_LOAD_PIXMAP
            lw->program_pixmap = pixmap;
            lw->program_mask = mask;

            icon_data = (u_int8_t **)icon_unique_object_20x20_xpm;
            DO_LOAD_PIXMAP
            lw->unique_object_pixmap = pixmap;
            lw->unique_object_mask = mask;

#undef DO_LOAD_PIXMAP
	}



        /* Main vbox. */
        lw->main_vbox = w = gtk_vbox_new(FALSE, border_major);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_container_add(GTK_CONTAINER(parent), w);
        gtk_widget_show(w);
        parent = w;


	/* Hbox for find prompt. */
	w = gtk_hbox_new(FALSE, border_major);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent2 = w;

        w = (GtkWidget *)GUIPromptBar(
            NULL,
#ifdef PROG_LANGUAGE_ENGLISH
            "Find:",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "El Hallazgo:",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Dcouverte:",
#endif
	    NULL, &entry_rtn
        );
        lw->find_entry = (GtkWidget *)entry_rtn;
	entry = (GtkEntry *)entry_rtn;
        gtk_signal_connect(
            GTK_OBJECT(entry), "activate",
            GTK_SIGNAL_FUNC(EDVMimeTypesListWinFindCB), lw
        );
	EDVEntrySetDND((edv_core_struct *)core_ptr, w);
        gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, TRUE, 0);
        gtk_widget_show(w);


	/* Hbox for MIME Types clist and buttons. */
	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent2 = w;


	/* Scrolled window for MIME Types clist. */
        w = gtk_scrolled_window_new(NULL, NULL);
        gtk_scrolled_window_set_policy(
            GTK_SCROLLED_WINDOW(w),
            GTK_POLICY_AUTOMATIC,
            GTK_POLICY_AUTOMATIC
        );
        gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, TRUE, 0);
        gtk_widget_show(w);
        parent3 = w;

        /* Contents clist. */
#ifdef PROG_LANGUAGE_ENGLISH
	heading[0] = g_strdup("Type");
	heading[1] = g_strdup("Value");
        heading[2] = g_strdup("");	/* Class. */
#endif
#ifdef PROG_LANGUAGE_SPANISH
        heading[0] = g_strdup("El Tipo");
        heading[1] = g_strdup("El Valor");
        heading[2] = g_strdup("");	/* Class. */
#endif
#ifdef PROG_LANGUAGE_FRENCH
        heading[0] = g_strdup("Type");
        heading[1] = g_strdup("Valeur");
        heading[2] = g_strdup("");	/* Class. */
#endif
	lw->mimetypes_clist = w = gtk_clist_new_with_titles(3, heading);
	g_free(heading[0]);
        g_free(heading[1]);
        g_free(heading[2]);
        clist = GTK_CLIST(w);
        gtk_widget_add_events(
            w,
            GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK |
            GDK_BUTTON_PRESS_MASK
        );
        gtk_signal_connect(
            GTK_OBJECT(w), "key_press_event",
            GTK_SIGNAL_FUNC(EDVMimeTypesListWinKeyEventCB), lw
        );
        gtk_signal_connect(
            GTK_OBJECT(w), "key_release_event",
            GTK_SIGNAL_FUNC(EDVMimeTypesListWinKeyEventCB), lw
        );
        gtk_signal_connect_after(
            GTK_OBJECT(w), "button_press_event",
            GTK_SIGNAL_FUNC(EDVMimeTypesListWinButtonPressEventCB), lw
        );
	gtk_clist_set_selection_mode(clist, GTK_SELECTION_EXTENDED);
	gtk_clist_set_column_width(clist, 0, 160);
        gtk_clist_set_column_width(clist, 1, 150);
        gtk_clist_set_column_width(clist, 2, 20);
	gtk_clist_column_titles_passive(clist);
        gtk_clist_set_row_height(clist, EDV_LIST_ROW_SPACING);
        gtk_clist_set_shadow_type(clist, GTK_SHADOW_IN);
	gtk_widget_set_usize(w, -1, LISTWIN_HEIGHT * 0.5);
        gtk_container_add(GTK_CONTAINER(parent3), w);
        gtk_signal_connect(
            GTK_OBJECT(w), "select_row",
            GTK_SIGNAL_FUNC(EDVMimeTypesListWinSelectRowCB), lw
        );
        gtk_signal_connect(
            GTK_OBJECT(w), "unselect_row",
            GTK_SIGNAL_FUNC(EDVMimeTypesListWinUnselectRowCB), lw
        );
        rcstyle = gtk_rc_style_new();
        rcstyle->font_name = (font_name != NULL) ? g_strdup(font_name) : NULL;
        state = GTK_STATE_NORMAL;
        rcstyle->color_flags[state] =
            ((fg_color_name != NULL) ? GTK_RC_FG | GTK_RC_TEXT : 0) |
            ((bg_color_name != NULL) ? GTK_RC_BG | GTK_RC_BASE : 0);
        if(fg_color_name != NULL)
        {
            gdk_color_parse(fg_color_name, &rcstyle->fg[state]);
            gdk_color_parse(fg_color_name, &rcstyle->text[state]);
        }
        if(bg_color_name != NULL)
        {
            gdk_color_parse(bg_color_name, &rcstyle->bg[state]);
            gdk_color_parse(bg_color_name, &rcstyle->base[state]);
        }
        if(bg_pixmap_path != NULL)
            rcstyle->bg_pixmap_name[state] = g_strdup(bg_pixmap_path);
        state = GTK_STATE_SELECTED;
        rcstyle->color_flags[state] =
            ((sfg_color_name != NULL) ? GTK_RC_FG | GTK_RC_TEXT : 0) |
            ((sbg_color_name != NULL) ? GTK_RC_BG | GTK_RC_BASE : 0);
        if(sfg_color_name != NULL)
        {
            gdk_color_parse(sfg_color_name, &rcstyle->fg[state]);
            gdk_color_parse(sfg_color_name, &rcstyle->text[state]);
        }
        if(sbg_color_name != NULL)
        {
            gdk_color_parse(sbg_color_name, &rcstyle->bg[state]);
            gdk_color_parse(sbg_color_name, &rcstyle->base[state]);
        }
        if(sbg_pixmap_path != NULL)
            rcstyle->bg_pixmap_name[state] = g_strdup(sbg_pixmap_path);
        gtk_widget_modify_style(w, rcstyle);
        GUIRCStyleDeallocUnref(rcstyle);
        gtk_widget_show(w);


	/* Vbox for buttons. */
	w = gtk_vbox_new(FALSE, border_major);
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent3 = w;

	/* Vbox for add, edit, and remove set of buttons. */
	w = gtk_vbox_new(FALSE, border_minor);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent4 = w;

        /* Add button. */
        lw->add_btn = w = GUIButtonPixmapLabelH(
            (u_int8_t **)icon_add_20x20_xpm,
#ifdef PROG_LANGUAGE_ENGLISH
	    "Add...",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Agregue...",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Ajouter...",
#endif
	    NULL
        );
        gtk_widget_set_usize(w, LISTWIN_BTN_WIDTH, LISTWIN_BTN_HEIGHT);
        GTK_WIDGET_SET_FLAGS(w, GTK_CAN_DEFAULT);
        gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
        gtk_signal_connect(
            GTK_OBJECT(w), "clicked",
            GTK_SIGNAL_FUNC(EDVMimeTypesListWinAddCB), lw
        );
        gtk_widget_show(w);

        /* Edit button. */
        lw->edit_btn = w = GUIButtonPixmapLabelH(
            (u_int8_t **)icon_edit_20x20_xpm,
#ifdef PROG_LANGUAGE_ENGLISH
            "Edit...",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Redacte...",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Editer...",
#endif
	    NULL
        );
        gtk_widget_set_usize(w, LISTWIN_BTN_WIDTH, LISTWIN_BTN_HEIGHT);
        GTK_WIDGET_SET_FLAGS(w, GTK_CAN_DEFAULT);
        gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
        gtk_signal_connect(
            GTK_OBJECT(w), "clicked",
            GTK_SIGNAL_FUNC(EDVMimeTypesListWinEditCB), lw
        );
        gtk_widget_show(w);

        /* Remove button. */
        lw->remove_btn = w = GUIButtonPixmapLabelH(
            (u_int8_t **)icon_remove_20x20_xpm,
#ifdef PROG_LANGUAGE_ENGLISH
            "Remove",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Quita",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Enlever",
#endif
	    NULL
        );
        gtk_widget_set_usize(w, LISTWIN_BTN_WIDTH, LISTWIN_BTN_HEIGHT);
        GTK_WIDGET_SET_FLAGS(w, GTK_CAN_DEFAULT);
        gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
        gtk_signal_connect(
            GTK_OBJECT(w), "clicked",
            GTK_SIGNAL_FUNC(EDVMimeTypesListWinRemoveCB), lw
        );
        gtk_widget_show(w);


        /* Vbox for up and down set of buttons. */
        w = gtk_vbox_new(FALSE, border_minor);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent4 = w;

	/* Hbox for up button. */
	w = gtk_hbox_new(TRUE, 0);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent5 = w;
        /* Up button. */
        lw->up_btn = w = gtk_button_new();
        gtk_box_pack_start(GTK_BOX(parent5), w, TRUE, FALSE, 0);
        gtk_signal_connect(
            GTK_OBJECT(w), "clicked",
            GTK_SIGNAL_FUNC(EDVMimeTypesListWinUpCB), lw
        );
        gtk_widget_show(w);
	parent5 = w;
        /* Arrow. */
        w = gtk_arrow_new(GTK_ARROW_UP, GTK_SHADOW_OUT);
        gtk_widget_set_usize(
            w, LISTWIN_ARROW_WIDTH, LISTWIN_ARROW_HEIGHT
        );
        gtk_container_add(GTK_CONTAINER(parent5), w);
        gtk_widget_show(w);

        /* Hbox for down button. */
        w = gtk_hbox_new(TRUE, 0);
        gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent5 = w;
        /* Down button. */
        lw->down_btn = w = gtk_button_new();
        gtk_box_pack_start(GTK_BOX(parent5), w, TRUE, FALSE, 0);
        gtk_signal_connect(
            GTK_OBJECT(w), "clicked",
            GTK_SIGNAL_FUNC(EDVMimeTypesListWinDownCB), lw
        );
        gtk_widget_show(w);
        parent5 = w;
        /* Arrow. */
        w = gtk_arrow_new(GTK_ARROW_DOWN, GTK_SHADOW_OUT);
        gtk_widget_set_usize(
            w, LISTWIN_ARROW_WIDTH, LISTWIN_ARROW_HEIGHT
        );
        gtk_container_add(GTK_CONTAINER(parent5), w);
        gtk_widget_show(w);


        /* Vbox for save, import, and export set of buttons. */
        w = gtk_vbox_new(FALSE, border_minor);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent4 = w;

        /* Save button. */
        lw->save_btn = w = GUIButtonPixmapLabelH(
            (u_int8_t **)icon_save_20x20_xpm,
#ifdef PROG_LANGUAGE_ENGLISH
            "Save",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Salve",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Epargner",
#endif
	    NULL
        );
        gtk_widget_set_usize(w, LISTWIN_BTN_WIDTH, LISTWIN_BTN_HEIGHT);
        GTK_WIDGET_SET_FLAGS(w, GTK_CAN_DEFAULT);
        gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
        gtk_signal_connect(
            GTK_OBJECT(w), "clicked",
            GTK_SIGNAL_FUNC(EDVMimeTypesListWinSaveCB), lw
        );
        gtk_widget_show(w);

        /* Import button. */
        lw->import_btn = w = GUIButtonPixmapLabelH(
            (u_int8_t **)icon_import_20x20_xpm,
#ifdef PROG_LANGUAGE_ENGLISH
            "Import...",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Importe...",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Importation...",
#endif
	    NULL
        );
        gtk_widget_set_usize(w, LISTWIN_BTN_WIDTH, LISTWIN_BTN_HEIGHT);
        GTK_WIDGET_SET_FLAGS(w, GTK_CAN_DEFAULT);
        gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
        gtk_signal_connect(
            GTK_OBJECT(w), "clicked",
            GTK_SIGNAL_FUNC(EDVMimeTypesListWinImportCB), lw
        );
        gtk_widget_show(w);

        /* Export button. */
        lw->export_btn = w = GUIButtonPixmapLabelH(
            (u_int8_t **)icon_export_20x20_xpm,
#ifdef PROG_LANGUAGE_ENGLISH
            "Export...",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Exportacin...",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Exportation...",
#endif
	    NULL
        );
        gtk_widget_set_usize(w, LISTWIN_BTN_WIDTH, LISTWIN_BTN_HEIGHT);
        GTK_WIDGET_SET_FLAGS(w, GTK_CAN_DEFAULT);
        gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
        gtk_signal_connect(
            GTK_OBJECT(w), "clicked",
            GTK_SIGNAL_FUNC(EDVMimeTypesListWinExportCB), lw
        );
        gtk_widget_show(w);



        /* Horizontal separator. */
        w = gtk_hseparator_new();
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_widget_show(w);


	/* Parent vbox for displaying selected MIME Type. */
	lw->display_parent = w = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
        gtk_widget_show(w);
	parent2 = w;

	/* Client vbox that is parented to the display_parent, leave this
	 * NULL, it'll be created when needed.
	 */
	lw->display_client = NULL;


	/* Horizontal separator. */
	w = gtk_hseparator_new();
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_widget_show(w);


	/* Hbox for buttons. */
	w = gtk_hbox_new(FALSE, 0);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
	parent2 = w;

	/* Alignment. */
	w = gtk_alignment_new(1.0, 0.5, 0.0, 0.0);
	gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, TRUE, 0);
        gtk_widget_show(w);
        parent2 = w;

	/* Hbox for buttons set. */
        w = gtk_hbox_new(FALSE, border_major);
        gtk_container_add(GTK_CONTAINER(parent2), w);
        gtk_widget_show(w);
        parent2 = w;

        /* Close button. */
        lw->close_btn = w = GUIButtonPixmapLabelH(
            (u_int8_t **)icon_close_20x20_xpm,
#ifdef PROG_LANGUAGE_ENGLISH
            "Close",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Cierre",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Proche",
#endif
	    NULL
        );
        gtk_widget_set_usize(w, LISTWIN_BTN_WIDTH, LISTWIN_BTN_HEIGHT);
        GTK_WIDGET_SET_FLAGS(w, GTK_CAN_DEFAULT);
        gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, FALSE, 0);
        gtk_signal_connect(
            GTK_OBJECT(w), "clicked",
            GTK_SIGNAL_FUNC(EDVMimeTypesListWinCloseCB), lw
        );
        gtk_accel_group_add(
            accelgrp, GDK_Escape, 0, GTK_ACCEL_VISIBLE,
            GTK_OBJECT(w), "clicked"
        );
        gtk_widget_show(w);



	/* Right click menu. */
        lw->menu = menu = (GtkWidget *)GUIMenuCreate();
        mclient_data = lw;
        if(menu != NULL)
        {
            u_int8_t **icon;
            gint accel_key;
            guint accel_mods;
            const gchar *label;
            void (*func_cb)(GtkWidget *, gpointer);

#define DO_ADD_MENU_ITEM_LABEL  \
{ \
 w = GUIMenuItemCreate( \
  menu, GUI_MENU_ITEM_TYPE_LABEL, accelgrp, \
  icon, label, accel_key, accel_mods, (void **)&fw, \
  mclient_data, func_cb \
 ); \
}
#define DO_ADD_MENU_SEP \
{ \
 w = GUIMenuItemCreate( \
  menu, GUI_MENU_ITEM_TYPE_SEPARATOR, NULL, \
  NULL, NULL, 0, 0, NULL, \
  NULL, NULL \
 ); \
}
            icon = (u_int8_t **)icon_add_20x20_xpm;
#ifdef PROG_LANGUAGE_ENGLISH
            label = "Add...";
#endif
#ifdef PROG_LANGUAGE_SPANISH
            label = "Agregue...";
#endif
#ifdef PROG_LANGUAGE_FRENCH
            label = "Ajouter...";
#endif
            accel_key = 0;
            accel_mods = 0;
            func_cb = EDVMimeTypesListWinAddCB;
            DO_ADD_MENU_ITEM_LABEL
	    lw->add_mi = w;

            icon = (u_int8_t **)icon_edit_20x20_xpm;
#ifdef PROG_LANGUAGE_ENGLISH
            label = "Edit...";
#endif
#ifdef PROG_LANGUAGE_SPANISH
            label = "Redacte...";
#endif
#ifdef PROG_LANGUAGE_FRENCH
            label = "Editer...";
#endif
            accel_key = 0;
            accel_mods = 0;
            func_cb = EDVMimeTypesListWinEditCB;
            DO_ADD_MENU_ITEM_LABEL
            lw->edit_mi = w;

            icon = (u_int8_t **)icon_remove_20x20_xpm;
#ifdef PROG_LANGUAGE_ENGLISH
            label = "Remove";
#endif
#ifdef PROG_LANGUAGE_SPANISH
            label = "Quita";
#endif
#ifdef PROG_LANGUAGE_FRENCH
            label = "Enlever";
#endif
            accel_key = 0;
            accel_mods = 0;
            func_cb = EDVMimeTypesListWinRemoveCB;
            DO_ADD_MENU_ITEM_LABEL
            lw->remove_mi = w;

            DO_ADD_MENU_SEP

            icon = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
            label = "Shift Up";
#endif
#ifdef PROG_LANGUAGE_SPANISH
            label = "Cambie Arriba";
#endif
#ifdef PROG_LANGUAGE_FRENCH
            label = "Changer En Haut";
#endif
            accel_key = 0;
            accel_mods = 0;
            func_cb = EDVMimeTypesListWinUpCB;
            DO_ADD_MENU_ITEM_LABEL
            lw->up_mi = w;

            icon = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
            label = "Shift Down";
#endif
#ifdef PROG_LANGUAGE_SPANISH
            label = "Cambie Hacia Abajo";
#endif
#ifdef PROG_LANGUAGE_FRENCH
            label = "Changer En Bas";
#endif
            accel_key = 0;
            accel_mods = 0;
            func_cb = EDVMimeTypesListWinDownCB;
            DO_ADD_MENU_ITEM_LABEL
            lw->down_mi = w;

            DO_ADD_MENU_SEP

            icon = (u_int8_t **)icon_save_20x20_xpm;
#ifdef PROG_LANGUAGE_ENGLISH
            label = "Save";
#endif
#ifdef PROG_LANGUAGE_SPANISH
            label = "Salve";
#endif
#ifdef PROG_LANGUAGE_FRENCH
            label = "Epargner";
#endif
            accel_key = 0;
            accel_mods = 0;
            func_cb = EDVMimeTypesListWinSaveCB;
            DO_ADD_MENU_ITEM_LABEL
            lw->save_mi = w;

            icon = (u_int8_t **)icon_import_20x20_xpm;
#ifdef PROG_LANGUAGE_ENGLISH
            label = "Import...";
#endif
#ifdef PROG_LANGUAGE_SPANISH
            label = "Importe...";
#endif
#ifdef PROG_LANGUAGE_FRENCH
            label = "Importation...";
#endif
            accel_key = 0;
            accel_mods = 0;
            func_cb = EDVMimeTypesListWinImportCB;
            DO_ADD_MENU_ITEM_LABEL
            lw->import_mi = w;

            icon = (u_int8_t **)icon_export_20x20_xpm;
#ifdef PROG_LANGUAGE_ENGLISH
            label = "Export...";
#endif
#ifdef PROG_LANGUAGE_SPANISH
            label = "Exportacin...";
#endif
#ifdef PROG_LANGUAGE_FRENCH
            label = "Exportation...";
#endif
            accel_key = 0;
            accel_mods = 0;
            func_cb = EDVMimeTypesListWinExportCB;
            DO_ADD_MENU_ITEM_LABEL
            lw->export_mi = w;



#undef DO_ADD_MENU_ITEM_LABEL
#undef DO_ADD_MENU_SEP
        }




        EDVMimeTypesListWinUpdateMenus(lw);

	return(lw);
}

/*
 *	Updates menus and other widgets on the given MIME Types list
 *	window to reflect its current data.
 */
void EDVMimeTypesListWinUpdateMenus(
        edv_mimetype_listwin_struct *lw
)
{
	gbool sensitive;
	gint sel_row;
        GtkWidget *w;
	GtkCList *clist;


        if(lw == NULL)
            return;


	/* Get selected row on clist. */
	clist = (GtkCList *)lw->mimetypes_clist;
	sel_row = EDVCListGetSelectedLast(clist, NULL);

#define DO_SET_SENSITIVE	\
{ \
 if(w != NULL) \
  gtk_widget_set_sensitive(w, sensitive); \
}

        sensitive = (sel_row > -1) ? TRUE : FALSE;
	w = lw->edit_btn;
        DO_SET_SENSITIVE
        w = lw->remove_btn;
        DO_SET_SENSITIVE

        w = lw->edit_mi;
        DO_SET_SENSITIVE
        w = lw->remove_mi;
        DO_SET_SENSITIVE

	/* Shift up? */
        sensitive = (sel_row > 0) ? TRUE : FALSE;
        w = lw->up_btn;
        DO_SET_SENSITIVE
        w = lw->up_mi;
        DO_SET_SENSITIVE

	/* Shift down? */
        sensitive = ((sel_row > -1) && (sel_row < (clist->rows - 1))) ?
            TRUE : FALSE;
        w = lw->down_btn;
        DO_SET_SENSITIVE
        w = lw->down_mi;
        DO_SET_SENSITIVE


        /* Export. */
	sensitive = (sel_row > -1) ? TRUE : FALSE;
	w = lw->export_mi;
        DO_SET_SENSITIVE
        w = lw->export_btn;
        DO_SET_SENSITIVE


#undef DO_SET_SENSITIVE
}

/*
 *	Maps the MIME Types list window.
 */
void EDVMimeTypesListWinMap(
        edv_mimetype_listwin_struct *lw
)
{
        GtkWidget *w;

        if(lw == NULL)
            return;

	/* Set close button as the default on map. */
        w = lw->close_btn;
        if(w != NULL)
        {
            gtk_widget_grab_focus(w);
            gtk_widget_grab_default(w);
        }

	w = lw->toplevel;
	gtk_widget_show_raise(w);
	lw->map_state = TRUE;
}

/*
 *	Marks the MIME Types list window as busy or ready.
 */
void EDVMimeTypesListWinSetBusy(
        edv_mimetype_listwin_struct *lw, gbool is_busy
)
{
        GdkCursor *cursor;
        GtkWidget *w;
        edv_core_struct *core_ptr;


        if(lw == NULL)
            return;

        if(!lw->initialized)
            return;

        core_ptr = (edv_core_struct *)lw->core_ptr;
        if(core_ptr == NULL)
            return;

        w = lw->toplevel;
        if(w != NULL)
        {
            if(is_busy)
            {
                /* Increase busy count. */
                lw->busy_count++;

                /* If already busy then don't change anything. */
                if(lw->busy_count > 1)
                    return;

                cursor = EDVGetCursor(core_ptr, EDV_CURSOR_CODE_BUSY);
            }
            else
            {
                /* Reduce busy count. */
                lw->busy_count--;
                if(lw->busy_count < 0)
                    lw->busy_count = 0;

                /* If still busy do not change anything. */
                if(lw->busy_count > 0)
                    return;

                cursor = NULL;  /* Use default cursor. */
            }

            /* Update toplevel window's cursor. */
            if(w->window != NULL)
            {
                gdk_window_set_cursor(w->window, cursor);
                gdk_flush();
            }
        }
}

/*
 *	Unmaps the MIME Types list window.
 */
void EDVMimeTypesListWinUnmap(
        edv_mimetype_listwin_struct *lw
)
{
	GtkWidget *w;

	if(lw == NULL)
	    return;

	w = lw->toplevel;
	if(w == NULL)
	    return;

	if(lw->map_state)
	{
	    gtk_widget_hide(w);
	    lw->map_state = FALSE;
	}
}

/*
 *	Deallocates all resources of the given MIME Types list window and
 *	deallocates the structure itself.
 */
void EDVMimeTypesListWinDelete(
        edv_mimetype_listwin_struct *lw
)
{
        GtkWidget **w;
	GdkPixmap **pixmap;
	GdkBitmap **mask;


        if(lw == NULL)
            return;

        if(lw->initialized)
        {
#define DO_DESTROY_WIDGET       \
{ \
 if((*w) != NULL) \
 { \
  GtkWidget *tmp_w = *w; \
  (*w) = NULL; \
  gtk_widget_destroy(tmp_w); \
 } \
}

#define DO_UNREF_PIXMAP_PAIR	\
{ \
 if((*pixmap) != NULL) \
 { \
  GdkPixmap *tpm = *pixmap; \
  (*pixmap) = NULL; \
  gdk_pixmap_unref(tpm); \
 } \
 if((*mask) != NULL) \
 { \
  GdkBitmap *tbm = *mask; \
  (*mask) = NULL; \
  gdk_bitmap_unref(tbm); \
 } \
}

	    /* Destroy right click menu. */
            w = &lw->menu;
            lw->add_mi = NULL;
            lw->edit_mi = NULL;
            lw->remove_mi = NULL;
            lw->up_mi = NULL;
            lw->down_mi = NULL;
            DO_DESTROY_WIDGET

	    /* Delete MIME Type edit window. */
	    EDVMimeTypesEditWinDelete(lw->editwin);
	    lw->editwin = NULL;

	    /* Begin destroying widgets. */
	    w = &lw->display_client;
	    DO_DESTROY_WIDGET

	    w = &lw->display_parent;
	    DO_DESTROY_WIDGET

            w = &lw->find_entry;
            DO_DESTROY_WIDGET

            w = &lw->mimetypes_clist;
            DO_DESTROY_WIDGET

            w = &lw->add_btn;
            DO_DESTROY_WIDGET
            w = &lw->edit_btn;
            DO_DESTROY_WIDGET
            w = &lw->remove_btn;
            DO_DESTROY_WIDGET
            w = &lw->up_btn;
            DO_DESTROY_WIDGET
            w = &lw->down_btn;
            DO_DESTROY_WIDGET
            w = &lw->save_btn;
            DO_DESTROY_WIDGET
            w = &lw->import_btn;
            DO_DESTROY_WIDGET
            w = &lw->export_btn;
            DO_DESTROY_WIDGET
            w = &lw->close_btn;
            DO_DESTROY_WIDGET

            w = &lw->toplevel;
            DO_DESTROY_WIDGET

            if(lw->accelgrp != NULL)
            {
                gtk_accel_group_unref(lw->accelgrp);
                lw->accelgrp = NULL;
            }
/*
if(1)
{
GdkWindowPrivate *private = (GdkWindowPrivate *)lw->system_object_pixmap;
printf("Pixmap refcount = %i\n", private->ref_count - 1);
}
 */
	    pixmap = &lw->system_object_pixmap;
            mask = &lw->system_object_mask;
	    DO_UNREF_PIXMAP_PAIR
            pixmap = &lw->file_format_pixmap;
            mask = &lw->file_format_mask;
	    DO_UNREF_PIXMAP_PAIR
            pixmap = &lw->program_pixmap;
            mask = &lw->program_mask;
	    DO_UNREF_PIXMAP_PAIR
            pixmap = &lw->unique_object_pixmap;
            mask = &lw->unique_object_mask;
            DO_UNREF_PIXMAP_PAIR

#undef DO_UNREF_PIXMAP_PAIR
#undef DO_DESTROY_WIDGET
        }

        /* Deallocate structure itself. */
	g_free(lw);
}
